<?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">edit farmer</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("Fpo/update_farmer") ?>" id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">


                                <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

                                <input type="hidden" name="updating_id" value="<?= $farmer['id'] ?>">

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Farmer ID  </label>


                                    <input type="text" class="form-control" name="building_id" aria-label="building-id" value="<?= $farmer['farmer_id'] ?>"
                                        readonly>
                                </div>










                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Name of the Supervisor</label>
                                    <select class='form-control selected_supervisory' name="name_of_supervisor"  >
                                        <option value="" selected disabled>Select Supervisor</option>

                                        <?php
                                        $db = \Config\Database::connect();

                                        // Fetch farmer_supervisors list
                                        $supervisors = $db->table('farmer_supervisors')
                                            ->where('status', 1)
                                            ->where('associated_by', session()->get('user_associated'))
                                            ->where('entity_id', session()->get('entity_id'))
                                            ->get()
                                            ->getResult();

                                        // Define mapping of table names to readable names


                                        foreach ($supervisors as $fs) {
                                            $tableName = $fs->Supervisory_From;
                                            $supervisorId = $fs->Name_of_the_Supervisor;



                                            // Fetch supervisor info from the correct table
                                            $emp = $db->table($tableName)
                                                ->select('title, first_name, last_name')
                                                ->where('id', $supervisorId)
                                                ->get()
                                                ->getRow();

                                            if ($emp) {
                                                $fullName = $emp->title . ' ' . $emp->first_name . ' ' . $emp->last_name;
                                                $label = $fullName;
                                                $selected = ($fs->id == $farmer['name_of_the_supervisor']) ? 'selected' : '';
                                                echo "<option value='" . esc($fs->id) . "' $selected>" . esc($label) . "</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>









                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Title <span class="text-danger ms-2">*</span></label>
                                    <select class="form-control" name="title" aria-label="contact_person_title">
                                        <option value="Mr" <?= isset($farmer['title']) && $farmer['title'] == 'Mr' ? 'selected' : '' ?>>Mr</option>
                                        <option value="Mrs" <?= isset($farmer['title']) && $farmer['title'] == 'Mrs' ? 'selected' : '' ?>>Mrs</option>
                                        <option value="Ms" <?= isset($farmer['title']) && $farmer['title'] == 'Ms' ? 'selected' : '' ?>>Ms</option>
                                    </select>
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>First Name <span class='text-danger ms-2'>*</span></label>
                                    <input type='text' class='form-control' value="<?= $farmer['first_name'] ?>" required name="first_name" placeholder='Enter First Name' maxlength='30'  >
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Middle Name</label>
                                    <input type='text' class='form-control' name="Middle_name" value="<?= $farmer['middle_name'] ?>" placeholder='Enter Middle Name' maxlength='30'>
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Last Name <span class='text-danger ms-2'>*</span></label>
                                    <input type='text' class='form-control' name="Last_name" value="<?= $farmer['last_name'] ?>" placeholder='Enter Last Name' maxlength='30'  >
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Person Photo <span class='text-danger ms-2'>*</span> <a href="<?= base_url($farmer['Person_Photo']) ?>" target="_blank" class="text-primary text-decoration-underline ">
                                            view image
                                        </a> </label>
                                    <input type='file' class='form-control '
                                        name="Person_Photo[]"
                                        accept="image/*">
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Gender  </label>
                                    <select class="form-control" aria-label="gender" name="Gender"  >
                                        <option value="">Select Gender</option>
                                        <option value="Male" <?= isset($farmer['gender']) && $farmer['gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
                                        <option value="Female" <?= isset($farmer['gender']) && $farmer['gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
                                        <option value="Other" <?= isset($farmer['gender']) && $farmer['gender'] == 'Other' ? 'selected' : '' ?>>Other</option>
                                    </select>
                                </div>


                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Contact Number   </label>
                                    <input type='text' class='form-control' value="<?= $farmer['contact_mobile'] ?>" name="contact_number"   placeholder='Contact Number ' maxlength="10" pattern="[0-9]{10}">
                                </div>





                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Address 1 <span class="text-danger scale5 ms-2">*</span> </label>
                                    <input type="text" class="form-control" required placeholder="Address Line 1" value="<?= $farmer['permanent_address1'] ?>" aria-label="factory-address1" name="adresss_1"   >
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Address 2</label>
                                    <input type="text" class="form-control" value="<?= $farmer['permanent_address2'] ?>" placeholder="Address Line 2" aria-label="factory-address2" name="adresss_2"   >
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Village</label>
                                    <input type="text" class="form-control" placeholder="Village" value="<?= $farmer['permanent_village'] ?>" aria-label="factory-village" name="Village"   >
                                </div>



                                <?php
                                $country = $farmer['permanent_country'] ?? '';
                                $state = $farmer['permanent_state'] ?? '';
                                $city = $farmer['permanent_city'] ?? '';
                                ?>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Country  </label>
                                    <select class="form-control" id="country" name="country"  >
                                        <option value="<?= $country ?>" selected><?= $country ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> State  </label>
                                    <select class="form-control" id="state" name="state"  >
                                        <option value="<?= $state ?>" selected><?= $state ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> City  </label>
                                    <select class="form-control" id="city" name="city"  >
                                        <option value="<?= $city ?>" selected><?= $city ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> PIN Code <span class="text-danger scale5 ms-2">*</span> </label>
                                    <input type="text" maxlength="6"  oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6);"   class="form-control" required value="<?= $farmer['permanent_pincode'] ?>" placeholder="PIN Code" name="pin_code" aria-label="factory-pin-code" maxlength="6"  >
                                </div>




                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Membership Start Date  </label>
                                    <input type='date' class='form-control' value="<?= $farmer['membership_start_date'] ?>" name="Membership_Start_Date"   placeholder='Membership Start Date'>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Insurance Coverage  </label>
                                    <select class="form-control" name="insurance_coverage"   aria-label="insurance_coverage">
                                        <option value="" disabled <?= !isset($farmer['insurance_coverage']) ? 'selected' : '' ?>>Select Option</option>
                                        <option value="Yes" <?= isset($farmer['insurance_coverage']) && $farmer['insurance_coverage'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
                                        <option value="No" <?= isset($farmer['insurance_coverage']) && $farmer['insurance_coverage'] == 'No' ? 'selected' : '' ?>>No</option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Received  </label>
                                    <select class="form-control" name="Training_Received"   aria-label="training_received">
                                        <option value="" disabled <?= !isset($farmer['training_received']) ? 'selected' : '' ?>>Select Option</option>
                                        <option value="Yes" <?= isset($farmer['training_received']) && $farmer['training_received'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
                                        <option value="No" <?= isset($farmer['training_received']) && $farmer['training_received'] == 'No' ? 'selected' : '' ?>>No</option>
                                    </select>
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Title  </label>
                                    <input type="text" class="form-control" value="<?= $farmer['training_title'] ?>" name="Training_Title" placeholder="Training Title" aria-label="training_title">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Date  </label>
                                    <input type="date" class="form-control" value="<?= $farmer['training_date'] ?>" name="Training_Date" aria-label="training_date">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Conducted By  </label>
                                    <input type="text" class="form-control" value="<?= $farmer['conducted_by'] ?>" name="Conducted_By" placeholder="Conducted By" aria-label="conducted_by">
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Email id</label>
                                    <input type='email' class='form-control' value="<?= $farmer['email'] ?>" name="email_id"   placeholder='Enter password' minlength='8'>
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>password</label>
                                    <input type='text' class='form-control' name="password" placeholder='Enter password' minlength='8'>
                                </div>
















                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Remarks  </label>

                                    <textarea id="" class="form-control" placeholder="Remarks" name="Remark" aria-label="manufacturing-activities"> <?= $farmer['remark'] ?></textarea><!-- <input type="text" class="form-control" placeholder="Manufacturing activities" aria-label="manufacturing-activities" > -->
                                </div>






                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Photos   </label>
                                    <input
                                        type="file"
                                        class="form-control"
                                        id="fileInput"
                                        accept="image/jpeg, image/png"
                                        name="Photos[]"
                                        multiple>
                                    <div id="filePreview" class="mt-3"></div>
                                    <!-- Existing photos -->
                                    <div id="existingPhotoContainer" class="mt-3">


                                        <?php
                                        $jsonString = $farmer['Photos'];

                                        // Convert JSON string to PHP array
                                        $imageArray = json_decode($jsonString, true);

                                        ?>

                                        <?php if (is_array($imageArray) && !empty($imageArray)): ?>
                                            <?php foreach ($imageArray as $index => $image): ?>
                                                <div class="d-flex align-items-center justify-content-between mb-2 p-2 bg-light rounded" id="image-<?php echo $index; ?>">
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-image me-2 text-primary"></i>
                                                        <a href="<?= base_url($image) ?>" target="_blank" class="text-decoration-none">
                                                            Image <?php echo ($index + 1); ?>
                                                        </a>
                                                    </div>
                                                    <button type="button" class="btn btn-sm btn-danger ms-3" onclick="deleteImage('<?php echo $image; ?>', <?php echo $index; ?>)">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p>No images found.</p>
                                        <?php endif; ?>
                                    </div>

                                    <input type="hidden" name="remaining_images" id="remainingImages" value='<?= json_encode($imageArray) ?>'>

                                    <!-- New preview -->

                                </div>


                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label"> document  </label>
                                    <div id="documentContainer">

                                        <?php

                                        $documants = json_decode($farmer['documents'], true);


                                        ?>


                                        <?php if (!empty($documants) && is_array($documants)): ?>
                                            <?php foreach ($documants as $index => $doc): ?>
                                                <div class="document-row row">
                                                    <div class="col-xl-3 mb-3">
                                                        <label class="form-label">Document Name <span class="text-danger ms-2">*</span></label>
                                                        <input type="text" name="doc_name[]" class="form-control" value="<?= esc($doc['name']) ?>"  >
                                                    </div>
                                                    <div class="col-xl-3 mb-3">
                                                        <label class="form-label">Document Date</label>
                                                        <input type="date" name="doc_date[]" class="form-control" value="<?= esc($doc['date']) ?>"  >
                                                    </div>
                                                    <div class="col-xl-3 mb-3">
                                                        <div class="d-flex align-items-center mb-2">
                                                            <label class="me-2 mb-0">Old File:</label>
                                                            <a href="<?= base_url($doc['file']) ?>" target="_blank" class="btn btn-link p-0">View</a>
                                                        </div>
                                                        <label class="form-label">Replace File</label>
                                                        <input type="file" name="doc_file[]" class="form-control">
                                                        <input type="hidden" name="existing_file[]" value="<?= esc($doc['file']) ?>">
                                                    </div>
                                                    <div class="col-xl-3 d-flex align-items-end">
                                                        <button type="button" class="btn btn-danger remove-btn">
                                                            <i class="fas fa-trash-alt me-1"></i> Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMore" class="btn btn-primary mt-3">Add More</button>

                                    </div>
                                </div>


                            </div>

                    </div>





                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>












<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<script>
    $(document).ready(function() {
        $("#addMore").click(function() {
            let newRow = `
                <div class="document-row row">
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Name<span class="text-danger ms-2">*</span></label>
                        <input type="text" class="form-control" name="doc_name[]"   accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv" 
 placeholder="Enter Document Name"  >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Date<span class="text-danger ms-2">*</span></label>
                        <input type="date" class="form-control" name="doc_date[]"  >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                       <label class="form-label">Upload document<span class="text-danger ms-2">*</span></label>
                        <input type="file" class="form-control" name="doc_file[]"      accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv">
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#documentContainer").append(newRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".document-row").remove();
        });

        $("#documentForm").submit(function(e) {
            e.preventDefault();
            alert("Form Submitted with " + $("input[name='doc_name[]']").length + " documents!");
        });
    });
</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery ( ) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>





<script>
      $(document).ready(function() {
        $('.selected_supervisory').selectize({

        });
    });
    const form = document.getElementById('form_upload');

    form.addEventListener('submit', (e) => {




        console.log(selectedSkills);
        // Re-assign uploadedFiles to file input before submit
        const dataTransfer = new DataTransfer();
        uploadedFiles.forEach(file => dataTransfer.items.add(file));
        fileInput.files = dataTransfer.files;

        // Optional: Block submission if no files
        if (fileInput.files.length === 0) {
            // e.preventDefault();
            // alert('Please select at least one image to upload.');
        }
    });


    const $selectedLocations = $('#selected_locations_show').selectize({
        plugins: ['remove_button'], // 💡 Enable remove button
        maxItems: null, // Allow multiple selection
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        placeholder: 'Select Locations',
        options: [],
        create: false
    });
    const selectedLocationsSelectize = $selectedLocations[0].selectize;


    $("#locationDropdown").change(function() {



        if ($(this).val() == 'Corporate_Office') {

            $('.show_options').hide()
            $('.Others').hide()
        } else if ($(this).val() == 'Others') {
            console.log($(this).val())
            $('.show_options').hide()
            $('.Others').show()

        } else {
            $('.show_options').show()
            $('.Others').hide()
            let csrfName = $('#csrf_token').attr('name');
            let csrfHash = $('#csrf_token').val();
            $.ajax({
                type: "POST",
                url: "<?= base_url("Fpo/get_details_of_unites") ?>",
                data: {

                    data: $(this).val(),
                    [csrfName]: csrfHash
                },
                dataType: "json",
                success: function(response) {



                    if (response.data && Array.isArray(response.data)) {
                        selectedLocationsSelectize.clear(); // Clear the selected data
                        selectedLocationsSelectize.clearOptions(); // Clear existing options
                        selectedLocationsSelectize.addOption(response.data); // Add the new options
                        selectedLocationsSelectize.refreshOptions(true); // Refresh the options display
                    } else {
                        console.warn('No location data found');
                    }

                    if (response.csrfToken) {
                        $('#csrf_token').val(response.csrfToken);



                    }

                }
            });



        }



    })
</script>
<script>

</script>

<script>
    $(document).ready(function() {
        function initSelectize(selector) {
            return $(selector).selectize({
                create: false,
                sortField: "text",
                placeholder: "Select an option",
            })[0].selectize;
        }

        let countrySelect = initSelectize("#country");
        let stateSelect = initSelectize("#state");
        let citySelect = initSelectize("#city");

        function loadCountries(selectedCountry) {
            $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                if (!response.error) {
                    response.data.forEach(country => {
                        countrySelect.addOption({
                            value: country.name,
                            text: country.name
                        });
                    });

                    if (selectedCountry) {
                        countrySelect.setValue(selectedCountry, true);
                        loadStates(selectedCountry, "<?= $state ?>"); // preload state
                    }
                }
            });
        }

        function loadStates(country, selectedState = "") {
            stateSelect.clear();
            stateSelect.clearOptions();

            if (country) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/states",
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({
                        country: country
                    }),
                    success: function(response) {
                        if (!response.error) {
                            response.data.states.forEach(state => {
                                stateSelect.addOption({
                                    value: state.name,
                                    text: state.name
                                });
                            });

                            if (selectedState) {
                                stateSelect.setValue(selectedState, true);
                                loadCities(country, selectedState, "<?= $city ?>"); // preload city
                            }
                        }
                    }
                });
            }
        }

        function loadCities(country, state, selectedCity = "") {
            citySelect.clear();
            citySelect.clearOptions();

            if (country && state) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({
                        country: country,
                        state: state
                    }),
                    success: function(response) {
                        if (!response.error) {
                            response.data.forEach(city => {
                                citySelect.addOption({
                                    value: city,
                                    text: city
                                });
                            });

                            if (selectedCity) {
                                citySelect.setValue(selectedCity, true);
                            }
                        }
                    }
                });
            }
        }

        loadCountries("<?= $country ?>"); // Initial country load with selected value

        $("#country").change(function() {
            let selectedCountry = $(this).val();
            loadStates(selectedCountry);
        });

        $("#state").change(function() {
            let selectedState = $(this).val();
            loadCities($("#country").val(), selectedState);
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#designation').selectize(); // Only after the DOM is fully ready
    });
</script>

<script>
    let remainingImages = <?= json_encode($imageArray) ?>;

    function deleteImage(imagePath, index) {
        // Remove from UI
        document.getElementById('image-' + index).remove();

        // Remove from array
        remainingImages = remainingImages.filter(img => img !== imagePath);

        console.log("Remaining images:", remainingImages);

        // You can send `remainingImages` via hidden input before form submit
        document.getElementById('remainingImages').value = JSON.stringify(remainingImages);
    }
</script>