 <?= view('Fpo/layout/header') ?>
 <?= view('Fpo/layout/sidebar') ?>

 <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

 <!--**********************************
            Sidebar start
        ***********************************-->

 <!--********************************** 
            Sidebar end
        ***********************************-->

 <!--**********************************
            Content body start
        ***********************************-->

 <style>
.dashboard-card {
    border: none;
    border-radius: 15px;
    padding: 25px;
    color: #fff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
}

.icon-box {
    font-size: 3rem;
    opacity: 0.8;
}

.badge-custom {
    font-size: 0.9rem;
    padding: 5px 10px;
    border-radius: 10px;
}

/* S.NO column small */
.table th:nth-child(1),
.table td:nth-child(1) {
  width: 50px !important;
  text-align: center;
  padding: 4px 6px;
}

/* Standard Clause No column small */
.table th:nth-child(2),
.table td:nth-child(2) {
  width: 70px !important;
  text-align: center;
  padding: 4px 6px;
  white-space: normal !important;
  word-break: break-word;
}

/* Action column small */
.table th:last-child,
.table td:last-child {
  width: 100px !important;
  text-align: center;
  padding: 4px 6px;
}

/* Wrap text for all other columns */
.table th,
.table td {
  white-space: normal !important;
  word-wrap: break-word;
  word-break: break-word;
  vertical-align: top;
}



 </style>

 <div class="content-body">
     <!-- row -->
     <div class="container-fluid">
         <div class="d-flex align-items-center mb-4">
             <h3 class="mb-0 me-auto">Implementation Compliance</h3>

         </div>
         <div class="row">
             <div class="col-xl-12">
                 <div class="card">
                     <div class="card-body">
                         <?php if (session()->getTempdata('validation_errors')): ?>
                         <div class="alert alert-danger">
                             <?= session('validation_errors'); ?>

                         </div>
                         <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                         <?php endif; ?>

                         <?php if (session()->getFlashdata('success')): ?>
                         <div class="alert alert-success">
                             <?= session()->getFlashdata('success') ?>
                         </div>
                         <?php endif; ?>

                         <?php
// Controller should pass: $ImplementationCompliance (row)
// Optionally pass $updated_user_name, $updated_at if desired

$payload = json_decode($ImplementationCompliance['section_data'] ?? '[]', true) ?: [];
$main    = $payload['main_clause'] ?? [];
$subs    = $payload['subclauses'] ?? [];

$mNo   = $main['clause_no']      ?? '';
$mReq  = $main['requirement']    ?? '';
$mImpl = $main['implementation'] ?? '';
$mRem  = $main['remark']         ?? '';
$mType = $main['input_type']     ?? '';
$mLink = $main['link']           ?? '';
$mFile = $main['file_path']      ?? '';
?>

                         <div class="container-xxl">
                             <!-- Main Clause (Read-only form view) -->
                             <form class="mb-4">
                                 <fieldset disabled>
                                     <div class="border rounded p-3 mb-3">
                                         <h5 class="mb-3">Main Clause</h5>

                                         <div class="row g-3">
                                             <div class="col-md-4">
                                                 <label class="form-label">Standard Clause No.</label>
                                                 <input type="text" class="form-control" value="<?= esc($mNo) ?>">
                                             </div>

                                             
<div class="col-md-5">
  <label class="form-label">Link / Upload</label>
  <div class="input-group">
    <input type="text" class="form-control"
           value="<?php
             if ($mType === 'link' && !empty($mLink)) echo $mLink;
             elseif ($mType === 'file' && !empty($mFile)) echo base_url($mFile);
             else echo '-';
           ?>"
           style="white-space:nowrap; overflow:hidden; text-overflow:ellipsis;">

    <?php if ($mType === 'link' && !empty($mLink)): ?>
      <a href="<?= esc($mLink) ?>" target="_blank"
         class="input-group-text text-decoration-none">Open</a>
    <?php elseif ($mType === 'file' && !empty($mFile)): ?>
      <a href="<?= base_url($mFile) ?>" target="_blank"
         class="input-group-text text-decoration-none">View</a>
    <?php endif; ?>
  </div>
</div>

                                             <div class="col-3">
                                                 <label class="form-label">Standard Requirement</label>
                                                 <textarea class="form-control" rows="3"><?= esc($mReq) ?></textarea>
                                             </div>

                                             <div class="col-3">
                                                 <label class="form-label">Implementation</label>
                                                 <textarea class="form-control" rows="3"><?= esc($mImpl) ?></textarea>
                                             </div>

                                             <div class="col-3">
                                                 <label class="form-label">Remarks</label>
                                                 <textarea class="form-control" rows="2"><?= esc($mRem) ?></textarea>
                                             </div>
                                         </div>
                                     </div>
                                 </fieldset>

                                
                             </form>

                             <!-- Sub-Clauses table -->
                             <div class="col-xl-12">
                                 <div class="table-responsive">
                                     <table class="table table-bordered align-middle">
                                         <thead class="table-success text-center">
                                             <tr>
                                                 <th style="width:80px;">S.NO</th>
                                                 <th style="width:180px;">Standard Clause No</th>
                                                 <th>Standard Requirement</th>
                                                 <th>Implementation</th>
                                                 <th style="width:220px;">Action</th>
                                             </tr>
                                         </thead>
                                         <tbody>
                                             <?php if (!empty($subs)): ?>
                                             <?php foreach ($subs as $idx => $sc): ?>
                                             <?php
            $sNo   = $sc['clause_no']      ?? '';
            $sReq  = $sc['requirement']    ?? '';
            $sImpl = $sc['implementation'] ?? '';
            $sType = $sc['input_type']     ?? '';
            $sLink = $sc['link']           ?? '';
            $sFile = $sc['file_path']      ?? '';
          ?>
                                             <tr>
                                                 <td class="text-center"><?= $idx + 1 ?></td>
                                                 <td><?= esc($sNo) ?></td>
                                                 <td class="text-break"><?= nl2br(esc($sReq)) ?></td>
                                                 <td class="text-break"><?= nl2br(esc($sImpl)) ?></td>
                                                 <td>
                                                     <div class="action-buttons d-flex justify-content-end">
                                                         <a href="<?= base_url('Fpo/viewSubClause/' . $ImplementationCompliance['id'] . '/' . $idx) ?>"
                                                             class="btn btn-success btn-sm" title="View">
                                                             <span class="material-icons">visibility</span>
                                                         </a>

                                                         <?php if (session()->get('edit')): ?>
                                                         <a href="<?= base_url('Fpo/edit_subclause/' . $ImplementationCompliance['id'] . '/' . $idx) ?>"
                                                             class="btn btn-secondary btn-sm" title="Edit">
                                                             <span class="material-icons">edit</span>
                                                         </a>
                                                         <?php endif; ?>

                                                         <?php if (session()->get('delete')): ?>
                                                         <a href="<?= base_url('Fpo/delete_subclause/' . $ImplementationCompliance['id'] . '/' . $idx) ?>"
                                                             class="btn btn-danger btn-sm"
                                                             onclick="return confirm('Are you sure you want to delete this sub-clause?')"
                                                             title="Delete">
                                                             <span class="material-icons">delete</span>
                                                         </a>
                                                         <?php endif; ?>


                                                     </div>
                                                 </td>
                                             </tr>
                                             <?php endforeach; ?>
                                             <?php else: ?>
                                             <tr>
                                                 <td colspan="5" class="text-center text-muted">No sub-clauses added.
                                                 </td>
                                             </tr>
                                             <?php endif; ?>
                                         </tbody>
                                     </table>

                                     <nav>
                                         <ul class="pagination justify-content-center" id="pagination"></ul>
                                     </nav>
                                 </div>
                             </div>
                         </div>


                     </div>
                 </div>
             </div>
         </div>
     </div>

     <!--**********************************
            Content body end
        ***********************************-->

     <!--**********************************
            Footer start
        ***********************************-->
     <?= view('Fpo/layout/footer') ?>


     <!-- Selectize CSS -->
     <link rel="stylesheet"
         href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

     <!-- jQuery (Required) -->


     <!-- Selectize JS -->
     <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>