 <?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--**********************************
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">New Contact</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("Fpo/insert_contact_person") ?>" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Title <span class="text-danger scale5 ms-2">*</span></label>
                                    <select class="form-control" name="title" aria-label="contact_person_title"  >
                                        <option>Mr</option>
                                        <option>Mrs</option>
                                        <option>Ms</option>
                                    </select> 
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> First Name <span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" class="form-control" name="First_Name" placeholder="First Name"  required aria-label="contact_person_first_name">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Middle Name</label>
                                    <input type="text" class="form-control" name="Middle_Name" placeholder="Middle Name"  aria-label="contact_person_middle_name">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Last Name <span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" class="form-control" name="Last_Name" placeholder="Last Name"    aria-label="contact_person_last_name">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Select Role <span class="text-danger">*</span></label>

                                    <?php
                                    $db   = \Config\Database::connect();
                                    $role = $db->table('roles')
                                        ->select('id, role_name')
                                        ->where('status', 1)
                                        ->where('associated_by', session()->get('user_associated'))
                                        ->where('entity_id', session()->get('entity_id'))
                                        ->get()
                                        ->getResult();
                                    ?>

                                    <?php if (empty($role)): ?>
                                        <div class="alert alert-warning">
                                            Please add some roles before adding a contact person.
                                        </div>
                                    <?php else: ?>
                                        <select class="form-control role" name="role" required>
                                            <option value="" selected disabled>Select role</option>
                                            <?php foreach ($role as $r): ?>
                                                <option value="<?= esc($r->id) ?>"><?= esc($r->role_name) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Select Department <span class="text-danger">*</span></label>

                                    <?php
                                    $db          = \Config\Database::connect();
                                    $departments = $db->table('department')
                                        ->select('id, department_name')
                                        ->where('status', 1)
                                        ->where('associated_by', session()->get('user_associated'))
                                        ->where('entity_id', session()->get('entity_id'))
                                        ->get()
                                        ->getResult();
                                    ?>

                                    <?php if (empty($departments)): ?>
                                        <div class="alert alert-warning">
                                            Please add some departments before adding a contact person.
                                        </div>
                                    <?php else: ?>
                                        <select class="form-control select_department" name="department"  >
                                            <option value="" selected disabled>Select department</option>
                                            <?php foreach ($departments as $dept): ?>
                                                <option value="<?= esc($dept->id) ?>">
                                                    <?= esc($dept->department_name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                </div>
 

                                <div class="col-xl-3 col-md-3 mb-4 select_desingation" style="<?= old('designation') ? 'display: block;' : 'display: none;' ?>">
                                    <label class="form-label">designation<span class="text-danger">*</span></label>
                                    <select class="form-control select_Designation" name="designation">
                                        <?php if (old('designation')): ?>
                                            <option value="<?= old('designation') ?>" selected><?= old('designation') ?></option>
                                        <?php else: ?>
                                            <option value="">Select Designation</option>
                                        <?php endif; ?>
                                    </select>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Contact Number <span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" class="form-control" name="Contact_Number" placeholder="Contact Number" maxlength="10" pattern="\d{10}" title="10 digits required" aria-label="contact_person_contact_number" required>
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Email Address <span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="email" class="form-control" name="Email_Address" placeholder="Email Address"  aria-label="contact_person_email" required>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Password <span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="password" class="form-control" name="Password" placeholder="Password" minlength="8" aria-label="password" required>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Photo<span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="file"
                                        class="form-control"
                                        id=""
                                        name="Photo"
                                        accept="image/jpeg, image/png"
                                        required>
                                    <!-- Preview container with remove options -->

                                </div>





                            </div>

                    </div>
                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>


<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- Bootstrap 5 Theme for Select2 -->
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.5.2/dist/select2-bootstrap4.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>


<script>
    $(document).ready(function() {
        $('#designation').select2({
            theme: 'bootstrap4', // Use Bootstrap 5 friendly theme
            placeholder: 'Select Designation',
            allowClear: true
        });
    });




    $(document).ready(function() {
        $('.select_department').selectize({

        });
    });


    $(".select_department").change(function() {

        $(".select_desingation").hide();
        let csrfName = $('#csrf_token').attr('name');
        let csrfHash = $('#csrf_token').val();

        $.ajax({
            type: "POST",
            url: "<?= base_url("get_designation_name") ?>",
            data: {

                data: $(this).val(),
                [csrfName]: csrfHash
            },
            dataType: "json",
            success: function(response) {


                if (response.csrfToken) {
                    $('#csrf_token').val(response.csrfToken);



                }
                if (response.data && response.data[0].designation_name) {
                    var designation_list = response.data[0].designation_name.split(',');

                    var $select = $('.select_Designation').selectize({
                        delimiter: ',',
                        persist: false,

                        create: false,
                        maxItems: 1,
                        onDelete: function(values) {
                            var selected = this.items;
                            if (selected.length <= 1) {
                                return false;
                            }
                        }
                    });

                    var selectize = $select[0].selectize;

                    // Clear current values
                    selectize.clear();
                    selectize.clearOptions(); // Clear existing options

                    // Add values dynamically
                    designation_list.forEach(function(skill) {
                        selectize.addOption({
                            value: skill,
                            text: skill
                        });
                        selectize.addItem(skill);
                    });

                    $(".select_desingation").show();

                } else {

                    var $select = $('.select_Designation').selectize({
                        delimiter: ',',
                        persist: false,

                        create: false,
                        maxItems: 1,
                        onDelete: function(values) {
                            var selected = this.items;
                            if (selected.length <= 1) {
                                return false;
                            }
                        }
                    });

                    var selectize = $select[0].selectize;

                    // Clear current values
                    selectize.clear();
                    selectize.clearOptions(); // Clear existing options

                    $(".select_desingation").hide();
                }



            }
        });



        // $('#skills').selectize({
        //     delimiter: ',',
        //     persist: false,
        //     plugins: ['remove_button'],
        //     create: false,
        //     maxItems: null,
        //     onDelete: function(values) {
        //         var selected = this.items;
        //         if (selected.length <= 1) {
        //             alert("atlest 1 skill require")
        //             return false;
        //         }
        //     }
        // });
    });
</script>