<!DOCTYPE html>
<html lang="en">

<head>

  <!-- PAGE TITLE HERE -->
  <title>TraceAudit </title>

  <!-- Meta -->
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">

  <meta name="robots" content="index, follow">




  <!-- Mobile Specific -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Favicon icon -->
  <link rel="shortcut icon" type="image/png" href="assets/images/favicon.png">
  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="<?= base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
  <link href="<?= base_url(); ?>assets/vendor/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />


  <!-- Localization Tool -->
  <!-- <link href="assets/css/jquery.localizationTool.css" rel="stylesheet"> -->

  <!-- Style Css -->
  <link href="<?= base_url(); ?>assets/new_style_assets-25-07-25/css/style.css" rel="stylesheet" type="text/css">
  <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">


</head>

<body>

 <style>
        .btn-primary {

            border-color: #2e1f7a !important;
            background-color: #2e1f7a !important;
        }
    </style>


  <div class="container-fluid p-0">
    <div class="row g-0">
      <div class="col-md-12"> <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/top-banner.jpg" alt="top banner" width="100%"></div>
    </div>
    <div class="row g-0 ">

      <!-- Left Panel -->
      <div class="col-md-8 left-panel">
        <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/logo.png" alt="TraceAudit Logo">
        <!--<h2>Your Digital Pathway <br> to Standards Compliance <br> and Market Trust</h2>-->
      </div>

      <!-- Right Panel -->
      <div class="col-md-4 right-panel">
        <div class="login-card text-center">
          <h3>Sign In</h3>
          <p>Access the Trace Audit panel using your email passcode</p>

          <?php if (session()->getTempdata('validation_errors')): ?>
            <div class="alert alert-danger"><?= session('validation_errors'); ?></div>
            <?php session()->removeTempdata('validation_errors'); ?>
          <?php endif; ?>

          <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
          <?php endif; ?>

          <form action="<?= base_url(); ?>validate_login" method="post" id="loginForm" enctype="multipart/form-data">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" />

       
            <div class=" position-relative mb-3 custom-select-wrapper">
              <select id="type" name="type" class="form-control required">
                <option value="0">User Type*</option>
                <option value="organisation">Organization</option>
                <option value="fpo">Farmer organization</option>
                <option value="audit_company">Audit company</option>
                <option value="farmers">Farmer</option>
                <option value="app_user">TA User</option>
              </select>
            </div>


            
            <div class=" position-relative mb-3">


              <input type="email" class="form-control" name="Email_id" id="emailInput" placeholder="Email*" required />

            </div>

           
            <div class="form position-relative mb-3">


              <input type="password" class="form-control" name="password" id="passwordInput" placeholder="Password*" required />

            </div>

            <div class="d-flex justify-content-between mb-3">
              <div></div>
              <div>
                <a href="<?= base_url(); ?>forget_password" class="text-decoration-none ">Forgot Password?</a>
              </div>
            </div>

            <div class="d-grid mb-3">
              <button
                id="submitBtn"
                class="g-recaptcha btn btn-primary"
                data-sitekey="6LfgOlsrAAAAAPyqVSPW3kEsCcIa-b2MdFsLg1u1"
                data-callback="onSubmit"
                data-action="login"
                type="submit">
                <span id="btnText">Login</span>
                <span id="spinner" style="display: none;">⏳ Verifying...</span>
              </button>
              <!--<button type="submit" id="submit" class="submit btn btn-primary d-none" style="">Login</button>-->
            </div>
          </form>

          <div class="text-left mt-3">
            <h6>New on our platform?<a href="<?= base_url(); ?>" class="link-hover"> Create
                an account</a></h6>

          </div>

          <div class="text-center mt-5">
            <p class="fw-medium text-gray">Copyright © 2025 - <span class="">TraceAudit</span> </p>
          </div>


        </div>
      </div>
    </div>
  </div>



  <style>
    .login-card {
      max-width: 350px;
    }
  </style>




  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    function onSubmit(token) {


      const form = document.getElementById("loginForm");
      const button = document.getElementById("submitBtn");
      const spinner = document.getElementById("spinner");
      const btnText = document.getElementById("btnText");

      // Disable button and show spinner
      button.disabled = true;
      btnText.style.display = "none";
      spinner.style.display = "inline";

      // Submit the form
      form.submit();


    }
  </script>

</body>

</html>