<!DOCTYPE html>
<html lang="en">

<head>

    <!-- PAGE TITLE HERE -->
    <title>TraceAudit </title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="robots" content="index, follow">




    <!-- Mobile Specific -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon icon -->
    <link rel="shortcut icon" type="image/png" href="assets/images/favicon.png">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="<?= base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />


    <!-- Localization Tool -->
    <!-- <link href="assets/css/jquery.localizationTool.css" rel="stylesheet"> -->

    <!-- Style Css -->
    <link href="<?= base_url(); ?>assets/new_style_assets-25-07-25/css/style.css" rel="stylesheet" type="text/css">
    <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">


</head>

<body>

    <?php if (session()->has('otp_code')): ?>





        <div class="container-fluid p-0">
            <div class="row g-0">
                <div class="col-md-12"> <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/top-banner.jpg" alt="top banner" width="100%"></div>
            </div>
            <div class="row g-0 ">

                <!-- Left Panel -->
                <div class="col-md-8 left-panel">
                    <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/logo.png" alt="TraceAudit Logo">
                    <!--<h2>Your Digital Pathway <br> to Standards Compliance <br> and Market Trust</h2>-->
                </div>

                <!-- Right Panel -->
                <div class="col-md-4 right-panel">
                    <div class="login-card text-center">
                        <h3>Sign In</h3>
                        <p>Access the Trace Audit panel using your email passcode</p>



                        <?php if (session()->getFlashdata('error')): ?>
                            <p style="color: red;"><?= session()->getFlashdata('error') ?></p>
                        <?php endif; ?>
                        <p style="color:green"></p>
                        <h4 class="text-center mb-4">Enter New password </h4>
                        <form id="resetForm" action="<?= base_url('reset_password') ?>" method="POST">
                            <div class="mb-sm-4 mb-3 position-relative">
                                <label class="form-label" for="dlab-password">New password</label>
                                <input type="password" id="dlab-password" class="form-control" name="password" required minlength="8">


                            </div>

                            <div id="passwordError" class="invalid-feedback" style="display:none;">
                                Password must be at least 8 characters long and include:<br>
                                • 1 uppercase letter<br>
                                • 1 lowercase letter<br>
                                • 1 number<br>
                                • 1 special character (e.g. !@#$%^&*)
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-block">Reset password</button>
                            </div>
                        </form>



                        <div class="text-left mt-3">
                            <h6 class="text-left">Return to <a href="<?= base_url(); ?>" class="  link-hover"> Login</a></h6>
                        </div>
                        <div class="text-center mt-5">
                            <p class="fw-medium text-gray">Copyright © 2025 - <span class=" ">TraceAudit</span> </p>
                        </div>

                        <!--<div class="new-account text-center mt-3">-->
                        <!--    <h6>Return to <a href="<?= base_url(); ?>" class="text-secondary link-hover"> Login</a></h6>-->

                        <!--</div>-->

                    </div>


                    <!-- <div class="new-account mt-3">
                                <p>Already have an account? <a class="text-primary" href="page-login.html">Sign in</a>
                                </p>
                            </div> -->
                </div>


            </div>
        </div>
        </div>
        </div>






  <style>
        .btn-primary {

            border-color: #2e1f7a !important;
            background-color: #2e1f7a !important;
        }
    </style>

        <!--<div class="fix-wrapper">-->
        <!--    <div class="container">-->
        <!--        <div class="row justify-content-center">-->
        <!--            <div class="col-lg-5 col-md-6">-->
        <!--                <div class="card mb-0 h-auto">-->
        <!--                    <div class="card-body">-->







        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->

    <?php endif; ?>

    <!--**********************************
    Scripts
***********************************-->
    <!-- Required vendors -->
    <script src="<?= base_url(); ?>assets/vendor/global/global.min.js"></script>
    <!-- <script src="assets/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script> -->
    <!-- <script src="assets/vendor/bootstrap-datepicker-master/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/js/dlabnav-init.js"></script> -->
    <!-- <script src="assets/js/custom.min.js"></script> -->
    <!-- <script src="assets/js/demo.js"></script> -->
    <!-- <script src="assets/js/styleSwitcher.js"></script> -->



    <!-- localizationTool -->
    <!-- <script src="assets/js/jquery.localizationTool.js"></script> -->
    <!-- <script src="assets/js/translator.js"></script>	 -->

    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <!-- Selectize CSS -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

    <!-- jQuery (Required) -->


    <!-- Selectize JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>
    <style>
        .required {
            color: #000000;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        .error-text {
            display: none;
            color: red;
            font-size: 14px;
        }

        .nav-tabs .nav-link.active {
            background-color: #6591fd;
            color: white;
        }
    </style>

















    <style>
        label {
            text-transform: capitalize;

        }
    </style>
</body>
<script>
    (function() {
        const form = document.getElementById('resetForm');
        const pwdInput = document.getElementById('dlab-password');
        const errDiv = document.getElementById('passwordError');

        form.addEventListener('submit', function(e) {
            // Regex: >=8 chars, at least one uppercase, one lowercase, one digit, one special
            const policy = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#\$%\^&\*]).{8,}$/;
            const val = pwdInput.value;

            if (!policy.test(val)) {
                e.preventDefault();
                pwdInput.classList.add('is-invalid');
                errDiv.style.display = 'block';
            } else {
                // allow submit
                pwdInput.classList.remove('is-invalid');
                errDiv.style.display = 'none';
            }
        });

        // hide error on input
        pwdInput.addEventListener('input', () => {
            if (pwdInput.classList.contains('is-invalid')) {
                const policy = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#\$%\^&\*]).{8,}$/;
                if (policy.test(pwdInput.value)) {
                    pwdInput.classList.remove('is-invalid');
                    errDiv.style.display = 'none';
                }
            }
        });
    })();
</script>

</html>