 <?= view('organisation/layout/header') ?>
 <?= view('organisation/layout/sidebar') ?>

 <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

 <!--**********************************
            Sidebar start
        ***********************************-->

 <!--**********************************
            Sidebar end 
        ***********************************-->

 <!--**********************************
            Content body start
        ***********************************-->

 <style>
.dashboard-card {
    border: none;
    border-radius: 15px;
    padding: 25px;
    color: #fff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
}

.icon-box {
    font-size: 3rem;
    opacity: 0.8;
}

.badge-custom {
    font-size: 0.9rem;
    padding: 5px 10px;
    border-radius: 10px;
}
 </style>

 <div class="content-body">


     <!-- app/Views/organization/edit_subclause.php -->
     <?php

// var_dump($sub);
//      die();
$sc   = $sub ?? [];
$no   = $sc['clause_no']      ?? '';
$req  = $sc['requirement']    ?? '';
$impl = $sc['implementation'] ?? '';
$rmk  = $sc['remark']         ?? '';
$type = $sc['input_type']     ?? '';
$link = $sc['link']           ?? '';
$file = $sc['file_path']      ?? '';
$isHeading = (bool)($sc['is_heading'] ?? false);
?>
 
     <div class="container-xxl py-3">
         <div class="d-flex justify-content-between align-items-center mb-3">
             <h4 class="mb-0">Edit Sub-Clause #<?= esc($subIndex + 1) ?></h4>
             <a href="<?= base_url('organization/view_Implementation_Compliance/' . $record['id']) ?>"
                 class="btn btn-light">Back</a>
         </div>

         <?php if (session()->getFlashdata('validation_errors')): ?>
         <div class="alert alert-danger">
             <ul class="mb-0">
                 <?php foreach (session()->getFlashdata('validation_errors') as $err): ?>
                 <li><?= esc($err) ?></li>
                 <?php endforeach; ?>
             </ul>
         </div>
         <?php endif; ?>

         <form action="<?= base_url('organization/update_subclause/' . $record['id'] . '/' . $subIndex) ?>"
             method="post" enctype="multipart/form-data" id="form_edit_subclause">
             <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

             <div class="card shadow-sm">
                 <div class="card-body">
                     <div class="row g-3">
                         <div class="col-md-4">
                             <label class="form-label">Standard Clause No. <span class="text-danger">*</span></label>
                             <input type="text" class="form-control" name="clause_no" value="<?= esc($no) ?>" required>
                         </div>

                          
                     </div>

                     <div class="row g-3 mt-1">
                         <div class="col-12">
                             <label class="form-label">Standard Requirement</label>
                             <textarea class="form-control" name="requirement" rows="3"><?= esc($req) ?></textarea>
                         </div>

                         <div class="col-12 impl-wrap">
                             <label class="form-label">Implementation</label>
                             <textarea class="form-control" name="implementation" rows="3"><?= esc($impl) ?></textarea>
                         </div>

                         <div class="col-md-6 attach-wrap">
                             <label class="form-label">Attachment Type</label>
                             <select class="form-control" name="input_type" id="input_type">
                                 <option value="">-- None --</option>
                                 <option value="link" <?= $type==='link' ? 'selected' : '' ?>>Link</option>
                                 <option value="file" <?= $type==='file' ? 'selected' : '' ?>>Upload</option>
                             </select>
                         </div>

                         <!-- Link -->
                         <div class="col-md-6 link_section attach-wrap"
                             style="display: <?= $type==='link' ? 'block' : 'none' ?>;">
                             <label class="form-label">Link (URL)</label>
                             <input type="url" class="form-control" name="link" value="<?= esc($link) ?>"
                                 placeholder="https://example.com">
                             <?php if (!empty($link)): ?>
                             <a href="<?= esc($link) ?>" target="_blank"
                                 class="btn btn-outline-primary btn-sm mt-2">Open Link</a>
                             <?php endif; ?>
                         </div>

                         <!-- File -->
                         <div class="col-md-6 file_section attach-wrap"
                             style="display: <?= $type==='file' ? 'block' : 'none' ?>;">
                             <label class="form-label">Replace File (optional)</label>
                             <input type="file" class="form-control" name="file">
                             <input type="hidden" name="existing_file" value="<?= esc($file) ?>">
                             <?php if (!empty($file)): ?>
                             <a href="<?= base_url($file) ?>" target="_blank"
                                 class="btn btn-outline-primary btn-sm mt-2">View Current File</a>
                             <?php endif; ?>
                         </div>

                         <div class="col-12 rmk-wrap">
                             <label class="form-label">Remarks</label>
                             <textarea class="form-control" name="remark" rows="2"><?= esc($rmk) ?></textarea>
                         </div>
                     </div>
                 </div>

                 <div class="card-footer text-end">
                     <button type="submit" class="btn btn-primary">Update</button>
                 </div>
             </div>
         </form>
     </div>

    

 </div>




 <?= view('organisation/layout/footer') ?>


 <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
 <!-- Excel Export -->
 <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>


 <script>

 </script>

 <!-- Selectize CSS -->
 <link rel="stylesheet"
     href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

 <!-- jQuery (Required) -->


 <!-- Selectize JS -->
 <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>

 <script>
document.addEventListener('DOMContentLoaded', function () {
  // Scope to this form to avoid collisions
  const form = document.getElementById('form_edit_subclause') || document;

  function refreshUI(scope) {
    const select = scope.querySelector('#input_type');
    const linkSec = scope.querySelector('.link_section');
    const fileSec = scope.querySelector('.file_section');

    if (!select) return; // nothing to do

    const type = select.value || '';

    if (linkSec) linkSec.style.display = (type === 'link') ? 'block' : 'none';
    if (fileSec) fileSec.style.display = (type === 'file') ? 'block' : 'none';
  }

  // Initialize once on load
  refreshUI(form);

  // Toggle on change of the attachment type
  form.addEventListener('change', function (e) {
    if (e.target && e.target.id === 'input_type') {
      // optional cleanup: clear the opposite field
      if (e.target.value === 'link') {
        const f = form.querySelector('input[name="file"]');
        if (f) f.value = '';
      } else if (e.target.value === 'file') {
        const l = form.querySelector('input[name="link"]');
        if (l) l.value = '';
      }
      refreshUI(form);
    }
  });
});
</script>
