<?php

namespace App\Controllers\Audit_maping;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farmer_module;

use App\Models\subscribe_the_audit_teamplate_model;
use App\Models\AuditCompanyLogsModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Audit_maping extends BaseController
{


    public function delete_manuvals_and_documants($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Manuvals_and_documents = new Manuvals_and_documents();

        // Check if record exists
        $existing = $Manuvals_and_documents->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Manuvals_and_documents->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'data deleted successfully.');
    }


    public function update_audit_template_subscribed_version()
    {

        $rules = [
            'audit_template_id' => [
                'label'  => 'audit_template_id',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'max_length'  => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'subscribed_entity_id' => [
                'label'  => 'subscribed_entity_id',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'subscribed_entity_associated_by' => [
                'label'  => 'subscribed_entity_associated_by',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],



        ];






        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }




        $data = [
            'message_to_auditors' => $this->request->getPost('message_to_auditor'),



            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];




        $insertId = $this->request->getPost('updating_id');







        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $user_comments = $this->request->getPost('user_comments');
        $auditor_comments = $this->request->getPost('auditor_comments');
        $doc_status = $this->request->getPost('doc_status');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/subscribed_audit_template/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;

        if (!empty($docNames) && is_array($docNames)) {

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            foreach ($docNames as $i => $docName) {
                $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

                if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                    // Delete old file
                    if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                        unlink(FCPATH . $existingFiles[$i]);
                    }

                    $file = $files['doc_file'][$i];
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName); // Move to new path
                    $newFilePath = $uploadFolder . $newName; // Save relative path
                }

                $documents[] = [
                    'name' => $docName,
                    'date' => $docDates[$i],
                    'file' => $newFilePath,
                    'user_comments' => $user_comments[$i] ?? null,
                    'auditor_comments' => $auditor_comments[$i] ?? null,
                    'doc_status' => $doc_status[$i] ?? null,
                ];
            }

            $data['documents'] = json_encode($documents);
        }



        $model = new subscribe_the_audit_teamplate_model();

        $success = $model->update($insertId, $data);
        $data_2 = [

            'subscription_id' => $this->request->getPost('updating_id'),
            'message_to_auditor' => $this->request->getPost('message_to_auditor'),
            'message_from_auditor' => NULL,
            'who_send' => 'subscriber',
            'audit_template_id' => $this->request->getPost('audit_template_id'),
            'audit_company_id' => $this->request->getPost('audit_company_id'),
            'documents_status' => json_encode($documents),
            'subscriber_associated_by' => session()->get('user_associated'),

            'subscriber_entity_id' => session()->get('entity_id'),


            'created_by' => session()->get('logined_user_id'), // Empty for now,





        ];
        $model_2 = new AuditCompanyLogsModel;
        // // var_dump($data);
        $model_2->insert($data_2);




        if ($success) {
            // Success





            //    var_dump($_POST['designation']);
            $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'template updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }


    public function edit_subscribed_template_audit_mapping($id)
    {
        if (!is_numeric($id)) {
            throw new \RuntimeException("Invalid ID format. ID must be a number.");
        }
        $id = (int)$id;

        $subscribeModel = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribeModel->find($id);

        if (!$subscribe_the_audit_teamplate) {
            throw new \RuntimeException("No audit template found for ID: " . $id);
        }

        $session = session();
        $entityId = $session->get('entity_id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($entityId);

        return view($session->get('acessing_folder') . '/audit_maping/edit', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'organization' => $organization
        ]);
    }

    public function view_audit_subcribed_template($id)
    {
        if (!is_numeric($id)) {
            throw new \RuntimeException("Invalid ID format. ID must be a number.");
        }
        $id = (int)$id;

        $subscribeModel = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribeModel->find($id);

        if (!$subscribe_the_audit_teamplate) {
            throw new \RuntimeException("No audit template found for ID: " . $id);
        }

        $session = session();
        $entityId = $session->get('entity_id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($entityId);

        return view($session->get('acessing_folder') . '/audit_maping/view', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'organization' => $organization
        ]);
    }





    public function insert_audit_mapping()
    {



        $rules = [

            'audit_company' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'audit company is required.',
                ]
            ],
            'audit_template' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'audit_template is required.',
                ]
            ],

            'Remark' => [
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]',
                'errors' => [
                    'regex_match' => 'Only alphabets, numbers, spaces, dots, commas, dashes, and brackets are allowed.',
                ]
            ],

        ];



        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [

            'audit_teamplate_id' => $this->request->getPost('audit_template'),
            'audit_company' => $this->request->getPost('audit_company'),




            'message_to_auditors' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];





        $model = new subscribe_the_audit_teamplate_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();











        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $comments_about_this_document = $this->request->getPost('comments_about_this_document');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/subscribed_audit_template/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/subscribed_audit_template/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];
            $comments_about_this_document_live = $comments_about_this_document[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}",
                    'user_comments' => $comments_about_this_document_live,
                    'auditor_comments' => null,

                ];
            } else {

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => null,
                    'user_comments' => $comments_about_this_document_live,
                    'auditor_comments' => null,

                ];
            }
        }

        $model->update($insertId, [
            'documents' => json_encode($documents)
        ]);




        $data_2 = [

            'subscription_id' => $insertId,
            'message_to_auditor' => $this->request->getPost('Remark'),
            'message_from_auditor' => NULL,
            'who_send' => 'subscriber',
            'audit_template_id' => $this->request->getPost('audit_template'),
            'audit_company_id' => $this->request->getPost('audit_company'),
            'documents_status' => json_encode($documents),
            'subscriber_associated_by' => session()->get('user_associated'),

            'subscriber_entity_id' => session()->get('entity_id'),


            'created_by' => session()->get('logined_user_id'), // Empty for now,





        ];

        $model_2 = new AuditCompanyLogsModel;
        // // var_dump($data);
        $model_2->insert($data_2);


        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'audit template subscribed  successfully!');
    }






    public function view_audit_log($id)
    {
        $subscribe_the_audit_teamplate = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribe_the_audit_teamplate->find($id);



        $audit_logs = new AuditCompanyLogsModel();
        $logs = $audit_logs->where('subscription_id', $id)->findAll();

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/audit_maping/audit_log', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'log' => $logs,
            'organization' => $organization
        ]);
    }







    public function add_audit_mapping()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

         $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/audit_maping/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/audit_maping/index', ['organization' => $organization]);
    }
}
