<?php

namespace App\Controllers\Famer_Supervisor;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\FarmerSupervisorModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Famer_Supervisor extends BaseController
{


    public function delete_farmer_supervisor($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $FarmerSupervisor = new FarmerSupervisorModel();

        // Check if record exists
        $existing = $FarmerSupervisor->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $FarmerSupervisor->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Farmer Supervisor deleted successfully.');
    }


    public function update_farmer_supervisor()
    {

         $rules = [

            'facility_id' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Employee ID is required.',
                ]
            ],


            'evaluated_by' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select Supervisory From.',
                ]
            ],

            'name_of_the_evaluator' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter Name of the Supervisor.',
                ]
            ],

            'remark' => [
                'rules' => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'remark is less than 255',
                ]
            ],

        ];




        

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
               'supervisor_id' => $this->request->getPost('facility_id'),
            'Supervisory_From' => $this->request->getPost('evaluated_by'),
            'Name_of_the_Supervisor' => $this->request->getPost('name_of_the_evaluator'),
            
    
            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            
            


        ];


       


         
        $insertId = $this->request->getPost('updating_id');

        

 


        $model = new FarmerSupervisorModel();



        

        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

           
            //    var_dump($_POST['designation']);
                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_farmer_supervisor($id)
    {
          $FarmerSupervisor = new FarmerSupervisorModel();
        $FarmerSupervisor = $FarmerSupervisor->find($id);
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Famer_Supervisor/edit', [
            'FarmerSupervisor' => $FarmerSupervisor,
            'organization' => $organization
        ]);
    }


    public function view_farmer_supervisor($id)
    {
        $FarmerSupervisor = new FarmerSupervisorModel();
        $FarmerSupervisor = $FarmerSupervisor->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Famer_Supervisor/view', [
            'FarmerSupervisor' => $FarmerSupervisor,
            'organization' => $organization
        ]);
    }


    public function insert_farmer_supervisor()
    {



        $rules = [

            'facility_id' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Employee ID is required.',
                ]
            ],


            'evaluated_by' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select Supervisory From.',
                ]
            ],

            'name_of_the_evaluator' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter Name of the Supervisor.',
                ]
            ],

            'remark' => [
                'rules' => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'remark is less than 255',
                ]
            ],

        ];

        
         
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'supervisor_id' => $this->request->getPost('facility_id'),
            'Supervisory_From' => $this->request->getPost('evaluated_by'),
            'Name_of_the_Supervisor' => $this->request->getPost('name_of_the_evaluator'),
            
    
            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            
            

        ];



         


        $model = new FarmerSupervisorModel;
        // // var_dump($data);
        $model->insert($data);
     





       





        

        




                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'farmer supervisor added successfully!');
    }










    public function add_Farmer_Supervisor()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Famer_Supervisor/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Famer_Supervisor/index', ['organization' => $organization]);
    }
}
