<?php

namespace App\Controllers\Implementation_compliance;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\ImplementationComplianceModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Implementation_compliance extends BaseController
{


    public function delete_ImplementationCompliance($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $ImplementationComplianc = new ImplementationComplianceModel();

        // Check if record exists
        $existing = $ImplementationComplianc->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $ImplementationComplianc->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'data deleted successfully.');
    }


    public function update_Implementation_compliance()
    {

          $session = session();
    $model = new \App\Models\ImplementationComplianceModel();
    $id = $this->request->getPost('updating_id');
    $existing = $model->find($id);

    if (!$existing) {
        return redirect()->back()->with('error', 'Record not found.');
    }

    $headings = $this->request->getPost('heading');
    $uploadTypes = $this->request->getPost('upload_type');
    $requirementClauses = $this->request->getPost('requirement_clause');
    $implementations = $this->request->getPost('implementation');
    $remarksList = $this->request->getPost('remarks');
    $links = $this->request->getPost('link');
    $files = $this->request->getFiles()['file_path'] ?? [];

    $existingSections = json_decode($existing['section_data'], true) ?? [];
    $errors = [];
    $sections = [];
    $session_id = $session->get('entity_id');

    foreach ($headings as $i => $heading) {
        $uploadType = $uploadTypes[$i] ?? '';
        $requirement = $requirementClauses[$i] ?? '';
        $implementation = $implementations[$i] ?? '';
        $remarks = $remarksList[$i] ?? '';
        $link = $links[$i] ?? '';
        $file = $files[$i] ?? null;
        $sectionIndex = $i + 1;

        $filePath = $existingSections[$i]['file_path'] ?? null;
        $sectionErrors = [];

        // Validation
        if (empty($heading)) {
            $sectionErrors[] = "Section $sectionIndex: Heading is required.";
        }

        if (!in_array($uploadType, ['file', 'link'])) {
            $sectionErrors[] = "Section $sectionIndex: Upload type must be 'file' or 'link'.";
        }

        if (empty($requirement)) {
            $sectionErrors[] = "Section $sectionIndex: Requirement clause is required.";
        }

        if (empty($implementation)) {
            $sectionErrors[] = "Section $sectionIndex: Implementation is required.";
        }

        if (!empty($remarks) && !preg_match('/^[a-zA-Z0-9\s\.\,\-\(\)]+$/', $remarks)) {
            $sectionErrors[] = "Section $sectionIndex: Remarks contain invalid characters.";
        }

        if ($uploadType === 'file') {
            if ($file && $file->isValid()) {
                if ($file->getSize() > 2 * 1024 * 1024) {
                    $sectionErrors[] = "Section $sectionIndex: File must be less than 2MB.";
                } elseif (!in_array($file->getExtension(), ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx', 'xls', 'xlsx'])) {
                    $sectionErrors[] = "Section $sectionIndex: Invalid file type.";
                }
            }
        }

        if ($uploadType === 'link') {
            if (empty($link) || !filter_var($link, FILTER_VALIDATE_URL)) {
                $sectionErrors[] = "Section $sectionIndex: Valid link is required.";
            }
        }

        if (!empty($sectionErrors)) {
            $errors = array_merge($errors, $sectionErrors);
            continue;
        }

        // File handling
        if ($uploadType === 'file' && $file && $file->isValid()) {
            $randomName = $file->getRandomName();
            $folder = "uploads/entity_profile/{$session_id}/Implementation_compliance/{$id}";
            $uploadPath = FCPATH . $folder;

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Delete old file if exists
            if (!empty($filePath) && file_exists(FCPATH . $filePath)) {
                unlink(FCPATH . $filePath);
            }

            // Move new file
            $file->move($uploadPath, $randomName);
            $filePath = $folder . '/' . $randomName;
        }

        $sections[] = [
            'heading' => $heading,
            'upload_type' => $uploadType,
            'file_path' => $uploadType === 'file' ? $filePath : null,
            'link' => $uploadType === 'link' ? $link : null,
            'requirement_clause' => $requirement,
            'implementation' => $implementation,
            'remarks' => $remarks,
        ];
    }

    if (!empty($errors)) {
        $session->setFlashdata('validation_errors', $errors);
        return redirect()->back()->withInput();
    }

    // Update row
    $model->update($id, [
        'section_data' => json_encode($sections),
        'updated_by' => $session->get('logined_user_id'),
        'updated_at' => date('Y-m-d H:i:s'),
    ]);

    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
    return redirect()->to($redirectUrl)->with('success', 'Implementation compliance updated successfully!');
    }



    public function edit_ImplementationCompliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/edit', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function view_Implementation_Compliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/view', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function insert_Implementation_compliance()
    {

 
  
    $session = session();

    $headings = $this->request->getPost('heading');
    $uploadTypes = $this->request->getPost('upload_type');
    $requirementClauses = $this->request->getPost('requirement_clause');
    $implementations = $this->request->getPost('implementation');
    $remarksList = $this->request->getPost('remarks');
    $links = $this->request->getPost('link');
    $files = $this->request->getFiles()['file_path'] ?? [];

    $sections = [];
    $errors = [];
    $session_id = $session->get('entity_id');

    foreach ($headings as $i => $heading) {
        $uploadType = $uploadTypes[$i] ?? '';
        $requirement = $requirementClauses[$i] ?? '';
        $implementation = $implementations[$i] ?? '';
        $remarks = $remarksList[$i] ?? '';
        $link = $links[$i] ?? '';
        $file = $files[$i] ?? null;
        $sectionIndex = $i + 1;

        $filePath = null;
        $sectionErrors = [];

        // ✅ Validation
        if (empty($heading)) {
            $sectionErrors[] = "Section $sectionIndex: Heading is required.";
        }

        if (!in_array($uploadType, ['file', 'link'])) {
            $sectionErrors[] = "Section $sectionIndex: Upload type must be 'file' or 'link'.";
        }

        if (empty($requirement)) {
            $sectionErrors[] = "Section $sectionIndex: Requirement clause is required.";
        }

        if (empty($implementation)) {
            $sectionErrors[] = "Section $sectionIndex: Implementation is required.";
        }

        if (!empty($remarks) && !preg_match('/^[a-zA-Z0-9\s\.\,\-\(\)]+$/', $remarks)) {
            $sectionErrors[] = "Section $sectionIndex: Remarks contain invalid characters.";
        }

        if ($uploadType === 'file') {
            if (!$file || !$file->isValid()) {
                $sectionErrors[] = "Section $sectionIndex: File is required and must be valid.";
            } elseif ($file->getSize() > 2 * 1024 * 1024) {
                $sectionErrors[] = "Section $sectionIndex: File must be less than 2MB.";
            } elseif (!in_array($file->getExtension(), ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx', 'xls', 'xlsx'])) {
                $sectionErrors[] = "Section $sectionIndex: Invalid file type.";
            }
        }

        if ($uploadType === 'link') {
            if (empty($link) || !filter_var($link, FILTER_VALIDATE_URL)) {
                $sectionErrors[] = "Section $sectionIndex: Valid link is required.";
            }
        }

        if (!empty($sectionErrors)) {
            $errors = array_merge($errors, $sectionErrors);
            continue; // skip adding this section
        }

        // ✅ Handle file upload if valid
        if ($uploadType === 'file' && $file && $file->isValid()) {
            $randomName = $file->getRandomName();
            $folder = "uploads/entity_profile/{$session_id}/Implementation_compliance/temp";
            $uploadPath = FCPATH . $folder;
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            $file->move($uploadPath, $randomName);
            $filePath = $folder . '/' . $randomName;
        }

        // ✅ Push section
        $sections[] = [
            'heading' => $heading,
            'upload_type' => $uploadType,
            'file_path' => $filePath,
            'link' => $uploadType === 'link' ? $link : null,
            'requirement_clause' => $requirement,
            'implementation' => $implementation,
            'remarks' => $remarks,
        ];
    }

    // ❌ If any errors exist, redirect with them
    if (!empty($errors)) {
        $session->setFlashdata('validation_errors', $errors);
        return redirect()->back()->withInput();
    }

    // ✅ Save single row with all sections
    $finalData = [
        'section_data' => json_encode($sections),
        'associated_by' => $session->get('user_associated'),
        'entity_id' => $session_id,
        'created_by' => $session->get('logined_user_id'),
        'updated_by' => $session->get('logined_user_id'),
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
        'status' => 1
    ];

    $model = new \App\Models\ImplementationComplianceModel();
    $model->insert($finalData);

//     return redirect()->back()->with('success', 'All sections submitted successfully.');
// }



                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Implementation compliance  added successfully!');
    }










    public function add_ImplementationCompliance()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/index', ['organization' => $organization]);
    }
}