<?php

namespace App\Controllers\Irrigation_Methods;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Irrigation_Methods_model;
use App\Models\Farmer_module;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Irrigation_Methods extends BaseController
{


    public function delete_irrigation_method($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Irrigation_Methods = new Irrigation_Methods_model();

        // Check if record exists
        $existing = $Irrigation_Methods->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $Irrigation_Methods->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Irrigation Methods   deleted successfully.');
    }


    public function update_Irrigation_Method()
    {


           $rules = [
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'permit_empty|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_varaity' => [
                'label'  => 'crop varaity',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],


            'Type_of_Irrigation_Equipmen' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Drip Irrigation,Sprinkler System,Flood Irrigation]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Drip Irrigation,Sprinkler System,Flood Irrigation',
                ],
            ],

            'installation_date' => [
                'label'  => 'Installation Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'    => 'The {field} field is required.',
                    'valid_date'  => 'The {field} must be a valid date.',
                ],
            ],
            'manufacturer' => [
                'label'  => 'Manufacturer',
                'rules'  => 'permit_empty|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'responsible_operator' => [
                'label'  => 'Responsible Operator',
                'rules'  => 'permit_empty|alpha_space|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'calibration_due_date' => [
                'label'  => 'Calibration Due Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date.',
                ],
            ],
            'next_due_date' => [
                'label'  => 'Next Due Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date.',
                ],
            ],
            'calibrator_name' => [
                'label'  => 'Name of the Calibrator',
                'rules'  => 'permit_empty|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Unit_of_Water_Quantity' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Gallons,Litres,Cubic Capacity]',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'in_list'  => 'The {field} must be one of: Gallons, Litres, or Cubic Capacity.',
                ],
            ],
            'Any_Other_Installations' => [
                'label'  => 'Any Other Installations',
                'rules'  => 'permit_empty|string|min_length[5]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'min_length' => 'The {field} must be at least 5 characters.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|min_length[5]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'min_length' => 'The {field} must be at least 5 characters.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'crop_type.*' => [
                'label'  => 'Crop Type',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'Each {field} is required.',
                    'string'     => '{field} must be a valid string.',
                    'max_length' => '{field} cannot exceed 100 characters.',
                ],
            ],

            'water_volume.*' => [
                'label'  => 'Water Volume',
                'rules'  => 'required|numeric|greater_than[0]',
                'errors' => [
                    'required'     => 'Each {field} is required.',
                    'numeric'      => '{field} must be a number.',
                    'greater_than' => '{field} must be greater than 0.',
                ],
            ],
        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farm_crop_id' => $this->request->getPost('crop_varaity'),
            'Type_of_Irrigation_Equipment' => $this->request->getPost('Type_of_Irrigation_Equipmen'),
            'Installation_Date' => $this->request->getPost('installation_date'),
            'Manufacturer' => $this->request->getPost('manufacturer'),
            'Responsible_Operator' => $this->request->getPost('responsible_operator'),
            'Calibration_Due_Date' => $this->request->getPost('calibration_due_date'),
            'Next_Due_Date' => $this->request->getPost('next_due_date'),
            'Name_of_the_Calibrator' => $this->request->getPost('calibrator_name'),
            'Unit_of_Water_Quantity' => $this->request->getPost('Unit_of_Water_Quantity'),
            'Any_Other_Installations' => $this->request->getPost('Any_Other_Installations'),
            'Remark' => $this->request->getPost('Remark'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),




            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');

        $entityId = session()->get('entity_id');


        $crop_name = $this->request->getPost('crop_type');
        $water_qty_list = $this->request->getPost('water_volume');

        $crop_details = [];
 if (!empty($crop_name)) {

 foreach ($crop_name as $i => $name) {
            $volume = $water_qty_list[$i] ?? null;

            // Optional: Skip empty values
            if ($name !== '' && is_numeric($volume)) {
                $crop_details[] = [
                    'crop_type' => $name,
                    'water'     => $volume
                ];
            }
        }

        $data['Water_discharge'] = json_encode($crop_details);

 }
       









        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/crop_water_management/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;

  if (!empty($docNames) && is_array($docNames)) {




  if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['Document'] = json_encode($documents);
  }
      


        $model = new Irrigation_Methods_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_irrigation_method($id)
    {
        $Irrigation_Methods = new Irrigation_Methods_model();
        $Irrigation_Methods = $Irrigation_Methods->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

       $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Irrigation_Methods/edit', [
            'Irrigation_Methods' => $Irrigation_Methods,
            'organization' => $organization
        ]);
    }


    public function view_Irrigation_Method($id)
    {
        $Irrigation_Methods = new Irrigation_Methods_model();
        $Irrigation_Methods = $Irrigation_Methods->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

       $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Irrigation_Methods/view', [
            'Irrigation_Methods' => $Irrigation_Methods,
            'organization' => $organization
        ]);
    }


    public function insert_Irrigation_Method()
    {




        $rules = [
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'permit_empty|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_varaity' => [
                'label'  => 'crop varaity',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],


            'Type_of_Irrigation_Equipmen' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Drip Irrigation,Sprinkler System,Flood Irrigation]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Drip Irrigation,Sprinkler System,Flood Irrigation',
                ],
            ],

            'installation_date' => [
                'label'  => 'Installation Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'    => 'The {field} field is required.',
                    'valid_date'  => 'The {field} must be a valid date.',
                ],
            ],
            'manufacturer' => [
                'label'  => 'Manufacturer',
                'rules'  => 'permit_empty|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'responsible_operator' => [
                'label'  => 'Responsible Operator',
                'rules'  => 'permit_empty|alpha_space|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'calibration_due_date' => [
                'label'  => 'Calibration Due Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date.',
                ],
            ],
            'next_due_date' => [
                'label'  => 'Next Due Date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date.',
                ],
            ],
            'calibrator_name' => [
                'label'  => 'Name of the Calibrator',
                'rules'  => 'permit_empty|min_length[2]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'alpha_space'  => 'The {field} may only contain letters and spaces.',
                    'min_length'   => 'The {field} must be at least 2 characters.',
                    'max_length'   => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Unit_of_Water_Quantity' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Gallons,Litres,Cubic Capacity]',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'in_list'  => 'The {field} must be one of: Gallons, Litres, or Cubic Capacity.',
                ],
            ],
            'Any_Other_Installations' => [
                'label'  => 'Any Other Installations',
                'rules'  => 'permit_empty|string|min_length[5]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'min_length' => 'The {field} must be at least 5 characters.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|min_length[5]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'min_length' => 'The {field} must be at least 5 characters.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'crop_type.*' => [
                'label'  => 'Crop Type',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'Each {field} is required.',
                    'string'     => '{field} must be a valid string.',
                    'max_length' => '{field} cannot exceed 100 characters.',
                ],
            ],

            'water_volume.*' => [
                'label'  => 'Water Volume',
                'rules'  => 'required|numeric|greater_than[0]',
                'errors' => [
                    'required'     => 'Each {field} is required.',
                    'numeric'      => '{field} must be a number.',
                    'greater_than' => '{field} must be greater than 0.',
                ],
            ],
        ];




        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'farm_crop_id' => $this->request->getPost('crop_varaity'),
            'Type_of_Irrigation_Equipment' => $this->request->getPost('Type_of_Irrigation_Equipmen'),
            'Installation_Date' => $this->request->getPost('installation_date'),
            'Manufacturer' => $this->request->getPost('manufacturer'),
            'Responsible_Operator' => $this->request->getPost('responsible_operator'),
            'Calibration_Due_Date' => $this->request->getPost('calibration_due_date'),
            'Next_Due_Date' => $this->request->getPost('next_due_date'),
            'Name_of_the_Calibrator' => $this->request->getPost('calibrator_name'),
            'Unit_of_Water_Quantity' => $this->request->getPost('Unit_of_Water_Quantity'),
            'Any_Other_Installations' => $this->request->getPost('Any_Other_Installations'),
            'Remark' => $this->request->getPost('Remark'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];






        $entityId = session()->get('entity_id');
        $crop_details = [];



        $crop_name = $this->request->getPost('crop_type');
        $water_qty_list = $this->request->getPost('water_volume');

        $crop_details = [];
        if (!empty($crop_name)) {

            foreach ($crop_name as $i => $name) {
                $volume = $water_qty_list[$i] ?? null;

                // Optional: Skip empty values
                if ($name !== '' && is_numeric($volume)) {
                    $crop_details[] = [
                        'crop_type' => $name,
                        'water'     => $volume
                    ];
                }
            }

            $data['Water_discharge'] = json_encode($crop_details);
        }







        $model = new Irrigation_Methods_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();































        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Irrigation_Methods/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Irrigation_Methods/{$insertId}/documants";
        if (!empty($docNames) && is_array($docNames)) {


            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Loop and process each document
            foreach ($docNames as $i => $name) {
                $date = $docDates[$i];
                $file = $docFiles[$i];

                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName);

                    $documents[] = [
                        'name' => $name,
                        'date' => $date,
                        'file' => "{$relativeBasePath}/{$newName}"
                    ];
                }
            }

            $model->update($insertId, [
                'Document' => json_encode($documents)
            ]);
        }
        // Create directory if not exists




















                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Irrigation Method  added successfully!');
    }










    public function add_new_Irrigation_Methods()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Irrigation_Methods/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');


        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Irrigation_Methods/index', ['organization' => $organization]);
    }
}
