<?php

namespace App\Controllers\Referance_documents;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\ReferenceDocumentModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Referance_documents extends BaseController
{


    public function delete_referal_document($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $ReferenceDocumen = new ReferenceDocumentModel();

        // Check if record exists
        $existing = $ReferenceDocumen->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $ReferenceDocumen->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Reference Document deleted successfully.');
    }


    public function update_referral_document()
    {



       $rules = [
           
            'Standard' => [
                'label' => 'Standard',
                'rules' => 'required|string',
            ],
            'Subject' => [
                'label' => 'Subject',
                'rules' => 'required|string',
            ],
           
            'Source' => [
                'label' => 'Source',
                'rules' => 'required|string',
            ],
             'Link' => [
                'label' => 'Link',
                'rules' => 'required',
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty',
            ],
             
        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
             
            'standard' => $this->request->getPost('Standard'),
            'subject' => $this->request->getPost('Subject'),
            
            'source' => $this->request->getPost('Source'),
            'link' => $this->request->getPost('Link'),
            'remark' => $this->request->getPost('Remark'),
            




            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];





        $insertId = $this->request->getPost('updating_id');


        $session_id = session()->get('entity_id');









      

        $model = new ReferenceDocumentModel();



            $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['document'] = json_encode($documents);

        $success = $model->update($insertId, $data);

        if ($success) {
            // Success



 


                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_referance_document($id)
    {
         $ReferenceDocument = new ReferenceDocumentModel();
        $ReferenceDocument = $ReferenceDocument->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id); 

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Referance_documents/edit', [
            'ReferenceDocument' => $ReferenceDocument,
            'organization' => $organization
        ]);
    }


    public function view_referal_document($id)
    {
        $ReferenceDocument = new ReferenceDocumentModel();
        $ReferenceDocument = $ReferenceDocument->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Referance_documents/view', [
            'ReferenceDocument' => $ReferenceDocument,
            'organization' => $organization
        ]);
    }


    public function insert_Reference_Documents()
    {




        $rules = [
            'facility_id' => [
                'label' => 'Serial Number',
                'rules' => 'required',
            ],
            'Standard' => [
                'label' => 'Standard',
                'rules' => 'required|string',
            ],
            'Subject' => [
                'label' => 'Subject',
                'rules' => 'required|string',
            ],
           
            'Source' => [
                'label' => 'Source',
                'rules' => 'required|string',
            ],
             'Link' => [
                'label' => 'Link',
                'rules' => 'required',
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty',
            ],
             
        ];







        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }




 


        $data = [
            'serial_number' => $this->request->getPost('facility_id'),
            'standard' => $this->request->getPost('Standard'),
            'subject' => $this->request->getPost('Subject'),
           
            'source' => $this->request->getPost('Source'),
            'link' => $this->request->getPost('Link'), 
            'remark' => $this->request->getPost('Remark'),
            




            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];










        $model = new ReferenceDocumentModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

























       



 $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
 
        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [ 
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [ 
            'document' => json_encode($documents)
        ]);







                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'referral document   added successfully!');
    }










    public function add_new_Referance_documents()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Referance_documents/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Referance_documents/index', ['organization' => $organization]);
    }
}
