<?php

namespace App\Controllers\Review_audit_template;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\subscribe_the_audit_teamplate_model;
use App\Models\AuditCompanyLogsModel;

use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Review_audit_template extends BaseController
{


    public function delete_audit_template($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $AuditTemplate = new AuditTemplateModel();

        // Check if record exists
        $existing = $AuditTemplate->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $AuditTemplate->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'Audit Template   deleted successfully.');
    }


    public function update_subscribed_template()
    {


        $rules = [
            'audit_template_id' => [
                'label'  => 'audit_template_id',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'max_length'  => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'subscribed_entity_id' => [
                'label'  => 'subscribed_entity_id',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'subscribed_entity_associated_by' => [
                'label'  => 'subscribed_entity_associated_by',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],



        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'message_to_entity' => $this->request->getPost('message_to_subscriber'),
            'status' => $this->request->getPost('audit_status'),



            'last_updated_at_aditor'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),


            'last_updated_by_aditor' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');



        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $user_comments = $this->request->getPost('user_comments');
        $auditor_comments = $this->request->getPost('auditor_comments');
        $doc_status = $this->request->getPost('doc_status');
        $existingFiles = $this->request->getPost('existing_file');



        $documents = [];
        $entityId = $this->request->getPost('subscribed_entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/subscribed_audit_template/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;
        if (!empty($docNames) && is_array($docNames)) {

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            foreach ($docNames as $i => $docName) {
                $newFilePath = $existingFiles[$i] ?? 'NULL'; // Default to existing



                $documents[] = [
                    'name' => $docName,
                    'date' => $docDates[$i],
                    'file' => $newFilePath,
                    'user_comments' => $user_comments[$i],
                    'auditor_comments' => $auditor_comments[$i],
                    'doc_status' => $doc_status[$i],
                ];
            }

            $data['documents'] = json_encode($documents);
        }






        $model = new subscribe_the_audit_teamplate_model();






        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);




        $data_2 = [

            'subscription_id' => $this->request->getPost('updating_id'),
            'message_to_auditor' => NULL,
            'message_from_auditor' => $this->request->getPost('message_to_subscriber'),
            'who_send' => 'auditor',
            'audit_template_id' => $this->request->getPost('audit_template_id'),
            'audit_company_id' => $this->request->getPost('audit_company_id'),
            'documents_status' => json_encode($documents),
            'subscriber_associated_by' => $this->request->getPost('subscribed_entity_associated_by'),
            'audit_Status' => $this->request->getPost('audit_status'),

            'subscriber_entity_id' => $this->request->getPost('subscribed_entity_id'),


            'created_by' => session()->get('logined_user_id'), // Empty for now,





        ];




        $model_2 = new AuditCompanyLogsModel;
        // // var_dump($data);
        $model_2->insert($data_2);


        if ($success) {
            // Success






            $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'audit updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }
    }



    public function review_the_template($id)
    {
        $subscribe_the_audit_teamplate = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribe_the_audit_teamplate->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Review_audit_template/edit', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'organization' => $organization
        ]);
    }


    public function view_audit_subcribed_template_auditor($id)
    {
        $subscribe_the_audit_teamplate = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribe_the_audit_teamplate->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Review_audit_template/view', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'organization' => $organization
        ]);
    }



    public function audit_log_show_auditor_version($id)
    {
        $subscribe_the_audit_teamplate = new subscribe_the_audit_teamplate_model();
        $subscribe_the_audit_teamplate = $subscribe_the_audit_teamplate->find($id);



       $audit_logs = new AuditCompanyLogsModel();
$logs = $audit_logs->where('subscription_id', $id)->findAll();

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Review_audit_template/audit_log', [
            'subscribe_the_audit_teamplate' => $subscribe_the_audit_teamplate,
            'log' => $logs,
            'organization' => $organization
        ]);
    }














    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Review_audit_template/index', ['organization' => $organization]);
    }
}
