<?php

namespace App\Controllers\Skill;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Skill_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Skill extends BaseController
{


    public function delete_skill($id)
    {
        $Skill_model = new Skill_model();

        // Check if record exists
        $existing = $Skill_model->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Skill_model->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'skill deleted successfully.');
    }


    public function update_skill()
    {
        $skill = new Skill_model();

        $data = [
            'category_name' => $this->request->getPost('Category_name'),
            'required_skills' => $this->request->getPost('skills'),


            'updated_at' => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by' => session()->get('logined_user_id'),





        ];

        $skill->update($this->request->getPost('skill_id'), $data);

                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'skill updated successfully');
    }




    public function edit_skill($id)
    {
        $skill = new Skill_model();
        $skill = $skill->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
        // echo "hi";

        return view('' . $session->get('acessing_folder') . '/skill/edit', [
            'skill' => $skill,
            'organization' => $organization
        ]);
    }

    public function insert_skill()
    {

        $model = new Skill_model();

        $model->insert([
            'category_name' => $this->request->getPost('Category_name'),
            'required_skills' => $this->request->getPost('skills'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,

        ]);
 
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'skill added successfully!');
    }

    public function add_skill()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/skill/add', ['organization' => $organization]);
    }
    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // print_r($session->get('acessing_folder'));
        // exit;
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/skill/index', ['organization' => $organization]);
    }
}
