<?php

namespace App\Controllers\impact_Creation;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Impact_creation_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class impact_Creation extends BaseController
{


    public function delete_impact_creation($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Impact_creation = new Impact_creation_model();

        // Check if record exists
        $existing = $Impact_creation->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Impact_creation->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Impact creation  deleted successfully.');
    }


    public function update_impact_creation()
    {



          $rules = [

            'Market_Access_Gained' => [
                'label' => 'Market_Access_Gained',
                'rules' => 'required|string',
            ],
            'Premium_Price_Achieved' => [
    'label' => 'Premium_Price_Achieved',
    'rules' => 'permit_empty|string',
],
            'Impact_on_FPIncome' => [
                'label' => 'Impact_on_FPIncome',
                'rules' => 'required|string',
            ],
            'Impact_on_Farmers_Income' => [
                'label' => 'Impact_on_Farmers_Income',
                'rules' => 'required|string',
            ],
            'New_Opportunities_Identified' => [
                'label' => 'New_Opportunities_Identified',
                'rules' => 'required|string',
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'required|string',
            ],
        ];













        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
             'market_access_gained' => $this->request->getPost('Market_Access_Gained'),
            'premium_price_achieved' => $this->request->getPost('Premium_Price_Achieved'),
            'impact_on_fp_income' => $this->request->getPost('Impact_on_FPIncome'),
            'impact_on_farmers_income' => $this->request->getPost('Impact_on_Farmers_Income'),
            'new_opportunities_identified' => $this->request->getPost('New_Opportunities_Identified'),
            'remark' => $this->request->getPost('Remark'),
            




            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];





        $insertId = $this->request->getPost('updating_id');


        $session_id = session()->get('entity_id');









        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/impact_creation/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documents'] = json_encode($documents);


        $model = new Impact_creation_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_impact_creation($id)
    {
         $Impact_creation = new Impact_creation_model();
        $Impact_creation = $Impact_creation->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/impact_Creation/edit', [
            'Impact_creation' => $Impact_creation,
            'organization' => $organization
        ]);
    }


    public function view_impact_creation($id)
    {
        $Impact_creation = new Impact_creation_model();
        $Impact_creation = $Impact_creation->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/impact_Creation/view', [
            'Impact_creation' => $Impact_creation,
            'organization' => $organization
        ]);
    }


    public function insert_impact_creation()
    {




        $rules = [

            'Market_Access_Gained' => [
                'label' => 'Market_Access_Gained',
                'rules' => 'required|string',
            ],
            'Premium_Price_Achieved' => [
    'label' => 'Premium_Price_Achieved',
    'rules' => 'permit_empty|string',
],
            'Impact_on_FPIncome' => [
                'label' => 'Impact_on_FPIncome',
                'rules' => 'required|string',
            ],
            'Impact_on_Farmers_Income' => [
                'label' => 'Impact_on_Farmers_Income',
                'rules' => 'required|string',
            ],
            'New_Opportunities_Identified' => [
                'label' => 'New_Opportunities_Identified',
                'rules' => 'required|string',
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'required|string',
            ],
        ];







        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'market_access_gained' => $this->request->getPost('Market_Access_Gained'),
            'premium_price_achieved' => $this->request->getPost('Premium_Price_Achieved'),
            'impact_on_fp_income' => $this->request->getPost('Impact_on_FPIncome'),
            'impact_on_farmers_income' => $this->request->getPost('Impact_on_Farmers_Income'),
            'new_opportunities_identified' => $this->request->getPost('New_Opportunities_Identified'),
            'remark' => $this->request->getPost('Remark'),
            



            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
             


        ];










        $model = new Impact_creation_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

























        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/impact_creation/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/impact_creation/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documents' => json_encode($documents)
        ]);



















                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'impact creation   added successfully!');
    }










    public function add_new_impact_Creation()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/impact_Creation/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/impact_Creation/index', ['organization' => $organization]);
    }
}
