<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\Router\Exceptions\RedirectException;

class AuthGuard implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();



        // If not logged in at all
        if (!$session->get('isLoggedIn')) {
            session()->set('validation_errors', 'Please login first.');
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            return redirect()->to('/entity_login')->with('error', 'Please login first.');
        }




        // If arguments like 'farmer' or 'organization' are passed
        if ($arguments) {

            $userType = $session->get('user_associated') ?? $session->get('user_type');



            $entityId = $session->get('entity_id');



            if ($entityId) {

if (session()->get("this_is_entity_login") == true) {


                    session()->set("add", true);
                    session()->set("edit", true);
                    session()->set("delete", true);
                }

                
                if ($userType == "farmers") {

                    $db = \Config\Database::connect();
                    $builder = $db->table('farmers');
                    $entity = $builder->where('id', $entityId)->get()->getRow();

                    if ($entity && isset($entity->audo_id_gendrator)) {
                        $session->set('auto_generate', $entity->audo_id_gendrator == 1);
                    }


                    switch ($userType) {

                        case "farmers":

                            session()->set("add", true);
                            session()->set("edit", true);
                            session()->set("delete", true);
                            $session->set('acessing_folder', 'farmers');
                            break;
                        default:
                            return redirect()->to('/entity_login')->with('error', 'Access denied.');
                    }
                } else {



                    $db = \Config\Database::connect();
                    $builder = $db->table('entity_profiles');
                    $entity = $builder->where('id', $entityId)->get()->getRow();

                    if ($entity && isset($entity->audo_id_gendrator)) {
                        $session->set('auto_generate', $entity->audo_id_gendrator == 1);
                    }


                    switch ($userType) {
                        case "organisation":
                            $session->set('acessing_folder', 'organisation');
                            break;
                        case "fpo":
                            $session->set('acessing_folder', 'Fpo');
                            break;
                        case "audit_company":

                            $session->set('acessing_folder', 'Audit_company');
                            break;
                        case "app_user":
                            $session->set('acessing_folder', 'admin');
                            break;

                        default:


                            return redirect()->to('/entity_login')->with('error', 'Access denied.');
                    }
                }
            }






            if (!in_array($userType, $arguments)) {

                session()->set('validation_errors', 'Access denied');
                session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
                return redirect()->to('/entity_login')->with('error', 'Access denied.');
            }
        }

        // Everything is fine, allow access
        return;
    }


    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Not doing anything after the controller, so just return
        return;
    }
}
