<?php

namespace App\Models;

use CodeIgniter\Model;

class Employee extends Model
{
    protected $table = 'employee';
    protected $primaryKey = 'id';
    
    // CI4 equivalent of Laravel's $fillable
    protected $allowedFields = [
        'title',
        'first_name',
        'middle_name',
        'last_name',
        'employee_id',
        'location',
        'photo',
        'appointment_date',
        'qualification',
        'experience_years',
        'experience_months',
        'designation',
        'skills',
        'trainings',
        'documents',
        'responsibilities',
        'reporting_authority_id',
        'remark',
        'status',
        'associated_by',
        'entity_id',
        'created_by',
        'updated_by',
        'password',
        'email',
        'Person_Photo',
        'department',
        'role',
        'skill_distribution',
    ];

    // Timestamps support (optional)
    protected $useTimestamps = true; // enables created_at and updated_at
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

 
}
