<?php

namespace App\Models;

use CodeIgniter\Model;

class OtherDocsReportModel extends Model
{
    protected $table = 'fpo_otherdocs_reports';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'certification_standard',
        'plant_protection_products',
        'fertilizers_micro_nutrients',
        'organic_inputs',
        'seeds_propagation_material',
        'sampling_date',
        'qty_collected',
        'who_collected',
        'test_report_date',
        'lab_name',
        'lab_type',
        'report_result',
        
        'report_summary',
        'bank_name',
        'bank_branch',
        'bank_account_number',
        'bank_ifsc_code',
        'remarks',
        'created_by',
        'updated_by',
        'status',
        'associated_by',
        'entity_id',
        'document',
        'farmer_id',
        'farm_id',
        'crop_id',
        'others',
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
}
