 <?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">Implementation Compliance</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form id="form_upload" method="post" enctype="multipart/form-data">
                           
                        <div class="container">
    <h4 class="mb-4">Implementation Compliance Details</h4>

    <?php
    $sections = json_decode($ImplementationCompliance['section_data'], true);
    ?>

    <?php foreach ($sections as $index => $section): ?>
        <div class="card mb-4 border">
            <div class="card-header">
                <h5 class="mb-0">Section <?= $index + 1 ?></h5>
            </div>
            <div class="card-body row">
                <div class="col-md-12 mb-3">
                    <label class="form-label">Heading</label>
                    <input type="text" class="form-control" value="<?= esc($section['heading']) ?>" readonly>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Standard Requirement Clause</label>
                    <textarea class="form-control" rows="2" readonly><?= esc($section['requirement_clause']) ?></textarea>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Implementation</label>
                    <textarea class="form-control" rows="2" readonly><?= esc($section['implementation']) ?></textarea>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Remarks</label>
                    <textarea class="form-control" rows="2" readonly><?= esc($section['remarks']) ?></textarea>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Upload Type</label>
                    <input type="text" class="form-control" value="<?= esc($section['upload_type']) ?>" readonly>
                </div>

                <?php if ($section['upload_type'] === 'file'): ?>
                    <div class="col-md-12 mb-3">
                        <label class="form-label">Uploaded File</label>
                        <?php if (!empty($section['file_path'])): ?>
                            <a href="<?= base_url($section['file_path']) ?>" target="_blank" class="btn btn-primary btn-sm">View File</a>
                        <?php else: ?>
                            <p class="text-muted">No file uploaded</p>
                        <?php endif; ?>
                    </div>
                <?php elseif ($section['upload_type'] === 'link'): ?>
                    <div class="col-md-12 mb-3">
                        <label class="form-label">Provided Link</label>
                        <a href="<?= esc($section['link']) ?>" target="_blank"><?= esc($section['link']) ?></a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>

    
</div>

                        
                        
                      

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>