 <?= view('organisation/layout/header') ?>
<?= view('organisation/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--**********************************
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
	.dashboard-card {
		border: none;
		border-radius: 15px;
		padding: 25px;
		color: #fff;
		transition: transform 0.3s ease, box-shadow 0.3s ease;
		box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
	}

	.dashboard-card:hover {
		transform: translateY(-5px);
		box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
	}

	.icon-box {
		font-size: 3rem;
		opacity: 0.8;
	}

	.badge-custom {
		font-size: 0.9rem;
		padding: 5px 10px;
		border-radius: 10px;
	}
</style>

<div class="content-body">
	<!-- row -->
	<div class="container-fluid">
		<div class="d-flex align-items-center mb-4 flex-wrap">
			<h3 class="me-auto">Contact Person List</h3>
			<div>
				<?php if (session()->get('add') == true): ?>
					<a href="<?= base_url("organization/add_Contact_Person") ?>" class="btn btn-primary me-3"><i class="fas fa-plus me-2"></i>Create New</a>

				<?php endif; ?>
			</div>
		</div>
		<?php if (session()->getFlashdata('success')): ?>
			<div class="alert alert-success">
				<?= session()->getFlashdata('success') ?>
			</div>
		<?php endif; ?>


		<div class="row">

			<div class="col-xl-6">

				<button onclick="exportToExcel()" id="exportBtn" class="btn btn-success mb-3">Export to Excel</button>

			</div>
			<div class="col-xl-3"></div>
			<div class="col-xl-3">

				<input type="text" id="searchInput" onkeyup="searchTable()" class="form-control mb-3" placeholder="Search table...">

			</div>
			<div class="col-xl-12">
				<div class="table-responsive">
					<table class="table display mb-4 dataTablesCard job-table table-responsive-xl card-table" id="contactTable">
						<thead>
							<tr>
								<th>Name</th>

								<th>Designation</th>
								<th>Contact Number</th>
								<th>Email Address</th>
								<th>image</th>

								<th>updated by</th>
								<th>updated at</th>


								<th>Action</th>

							</tr>
						</thead>
						<tbody>

							<?php

							$db = \Config\Database::connect();

							$builder = $db->table('contact_person');

							$query = $builder->select('*') // or specific columns
								->where('status', 1)
								->where('associated_by', session()->get('user_associated'))
								->where('entity_id', session()->get('entity_id'))
								->orderBy('id', 'DESC')
								->get();

							// $results = $query->getResult(); // returns array of object

							$results = $query->getResultArray(); // each row is an associative array

							foreach ($results as $row):



								$updated_by_data = $db->table('register_log');
								$updated_by_data = $updated_by_data->select('*') // or specific columns
									->where('id', $row['updated_by'])
									->get();

								$updated_person = $updated_by_data->getResultArray();

								$created_by = $db->table('register_log');
								$created_by = $created_by->select('*') // or specific columns
									->where('id', $row['created_by'])
									->get();

								$created_by = $created_by->getResultArray();





								$department = [];

								if (!empty($row['department'])) {
									$departmentQuery = $db->table('department')
										->select('*') // or specify 'role_name' if that's the column
										->where('id', $row['department'])
										->get();

									$department = $departmentQuery->getResultArray();
								}

								// Fallback to dummy value if empty
								$department_name = !empty($department) ? $department[0]['department_name'] : 'Not Assigned';



								$Role = [];

								if (!empty($row['role'])) {
									$RoleQuery = $db->table('roles')
										->select('*') // or specify 'role_name' if that's the column
										->where('id', $row['role'])
										->get();

									$Role = $RoleQuery->getResultArray();
								}

								// Fallback to dummy value if empty
								$Role_name = !empty($Role) ? $Role[0]['role_name'] : 'Not Assigned';









							?>
								<tr



									data-name="<?= $row['Contact_Person_Title'] . "  ." . $row['Contact_Person_First_Name'] . "  " . $row['Contact_Person_Middle_Name'] . "  " . $row['Contact_Person_Last_Name'] ?>"
									data-department="<?= $department_name ?>"
									data-designation="<?= $row['designation'] ?>"
									data-Role="<?= $Role_name ?>"
									data-Contact-Number="<?= $row['Contact_Number'] ?>"
									data-Email-Address="<?= $row['email'] ?>"
									data-image="<?= $row['Person_Photo'] ?>"


									data-created-by='<?= $created_by[0]['name_of_the_user'] ?>'
									data-created-at='<?= $row['created_at']  ?>'
									data-updated-by='<?= $updated_person[0]['name_of_the_user'] ?>'
									data-updated-at='<?= $row['updated_at']  ?>'>
									<td><?= $row['Contact_Person_Title'] . "  ." . $row['Contact_Person_First_Name'] . "  " . $row['Contact_Person_Middle_Name'] . "  " . $row['Contact_Person_Last_Name'] ?></td>
									<td><?= $row['designation'] ?></td>
									<td><?= $row['Contact_Number']  ?></td>
									<td><?= $row['email']  ?></td>


									<td>
										<?php if (!empty($row['Person_Photo'])): ?>
											<a href="<?= base_url($row['Person_Photo']) ?>" target="_blank">
												<img src="<?= base_url($row['Person_Photo']) ?>" alt="Photo" style="width: 50px; height: 50px; object-fit: cover; border-radius: 4px;">
											</a>
										<?php else: ?>
											<span>No Image</span>
										<?php endif; ?>
									</td>
									<td><?= $updated_person[0]['name_of_the_user'] ?></td>
									<td><?= date('d/m/Y H:i', strtotime($row['updated_at']))  ?></td>


									<td>
										<div class="action-buttons d-flex justify-content-end">

											<?php if (session()->get('edit') == true): ?>
												<a href="<?= base_url() ?>organization/view_edit_contact_person/<?= $row['id'] ?>" class="btn btn-secondary light mr-2">
													<span class="material-icons">edit</span>
												</a>
											<?php endif; ?>

											<?php if (session()->get('delete') == true): ?>
												<a href="<?= base_url() ?>organization/delete_contact_person/<?= $row['id'] ?>" class="btn btn-danger light">
													<span class="material-icons">delete</span>
												</a>

											<?php endif; ?>

										</div>
									</td>

								</tr>
							<?php endforeach; ?>








						</tbody>
					</table>
					<nav>
						<ul class="pagination justify-content-center" id="pagination"></ul>
					</nav>
				</div>
			</div>
		</div>
	</div>
</div>






<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('organisation/layout/footer') ?>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<!-- Excel Export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>




<!-- Selectize CSS -->
<link rel="stylesheet"
	href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>



<script>

</script>