<?php

namespace App\Controllers\Audit_template;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\AuditTemplateModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Audit_template extends BaseController
{


    public function delete_audit_template($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $AuditTemplate = new AuditTemplateModel();

        // Check if record exists
        $existing = $AuditTemplate->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $AuditTemplate->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'Audit Template   deleted successfully.');
    }


    public function update_audit_template()
    {


        $rules = [
            'Template_Name' => [
                'label'  => 'Template Name',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'max_length'  => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'Template_for' => [
                'label'  => 'Template for',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'template_expiry_date' => [
                'label'  => 'Template expiry date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'    => 'Please select a {field}.',
                    'valid_date'  => 'The {field} must be a valid date.',
                ],
            ],
            'required_documents' => [
                'label'  => 'required documents',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],


            'description' => [
                'label'  => 'required documents',
                'rules'  => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'template_name' => $this->request->getPost('Template_Name'),
            'template_for' => $this->request->getPost('Template_for'),
            'template_expiry_date' => $this->request->getPost('Template_expiry_date'),
            'required_documents' => $this->request->getPost('required_documents'),
            'description' => $this->request->getPost('description'),






            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');



        $model = new AuditTemplateModel();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






            $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        
    }



    public function edit_audit_template($id)
    {
        $AuditTemplate = new AuditTemplateModel();
        $AuditTemplate = $AuditTemplate->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Audit_template/edit', [
            'AuditTemplate' => $AuditTemplate,
            'organization' => $organization
        ]);
    }


    public function view_audit_template($id)
    {
        $AuditTemplate = new AuditTemplateModel();
        $AuditTemplate = $AuditTemplate->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Audit_template/view', [
            'AuditTemplate' => $AuditTemplate,
            'organization' => $organization
        ]);
    }


    public function insert_audit_template()
    {




        $rules = [
            'Template_Name' => [
                'label'  => 'Template Name',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'max_length'  => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'Template_for' => [
                'label'  => 'Template for',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'template_expiry_date' => [
                'label'  => 'Template expiry date',
                'rules'  => 'permit_empty|valid_date',
                'errors' => [
                    'required'    => 'Please select a {field}.',
                    'valid_date'  => 'The {field} must be a valid date.',
                ],
            ],
            'required_documents' => [
                'label'  => 'required documents',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],


            'description' => [
                'label'  => 'required documents',
                'rules'  => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

        ];





        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'template_name' => $this->request->getPost('Template_Name'),
            'template_for' => $this->request->getPost('Template_for'),
            'template_expiry_date' => $this->request->getPost('Template_expiry_date'),
            'required_documents' => $this->request->getPost('required_documents'),
            'description' => $this->request->getPost('description'),


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];










        $model = new AuditTemplateModel;
        // // var_dump($data);

        $model->insert($data);










        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'audit template  added successfully!');
    }










    public function add_new_audit_Template()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Audit_template/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Audit_template/index', ['organization' => $organization]);
    }
}
