<?php

namespace App\Controllers;

// use App\Models\Comon_details;
use CodeIgniter\Database\Exceptions\DataException;

class Comon_details extends BaseController
{
    public function get_crop_asseiged_farm()
    {
        $id = $this->request->getPost('id');
        $db = \Config\Database::connect();
        $builder = $db->table('farm_crop_details');

        $builder->select('id, crop_name')
            ->where('status', 1)

            ->where('id', $id);

        $row = $builder->get()->getRowArray();

        if (!empty($row)) {
            $cropNames = array_map('trim', explode(',', $row['crop_name']));
            $data = [];

            foreach ($cropNames as $name) {
                $data[] = [
                    'id' => $name,
                    'crop_name' => $name
                ];
            }

            return $this->response->setJSON([
                'data' => $data,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }

    public function get_crop_catagery_by_farm_and_land()
    {
        $farmer = $this->request->getPost('farmer');
        $farme_land = $this->request->getPost('farmer_land');

        $db      = \Config\Database::connect();
        $builder = $db->table('farm_crop_details');

        $builder->select('farm_crop_details.id, farm_crop_details.crop_id, crop_master.crop_variety')
            ->join('crop_master', 'farm_crop_details.crop_id = crop_master.id', 'left') // LEFT JOIN
            ->where('farm_crop_details.status', 1)
            ->where('farm_crop_details.associated_by', session()->get('user_associated'))
            ->where('farm_crop_details.entity_id', session()->get('entity_id'))
            ->where('farm_crop_details.farmer_id', $farmer)
            ->where('farm_crop_details.farm_id', $farme_land);

        $rows = $builder->get()->getResultArray();

        if (! empty($rows)) {
            return $this->response->setJSON([
                'data'      => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }
        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }



    public function get_crop_veraity_details()
    {
        $Crop_id = $this->request->getPost('data');

        $db      = \Config\Database::connect();
        $builder = $db->table('crop_master');

        $builder->select('id, crop_name')
            ->where('status', 1)
            ->where('associated_by', session()->get('user_associated'))
            ->where('entity_id', session()->get('entity_id'))
            ->where('id', $Crop_id);

        $row = $builder->get()->getRowArray();

        if (!empty($row)) {
            $cropNames = array_map('trim', explode(',', $row['crop_name'])); // Split and trim
            $data = [];

            foreach ($cropNames as $name) {
                $data[] = [
                    'id' => $name, // use crop name as ID for uniqueness
                    'crop_name' => $name
                ];
            }

            return $this->response->setJSON([
                'data' => $data,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }


    public function get_farm_details_by_farmer()
    {



        $farmer_id = $this->request->getPost('data');

        $db      = \Config\Database::connect();
        $builder = $db->table('farmer_land_details');

        $builder->select('id, farm_iD AS farm')  // <— alias farm_iD to farm
            ->where('status',        1)
            // ->where('associated_by', session()->get('user_associated'))
            // ->where('entity_id',     session()->get('entity_id'))
            ->where('farmer_id',     $farmer_id);

        $rows = $builder->get()->getResultArray();

        if (! empty($rows)) {
            return $this->response->setJSON([
                'data'      => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error'     => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }


    public function get_designation_name()
    {



        $department_id = $this->request->getPost('data');

        $db = \Config\Database::connect();
        $builder = $db->table('department');


        $builder->select('designation_name')
            ->where('status', 1)
            ->where('associated_by', session()->get('user_associated'))
            ->where('entity_id', session()->get('entity_id'))
            ->where('id', $department_id);

        $query = $builder->get();
        $rows = $query->getResultArray();


        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }




    public function get_organization_list()
    {


        $entity_type = $this->request->getPost('selected_enity');
        $email_Adress = $this->request->getPost('email_id');
        $table = $this->request->getPost('Loign_as');


        $db = \Config\Database::connect();
        $builder = $db->table($table);


        $builder->select('entity_id')
            ->where('status', 1)
            ->where('associated_by', $entity_type)
            ->where('email', $email_Adress);



        $query = $builder->get();
        $rows = $query->getResultArray();



        $entityDetails = [];

        // Assume $rows is an array containing rows from a previous query
        foreach ($rows as $row) {

            // Get the 'entity_id' from the current row
            $entity_id = $row['entity_id'];

            // Initialize the database connection
            $db = \Config\Database::connect();

            // Query the 'entity_profiles' table for each 'entity_id'
            $entityBuilder = $db->table('entity_profiles'); // The name of the entity table

            // Select specific columns (e.g., 'id' and 'establishment_name') from the entity table
            $entityBuilder->select('id, establishment_name')
                ->where('id', $entity_id); // Assuming 'id' is the primary key in 'entity_profiles'

            // Execute the query to fetch the entity details
            $entityQuery = $entityBuilder->get();

            // Get the first result (if any) and store it in the array
            $entityRow = $entityQuery->getRowArray();

            // If an entity is found, add it to the $entityDetails array
            if ($entityRow) {
                $entityDetails[] = $entityRow;
            }
        }

        $entityCount = count($entityDetails);

        // Generate HTML select dropdown
        if ($entityCount === 1) {
            $html = '<select name="entity_select" id="entity_select" class="form-control" placeholder="Select Entity" required>';
            foreach ($entityDetails as $entity) {
                // Since there's only one entity, mark it as selected
                $html .= "<option value='{$entity['id']}' selected>{$entity['establishment_name']}</option>";
            }
            $html .= '</select>';
        } elseif ($entityCount > 1) {
            // If multiple entities are found
            $html = '<select name="entity_select" id="entity_select" class="form-control" placeholder="Select Entity" required>';
            $html .= '<option value="" selected disabled>Select entity</option>'; // Default placeholder option
            foreach ($entityDetails as $entity) {
                // Add each entity to the select options
                $html .= "<option value='{$entity['id']}'>{$entity['establishment_name']}</option>";
            }
            $html .= '</select>';
        } else {
            // If no entities found
            $html = 0;
        }

        // Return the generated HTML as a JSON response
        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $html,
                'csrfToken' => csrf_hash()
            ]);
        }

        // return $this->response->setJSON([
        //     'error' => 'Data not found',
        //     'csrfToken' => csrf_hash()
        // ]);
    }













    public function get_skill_data()
    {


        $id = $this->request->getPost('data');


        $db = \Config\Database::connect();
        $builder = $db->table('skills');


        $builder->select('required_skills')
            ->where('status', 1)
            ->where('associated_by', session()->get('user_associated'))
            ->where('entity_id', session()->get('entity_id'))
            ->where('id', $id);

        $query = $builder->get();
        $rows = $query->getResultArray();


        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }

    public function get_evalved_by_data()
    {


        $table = $this->request->getPost('data');





        $db = \Config\Database::connect();



        // $builder->select('id, first_name')
        //     ->where('status', 1)
        //     ->where('associated_by', session()->get('user_associated'))
        //     ->where('entity_id', session()->get('entity_id'));
        $builder = $db->table($table);

        if ($table == "employee") {
            $builder->select("CONCAT(first_name, '-', employee_id) AS first_name, id") // Combined name and separate ID
                ->where('status', 1)
                ->where('associated_by', session()->get('user_associated'))
                ->where('entity_id', session()->get('entity_id'));
        }else{

             $builder->select("CONCAT(first_name, '-', ID_Number) AS first_name, id") // Combined name and separate ID
                ->where('status', 1)
                ->where('associated_by', session()->get('user_associated'))
                ->where('entity_id', session()->get('entity_id'));

        }





        $query = $builder->get();
        $rows = $query->getResultArray();


        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }


    public function select_audit_template_based_on_audit_company()
    {


        $data_id = $this->request->getPost('data');



        //         $db = \Config\Database::connect();
        //         $builder = $db->table("audit_template");

        //         $today = date('Y-m-d');   // current date (YYYY-MM-DD)
        //         $templates = $builder
        //             ->select('id, template_name')
        //             ->where('status', 1)                         // status = 1
        //             ->where('entity_id', (int)$data_id)               // current entity
        //             // template_for  = 'all'  OR template_for = current user_associated
        //             ->groupStart()
        //             ->where('template_for', 'all')
        //             ->orWhere('template_for', session()->get('user_associated'))
        //             ->groupEnd()
        //             // template_expiry_date = '0000-00-00'  OR  template_expiry_date <= today
        //             ->groupStart()
        //             ->where('template_expiry_date', '0000-00-00')
        //             ->orWhere('template_expiry_date <=', $today)   // use  >=  if you want “not-expired”
        //             ->groupEnd()
        //             ->get()
        //             ->getResult();

        // echo $builder->getCompiledSelect();
        // die();


        $favcolor = session()->get('user_associated');

        $organization_type = '';
        switch ($favcolor) {
            case "organisation":
                $organization_type = 'organization';
                break;
            case "fpo":
                $organization_type = 'farmer_organization';
                break;
            case "farmers":
                $organization_type = 'farmer';
                break;
            default:
                $organization_type = '';
        }

        $db = \Config\Database::connect();
        $builder = $db->table("audit_template");

        $today = date('Y-m-d');


        $builder->select('id, template_name')
            ->where('status', 1)
            ->where('entity_id', (int)$data_id)
            ->groupStart()
            ->where('template_for', 'all')
            ->orWhere('template_for', $organization_type)
            ->groupEnd()
            ->groupStart()
            ->where('template_expiry_date', '0000-00-00')
            ->orWhere('template_expiry_date <=', $today)
            ->groupEnd();



        $query = $builder->get();
        $rows = $query->getResultArray();


        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }




    public function get_template_details_audit_company()
    {
        $template_id = $this->request->getPost('template_id');


        $db      = \Config\Database::connect();
        $builder = $db->table('audit_template');

        $builder->select('required_documents,description')

            ->where('status', 1)


            ->where('id', $template_id);

        $rows = $builder->get()->getResultArray();

        if (! empty($rows)) {
            return $this->response->setJSON([
                'data'      => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }
        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }
}
