<?php

namespace App\Controllers\Crop_master;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farmer_module;
use App\Models\Crop_master_model;

use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;



class Crop_master extends BaseController
{


    public function delete_crop($id)
    {
        $crop = new Crop_master_model();

        // Check if record exists 
        $existing = $crop->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $crop->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'crop deleted successfully.');
    }


    public function update_crop()
    {


        $rules = [
            'Crop_Variety' => [
                'label' => 'Crop Variety',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the Crop Variety.',
                    'max_length' => 'Crop Variety must not exceed 30 characters.',
                ]
            ],
            'Crop_Name' => [
                'label' => 'Crop Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the Crop Name.',
                    'max_length' => 'Crop Name must not exceed 30 characters.',
                ]
            ],

        ];

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
            // var_dump($this->validator->listErrors());
        }




        $model = new Crop_master_model();

        $data = [
            'crop_variety' => $this->request->getPost('Crop_Variety'),
            'crop_name' => $this->request->getPost('Crop_Name'),


            'updated_at' => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by' => session()->get('logined_user_id'),





        ];

        $model->update($this->request->getPost('crop_id'), $data);

        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'Crop updated successfully');
    }




    public function edit_crop($id)
    {
        $crop_master = new Crop_master_model();
        $crop_master = $crop_master->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);
        // echo "hi";

        return view('' . $session->get('acessing_folder') . '/Crop_master/edit_crop', [
            'crop_master' => $crop_master,
            'organization' => $organization
        ]);
    }

    public function insert_crop()
    {

        $rules = [
            'Crop_Variety' => [
                'label' => 'Crop Variety',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the Crop Variety.',
                    'max_length' => 'Crop Variety must not exceed 30 characters.',
                ]
            ],
            'Crop_Name' => [
                'label' => 'Crop Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the Crop Name.',
                    'max_length' => 'Crop Name must not exceed 30 characters.',
                ]
            ],

        ];

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
            // var_dump($this->validator->listErrors());
        }







        $model = new Crop_master_model();

        $model->insert([
            'crop_variety' => $this->request->getPost('Crop_Variety'),
            'crop_name' => $this->request->getPost('Crop_Name'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,

        ]);

        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'Crop added successfully!');
    }

    public function add_new_crop()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);

        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/Crop_master/add_crop', ['organization' => $organization]);
    }
    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        // $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/Crop_master/index', ['organization' => $organization]);
    }
}
