<?php

namespace App\Controllers\Departement;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\DepartmentDesignationModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Departement extends BaseController
{


    public function delete_department($id)
    {
        $department = new DepartmentDesignationModel();

        // Check if record exists
        $existing = $department->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $department->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'department deleted successfully.');
    }


    public function update_department()
    {
        $department = new DepartmentDesignationModel();

        $data = [
            'department_name' => $this->request->getPost('Department_name'),
            'designation_name' => $this->request->getPost('Designation_Name'),


            'updated_at' => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by' => session()->get('logined_user_id'),





        ];

        $department->update($this->request->getPost('dipartment_id'), $data);

                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'department updated successfully');
    }




    public function edit_department($id)
    {
        $department = new DepartmentDesignationModel();
        $department = $department->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
        // echo "hi";

        return view('' . $session->get('acessing_folder') . '/departement/edit_department', [
            'department' => $department,
            'organization' => $organization
        ]);
    }

    public function insert_department()
    {
   
        $model = new DepartmentDesignationModel();

        $model->insert([
            'department_name' => $this->request->getPost('Department_name'),
            'designation_name' => $this->request->getPost('Designation'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,

        ]);

                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'department added successfully!');
    }

    public function add_department()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/departement/add_departement', ['organization' => $organization]);
    }
    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/departement/index', ['organization' => $organization]);
    }
}
