<?php

namespace App\Controllers;

use App\Models\Farmer_module;

use CodeIgniter\Database\Exceptions\DataException;

class Farmer_controller extends BaseController
{


    public function index()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Farmer_module();

        $organization = $loginModel->find($id);
        return view('farmers/index', ['organization' => $organization]);
    }



    public function verify_otp()
    {

        return view('farmers/verify_otp');
    }

    public function verify_otp_and_update_profile()
    {


        $inputOtp = $this->request->getPost('otp');

        $inputOtp = (int)$inputOtp;

        // echo gettype(session()->get('otp_code'));
 
        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {
                // session()->remove('otp_code');

                $tableName = session()->get('table');;
                $insertId = session()->get('entity_id');

                $data_to_update = session()->get('updated_data');

                $loginModel = new Farmer_module();
                $session = session();
                $id = $session->get('entity_id'); // or session('id');
                // var_dump($data_to_update);


                session()->remove('otp_code');
                if ($loginModel->update($id, $data_to_update)) {




                    $db = \Config\Database::connect();

                    // Define the data to update
                    $data = [
                        'name_of_the_user' => $data_to_update['title'] . ' ' . $data_to_update['first_name'] . ' ' . $data_to_update['middle_name'] . ' ' . $data_to_update['last_name'],

                    ];

                    // Specify the condition for which the record should be updated
                    $builder = $db->table('register_log');

                    // Perform the update
                    $builder->set($data)
                        ->where('user_id', $id)  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->where('user_table', 'farmers')  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->update();




                    return redirect()->to('farmer_login/org_Profile')->with('success', 'farmers data updated successfully!');
                } else {
                    return redirect()->back()->with('error', 'Failed to update data');
                }



                // return redirect()->to('entity_login')->with('success', 'Account created successfully.');
            } else {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }
        } else {
            return redirect()->back()->with('error', 'OTP expired.');
        }
    }













    public function org_profile_edit()
    {


 
        if (session()->get('this_is_entity_login') != true) {

            $rules = [
                'title' => [
                    'label' => 'Title',
                    'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
                    'errors' => [
                        'in_list' => 'Title must be Mr, Mrs, or Ms.',
                    ]
                ],
                'first_name' => [
                    'label' => 'First Name',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'First name is required.',
                        'max_length' => 'First name must not exceed 30 characters.',
                    ]
                ],
                'middle_name' => [
                    'label' => 'Middle Name',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Middle name must not exceed 30 characters.',
                    ]
                ],
                'last_name' => [
                    'label' => 'Last Name',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Last name must not exceed 30 characters.',
                    ]
                ],
                'dob' => [
                    'label' => 'Date of Birth',
                    'rules' => 'permit_empty|valid_date',
                    'errors' => [
                        'valid_date' => 'Please enter a valid date.',
                    ]
                ],
                'income_tax_number' => [
                    'label' => 'Income Tax Number',
                    'rules' => 'required|alpha_numeric|exact_length[10]',
                    'errors' => [
                        'required' => 'Income Tax Number is required.',
                        'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                        'exact_length' => 'Income Tax Number must be exactly 10 characters.',
                    ]
                ],

                // Permanent Address
                'permanent_address1' => [
                    'label' => 'Permanent Address Line 1',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Permanent Address Line 1 is required.',
                        'max_length' => 'Address must not exceed 50 characters.',
                    ]
                ],
                'permanent_address2' => [
                    'label' => 'Permanent Address Line 2',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Address must not exceed 50 characters.',
                    ]
                ],
                'permanent_village' => [
                    'label' => 'Permanent Village',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Village name must not exceed 30 characters.',
                    ]
                ],
                'Permanent_cuntry' => [
                    'label' => 'Permanent Country',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select permanent country.',
                    ]
                ],
                'Permanent_State' => [
                    'label' => 'Permanent State',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select permanent state.',
                    ]
                ],
                'Permanent_city' => [
                    'label' => 'Permanent City',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select permanent city.',
                    ]
                ],
                'permanent_pincode' => [
                    'label' => 'Permanent PIN Code',
                    'rules' => 'required|numeric|exact_length[6]',
                    'errors' => [
                        'required' => 'PIN Code is required.',
                        'numeric' => 'PIN Code must be numeric.',
                        'exact_length' => 'PIN Code must be exactly 6 digits.',
                    ]
                ],

                // Communication Address
                'communication_address1' => [
                    'label' => 'Communication Address Line 1',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Communication Address Line 1 is required.',
                        'max_length' => 'Address must not exceed 50 characters.',
                    ]
                ],
                'communication_address2' => [
                    'label' => 'Communication Address Line 2',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Address must not exceed 50 characters.',
                    ]
                ],
                'communication_village' => [
                    'label' => 'Communication Village',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'Village name must not exceed 30 characters.',
                    ]
                ],
                'communication_country' => [
                    'label' => 'Communication Country',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select communication country.',
                    ]
                ],
                'communication_State' => [
                    'label' => 'Communication State',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select communication state.',
                    ]
                ],
                'communication_city' => [
                    'label' => 'Communication City',
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Please select communication city.',
                    ]
                ],
                'communication_pincode' => [
                    'label' => 'Communication PIN Code',
                    'rules' => 'required|numeric|exact_length[6]',
                    'errors' => [
                        'required' => 'PIN Code is required.',
                        'numeric' => 'PIN Code must be numeric.',
                        'exact_length' => 'PIN Code must be exactly 6 digits.',
                    ]
                ],

                // Contact Info
                'contact_mobile' => [
                    'label' => 'Mobile Number',
                    'rules' => 'required|numeric|exact_length[10]',
                    'errors' => [
                        'required' => 'Mobile number is required.',
                        'numeric' => 'Mobile number must be numeric.',
                        'exact_length' => 'Mobile number must be exactly 10 digits.',
                    ]
                ],
                'contact_fixedline' => [
                    'label' => 'Fixedline Number',
                    'rules' => 'permit_empty|numeric|exact_length[10]',
                    'errors' => [
                        'numeric' => 'Fixedline number must be numeric.',
                        'exact_length' => 'Fixedline number must be exactly 10 digits.',
                    ]
                ],

                'email' => [
                    'label' => 'Email ID',
                    'rules' => 'required|valid_email|unique_email_across_tables_on_update[farmers.email]',
                    'errors' => [
                        'required' => 'Email is required.',
                        'valid_email' => 'Please enter a valid email address.',
                        'max_length' => 'Email must not exceed 50 characters.',
                        'is_unique' => 'This email is already registered.',
                    ]
                ],

                'password' => [
                    'label' => 'Password',
                    'rules' => 'permit_empty|min_length[8]',
                    'errors' => [
                        'required' => 'Password is required.',
                        'min_length' => 'Password must be at least 8 characters.',
                    ]
                ]
            ];
        } else {

            $rules = [
                'title' => [
                    'label' => 'Title',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'Please select a title.'
                    ]
                ],
                'first_name' => [
                    'label' => 'First Name',
                    'rules' => 'required|alpha_space',
                    'errors' => [
                        'required' => 'First name is required.',
                        'alpha_space' => 'First name can only contain letters and spaces.'
                    ]
                ],
                'Middle_name' => [
                    'label' => 'Middle name',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'Middle name is required.',
                    ]
                ],
                'Last_name' => [
                    'label' => 'Last Name',
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'Last name is required.',
                    ]
                ],


                'Gender' => [
                    'rules' => 'permit_empty|in_list[Male,Female,Other]',
                    'errors' => [
                        'required' => 'Gender is required.',
                        'in_list' => 'Gender must be Male, Female, or Other.',
                    ]
                ],


                'name_of_supervisor' => [
                    'rules' => 'permit_empty|numeric',
                    'errors' => [
                        'required' => 'Name of the Supervisor is required.',
                        'numeric' => 'Name of the Supervisor  ID must be numeric.',
                    ]
                ],


                'adresss_1' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Address Line 1 is required.',
                    ]
                ],
                'adresss_2' => [
                    'rules' => 'permit_empty'
                ],
                'Village' => [
                    'rules' => 'permit_empty|alpha_space',
                    'errors' => [
                        'required' => 'Village is required.',
                        'alpha_space' => 'Village must contain only letters and spaces.',
                    ]
                ],
                'country' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'Country is required.',
                    ]
                ],
                'state' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'State is required.',
                    ]
                ],
                'city' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'City is required.',
                    ]
                ],
                'pin_code' => [
                    'rules' => 'required|numeric|exact_length[6]',
                    'errors' => [
                        'required' => 'PIN code is required.',
                        'numeric' => 'PIN code must be numeric.',
                        'exact_length' => 'PIN code must be exactly 6 digits.',
                    ]
                ],
                'Membership_Start_Date' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'required' => 'Membership start date is required.',
                        'valid_date' => 'Provide a valid date (YYYY-MM-DD).',
                    ]
                ],
                'insurance_coverage' => [
                    'rules' => 'permit_empty|in_list[Yes,No]',
                    'errors' => [
                        'required' => 'Insurance coverage is required.',
                        'in_list' => 'Insurance coverage must be Yes or No.',
                    ]
                ],
                'Training_Received' => [
                    'rules' => 'permit_empty|in_list[Yes,No]',
                    'errors' => [
                        'required' => 'Training received field is required.',
                        'in_list' => 'Training received must be Yes or No.',
                    ]
                ],
                'Training_Title' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'The {field} must not exceed 100 characters',
                    ]
                ],
                'Training_Date' => [
                    'rules' => 'permit_empty|valid_date[Y-m-d]',
                    'errors' => [
                        'valid_date' => 'Training date must be a valid date (YYYY-MM-DD).',
                    ]
                ],
                'Conducted_By' => [
                    'rules' => 'permit_empty',
                    'errors' => [
                        'max_length' => 'The {field} must not exceed 100 characters',
                    ]
                ],

                'contact_number' => [
                    'label' => 'contact number',
                    'rules' => 'permit_empty|max_length[10]',
                    'errors' => [
                        'max_length' => 'The {field} must not exceed 100 characters',
                    ]
                ],
                'email_id' => [
                    'label' => 'Email Address',
                    'rules' => 'required|valid_email|unique_email_across_tables_on_update[farmers.email]',
                    'errors' => [
                        'required' => 'The {field} is required.',
                        'valid_email' => 'The {field} must be a valid email address.',
                        'max_length' => 'The {field} must not exceed 50 characters.',
                        'unique_email_across_tables_on_update' => 'This email ID is already registered for the selected organization.',
                    ]
                ],



            ];
        }






        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);



 
return redirect()->to(site_url('farmer_login/org_Profile'))->withInput();
            // var_dump($this->validator->listErrors());
        }


       



        if (session()->get('this_is_entity_login') != true) {

            $data = [
                'title' => $this->request->getPost('title'),
                'first_name' => $this->request->getPost('first_name'),
                'middle_name' => $this->request->getPost('middle_name'),
                'last_name' => $this->request->getPost('last_name'),
                'dob' => $this->request->getPost('dob'),
                'income_tax_number' => $this->request->getPost('income_tax_number'),

                // Permanent Address
                'permanent_address1' => $this->request->getPost('permanent_address1'),
                'permanent_address2' => $this->request->getPost('permanent_address2'),
                'permanent_village' => $this->request->getPost('permanent_village'),
                'permanent_country' => $this->request->getPost('Permanent_cuntry'),
                'permanent_state' => $this->request->getPost('Permanent_State'),
                'permanent_city' => $this->request->getPost('Permanent_city'),
                'permanent_pincode' => $this->request->getPost('permanent_pincode'),

                // Communication Address
                'communication_address1' => $this->request->getPost('communication_address1'),
                'communication_address2' => $this->request->getPost('communication_address2'),
                'communication_village' => $this->request->getPost('communication_village'),
                'communication_country' => $this->request->getPost('communication_country'),
                'communication_state' => $this->request->getPost('communication_State'),
                'communication_city' => $this->request->getPost('communication_city'),
                'communication_pincode' => $this->request->getPost('communication_pincode'),

                // Contact Info
                'contact_mobile' => $this->request->getPost('contact_mobile'),
                'contact_fixedline' => $this->request->getPost('contact_fixedline'),

                // Credentials

                'email' => $this->request->getPost('email'),
            ];
        } else {

            $data = [
                'title' => $this->request->getPost('title'),
                'first_name' => $this->request->getPost('first_name'),
                'middle_name' => $this->request->getPost('Middle_name'),
                'last_name' => $this->request->getPost('Last_name'),

                'permanent_address1' => $this->request->getPost('adresss_1'),
                'permanent_address2' => $this->request->getPost('adresss_2'),
                'permanent_village' => $this->request->getPost('Village'),
                'permanent_country' => $this->request->getPost('country'),
                'permanent_state' => $this->request->getPost('state'),
                'permanent_city' => $this->request->getPost('city'),
                'permanent_pincode' => $this->request->getPost('pin_code'),
                'communication_address1' => $this->request->getPost('adresss_1'),
                'communication_address2' => $this->request->getPost('adresss_2'),
                'communication_village' => $this->request->getPost('Village'),
                'communication_country' => $this->request->getPost('country'),
                'communication_state' => $this->request->getPost('state'),
                'communication_city' => $this->request->getPost('city'),
                'communication_pincode' => $this->request->getPost('pin_code'),

                'email' => $this->request->getPost('email_id'),


                'name_of_the_supervisor' => $this->request->getPost('name_of_supervisor'),
                'gender' => $this->request->getPost('Gender'),
                'membership_start_date' => $this->request->getPost('Membership_Start_Date'),
                'insurance_coverage' => $this->request->getPost('insurance_coverage'),
                'training_received' => $this->request->getPost('Training_Received'),
                'training_title' => $this->request->getPost('Training_Title'),
                'training_date' => $this->request->getPost('Training_Date'),
                'conducted_by' => $this->request->getPost('Conducted_By'),
                'contact_mobile' => $this->request->getPost('contact_number'),
                'Remark' => $this->request->getPost('Remark'),




                'updated_by' => session()->get('logined_user_id'), // Empty for now,




            ];


            $remainingRaw = $this->request->getPost('remaining_images');
            $remaining_images = json_decode($remainingRaw ?? '[]', true);  // Treat null as empty array
            $remaining_images = is_array($remaining_images) ? $remaining_images : [];

            $mergedArray = $remaining_images;
            $insertId = $this->request->getPost('updating_id');
            $photos = $this->request->getFileMultiple('Photos');

            $session_id = session()->get('entity_id');

            if ($photos && count($photos) > 0) {
                $photoPaths = [];
                $errors = [];

                foreach ($photos as $index => $photo) {
                    if (!$photo->isValid() || $photo->hasMoved()) {
                        $errors[] = "File {$photo->getName()} is not valid or already moved.";
                        continue;
                    }

                    $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff'];
                    if (!in_array($photo->getMimeType(), $allowedTypes)) {
                        $errors[] = "File {$photo->getName()} is not an accepted image type.";
                        continue;
                    }

                    $maxSize = 5 * 1024 * 1024;
                    if ($photo->getSize() > $maxSize) {
                        $errors[] = "File {$photo->getName()} exceeds 5MB size limit.";
                        continue;
                    }

                    $photoName = $photo->getRandomName();
                    $photoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                    $photoPath = FCPATH . $photoDir;

                    if (!is_dir($photoPath)) {
                        mkdir($photoPath, 0777, true);
                    }

                    $photo->move($photoPath, $photoName);
                    $relativePath = $photoDir . $photoName;
                    $photoPaths[] = $relativePath;
                }

                if (!empty($photoPaths)) {
                    $mergedArray = array_merge($photoPaths, $remaining_images);

                    $folderPath = FCPATH . "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                    $keepFilenames = array_map('basename', $mergedArray);

                    if (is_dir($folderPath)) {
                        $filesInFolder = scandir($folderPath);
                        foreach ($filesInFolder as $file) {
                            if ($file === '.' || $file === '..') continue;
                            if (!in_array($file, $keepFilenames)) {
                                $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                                if (is_file($filePath)) {
                                    unlink($filePath);
                                }
                            }
                        }
                    }
                }

                if (!empty($errors)) {
                    log_message('error', 'Upload errors: ' . implode(', ', $errors));
                    // session()->set('validation_errors', implode('<br>', $errors));
                    // session()->markAsTempdata('validation_errors', 30);
                }
                $data['Photos'] = json_encode($mergedArray);
            }














            $docNames = $this->request->getPost('doc_name');
            $docDates = $this->request->getPost('doc_date');
            $existingFiles = $this->request->getPost('existing_file');
            $files = $this->request->getFiles();

            $documents = [];
            $entityId = session()->get('entity_id');
            $uploadFolder = "uploads/entity_profile/{$entityId}/Farmer/{$insertId}/documants/";
            $uploadPath = FCPATH . $uploadFolder;

            if (!empty($docNames) && is_array($docNames)) {

                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777, true);
                }
                foreach ($docNames as $i => $docName) {
                    $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

                    if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                        // Delete old file
                        if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                            unlink(FCPATH . $existingFiles[$i]);
                        }

                        $file = $files['doc_file'][$i];
                        $newName = $file->getRandomName();
                        $file->move($uploadPath, $newName); // Move to new path
                        $newFilePath = $uploadFolder . $newName; // Save relative path
                    }

                    $documents[] = [
                        'name' => $docName,
                        'date' => $docDates[$i],
                        'file' => $newFilePath
                    ];
                }

                $data['documents'] = json_encode($documents);
            } else {
                $data['documents'] = NULL;
            }






            $model = new Farmer_module();
            $existing = $model->find($insertId);




            $files = $this->request->getFileMultiple('Person_Photo');


            if (is_array($files) && count($files) > 0) {
                $uploadedFirstImage = false;

                foreach ($files as $file) {

                    if (!$file->isValid() || $file->getError() === 4) {
                        continue;
                    }
                    if ($file->isValid() && !$file->hasMoved()) {
                        $ext = strtolower($file->getClientExtension());
                        $allowed = ['jpeg', 'jpg', 'png', 'webp', 'gif', 'bmp', 'tiff'];

                        if (!in_array($ext, $allowed)) {
                            session()->set('validation_errors', "Invalid file type uploaded.");
                            session()->markAsTempdata('validation_errors', 30);





                            return redirect()->back()->withInput();
                        }

                        if ($existing && !empty($existing['Person_Photo'])) {
                            $oldImagePath = FCPATH . $existing['Person_Photo']; // Full path to old image
                            if (file_exists($oldImagePath)) {
                                unlink($oldImagePath); // Delete the old image
                            }
                        }




                        // Prepare upload directory
                        $logoName = $file->getRandomName();
                        $logoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                        $logoPath = FCPATH . $logoDir;

                        if (!is_dir($logoPath)) {
                            mkdir($logoPath, 0777, true);
                        }

                        // Delete existing image only once for the first valid file
                        if (!$uploadedFirstImage && $existing && !empty($existing['Person_Photo'])) {
                            $oldImagePath = FCPATH . $existing['Person_Photo'];
                            if (file_exists($oldImagePath)) {
                                unlink($oldImagePath);
                            }
                        }

                        // Move the file
                        $file->move($logoPath, $logoName);

                        // Save the first image's path
                        if (!$uploadedFirstImage) {
                            $data['Person_Photo'] = $logoDir . '/' . $logoName;
                            $uploadedFirstImage = true;
                        }

                        // Optionally: save all file paths in array for future use
                        // $all_uploaded_paths[] = $logoDir . '/' . $logoName;
                    }
                }
            }
        }


        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }






        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Farmer_module();

        $organization = $loginModel->find($id);

        // 1. Generate 6-digit OTP
        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($organization['email']);
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $organization['title'] . ' ' . $organization['first_name']  . ' ' . $organization['middle_name']  . ' ' . $organization['last_name']  . '</h3>
        <p>Your One-Time Password (OTP) for updating profile is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {

            var_dump($data);
            session()->set('otp_code', $otp);

            session()->set('updated_data', $data);
            session()->set('reciver_email', $organization['email']);
            session()->set('user_name', $organization['title'] . ' ' . $organization['first_name'] . ' ' . $organization['middle_name'] . ' ' . $organization['last_name']);

            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

            return redirect()->to('farmer_login/verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }

    public function org_Profile()
    {

        $session = session();


        $id = $session->get('entity_id');
        $loginModel = new Farmer_module();

        $organization = $loginModel->find($id);


        // var_dump($organization);
        return view('farmers/org_profile_page', ['organization' => $organization]);
    }



    public function toggleAutoId()
    {

        $newValue = $this->request->getPost('value');
        $entityId = session()->get('entity_id');

        // Example update
        $db = \Config\Database::connect();
        $db->table('farmers')
            ->where('id', $entityId)
            ->update(['audo_id_gendrator' => $newValue]);

        return $this->response->setJSON(['status' => 'success', 'newValue' => $newValue]);
    }
}
