<?php

namespace App\Controllers\Farmer_land_details;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farmer_module;
use App\Models\FarmerLandDetailsModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Farmer_land_details extends BaseController
{


    public function delete_farm($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $farm = new FarmerLandDetailsModel();

        // Check if record exists
        $existing = $farm->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $farm->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'farm   deleted successfully.');
    }


    public function update_farm()
    {




        $rules = [
            'facility_id' => [
                'label'  => 'Farm id',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farm_location' => [
                'label'  => 'Farm Location',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farm_year' => [
                'label'  => 'Farm Year',
                'rules'  => 'permit_empty|integer|greater_than_equal_to[1900]|less_than_equal_to[2025]',
                'errors' => [
                    'required'              => 'Please select a {field}.',
                    'integer'               => 'The {field} must be a valid year.',
                    'greater_than_equal_to' => 'The {field} must be at least 1900.',
                    'less_than_equal_to'    => 'The {field} cannot exceed 2025.',
                ],
            ],
            'Ownership' => [
                'label'  => 'Farm Ownership',
                'rules'  => 'permit_empty|in_list[Own,Leasehold]',
                'errors' => [
                    'required' => 'Please select {field}.',
                    'in_list'  => 'The {field} must be either Own or Leasehold.',
                ],
            ],
            'number_of_years_leasehold' => [
                'label'  => 'Number of Years Leasehold',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'integer'       => 'The {field} must be a valid number.',
                    'greater_than'  => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_mandal' => [
                'label'  => 'Farm Mandal',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_district' => [
                'label'  => 'Farm District',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_survey_parcel_number' => [
                'label'  => 'Survey Parcel Number',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_area' => [
                'label'  => 'Farm Area',
                'rules'  => 'required|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_total_extent_land' => [
                'label'  => 'Total Extent of Land',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_total_extent_under_cultivation' => [
                'label'  => 'Extent under Cultivation',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];




        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farm_iD' => $this->request->getPost('facility_id'),
            'farmer_id' => $this->request->getPost('farmer'),
            'location' => $this->request->getPost('farm_location'),
            'year' => $this->request->getPost('farm_year'),
            'ownership' => $this->request->getPost('Ownership'),
            'no_of_years_Leasehold' => $this->request->getPost('number_of_years_leasehold'),
            'mandal' => $this->request->getPost('farm_mandal'),
            'district' => $this->request->getPost('farm_district'),
            'survey_parcel_number' => $this->request->getPost('farm_survey_parcel_number'),
            'farm_area' => $this->request->getPost('farm_area'),
            'total_extent_of_land' => $this->request->getPost('farm_total_extent_land'),
            'extent_under_cultivation' => $this->request->getPost('farm_total_extent_under_cultivation'),
            'Remark' => $this->request->getPost('Remark'),




            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];


        $insertId = $this->request->getPost('updating_id');




        $session_id = session()->get('entity_id');






        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/farm/{$insertId}/Document/";
        $uploadPath = FCPATH . $uploadFolder;

        if (!empty($docNames) && is_array($docNames)) {

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            foreach ($docNames as $i => $docName) {
                $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

                if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                    // Delete old file
                    if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                        unlink(FCPATH . $existingFiles[$i]);
                    }

                    $file = $files['doc_file'][$i];
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName); // Move to new path
                    $newFilePath = $uploadFolder . $newName; // Save relative path
                }

                $documents[] = [
                    'name' => $docName,
                    'date' => $docDates[$i],
                    'file' => $newFilePath
                ];
            }

            $data['document'] = json_encode($documents);
        }















        $model = new FarmerLandDetailsModel();



        $model->update($insertId, $data);




        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'farm  updated successfully');
    }



    public function edit_farm_details($id)
    {
        $FarmerLandDetail = new FarmerLandDetailsModel();
        $FarmerLandDetail = $FarmerLandDetail->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Farmer_land_details/edit', [
            'FarmerLandDetail' => $FarmerLandDetail,
            'organization' => $organization
        ]);
    }


    public function view_farm($id)
    {
        $FarmerLandDetail = new FarmerLandDetailsModel();
        $FarmerLandDetail = $FarmerLandDetail->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Farmer_land_details/view', [
            'FarmerLandDetail' => $FarmerLandDetail,
            'organization' => $organization
        ]);
    }


    public function insert_farm()
    {



        $rules = [
            'facility_id' => [
                'label'  => 'Farm id',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farm_location' => [
                'label'  => 'Farm Location',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 30 characters.',
                ],
            ],
            'farm_year' => [
                'label'  => 'Farm Year',
                'rules'  => 'permit_empty|integer|greater_than_equal_to[1900]|less_than_equal_to[2025]',
                'errors' => [
                    'required'              => 'Please select a {field}.',
                    'integer'               => 'The {field} must be a valid year.',
                    'greater_than_equal_to' => 'The {field} must be at least 1900.',
                    'less_than_equal_to'    => 'The {field} cannot exceed 2025.',
                ],
            ],
            'Ownership' => [
                'label'  => 'Farm Ownership',
                'rules'  => 'permit_empty|in_list[Own,Leasehold]',
                'errors' => [
                    'required' => 'Please select {field}.',
                    'in_list'  => 'The {field} must be either Own or Leasehold.',
                ],
            ],
            'number_of_years_leasehold' => [
                'label'  => 'Number of Years Leasehold',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'integer'       => 'The {field} must be a valid number.',
                    'greater_than'  => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_mandal' => [
                'label'  => 'Farm Mandal',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_district' => [
                'label'  => 'Farm District',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_survey_parcel_number' => [
                'label'  => 'Survey Parcel Number',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'farm_area' => [
                'label'  => 'Farm Area',
                'rules'  => 'required|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_total_extent_land' => [
                'label'  => 'Total Extent of Land',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'farm_total_extent_under_cultivation' => [
                'label'  => 'Extent under Cultivation',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];




        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'farm_iD' => $this->request->getPost('facility_id'),
            'farmer_id' => $this->request->getPost('farmer'),
            'location' => $this->request->getPost('farm_location'),
            'year' => $this->request->getPost('farm_year'),
            'ownership' => $this->request->getPost('Ownership'),
            'no_of_years_Leasehold' => $this->request->getPost('number_of_years_leasehold'),
            'mandal' => $this->request->getPost('farm_mandal'),
            'district' => $this->request->getPost('farm_district'),
            'survey_parcel_number' => $this->request->getPost('farm_survey_parcel_number'),
            'farm_area' => $this->request->getPost('farm_area'),
            'total_extent_of_land' => $this->request->getPost('farm_total_extent_land'),
            'extent_under_cultivation' => $this->request->getPost('farm_total_extent_under_cultivation'),
            'Remark' => $this->request->getPost('Remark'),


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];


        $model = new FarmerLandDetailsModel;
        // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();



        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];
        if (!empty($docFiles) && is_array($docFiles) && isset($docNames[0]) && $docFiles[0]->getName()) {


            $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/farm/{$insertId}/Document";
            $relativeBasePath = "uploads/entity_profile/{$entityId}/farm/{$insertId}/Document";

            // Create directory if not exists
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Loop and process each document
            foreach ($docNames as $i => $name) {
                $date = $docDates[$i];
                $file = $docFiles[$i];

                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName);

                    $documents[] = [
                        'name' => $name,
                        'date' => $date,
                        'file' => "{$relativeBasePath}/{$newName}"
                    ];
                }
            }

            $model->update($insertId, [
                'document' => json_encode($documents)
            ]);
        }









        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
        return redirect()->to($redirectUrl)->with('success', 'farm added successfully!');
    }





    public function add_new_farmer_land()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Farmer_land_details/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Farmer_land_details/index', ['organization' => $organization]);
    }
}
