<?php

namespace App\Controllers\Farmers;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farmer_module;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Farmers extends BaseController
{


    public function delete_farmer($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Farmer = new Farmer_module();

        // Check if record exists
        $existing = $Farmer->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Farmer->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Farmer  deleted successfully.');
    }


    public function update_farmer()
    {





        $rules = [
            'title' => [
                'label' => 'Title',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a title.'
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required|alpha_space',
                'errors' => [
                    'required' => 'First name is required.',
                    'alpha_space' => 'First name can only contain letters and spaces.'
                ]
            ],
            'Middle_name' => [
                'label' => 'Middle name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Middle name is required.',
                ]
            ],
            'Last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Last name is required.',
                ]
            ],


            'Gender' => [
                'rules' => 'permit_empty|in_list[Male,Female,Other]',
                'errors' => [
                    'required' => 'Gender is required.',
                    'in_list' => 'Gender must be Male, Female, or Other.',
                ]
            ],


            'name_of_the_supervisor' => [
                'rules' => 'permit_empty|numeric',
                'errors' => [
                    'required' => 'Name of the Supervisor is required.',
                    'numeric' => 'Name of the Supervisor  ID must be numeric.',
                ]
            ],


            'adresss_1' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Address Line 1 is required.',
                ]
            ],
            'adresss_2' => [
                'rules' => 'permit_empty'
            ],
            'Village' => [
                'rules' => 'permit_empty|alpha_space',
                'errors' => [
                    'required' => 'Village is required.',
                    'alpha_space' => 'Village must contain only letters and spaces.',
                ]
            ],
            'country' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Country is required.',
                ]
            ],
            'state' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'State is required.',
                ]
            ],
            'city' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'City is required.',
                ]
            ],
            'pin_code' => [
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN code is required.',
                    'numeric' => 'PIN code must be numeric.',
                    'exact_length' => 'PIN code must be exactly 6 digits.',
                ]
            ],
            'Membership_Start_Date' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Membership start date is required.',
                    'valid_date' => 'Provide a valid date (YYYY-MM-DD).',
                ]
            ],
            'insurance_coverage' => [
                'rules' => 'permit_empty|in_list[Yes,No]',
                'errors' => [
                    'required' => 'Insurance coverage is required.',
                    'in_list' => 'Insurance coverage must be Yes or No.',
                ]
            ],
            'Training_Received' => [
                'rules' => 'permit_empty|in_list[Yes,No]',
                'errors' => [
                    'required' => 'Training received field is required.',
                    'in_list' => 'Training received must be Yes or No.',
                ]
            ],
            'Training_Title' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],
            'Training_Date' => [
                'rules' => 'permit_empty|valid_date[Y-m-d]',
                'errors' => [
                    'valid_date' => 'Training date must be a valid date (YYYY-MM-DD).',
                ]
            ],
            'Conducted_By' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],

            'contact_number' => [
                'label' => 'contact number',
                'rules' => 'permit_empty|max_length[10]',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],
            'email_id' => [
                'label' => 'Email Address',
                'rules' => 'required|valid_email|unique_email_across_tables_on_update[farmers.email]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'valid_email' => 'The {field} must be a valid email address.',
                    'max_length' => 'The {field} must not exceed 50 characters.',
                    'unique_email_across_tables_on_update' => 'This email ID is already registered for the selected organization.',
                ]
            ],



        ];



        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }


        $data = [
            'title' => $this->request->getPost('title'),
            'first_name' => $this->request->getPost('first_name'),
            'middle_name' => $this->request->getPost('Middle_name'),
            'last_name' => $this->request->getPost('Last_name'),

            'permanent_address1' => $this->request->getPost('adresss_1'),
            'permanent_address2' => $this->request->getPost('adresss_2'),
            'permanent_village' => $this->request->getPost('Village'),
            'permanent_country' => $this->request->getPost('country'),
            'permanent_state' => $this->request->getPost('state'),
            'permanent_city' => $this->request->getPost('city'),
            'permanent_pincode' => $this->request->getPost('pin_code'),
            'communication_address1' => $this->request->getPost('adresss_1'),
            'communication_address2' => $this->request->getPost('adresss_2'),
            'communication_village' => $this->request->getPost('Village'),
            'communication_country' => $this->request->getPost('country'),
            'communication_state' => $this->request->getPost('state'),
            'communication_city' => $this->request->getPost('city'),
            'communication_pincode' => $this->request->getPost('pin_code'),

            'email' => $this->request->getPost('email_id'),


            'name_of_the_supervisor' => $this->request->getPost('name_of_supervisor'),
            'gender' => $this->request->getPost('Gender'),
            'membership_start_date' => $this->request->getPost('Membership_Start_Date'),
            'insurance_coverage' => $this->request->getPost('insurance_coverage'),
            'training_received' => $this->request->getPost('Training_Received'),
            'training_title' => $this->request->getPost('Training_Title'),
            'training_date' => $this->request->getPost('Training_Date'),
            'conducted_by' => $this->request->getPost('Conducted_By'),
            'contact_mobile' => $this->request->getPost('contact_number'),
            'Remark' => $this->request->getPost('Remark'),




            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];


        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }





        // Handle null or empty remaining_images safely
        $remainingRaw = $this->request->getPost('remaining_images');
        $remaining_images = json_decode($remainingRaw ?? '[]', true);  // Treat null as empty array
        $remaining_images = is_array($remaining_images) ? $remaining_images : [];

        $mergedArray = $remaining_images;
        $insertId = $this->request->getPost('updating_id');
        $photos = $this->request->getFileMultiple('Photos');

        $session_id = session()->get('entity_id');

        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff'];
                if (!in_array($photo->getMimeType(), $allowedTypes)) {
                    $errors[] = "File {$photo->getName()} is not an accepted image type.";
                    continue;
                }

                $maxSize = 5 * 1024 * 1024;
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds 5MB size limit.";
                    continue;
                }

                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . $photoName;
                $photoPaths[] = $relativePath;
            }

            if (!empty($photoPaths)) {
                $mergedArray = array_merge($photoPaths, $remaining_images);

                $folderPath = FCPATH . "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                $keepFilenames = array_map('basename', $mergedArray);

                if (is_dir($folderPath)) {
                    $filesInFolder = scandir($folderPath);
                    foreach ($filesInFolder as $file) {
                        if ($file === '.' || $file === '..') continue;
                        if (!in_array($file, $keepFilenames)) {
                            $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                            if (is_file($filePath)) {
                                unlink($filePath);
                            }
                        }
                    }
                }
            }

            if (!empty($errors)) {
                log_message('error', 'Upload errors: ' . implode(', ', $errors));
                // session()->set('validation_errors', implode('<br>', $errors));
                // session()->markAsTempdata('validation_errors', 30);
            }
              $data['Photos'] = json_encode($mergedArray);
        }

      












        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Farmer/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;

        if (!empty($docNames) && is_array($docNames)) {

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            foreach ($docNames as $i => $docName) {
                $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

                if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                    // Delete old file
                    if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                        unlink(FCPATH . $existingFiles[$i]);
                    }

                    $file = $files['doc_file'][$i];
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName); // Move to new path
                    $newFilePath = $uploadFolder . $newName; // Save relative path
                }

                $documents[] = [
                    'name' => $docName,
                    'date' => $docDates[$i],
                    'file' => $newFilePath
                ];
            }

            $data['documents'] = json_encode($documents);
        } else {
            $data['documents'] = NULL;
        }






        $model = new Farmer_module();
        $existing = $model->find($insertId);




        $files = $this->request->getFileMultiple('Person_Photo');
        

        if (is_array($files) && count($files) > 0) {
            $uploadedFirstImage = false;

            foreach ($files as $file) {

                  if (!$file->isValid() || $file->getError() === 4) {
                    continue;
                }
                if ($file->isValid() && !$file->hasMoved()) {
                    $ext = strtolower($file->getClientExtension());
                    $allowed = ['jpeg', 'jpg', 'png', 'webp', 'gif', 'bmp', 'tiff'];

                    if (!in_array($ext, $allowed)) {
                        session()->set('validation_errors', "Invalid file type uploaded.");
                        session()->markAsTempdata('validation_errors', 30);





                        return redirect()->back()->withInput();
                    }

                    if ($existing && !empty($existing['Person_Photo'])) {
                        $oldImagePath = FCPATH . $existing['Person_Photo']; // Full path to old image
                        if (file_exists($oldImagePath)) {
                            unlink($oldImagePath); // Delete the old image
                        }
                    }




                    // Prepare upload directory
                    $logoName = $file->getRandomName();
                    $logoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos/";
                    $logoPath = FCPATH . $logoDir;

                    if (!is_dir($logoPath)) {
                        mkdir($logoPath, 0777, true);
                    }

                    // Delete existing image only once for the first valid file
                    if (!$uploadedFirstImage && $existing && !empty($existing['Person_Photo'])) {
                        $oldImagePath = FCPATH . $existing['Person_Photo'];
                        if (file_exists($oldImagePath)) {
                            unlink($oldImagePath);
                        }
                    }

                    // Move the file
                    $file->move($logoPath, $logoName);

                    // Save the first image's path
                    if (!$uploadedFirstImage) {
                        $data['Person_Photo'] = $logoDir . '/' . $logoName;
                        $uploadedFirstImage = true;
                    }

                    // Optionally: save all file paths in array for future use
                    // $all_uploaded_paths[] = $logoDir . '/' . $logoName;
                }
            }
        }













        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






            $db = \Config\Database::connect();

            // Define the data to update
            $data_new = [
                'name_of_the_user' => $this->request->getPost('title') . ' ' . $this->request->getPost('first_name') . ' ' . $this->request->getPost('Middle_name') . ' ' . $this->request->getPost('Last_name'),

            ];

            // Specify the condition for which the record should be updated
            $builder = $db->table('register_log');

            // Perform the update
            $builder->set($data_new)
                ->where('user_id', $insertId)  // Use the appropriate condition (e.g., primary key or other unique column)
                ->where('user_table', 'farmers')  // Use the appropriate condition (e.g., primary key or other unique column)
                ->update();



            //    var_dump($_POST['designation']);
                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_farmer($id)
    {
        $farmer = new Farmer_module();
        $farmer = $farmer->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Farmer/edit', [
            'farmer' => $farmer,
            'organization' => $organization
        ]);
    }


    public function view_farmer($id)
    {
        $farmer = new Farmer_module();
        $farmer = $farmer->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Farmer/view', [
            'farmer' => $farmer,
            'organization' => $organization
        ]);
    }


    public function insert_farmer()
    {

        $rules = [
            'title' => [
                'label' => 'Title',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a title.'
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required|alpha_space',
                'errors' => [
                    'required' => 'First name is required.',
                    'alpha_space' => 'First name can only contain letters and spaces.'
                ]
            ],
            'Middle_name' => [
                'label' => 'Middle name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Middle name is required.',
                ]
            ],
            'Last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Last name is required.',
                ]
            ],
            'facility_id' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Employee ID is required.',
                ]
            ],

            'Gender' => [
                'rules' => 'permit_empty|in_list[Male,Female,Other]',
                'errors' => [
                    'required' => 'Gender is required.',
                    'in_list' => 'Gender must be Male, Female, or Other.',
                ]
            ],


            'name_of_the_supervisor' => [
                'rules' => 'permit_empty|numeric',
                'errors' => [
                    'required' => 'Name of the Supervisor is required.',
                    'numeric' => 'Name of the Supervisor  ID must be numeric.',
                ]
            ],
            'password' => [
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters long.',
                ]
            ],

            'adresss_1' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Address Line 1 is required.',
                ]
            ],
            'adresss_2' => [
                'rules' => 'permit_empty'
            ],
            'Village' => [
                'rules' => 'permit_empty|alpha_space',
                'errors' => [
                    'required' => 'Village is required.',
                    'alpha_space' => 'Village must contain only letters and spaces.',
                ]
            ],
            'country' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Country is required.',
                ]
            ],
            'state' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'State is required.',
                ]
            ],
            'city' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'City is required.',
                ]
            ],
            'pin_code' => [
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN code is required.',
                    'numeric' => 'PIN code must be numeric.',
                    'exact_length' => 'PIN code must be exactly 6 digits.',
                ]
            ],
            'Membership_Start_Date' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Membership start date is required.',
                    'valid_date' => 'Provide a valid date (YYYY-MM-DD).',
                ]
            ],
            'insurance_coverage' => [
                'rules' => 'permit_empty|in_list[Yes,No]',
                'errors' => [
                    'required' => 'Insurance coverage is required.',
                    'in_list' => 'Insurance coverage must be Yes or No.',
                ]
            ],
            'Training_Received' => [
                'rules' => 'permit_empty|in_list[Yes,No]',
                'errors' => [
                    'required' => 'Training received field is required.',
                    'in_list' => 'Training received must be Yes or No.',
                ]
            ],
            'Training_Title' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],
            'Training_Date' => [
                'rules' => 'permit_empty|valid_date[Y-m-d]',
                'errors' => [
                    'valid_date' => 'Training date must be a valid date (YYYY-MM-DD).',
                ]
            ],
            'Conducted_By' => [
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],

            'contact_number' => [
                'label' => 'contact number',
                'rules' => 'permit_empty|max_length[10]',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 100 characters',
                ]
            ],
            'email_id' => [
                'label' => 'Email Address',
                'rules' => 'required|valid_email|unique_farmer_email[fpo]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'valid_email' => 'The {field} must be a valid email address.',
                    'max_length' => 'The {field} must not exceed 50 characters.',
                    'unique_farmer_email' => 'This email ID is already registered for the selected organization.',
                ]
            ],


            'Person_Photo' => [
                'label' => 'Person Photo',
                'rules' => 'uploaded[Person_Photo]|max_size[Person_Photo,5120]|is_image[Person_Photo]',
                'errors' => [
                    'uploaded' => 'The {field} is required.',
                    'max_size' => 'The {field} must not exceed 5MB.',
                    'mime_in' => 'The {field} must be a JPEG or PNG file.',

                ]
            ],
        ];





        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }






        $data = [
            'title' => $this->request->getPost('title'),
            'first_name' => $this->request->getPost('first_name'),
            'middle_name' => $this->request->getPost('Middle_name'),
            'last_name' => $this->request->getPost('Last_name'),
            'farmer_id' => $this->request->getPost('facility_id'),
            'permanent_address1' => $this->request->getPost('adresss_1'),
            'permanent_address2' => $this->request->getPost('adresss_2'),
            'permanent_village' => $this->request->getPost('Village'),
            'permanent_country' => $this->request->getPost('country'),
            'permanent_state' => $this->request->getPost('state'),
            'permanent_city' => $this->request->getPost('city'),
            'permanent_pincode' => $this->request->getPost('pin_code'),
            'communication_address1' => $this->request->getPost('adresss_1'),
            'communication_address2' => $this->request->getPost('adresss_2'),
            'communication_village' => $this->request->getPost('Village'),
            'communication_country' => $this->request->getPost('country'),
            'communication_state' => $this->request->getPost('state'),
            'communication_city' => $this->request->getPost('city'),
            'communication_pincode' => $this->request->getPost('pin_code'),

            'email' => $this->request->getPost('email_id'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),

            'name_of_the_supervisor' => $this->request->getPost('name_of_supervisor'),
            'gender' => $this->request->getPost('Gender'),
            'membership_start_date' => $this->request->getPost('Membership_Start_Date'),
            'insurance_coverage' => $this->request->getPost('insurance_coverage'),
            'training_received' => $this->request->getPost('Training_Received'),
            'training_title' => $this->request->getPost('Training_Title'),
            'training_date' => $this->request->getPost('Training_Date'),
            'conducted_by' => $this->request->getPost('Conducted_By'),
            'contact_mobile' => $this->request->getPost('contact_number'),
            'Remark' => $this->request->getPost('Remark'),
            'status' => 1,



            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];




        $model = new Farmer_module;

        $model->insert($data);
        $insertId = $model->getInsertID();
        $session_id = session()->get('entity_id');
        if ($this->request->getFileMultiple('Photos')) {
            $photos = $this->request->getFileMultiple('Photos');


            if ($photos && count($photos) > 0) {
                $photoPaths = [];
                $errors = [];

                foreach ($photos as $index => $photo) {
                    // Validate file
                    if (!$photo->isValid() || $photo->hasMoved()) {
                        $errors[] = "File {$photo->getName()} is not valid or already moved.";
                        continue;
                    }

                    // Validate file type
                    $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff']; // Added image/jpg as well
                    if (!in_array($photo->getMimeType(), $allowedTypes)) {
                        $errors[] = "File {$photo->getName()} must be a JPEG or PNG image.";
                        continue;
                    }

                    // Validate file size (e.g., max 2MB)
                    $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                    if ($photo->getSize() > $maxSize) {
                        $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                        continue;
                    }




                    // Passed all validations — save file
                    $photoName = $photo->getRandomName();
                    $photoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/photos";
                    $photoPath = FCPATH . $photoDir;

                    if (!is_dir($photoPath)) {
                        mkdir($photoPath, 0777, true);
                    }

                    $photo->move($photoPath, $photoName);
                    $relativePath = $photoDir . '/' . $photoName;
                    $photoPaths[] = $relativePath;
                }

                // Save valid paths if any
                if (!empty($photoPaths)) {
                    $model->update($insertId, ['Photos' => json_encode($photoPaths)]);
                }

                // Handle errors (e.g., flash message or log)
                if (!empty($errors)) {

                    // Example: pass to view or flashdata

                    session()->set('validation_errors', $this->validator->listErrors());
                    session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

                    // var_dump($errors);
                }
            }
        }



        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        if (!empty($docFiles) && is_array($docFiles) && isset($docNames[0]) && $docFiles[0]->getName()) {
            $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Farmer/{$insertId}/documants";
            $relativeBasePath = "uploads/entity_profile/{$entityId}/Farmer/{$insertId}/documants";

            // Create directory if not exists
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Loop and process each document
            foreach ($docNames as $i => $name) {
                $date = $docDates[$i];
                $file = $docFiles[$i];

                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName);

                    $documents[] = [
                        'name' => $name,
                        'date' => $date,
                        'file' => "{$relativeBasePath}/{$newName}"
                    ];
                }
            }

            // Save only if at least one valid document
            if (!empty($documents)) {
                $model->update($insertId, [
                    'documents' => json_encode($documents)
                ]);
            }
        }



        $logo = $this->request->getFile('Person_Photo');
        $session_id = session()->get('entity_id'); // ensure this is set above
        if ($logo && $logo->isValid() && !$logo->hasMoved() && $logo->getName() !== '') {
            $logoName = $logo->getRandomName();
            $logoDir = "uploads/entity_profile/{$session_id}/Farmer/{$insertId}/Person_Photo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Create the directory if it doesn't exist
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move the uploaded photo
            $logo->move($logoPath, $logoName);

            // Prepare relative path to store in database
            $relativePath = $logoDir . '/' . $logoName;

            // Update the database with the path
            $model->update($insertId, ['Person_Photo' => $relativePath]);
        }



        $db = \Config\Database::connect();

        // Define the data to insert
        $data_new = [
            'name_of_the_user' => $this->request->getPost('title') . ' ' . $this->request->getPost('first_name') . ' ' . $this->request->getPost('Middle_name') . ' ' . $this->request->getPost('Last_name'),
            'user_id' => $insertId, // Ensure you're including the user_id here
            'user_table' => 'farmers', // Set the user_table value as required
        ];

        // Specify the table where the data should be inserted
        $builder = $db->table('register_log');

        // Perform the insert
        $builder->insert($data_new);




                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'farmer  added successfully!');
    }










    public function add_farmer()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Farmer/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Farmer/index', ['organization' => $organization]);
    }
}
