<?php

namespace App\Controllers\Plant_and_Machinery;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\MachineryModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Plant_and_Machinery extends BaseController
{


    public function delete_plant_and_machinery($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $plant_and_machinery = new MachineryModel();

        // Check if record exists
        $existing = $plant_and_machinery->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $plant_and_machinery->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Plant and Machinery   deleted successfully.');
    }


    public function update_plant_and_machinery()
    {





        $rules = [
             

            'Purchase_Date' => [
                'label' => 'Purchase Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.'
                ]
            ],
            'Manufacturer' => [
                'label' => 'Manufacturer',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Usage' => [
                'label' => 'Usage',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Machinery_Operator_Name_Designation' => [
                'label' => 'Machinery Operator Name & Designation',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please enter the operator name and designation.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Calibration_Due_Date' => [
                'label' => 'Calibration Due Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Calibration_Completed_Date' => [
                'label' => 'Calibration Completed Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Next_Due_Date' => [
                'label' => 'Next Due Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Name_of_the_Calibrator' => [
                'label' => 'Name of the Calibrator',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please enter the {field}.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Insurance_Coverage' => [
                'label' => 'Insurance Coverage',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Insurance_Details' => [
                'label' => 'Insurance Details',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Standard_Certification' => [
                'label' => 'Standard Certification',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Machinery_Functiony' => [
                'label' => 'Machinery Functiony',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 250 characters.'
                ]
            ],




        ];




      $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if (($location !== 'Corporate_Office' && $location !== 'Others') and ($location == "storage_details" or   $location == "packaging_unit" or $location == "factory_builidings")) {
            // $rules['selected_location_id'] = [
            //     'label' => 'Selected Location',
            //     'rules' => 'required',
            //     'errors' => [
            //         'required' => 'The {field} is required.',

            //     ]
            // ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
            else{
                $data_1 = [];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'id_number' => $this->request->getPost('facility_id'),
            'purchase_date' => $this->request->getPost('Purchase_Date'),
            'Machinery_Functiony' => $this->request->getPost('Machinery_Functiony'),
            'manufacturer' => $this->request->getPost('Manufacturer'),
            'usage' => $this->request->getPost('Usage'),
            'Machinery_Operator_Name_Designation' => $this->request->getPost('Machinery_Operator_Name_Designation'),
            'calibration_due_date' => $this->request->getPost('Calibration_Due_Date'),
            'calibration_completed_date' => $this->request->getPost('Calibration_Completed_Date'),
            'next_due_date' => $this->request->getPost('Next_Due_Date'),
            'calibrator_name' => $this->request->getPost('Name_of_the_Calibrator'),
            'insurance_coverage' => $this->request->getPost('Insurance_Coverage'),
            'Insurance_Details' => $this->request->getPost('Insurance_Details'),
            'standard_certification' => $this->request->getPost('Standard_Certification'),



            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'location' => json_encode($data_1), // Empty for now,
            'searchable_location' => $this->request->getPost('location'), // Empty for now,


        ];


       
        $remainingRaw = $this->request->getPost('remaining_images');
        $remaining_images = json_decode($remainingRaw ?? '[]', true);  // Treat null as empty array
        $remaining_images = is_array($remaining_images) ? $remaining_images : [];

        $mergedArray = $remaining_images;
        $insertId = $this->request->getPost('updating_id');

        $photos = $this->request->getFileMultiple('Photos');


        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                if (strpos($photo->getMimeType(), 'image/') !== 0) {
                    $errors[] = "File {$photo->getName()} must be a valid image format.";
                    continue;
                }


                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/Plant_and_meachinery/{$insertId}/photos/";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {

                $mergedArray = array_merge($photoPaths, $remaining_images);


                $folderPath = FCPATH .  "uploads/entity_profile/{$session_id}/Plant_and_meachinery/{$insertId}/photos/";
                $keepFilenames = array_map('basename', $mergedArray);

                // Scan folder
                $filesInFolder = scandir($folderPath);

                foreach ($filesInFolder as $file) {
                    if ($file === '.' || $file === '..') continue;

                    // If the file is NOT in the keep list, delete it
                    if (!in_array($file, $keepFilenames)) {
                        $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                        if (is_file($filePath)) {
                            unlink($filePath);
                        }
                    }
                }
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata
                var_dump($errors);
                var_dump($_FILES['Photos']);


                session()->set('validation_errors', $this->validator->listErrors());
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            }
        }

        $data['photo'] = json_encode($mergedArray);





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Plant_and_meachinery/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


 if (!empty($docNames) && is_array($docNames)) {

 if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documents'] = json_encode($documents);


 }
       


        $model = new MachineryModel();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {


            var_dump($data);

            // Success
                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_plant_and_machinery($id)
    {
        $plant_and_m = new MachineryModel();
        $plant_and_m = $plant_and_m->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Plant_and_Machinery/edit', [
            'plant_and_m' => $plant_and_m,
            'organization' => $organization
        ]);
    }


    public function view_plant_and_machinery($id)
    {
        $plant_and_m = new MachineryModel();
        $plant_and_m = $plant_and_m->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Plant_and_Machinery/view', [
            'plant_and_m' => $plant_and_m,
            'organization' => $organization
        ]);
    }


    public function insert_plant_and_machinery()
    {



        $rules = [
            'facility_id' => [
                'label' => 'Plant & Machinery ID',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot be longer than 20 characters.'
                ]
            ],

            'Purchase_Date' => [
                'label' => 'Purchase Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.'
                ]
            ],
            'Manufacturer' => [
                'label' => 'Manufacturer',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Usage' => [
                'label' => 'Usage',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Machinery_Operator_Name_Designation' => [
                'label' => 'Machinery Operator Name & Designation',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please enter the operator name and designation.',
                    'max_length' => 'The {field} cannot exceed 100 characters.'
                ]
            ],
            'Calibration_Due_Date' => [
                'label' => 'Calibration Due Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Calibration_Completed_Date' => [
                'label' => 'Calibration Completed Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Next_Due_Date' => [
                'label' => 'Next Due Date',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.'
                ]
            ],
            'Name_of_the_Calibrator' => [
                'label' => 'Name of the Calibrator',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please enter the {field}.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Insurance_Coverage' => [
                'label' => 'Insurance Coverage',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Insurance_Details' => [
                'label' => 'Insurance Details',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Standard_Certification' => [
                'label' => 'Standard Certification',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Machinery_Functiony' => [
                'label' => 'Machinery Functiony',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please provide the {field}.',
                    'max_length' => 'The {field} must be under 100 characters.'
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must be under 250 characters.'
                ]
            ],




        ];

        $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if (($location !== 'Corporate_Office' && $location !== 'Others') and ($location == "storage_details" or   $location == "packaging_unit" or $location == "factory_builidings")) {
            // $rules['selected_location_id'] = [
            //     'label' => 'Selected Location',
            //     'rules' => 'required',
            //     'errors' => [
            //         'required' => 'The {field} is required.',

            //     ]
            // ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
            else{
                $data_1 = [];
            }
        }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'id_number' => $this->request->getPost('facility_id'),
            'purchase_date' => $this->request->getPost('Purchase_Date'),
            'Machinery_Functiony' => $this->request->getPost('Machinery_Functiony'),
            'manufacturer' => $this->request->getPost('Manufacturer'),
            'usage' => $this->request->getPost('Usage'),
            'Machinery_Operator_Name_Designation' => $this->request->getPost('Machinery_Operator_Name_Designation'),
            'calibration_due_date' => $this->request->getPost('Calibration_Due_Date'),
            'calibration_completed_date' => $this->request->getPost('Calibration_Completed_Date'),
            'next_due_date' => $this->request->getPost('Next_Due_Date'),
            'calibrator_name' => $this->request->getPost('Name_of_the_Calibrator'),
            'insurance_coverage' => $this->request->getPost('Insurance_Coverage'),
            'Insurance_Details' => $this->request->getPost('Insurance_Details'),
            'standard_certification' => $this->request->getPost('Standard_Certification'),



            'remark' => $this->request->getPost('Remark'),
            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,

            'location' => json_encode($data_1), // Empty for now,
            'searchable_location' => $this->request->getPost('location'), // Empty for now,


        ];


        $model = new MachineryModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

        $photos = $this->request->getFileMultiple('Photos');

        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {


                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                if (strpos($photo->getMimeType(), 'image/') !== 0) {
                    $errors[] = "File {$photo->getName()} must be a valid image format.";
                    continue;
                }

                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/Plant_and_meachinery/{$insertId}/photos";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {
                // $model->update($insertId, ['photo' => json_encode($photoPaths)]);


                if (!$model->update($insertId, ['photo' => json_encode($photoPaths)])) {
                    print_r($model->errors()); // Will show validation errors if any
                }
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata
                // var_dump($errors);
                log_message('error', 'Upload errors: ' . implode(', ', $errors));
            }
        }





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Plant_and_meachinery/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Plant_and_meachinery/{$insertId}/documants";


         if (!empty($docFiles) && is_array($docFiles) && isset($docNames[0]) && $docFiles[0]->getName()) {

 if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        if (!$model->update($insertId, [
            'documents' => json_encode($documents)
        ])) {
            print_r($model->errors()); // Will show validation errors if any
        }


         }
        // Create directory if not exists
       


                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Plant and meachinery added successfully!');
    }





    public function add_plant_and_meachinery()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Plant_and_Machinery/add', ['organization' => $organization]);
    }



    public function index($show_the)
    {

        // echo $id;
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Plant_and_Machinery/index', ['organization' => $organization, 'show_the_value' => $show_the]);
    }
}
