<?php

namespace App\Controllers\Water_management;

use App\Controllers\BaseController;

use App\Models\Loginmodel;

use App\Models\Farmer_module;
use App\Models\Water_management_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Water_management extends BaseController
{


    public function delete_water_management($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Water_management = new Water_management_model();

        // Check if record exists
        $existing = $Water_management->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $Water_management->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'water management   deleted successfully.');
    }


    public function update_water_management()
    {


          $rules = [
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'permit_empty|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_varaity' => [
                'label'  => 'crop varaity',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

            'water_source' => [
                'label'  => 'Water Source',
                'rules'  => 'permit_empty|in_list[Surface,Ground,Rainwater,Recycled]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Surface,Ground,Rainwater,Recycled',
                ],
            ],
            'Unit_of_Water_Quantity' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Gallons,Litres,Cubic Capacity]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Gallons,Litres,Cubic Capacity',
                ],
            ],

            'water_storage' => [
                'label'  => 'water storage',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_conservation' => [
                'label'  => 'water conservation',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_testing' => [
                'label'  => 'water testing',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_harvesting' => [
                'label'  => 'water harvesting',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'legal_compliance' => [
                'label'  => 'legal compliance',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'crop_type.*' => [
                'label'  => 'Crop Type',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'Each {field} is required.',
                    'string'     => '{field} must be a valid string.',
                    'max_length' => '{field} cannot exceed 100 characters.',
                ],
            ],

            'water_volume.*' => [
                'label'  => 'Water Volume',
                'rules'  => 'required|numeric|greater_than[0]',
                'errors' => [
                    'required'     => 'Each {field} is required.',
                    'numeric'      => '{field} must be a number.',
                    'greater_than' => '{field} must be greater than 0.',
                ],
            ],
        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farm_crop_id' => $this->request->getPost('crop_varaity'),
            'Water_Source' => $this->request->getPost('water_source'),
            'Water_Storage' => $this->request->getPost('water_storage'),
            'Water_Conservation_Techniques' => $this->request->getPost('water_conservation'),
            'Water_Testing' => $this->request->getPost('water_testing'),
            'Water_Harvesting_Structures' => $this->request->getPost('water_harvesting'),
            'Legal_and_Regulatory_Compliance' => $this->request->getPost('legal_compliance'),
            'Unit_of_Water_Quantity' => $this->request->getPost('Unit_of_Water_Quantity'),
            'Remark' => $this->request->getPost('Remark'),

            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),



            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');

        $entityId = session()->get('entity_id');


        $crop_name = $this->request->getPost('crop_type');
        $water_qty_list = $this->request->getPost('water_volume');

        $crop_details = [];
 if (!empty($crop_name)) {

 foreach ($crop_name as $i => $name) {
            $volume = $water_qty_list[$i] ?? null;

            // Optional: Skip empty values
            if ($name !== '' && is_numeric($volume)) {
                $crop_details[] = [
                    'crop_type' => $name,
                    'water'     => $volume
                ];
            }
        }

        $data['water_volum_crop_wise'] = json_encode($crop_details);

 }
       









        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/crop_water_management/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;

 if (!empty($docNames) && is_array($docNames)) {


 if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['document'] = json_encode($documents);
 }
       


        $model = new Water_management_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_water_management($id)
    {
        $Water_management = new Water_management_model();
        $Water_management = $Water_management->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

      $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/water_management/edit', [
            'Water_management' => $Water_management,
            'organization' => $organization
        ]);
    }


    public function view_water_management($id)
    {
        $Water_management = new Water_management_model();
        $Water_management = $Water_management->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

      $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/water_management/view', [
            'Water_management' => $Water_management,
            'organization' => $organization
        ]);
    }


    public function insert_water_management()
    {




        $rules = [
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'permit_empty|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'permit_empty|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_varaity' => [
                'label'  => 'crop varaity',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

            'water_source' => [
                'label'  => 'Water Source',
                'rules'  => 'permit_empty|in_list[Surface,Ground,Rainwater,Recycled]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Surface,Ground,Rainwater,Recycled',
                ],
            ],
            'Unit_of_Water_Quantity' => [
                'label'  => 'Unit of Water Quantity',
                'rules'  => 'permit_empty|in_list[Gallons,Litres,Cubic Capacity]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Gallons,Litres,Cubic Capacity',
                ],
            ],

            'water_storage' => [
                'label'  => 'water storage',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_conservation' => [
                'label'  => 'water conservation',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_testing' => [
                'label'  => 'water testing',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'water_harvesting' => [
                'label'  => 'water harvesting',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'legal_compliance' => [
                'label'  => 'legal compliance',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],


            'crop_type.*' => [
                'label'  => 'Crop Type',
                'rules'  => 'required|string',
                'errors' => [
                    'required'   => 'Each {field} is required.',
                    'string'     => '{field} must be a valid string.',
                    'max_length' => '{field} cannot exceed 100 characters.',
                ],
            ],

            'water_volume.*' => [
                'label'  => 'Water Volume',
                'rules'  => 'required|numeric|greater_than[0]',
                'errors' => [
                    'required'     => 'Each {field} is required.',
                    'numeric'      => '{field} must be a number.',
                    'greater_than' => '{field} must be greater than 0.',
                ],
            ],
        ];




        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'farm_crop_id' => $this->request->getPost('crop_varaity'),
            'Water_Source' => $this->request->getPost('water_source'),
            'Water_Storage' => $this->request->getPost('water_storage'),
            'Water_Conservation_Techniques' => $this->request->getPost('water_conservation'),
            'Water_Testing' => $this->request->getPost('water_testing'),
            'Water_Harvesting_Structures' => $this->request->getPost('water_harvesting'),
            'Legal_and_Regulatory_Compliance' => $this->request->getPost('legal_compliance'),
            'Unit_of_Water_Quantity' => $this->request->getPost('Unit_of_Water_Quantity'),
            'Remark' => $this->request->getPost('Remark'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),
            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];






        $entityId = session()->get('entity_id');
        $crop_details = [];



        $crop_name = $this->request->getPost('crop_type');
        $water_qty_list = $this->request->getPost('water_volume');

        $crop_details = [];

        if (!empty($crop_name)) {
            foreach ($crop_name as $i => $name) {
                $volume = $water_qty_list[$i] ?? null;

                // Optional: Skip empty values
                if ($name !== '' && is_numeric($volume)) {
                    $crop_details[] = [
                        'crop_type' => $name,
                        'water'     => $volume
                    ];
                }
            }

            $data['water_volum_crop_wise'] = json_encode($crop_details);
        }







        $model = new Water_management_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();































        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/crop_water_management/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/crop_water_management/{$insertId}/documants";
        if (!empty($docNames) && is_array($docNames)) {

            // Create directory if not exists
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Loop and process each document
            foreach ($docNames as $i => $name) {
                $date = $docDates[$i];
                $file = $docFiles[$i];

                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName);

                    $documents[] = [
                        'name' => $name,
                        'date' => $date,
                        'file' => "{$relativeBasePath}/{$newName}"
                    ];
                }
            }

            $model->update($insertId, [
                'document' => json_encode($documents)
            ]);
        }


















                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'water management  added successfully!');
    }










    public function add_new_water_management()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

       $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/water_management/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $userType = session()->get('user_type');

        if ($userType === 'farmers') {
            $loginModel = new Farmer_module();
        } else {
            $loginModel = new Loginmodel();
        }

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/water_management/index', ['organization' => $organization]);
    }
}
