<?php


// app/Filters/OrganizationPermissionFilter.php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class Permissionfilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // Extract the permission from the filter argument




        if (session()->get("this_is_entity_login") == false && !empty($arguments)) {

            $page = $arguments[0] ?? null;
            $requiredPermission = $arguments[1] ?? null;

            $userId = session()->get('user_funtional_id');
            $table = session()->get('table');

            $db = \Config\Database::connect();

            $builder = $db->table($table);
            $role = $builder->where('id', $userId)->get()->getRowArray();

            if ($role) {
                $builder = $db->table('pages_acessing_control');
                $actuval_roles = $builder
                    ->where('roll_id', $role['role'])
                    ->where('page_name', $page)
                    ->get()
                    ->getResultArray();

                if (!empty($actuval_roles)) {

                    // Clear existing permission sessions
                    session()->remove('add');
                    session()->remove('edit');
                    session()->remove('delete');

                    // Set new permission sessions
                    $permissions = array_map('trim', explode(',', $actuval_roles[0]['permison']));
                    foreach ($permissions as $x) {
                        session()->set($x, true);
                    }

                    if ($requiredPermission) {
                        if (in_array($requiredPermission, $permissions)) {
                            return true;
                        } else {
                            session()->setFlashdata('error', 'Permission Denied');
                            return redirect()->to(session()->get('user_associated'));
                        }
                    } else {
                        // Just view access is okay
                        return true;
                    }
                } else {
                    session()->setFlashdata('error', 'Permission Denied');

                    switch (session()->get('user_associated')) {
                        case "organisation":
                            return redirect()->to('/organization');
                        case "fpo":
                            return redirect()->to('/Fpo');
                        case "farmer":
                            return redirect()->to('/farmer_login');
                        case "audit_company":
                            return redirect()->to('/audit_company');
                        case "app_user":
                                return redirect()->to('/admin');
                        default:
                            return redirect()->to('/entity_login')->with('error', 'Invalid login type.');
                    }
                }
            } else {
                session()->setFlashdata('error', 'Permission Denied');
                switch (session()->get('user_associated')) {
                    case "organisation":
                        return redirect()->to('/organization');
                    case "fpo":
                        return redirect()->to('/Fpo');
                    case "farmer":
                        return redirect()->to('/farmer_login');
                    case "audit_company":
                        return redirect()->to('/audit_company');
                    case "app_user":
                        return redirect()->to('/admin');
                    default:
                        return redirect()->to('/entity_login')->with('error', 'Invalid login type.');
                }
            }
        } else {

            if (session()->get("this_is_entity_login") == true) {


                session()->set("add", true);
                session()->set("edit", true);
                session()->set("delete", true);



                return true;
            } else {
                session()->setFlashdata('error', 'Permission Denied');
                switch (session()->get('user_associated')) {
                    case "organisation":
                        return redirect()->to('/organization');
                    case "fpo":
                        return redirect()->to('/Fpo');
                    case "farmer":
                        return redirect()->to('/farmer_login');
                    case "audit_company":
                        return redirect()->to('/audit_company');
                    case "app_user":
                        return redirect()->to('/admin');
                    default:
                        return redirect()->to('/entity_login')->with('error', 'Invalid login type.');
                }
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Any post-processing logic, if required
    }
}
