<?php

namespace App\Models;

use CodeIgniter\Model;

class InternalAuditModel extends Model
{
    protected $table = 'internal_audit'; // Table name (with space)

    protected $primaryKey = 'id'; // Primary key

    protected $allowedFields = [
        'audit_category',
        'record_date',
        'location',
        'audit_for',
        'audit_type',
        'department',
        'internalAudit_schedule',
        'internalAudit_scope',
        'internalAudit_checklist_used',
        'internal_non_conformities_reported',
        'internal_opportunities_for_improvement',
        'internal_corrective_actions_taken',
        'internal_corrective_actions_closed',
        'internal_final_audit_report',
        'description',
        'remark',
        'auditors',
        'internal_auditee_representative',
        'documants',
        'entity_id',
        'associated_by',
        'created_by',
        'updated_by',
        'status',
        'created_at',
        'updated_at',
        'audit_id',
        'year',
        'due_date'
    ];

    protected $useTimestamps = true; // created_at, updated_at auto manage
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    
}
