<?php

namespace App\Validation;

use CodeIgniter\Database\BaseBuilder;

class Rules_for_login
{
    public function is_unique_email_per_type(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        $builder->where($column, $str);                     // Match email
        $builder->where('user_type', $data['type']);        // Match user_type
        $builder->where('status', 1);                    // Status must not be 1

        return $builder->countAllResults() === 0;
    }


    public function unique_farmer_email(string $email, $associatedBy = null, array $data = [], ?string &$error = null): bool
    {
        $db = \Config\Database::connect();
    
        if (empty($associatedBy)) {
            $error = 'Associated type is required for email validation.';
            return false;
        }
    
        $builder = $db->table('farmers');
        $builder->where('email', $email);
        $builder->where('associated_by', $associatedBy); // 'farmers' or 'fpo'
    
        if ($builder->countAllResults() > 0) {
            $error = 'This email already exists for the selected type.';
            return false;
        }
    
        return true;
    }
    

    public function unique_entity_email_with_type(string $email, string $userType, array $data, ?string &$error = null): bool
    {
        $db = \Config\Database::connect();
    
        if (empty($userType)) {
            $error = 'User type is required for email validation.';
            return false;
        }
    
        $builder = $db->table('entity_profiles');
        $builder->where('email', $email);
        $builder->where('user_type', $userType);
    
        if ($builder->countAllResults() > 0) {
            $error = 'This email is already used for the selected user type.';
            return false;
        }
    
        return true;
    }
    



    public function is_unique_farmer_email(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        $builder->where($column, $str);  // Match email
        $builder->where('status', 1);    // Status must be 1

        return $builder->countAllResults() === 0;
    }



    public function is_unique_email_per_type_org_profile(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        // Match email
        $builder->where($column, $str);

        // Match user type
        $userType = session()->get('user_associated');
        if (!empty($userType)) {
            $builder->where('user_type', $userType);
        }


        // Only check active users
        $builder->where('status', 1);

        // Exclude current user's record if user_id exists
        $session = session();
        $userId = $session->get('entity_id');
        if (!empty($userId)) {
            $builder->where('id !=', $userId); // Assumes your table uses 'id' as the PK
        }



        return $builder->countAllResults() === 0;
    }


    public function enity_user_email_cheek(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        log_message('debug', 'user_type: ' . session()->get('user_associated'));
        log_message('debug', 'associated_with_id: ' . session()->get('entity_id'));



        $builder->where($column, $str);                     // Match email
        $builder->where('associated_by', session()->get('user_associated'));        // Match user_type
        $builder->where('entity_id', session()->get('entity_id'));        // Match user_type
        $builder->where('status', 1);                    // Status must not be 1

        return $builder->countAllResults() === 0;
    }

    public function contact_person_email_id_cheek(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        // Get the current user's ID from session
        $currentUserId = session()->get('entity_id');
        $currentUserType = session()->get('user_associated');

        // Check if the current user is the one updating the email, no validation needed
        if (isset($data['contact_person_id']) && $data['contact_person_id'] !== '') {
            // Exclude the current record if it's being updated
            $builder->where('id !=', $data['contact_person_id']);  // Exclude current contact person being edited
        }

        // Log the session data for debugging
        log_message('debug', 'user_type: ' . $currentUserType);
        log_message('debug', 'associated_with_id: ' . $currentUserId);

        // Validate the email only for other contact persons in the same organization and user context
        $builder->where($column, $str);  // Match the email address
        $builder->where('associated_by', $currentUserType);  // Match the current user (associated_by)
        $builder->where('entity_id', $currentUserId);  // Match the current entity ID (organization)
        $builder->where('status', 1);  // Ensure status is 1 (active)

        // If the count of results is greater than 0, it means email is already used by another contact person
        return $builder->countAllResults() === 0; // No other user has this email, validation passes
    }



    public function comon_employee_updating_cheek(string $str, string $fields, array $data): bool
    {
        [$table, $column] = explode('.', $fields);

        $db = \Config\Database::connect();
        $builder = $db->table($table);

        // Get the current user's ID from session
        $currentUserId = session()->get('entity_id');
        $currentUserType = session()->get('associated_by');

        // Check if the current user is the one updating the email, no validation needed
        if (isset($data['updating_id']) && $data['updating_id'] !== '') {
            // Exclude the current record if it's being updated
            $builder->where('id !=', $data['updating_id']);  // Exclude current contact person being edited
        }

        // Log the session data for debugging
        log_message('debug', 'user_type: ' . $currentUserType);
        log_message('debug', 'associated_with_id: ' . $currentUserId);

        // Validate the email only for other contact persons in the same organization and user context
        $builder->where($column, $str);  // Match the email address
        $builder->where('associated_by', $currentUserType);  // Match the current user (associated_by)
        $builder->where('entity_id', $currentUserId);  // Match the current entity ID (organization)
        $builder->where('status', 1);  // Ensure status is 1 (active)

        // If the count of results is greater than 0, it means email is already used by another contact person
        return $builder->countAllResults() === 0; // No other user has this email, validation passes
    }





    public function unique_email_across_tables(string $email, ?string $fields = null, array $data = [], string &$error = null): bool
    {
        $db = \Config\Database::connect();
        $tables = [
            'contact_person',
            'entity_profiles',
            'farmers',
            'auditors',
            'internal_auditors',
            'internal_inspectors',
            'subcontractors',
            'employee',
        ];

        foreach ($tables as $table) {
            $builder = $db->table($table);
            $builder->where('email', $email);
            $builder->where('status', 1);

            if ($builder->countAllResults() > 0) {
                $error = "This email ID is already registered in the system. Please use a different one.";
                return false;
            }
        }

        return true;
    }


    public function unique_email_across_tables_on_update(string $email, string $fields, array $data, string &$error = null): bool
    {
        [$table, $emailColumn] = explode('.', $fields);
        $updateId = $data['updating_id'] ?? null;

        if (!$updateId) {
            $error = "Invalid request. Missing record ID.";
            return false;
        }

        $db = \Config\Database::connect();
        $tablesToCheck = [
            'contact_person',
            'entity_profiles',
            'farmers',
            'employee',
            'auditors',

            'internal_auditors',
            'internal_inspectors',
            'subcontractors'
        ];

        foreach ($tablesToCheck as $tbl) {
            $builder = $db->table($tbl);
            $builder->where($emailColumn, $email);
            $builder->where('status', 1);

            if ($tbl === $table) {
                // Same table: exclude current row from check
                $builder->where('id !=', $updateId);
            }




            if ($builder->countAllResults() > 0) {


                $error = "This email is already used in the system. Please choose another.";
                return false;
            }
        }

        return true;
    }
}
