<?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">farm</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <?php

                                $db = \Config\Database::connect();
                                ?>

                                <?= csrf_field() ?>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Farm ID<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['farm_iD'] ?>" readonly>
                                </div>


                                <?php

                                $farmer = [];

                                if (!empty($FarmerLandDetail['farmer_id'])) {
                                    $farmerQuery = $db->table('farmers')
                                        ->select('*') // or specify 'role_name' if that's the column
                                        ->where('id', $FarmerLandDetail['farmer_id'])
                                        ->get();

                                    $farmer = $farmerQuery->getResultArray();
                                }

                                // Fallback to dummy value if empty
                              if (!empty($farmer) && is_array($farmer)) {
									$farmer_name_parts = array_filter([
										$farmer[0]['first_name'] ?? '',
										$farmer[0]['middle_name'] ?? '',
										$farmer[0]['last_name'] ?? '',
									]);

									$farmer_id = $farmer[0]['farmer_id'] ?? '';
									$farmer_name = trim(implode(' ', $farmer_name_parts));

									if ($farmer_id !== '') {
										$farmer_name .= ' - ' . $farmer_id;
									}
								} else {
									$farmer_name = 'Not Assigned';
								}
                                ?>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">farmer<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $farmer_name ?>" readonly>
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Location<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['location'] ?>" readonly>
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Year<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['year'] ?>" readonly>
                                </div>








                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Ownership<span class="text-danger scale5 ms-2"></span></label>
                                    <input value="<?= $FarmerLandDetail['ownership'] ?>"
                                        readonly type="text" class="form-control" placeholder="PIN Code" name="pin_code" aria-label="factory-pin-code" maxlength="6" required>
                                </div>



                                <?php

                                if ($FarmerLandDetail['ownership'] == "Leasehold") {
                                ?>

                                    <div class="col-xl-3 col-md-3 mb-4">
                                        <label class="form-label">No. of years Leasehold<span class="text-danger scale5 ms-2"></span></label>
                                        <input value="<?= $FarmerLandDetail['no_of_years_Leasehold'] ?>"
                                            readonly type="text" class="form-control" placeholder="PIN Code" name="pin_code" aria-label="factory-pin-code" maxlength="6" required>
                                    </div>
                                <?php
                                }
                                ?>


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Mandal<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['mandal'] ?>" readonly>
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">District<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['district'] ?>" readonly>
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Survey Parcel Number<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['survey_parcel_number'] ?>" readonly>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4 d-none">
                                    <label class="form-label">Area (Acres)<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['farm_area'] ?>" readonly value="0">
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Total Extent of Land (Acres)<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['total_extent_of_land'] ?>" readonly>
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Extent under Cultivation (Acres)<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Name" name="Name" value="<?= $FarmerLandDetail['extent_under_cultivation'] ?>" readonly>
                                </div>
                                


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Remarks<span class="text-danger scale5 ms-2"></span></label>

                                    <textarea readonly id="" class="form-control" placeholder="Remarks" name="Remark" aria-label="manufacturing-activities"><?= $FarmerLandDetail['Remark'] ?></textarea>
                                    <!-- <input type="text" class="form-control" placeholder="Manufacturing activities" aria-label="manufacturing-activities" > -->
                                </div>








                                <?php
                                $documents = json_decode($FarmerLandDetail['document'] ?? '[]');
                                ?>

                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label"> document<span class="text-danger scale5 ms-2"></span></label>
                                    <div id="documentContainer">
                                        <?php if (!empty($documents)): ?>
                                            <?php foreach ($documents as $doc): ?>
                                                <div class="document-row row">
                                                    <div class="col-xl-3 col-md-3 mb-4">
                                                        <label class="form-label">Document Name<span class="text-danger ms-2"></span></label>
                                                        <input type="text" class="form-control" name="doc_name[]" value="<?= esc($doc->name) ?>" readonly>
                                                    </div>
                                                    <div class="col-xl-3 col-md-3 mb-4">
                                                        <label class="form-label">Document Date<span class="text-danger ms-2"></span></label>
                                                        <input type="date" class="form-control" name="doc_date[]" value="<?= esc($doc->date) ?>" readonly>
                                                    </div>
                                                    <div class="col-xl-3 col-md-3 mb-4">
                                                        <label class="form-label">Document<span class="text-danger ms-2"></span></label>
                                                        <a href="<?= base_url($doc->file) ?>" target="_blank" class="btn btn-primary w-100">
                                                            View
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <p class="text-muted">No uploaded documents available.</p>
                                        <?php endif; ?>
                                    </div>

                                </div>



                            </div>

                    </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>