<?php echo view('admin/layout/header'); ?>
<?php echo view('admin/layout/sidebar'); ?>

<style>
        .required {
            color: #000000;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        .error-text {
            display: none;
            color: red;
            font-size: 14px;
        }

        .nav-tabs .nav-link.active {
            background-color: #6591fd;
            color: white;
        }
    </style>

<div class="content-body">
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">Edit Farmer</h3>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>

                        <form action="<?= base_url('admin/update_farmer/' . $farmer['id']) ?>" method="post" enctype="multipart/form-data">
                            <?= csrf_field() ?>

                            <div class="row">
                                <div class="col-3 mb-3">
                                    <label class="form-label">Title</label>
                                    <select name="Title" class="form-control required">
                                        <option value="Mr" <?= $farmer['title'] == 'Mr' ? 'selected' : '' ?>>Mr</option>
                                        <option value="Mrs" <?= $farmer['title'] == 'Mrs' ? 'selected' : '' ?>>Mrs</option>
                                        <option value="Ms" <?= $farmer['title'] == 'Ms' ? 'selected' : '' ?>>Ms</option>
                                    </select>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">First Name</label>
                                    <input type="text" name="first_name" class="form-control required" value="<?= esc($farmer['first_name']) ?>" >
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Middle Name</label>
                                    <input type="text" name="middle_name" class="form-control required" value="<?= esc($farmer['middle_name']) ?>" >
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Last Name</label>
                                    <input type="text" name="last_name" class="form-control required" value="<?= esc($farmer['last_name']) ?>" >
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Date of Birth</label>
                                    <input type="date" name="Date_of_Birth" class="form-control required" value="<?= esc($farmer['dob']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Income Tax Number</label>
                                    <input type="text" name="Income_Tax_Number" maxlength="10" class="form-control required" value="<?= esc($farmer['income_tax_number']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Permanent Address 1</label>
                                    <input type="text" name="Permanent_Address1" class="form-control required" value="<?= esc($farmer['permanent_address1']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Permanent Address 2</label>
                                    <input type="text" name="Permanent_Address2" class="form-control" value="<?= esc($farmer['permanent_address2']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Permanent Village</label>
                                    <input type="text" name="Permanent_Village" class="form-control required" value="<?= esc($farmer['permanent_village']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Permanent PIN Code</label>
                                    <input type="text" name="Permanent_PIN_Code" class="form-control required" value="<?= esc($farmer['permanent_pincode']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                <label class="form-label">Country</label>
                                <select id="country1" name="Permanent_cuntry" class="form-control required">
                                <option value="">Select Country</option>
                                </select>
                                <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                <label class="form-label">State</label>
                                <select id="state1" name="Permanent_State" class="form-control required">
                                <option value="">Select State</option>
                                </select>
                                <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                <label class="form-label">City</label>
                                <select id="city1" name="Permanent_city" class="form-control required">
                                <option value="">Select City</option>
                                </select>
                                <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Communication Address 1</label>
                                    <input type="text" name="Communication_Address1" class="form-control required" value="<?= esc($farmer['communication_address1']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Communication Address 2</label>
                                    <input type="text" name="Communication_Address2" class="form-control" value="<?= esc($farmer['communication_address2']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Communication Village</label>
                                    <input type="text" name="Communication_Village" class="form-control required" value="<?= esc($farmer['communication_village']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Communication PIN Code</label>
                                    <input type="text" name="Communication_PIN_Code" class="form-control required" value="<?= esc($farmer['communication_pincode']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Country</label>
                                    <select id="country" name="Communication_cuntry" class="form-control required">
                                        <option value="">Select Country</option>
                                    </select>
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">State</label>
                                    <select id="state" name="Communication_State" class="form-control required">
                                        <option value="">Select State</option>
                                    </select>
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">City</label>
                                    <select id="city" name="Communication_City" class="form-control required">
                                        <option value="">Select City</option>
                                    </select>
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Mobile Number</label>
                                    <input type="text" name="Contact_Number_mobile" class="form-control required" value="<?= esc($farmer['contact_mobile']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Fixedline Number</label>
                                    <input type="text" name="Contact_Number_Fixedline" class="form-control required" value="<?= esc($farmer['contact_fixedline']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Email ID</label>
                                    <input type="email" name="Email_id" class="form-control required" value="<?= esc($farmer['email']) ?>">
                                    <small class="error-text">This field is required.</small>
                                </div>

                                <div class="col-3 mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                                    
                                </div>
                            </div>

                            <div class="card-footer text-end">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php echo view('admin/layout/footer'); ?>
<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>
<script>
    const country = "<?= esc($farmer['permanent_country'] ?? '') ?>";
    const state = "<?= esc($farmer['permanent_state'] ?? '') ?>";
    const city = "<?= esc($farmer['permanent_city'] ?? '') ?>";

    const commCountry = "<?= esc($farmer['communication_country'] ?? '') ?>";
    const commState = "<?= esc($farmer['communication_state'] ?? '') ?>";
    const commCity = "<?= esc($farmer['communication_city'] ?? '') ?>";

    function initSelectize(id) {
        return $(id).selectize({
            create: false,
            sortField: 'text',
            dropdownParent: 'body',
            placeholder: 'Select an option'
        })[0].selectize;
    }

    $(document).ready(function() {
        const country1 = initSelectize('#country1');
        const state1 = initSelectize('#state1');
        const city1 = initSelectize('#city1');

        const countryComm = initSelectize('#country');
        const stateComm = initSelectize('#state');
        const cityComm = initSelectize('#city');

        function populateLocation(countryVal, stateVal, cityVal, countrySel, stateSel, citySel) {
            $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                if (!response.error) {
                    response.data.forEach(country => {
                        countrySel.addOption({ value: country.name, text: country.name });
                    });
                    countrySel.setValue(countryVal);

                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/states",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({ country: countryVal }),
                        success: function(response) {
                            if (!response.error) {
                                stateSel.clearOptions();
                                response.data.states.forEach(state => {
                                    stateSel.addOption({ value: state.name, text: state.name });
                                });
                                stateSel.setValue(stateVal);

                                $.ajax({
                                    url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                                    type: "POST",
                                    contentType: "application/json",
                                    data: JSON.stringify({ country: countryVal, state: stateVal }),
                                    success: function(response) {
                                        if (!response.error) {
                                            citySel.clearOptions();
                                            response.data.forEach(city => {
                                                citySel.addOption({ value: city, text: city });
                                            });
                                            citySel.setValue(cityVal);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }

        populateLocation(country, state, city, country1, state1, city1);
        populateLocation(commCountry, commState, commCity, countryComm, stateComm, cityComm);
    });
</script>