<?= view('admin/layout/header') ?>
<?= view('admin/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>
<style>
        .required {
            color: #000000;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        .error-text {
            display: none;
            color: red;
            font-size: 14px;
        }

        .nav-tabs .nav-link.active {
            background-color: #6591fd;
            color: white;
        }
    </style>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">Update Entity</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>

                        <?php endif; ?>



                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("admin/update_entity/{$entity['id']}") ?>" id="form_upload" method="post" enctype="multipart/form-data">
    <?= csrf_field() ?>
    <input type="hidden" name="id" value="<?= $entity['id'] ?>">

    <div class="row">

        <div class="col-3 mb-3">
            <label class="form-label" >Entity Type</label>
            <select id="entity_type" name="entity_type" class="form-control required" disabled>
                <option value="organisation" <?= $entity['user_type'] === 'organisation' ? 'selected' : '' ?>>Organization</option>
                <option value="fpo" <?= $entity['user_type'] === 'fpo' ? 'selected' : '' ?>>Farmer organization</option>
                <option value="audit_company" <?= $entity['user_type'] === 'audit_company' ? 'selected' : '' ?>>Audit company</option>
            </select>
            <input name="entity_type" value="<?= $entity['user_type']?>" class="d-none">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Name</label>
            <input type="text" name="Organization_name" class="form-control required"  value="<?= esc($entity['establishment_name']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Date of Incorporation</label>
            <input type="date" name="Organization_Date_of_Establishment" class="form-control required" value="<?= esc($entity['incorporation_date']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Registration Number (entity)</label>
            <input type="text" name="Organization_Registration_Number" class="form-control required"  value="<?= esc($entity['registration_number']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Company Logo</label><br>
            <?php if (!empty($entity['company_logo'])): ?>
                <img src="<?=base_url()?><?=$entity['company_logo']?>" alt="Logo" height="40" class="mb-2">
            <?php endif; ?>
            <input type="file" name="Company_Logo" class="form-control" accept=".jpg,.jpeg,.png">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">GSTIN / VAT ID</label>
            <input type="text" name="GST_Registration" class="form-control required" maxlength="15" value="<?= esc($entity['employer_income_tax_number']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Employer Income Tax Number</label>
            <input type="text" name="Income_Tax_PAN_No" class="form-control required" maxlength="15" value="<?= esc($entity['Income_Tax_PAN_No']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Income Tax TAN Number</label>
            <input type="text" name="income_tax_tan_no" class="form-control required" maxlength="15" value="<?= esc($entity['Income_Tax_TAN_No']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Country</label>
            <select id="country" name="cuntry" class="form-control required">
                <option value="<?= esc($entity['country']) ?>"><?= esc($entity['country']) ?></option>
            </select>
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">State</label>
            <select id="state" name="State" class="form-control required">
                <option value="<?= esc($entity['state']) ?>"><?= esc($entity['state']) ?></option>
            </select>
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">City</label>
            <select id="city" name="City" class="form-control required">
                <option value="<?= esc($entity['city']) ?>"><?= esc($entity['city']) ?></option>
            </select>
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Address 1</label>
            <input type="text" name="Office_Address1" class="form-control required"  value="<?= esc($entity['address_line1']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Address 2</label>
            <input type="text" name="Office_Address2" class="form-control"  value="<?= esc($entity['address_line2']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Village</label>
            <input type="text" name="Office_Village" class="form-control required"  value="<?= esc($entity['village']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office PIN Code</label>
            <input type="text" name="Office_PIN_Code" class="form-control required" maxlength="6" pattern="[0-9]{6}" value="<?= esc($entity['pin_code']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Contact Number (Mobile)</label>
            <input type="text" name="Office_Contact_Mobile" class="form-control required" maxlength="10" pattern="[0-9]{10}" value="<?= esc($entity['contact_mobile']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Contact Number (Fixedline)</label>
            <input type="text" name="Office_Contact_fixed_line" class="form-control" maxlength="10" pattern="[0-9]{10}" value="<?= esc($entity['contact_fixedline']) ?>">
        </div>

        <div class="col-3 mb-3">
            <label class="form-label">Office Email ID</label>
            <input type="email" name="Email_id" class="form-control required"  value="<?= esc($entity['email']) ?>">
        </div>

        <!-- Password field can be skipped or added with logic -->
        <div class="col-3 mb-3">
            <label class="form-label">Password *</label>
            <input type="password" name="password" class="form-control"
                   minlength="8"
                   pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$"
                   data-error-required="Password is required."
                   data-error-pattern="Password must be at least 8 characters long and include uppercase, lowercase, number, and special character.">
            <small class="error-text" style="display: none; color: red;"></small>
        </div>
    </div>

    <div class="card-footer text-end">
        <button type="submit" class="btn btn-primary">Update</button>
    </div>
</form>

                </div>
            </div>
        </div>
    </div>
</div>












<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('admin/layout/footer') ?>



<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery () -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>





<script>
    $(document).ready(function() {
            function initSelectize(selector) {
                return $(selector).selectize({
                    create: false,
                    sortField: "text",
                    placeholder: "Select an option",
                })[0].selectize;
            }

            // Initialize Selectize for dynamic selects
            initSelectize("#country");
            initSelectize("#state");
            initSelectize("#city");
            initSelectize("#entity_type");
           
            function loadCountries() {
                $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                    if (!response.error) {
                        var countrySelect = $("#country")[0].selectize;
                        response.data.forEach(country => {
                            countrySelect.addOption({
                                value: country.name,
                                text: country.name
                            });
                        });
                    }
                });
            }

            function loadStates(country) {
                var stateSelect = $("#state")[0].selectize;
                stateSelect.clear();
                stateSelect.clearOptions();

                if (country) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/states",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.states.forEach(state => {
                                    stateSelect.addOption({
                                        value: state.name,
                                        text: state.name
                                    });
                                });
                            }
                        }
                    });
                }
            }

            function loadCities(country, state) {
                var citySelect = $("#city")[0].selectize;
                citySelect.clear();
                citySelect.clearOptions();

                if (country && state) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country,
                            state: state
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.forEach(city => {
                                    citySelect.addOption({
                                        value: city,
                                        text: city
                                    });
                                });
                            }
                        }
                    });
                }
            }

            loadCountries(); // Load Countries on Page Load

            $("#country").change(function() {
                loadStates($(this).val());
            });

            $("#state").change(function() {
                loadCities($("#country").val(), $(this).val());
            });

            


        });
  
</script>