
<?= view('admin/layout/header') ?>
 <?= view('admin/layout/sidebar') ?>

 <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

 <!--**********************************
            Sidebar start
        ***********************************-->

 <!--**********************************
            Sidebar end
        ***********************************-->

 <!--**********************************
            Content body start
        ***********************************-->

 <style>
     .dashboard-card {
         border: none;
         border-radius: 15px;
        
         color: #fff;
         transition: transform 0.3s ease, box-shadow 0.3s ease;
         box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
     }

     .dashboard-card:hover {
         transform: translateY(-5px);
         box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
     }

     .icon-box {
         font-size: 3rem;
         opacity: 0.8;
     }

     .badge-custom {
         font-size: 0.9rem;
         padding: 5px 10px;
         border-radius: 10px;
     }

     <style>
    .summary-card {
      border-radius: 1rem;
      transition: transform 0.2s;
    }
    .summary-card:hover {
      transform: scale(1.02);
    }
    .icon {
      font-size: 2rem;
      opacity: 0.3;
    }
    small{
      font-size: 12px;
      
    }
    .text-success
 {
   
    color: #006536 !important;
}

.badge {
    
    border-radius: 999px;
    font-size: xx-small;
}
  </style>
 


 <style>
.icon-circle {
  width: 50px;
  height: 50px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
}
.material-icons {
  font-size: 28px;
}
</style>

<style>
.group-title {
  border-radius: 0.5rem;
  padding: 10px 15px;
  font-weight: 600;
  color: #fff;
  margin-bottom: 10px;
}

.bg-title-organisation {
  background-color:rgba(54,162,235,1);/* Bootstrap primary */
  color:
}

.bg-title-fpo {
  background-color: rgba(75,192,192,1); /* Bootstrap success */
}

.bg-title-audit_company {
  background-color:rgba(255,99,132,1); /* Bootstrap warning */
 /* readable on yellow */
}

.bg-title-farmer {
  background-color:rgb(139,195,74); /* Bootstrap danger */
}

.user-card{
  background:#eee
}
</style>
<style>
  .top-right-arrow {
    position: absolute;
    top: 12px;
    right: 12px;
    background-color: rgba(54,162,235,0.1);
    border-radius: 50%;
    padding: 6px;
    animation: bounce 1.5s infinite;
  }

  @keyframes bounce {
    0%, 100% {
      transform: translateX(0);
    }
    50% {
      transform: translateX(5px);
    }
  }

  .summary-card {
    position: relative;
  }

  .icon-circle {
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    width: 48px;
    height: 48px;
  }
</style>


 <div class="content-body">
     <!-- row -->
    <div class="container-fluid">
    <div class="d-flex align-items-center mb-4 flex-wrap">
			<h3 class="me-auto">Dashboard</h3>
			<div>
									

							</div>
		</div>
         <div class="">
             <div class="col-xl-12">
                 <div class="row">
                 <?php if (session()->getFlashdata('error')): ?>
                         <div class="alert alert-danger">
                             <?= session()->getFlashdata('error') ?>
                         </div>
                 <?php endif; ?>
                 <?php
$userTypes = [
  'organisation'   => ['label' => 'Organisations',    'icon' => 'apartment',     'color' => 'rgba(54,162,235,1)'],
  'fpo'            => ['label' => 'FPOs',             'icon' => 'groups',        'color' => 'rgba(75,192,192,1)'],
  'audit_company'  => ['label' => 'Audit Companies',  'icon' => 'gavel',         'color' => 'rgba(255,99,132,1)']
];
?>






<?php
$db = \Config\Database::connect();

foreach ($userTypes as $typeKey => $meta):
  $label = $meta['label'];
  $icon = $meta['icon'];
  $color = $meta['color'];

  // Total count
  $total = $db->table('entity_profiles')
      ->select('COUNT(DISTINCT(id)) AS total')
      ->where('status', 1)
      ->where('user_type', $typeKey)
      ->get()
      ->getRowArray()['total'] ?? 0;

  // This month
  $startOfThisMonth = date('Y-m-01');
  $thisMonth = $db->table('entity_profiles')
      ->select('COUNT(DISTINCT(id)) AS this_month')
      ->where('status', 1)
      ->where('user_type', $typeKey)
      ->where('DATE(created_at) >=', $startOfThisMonth)
      ->get()
      ->getRowArray()['this_month'] ?? 0;

  // Last month
  $startOfLastMonth = date('Y-m-01', strtotime('-1 month'));
  $endOfLastMonth = date('Y-m-t', strtotime('-1 month'));
  $lastMonth = $db->table('entity_profiles')
      ->select('COUNT(DISTINCT(id)) AS last_month')
      ->where('status', 1)
      ->where('user_type', $typeKey)
      ->where('DATE(created_at) >=', $startOfLastMonth)
      ->where('DATE(created_at) <=', $endOfLastMonth)
      ->get()
      ->getRowArray()['last_month'] ?? 0;

  // Percentage growth
  $growth = $thisMonth - $lastMonth;
  $growthPercent = round(($growth / max($lastMonth, 1)) * 100, 1);
  $growthClass = $growth >= 0 ? 'text-success' : 'text-danger';
  $growthIcon = $growth >= 0 ? 'trending_up' : 'trending_down';
  $growthSign = $growth >= 0 ? '+' : '';
?>

<div class="col-md-3 ">
  <div class="card shadow-sm summary-card p-3 " >
    <div class="d-flex justify-content-between align-items-center" >
      <div>
        <h6 class="text-muted"><?= $label ?></h6>
        <h3 class="mb-0 counter" data-target="<?= $total ?>">0</h3>

        <!-- This Month -->
        <small class="text-info d-block">
          +<span class="counter" data-target="<?= $thisMonth ?>">0</span> this month
        </small>

        <!-- Last Month -->
        <small class="text-secondary d-block">
          +<span class="counter" data-target="<?= $lastMonth ?>">0</span> last month
        </small>

        <!-- Growth -->
        <small class="<?= $growthClass ?>">
          <?= $growthSign . $growthPercent ?>%
          <span class="material-icons align-middle" style="font-size: 16px;">
            <?= $growthIcon ?>
          </span> vs last month
        </small>
      </div>
      <br>
      <br>
      <!-- Icon with Colored Circle -->
      <div>
        <div class="icon-circle " style="background-color:<?= $color ?> ">
          <span class="material-icons text-white"><?= $icon ?></span>
        </div>
      </div>
    </div>
  </div>
</div>


<?php endforeach; ?>



<?php
$db = \Config\Database::connect();

// Total active unassociated farmers
$totalFarmers = $db->table('farmers')
    ->where('status', 1)
    ->where('associated_by','farmers')
    ->countAllResults();

// This month
$startOfThisMonth = date('Y-m-01');
$thisMonthFarmers = $db->table('farmers')
    ->where('status', 1)
    ->where('associated_by','farmers')
    ->where('DATE(created_at) >=', $startOfThisMonth)
    ->countAllResults();

// Last month
$startOfLastMonth = date('Y-m-01', strtotime('-1 month'));
$endOfLastMonth = date('Y-m-t', strtotime('-1 month'));
$lastMonthFarmers = $db->table('farmers')
    ->where('status', 1)
    ->where('associated_by','farmers')
    ->where('DATE(created_at) >=', $startOfLastMonth)
    ->where('DATE(created_at) <=', $endOfLastMonth)
    ->countAllResults();

// Growth %
$growth = $thisMonthFarmers - $lastMonthFarmers;
$growthPercent = round(($growth / max($lastMonthFarmers, 1)) * 100, 1);
$growthClass = $growth >= 0 ? 'text-success' : 'text-danger';
$growthIcon = $growth >= 0 ? 'trending_up' : 'trending_down';
$growthSign = $growth >= 0 ? '+' : '';
?>


<div class="col-md-3">
  <div class="card shadow-sm summary-card p-3 mb-3">
    <div class="d-flex justify-content-between align-items-center">
      <div>
        <h6 class="text-muted"> Farmers</h6>
        <h3 class="mb-0 counter" data-target="<?= $totalFarmers ?>">0</h3>

        <small class="text-info d-block">
          +<span class="counter" data-target="<?= $thisMonthFarmers ?>">0</span> this month
        </small>

        <small class="text-secondary d-block">
          +<span class="counter" data-target="<?= $lastMonthFarmers ?>">0</span> last month
        </small>

        <small class="<?= $growthClass ?>">
          <?= $growthSign . $growthPercent ?>%
          <span class="material-icons align-middle" style="font-size: 16px;">
            <?= $growthIcon ?>
          </span> vs last month
        </small>
      </div>
      <div>
        <div class="icon-circle " style="background:rgb(139,195,74)">
          <span class="material-icons text-white">agriculture</span>
        </div>
      </div>
    </div>
  </div>
</div>




                 </div>
             </div>
         </div>

         <!-- New Row with 2 Col-6 Boxes -->


         <?php
$db = \Config\Database::connect();

// Define user types with labels and colors
$types = [
  'organisation' => ['label' => 'Organisations',   'color' => 'rgba(54,162,235,1)'],
  'fpo'          => ['label' => 'FPOs',            'color' => 'rgba(75,192,192,1)'],
  'audit_company'=> ['label' => 'Audit Companies', 'color' => 'rgba(255,99,132,1)'],
  'farmer'       => ['label' => 'Farmers',         'color' => 'rgb(139,195,74)']
];

$months = [];
$data = [];

for ($i = 11; $i >= 0; $i--) {
  $monthLabel = date('M Y', strtotime("-$i months"));
  $start = date('Y-m-01', strtotime("-$i months"));
  $end = date('Y-m-t', strtotime("-$i months"));

  $months[] = $monthLabel;

  foreach ($types as $key => $meta) {
    if (!isset($data[$key])) $data[$key] = [];

    if ($key === 'farmer') {
      $count = $db->table('farmers')
        ->where('status', 1)
        ->where('associated_by','farmers')
        ->where('DATE(created_at) >=', $start)
        ->where('DATE(created_at) <=', $end)
        ->countAllResults();
    } else {
      $count = $db->table('entity_profiles')
        ->where('status', 1)
        ->where('user_type', $key)
        ->where('DATE(created_at) >=', $start)
        ->where('DATE(created_at) <=', $end)
        ->countAllResults();
    }

    $data[$key][] = $count;
  }
}
?>
<div class="col-md-12">
<div class="card  shadow-sm" data-aos="fade-up" data-aos-duration="800">
  <div class="card-body">
    <h5 class="card-title">Monthly User Type Trend</h5>
    <div id="userTrendChart" style="height: 400px; width: 100%;"></div>
  </div>
</div>
</div>





<?php
$db = \Config\Database::connect();

$types = [
  'organisation'   => ['label' => 'Organisations',   'color' => 'rgba(54,162,235,1)'],
  'fpo'            => ['label' => 'FPOs',            'color' => 'rgba(75,192,192,1)'],
  'audit_company'  => ['label' => 'Audit Companies', 'color' => 'rgba(255,99,132,1)'],
  'farmer'         => ['label' => 'Farmers',         'color' => 'rgb(139,195,74)']
];

// Outer ring: individual types
$outerData = [];
$outerColors = [];
$legendLabels = [];

// Inner ring: grouped categories
$innerData = [
  ['value' => 0, 'name' => 'Entities', 'itemStyle' => ['color' => '#8884d8']], // purple
  ['value' => 0, 'name' => 'Farmers',  'itemStyle' => ['color' => 'rgb(139,195,74)']] // orange
];
$innerLabels = ['Entities', 'Farmers'];

foreach ($types as $key => $meta) {
  if ($key === 'farmer') {
    $count = $db->table('farmers')
      ->where('status', 1)
      ->where('associated_by','farmers')
      ->countAllResults();
    $innerData[1]['value'] += $count;
  } else {
    $count = $db->table('entity_profiles')
      ->where('user_type', $key)
      ->where('status', 1)
      ->countAllResults();
    $innerData[0]['value'] += $count;
  }

  $outerData[] = ['value' => $count, 'name' => $meta['label']];
  $outerColors[] = $meta['color'];
  $legendLabels[] = $meta['label'];
}
$legendLabels = array_merge($innerLabels, $legendLabels);
?>





<div class="row">

<div class="col-md-12">
<div class="card shadow-sm" data-aos="fade-up" data-aos-duration="800">
  <div class="card-body">
    <h5 class="card-title"> User Type Breakdown</h5>
    <div id="userTypeDonut" style="width: 100%; height: 500px;"></div>

  </div>
</div>
</div>



<?php 
$users = [];

// Entity Users
$entities = $db->table('entity_profiles')
  ->select('establishment_name AS name, email, contact_mobile AS phone, user_type, company_logo AS photo')
  ->where('status', 1)
  ->where('id !=', 1)
  ->get()->getResultArray();

foreach ($entities as $e) {
  $e['type_color'] = match($e['user_type']) {
    'organisation'  => 'primary',
    'fpo'           => 'success',
    'audit_company' => 'warning',
    default         => 'secondary',
  };
  $e['type'] = ucfirst($e['user_type']);
  $e['photo'] = !empty($e['photo']) ? $e['photo'] : null;
  $users[] = $e;
}

// Farmers
$farmers = $db->table('farmers')
  ->select('first_name AS name, email, contact_mobile AS phone, Person_Photo AS photo')
  ->where('status', 1)
  ->where('associated_by','farmers')
  ->get()->getResultArray();

foreach ($farmers as $f) {
  $users[] = [
    'name'       => $f['name'],
    'email'      => $f['email'],
    'phone'      => $f['phone'],
    'type'       => 'Farmer',
    'photo'      => !empty($f['photo']) ? $f['photo'] : null,
    'type_color' => 'danger'
  ];
}

// Group by type
$groupedUsers = [];
foreach ($users as $user) {
  $groupedUsers[$user['type']][] = $user;
}

uksort($groupedUsers, 'strcasecmp');


?>

<?php

$typesMeta = [
  'Organisation'   => ['label' => 'Organisations',    'color' => 'rgba(54,162,235,1)', 'icon' => 'apartment'],
  'Fpo'            => ['label' => 'FPOs',             'color' => 'rgba(75,192,192,1)', 'icon' => 'groups'],
  'Audit_company'  => ['label' => 'Audit Companies',  'color' => 'rgba(255,99,132,1)', 'icon' => 'gavel'],
  'Farmer'         => ['label' => 'Farmers',          'color' => 'rgb(139,195,74)', 'icon' => 'agriculture']
];

// Sort users alphabetically within each group
foreach ($groupedUsers as &$usersGroup) {
  usort($usersGroup, function ($a, $b) {
    return strcasecmp($a['name'], $b['name']);
  });
}
unset($usersGroup); // break reference
?>




<div class="col-md-12">
  <div class="card  shadow-sm rounded-4" data-aos="fade-up" data-aos-duration="800">
    <div class="card-body">
      <h5 class="card-title mb-3">User Directory</h5>

      <!-- Global Search -->
      <input type="text" class="form-control mb-3" placeholder="Search all users..." id="globalSearch" onkeyup="filterAllGroups()">

      <!-- Scrollable User List -->
      <div class="overflow-auto" style="max-height: 500px;">
        <?php foreach ($groupedUsers as $type => $usersGroup): ?>
          <!-- Group Title -->
          <?php
$typeClass = strtolower(str_replace(' ', '_', $type)); // e.g., 'Audit Company' → 'audit_company'
?>
<?php
$typeLabel = $typesMeta[$type]['label'] ?? $type;
$typeIcon  = $typesMeta[$type]['icon'] ?? 'person';
$typeColor = $typesMeta[$type]['color'] ?? '#eee';
?>
<h6 class="group-title d-flex align-items-center justify-content-between px-3 py-2 mb-2 fs-4"
    style="background-color: <?= $typeColor ?>; position: sticky; top: 0; z-index: 2;">
  <span class="d-flex align-items-center">
    <div class="rounded-circle bg-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
      <i class="material-icons text-dark" style="font-size: 20px;"><?= $typeIcon ?></i>
    </div>
    <?= $typeLabel ?>
  </span>
  <span class="badge bg-light text-dark"><?= count($usersGroup) ?></span>
</h6>





          <!-- User Cards -->
          <div class="row  user-group">
            <?php foreach ($usersGroup as $user): ?>
              <div class="col-md-12 user-card-item">
                <div class="card shadow-sm p-3 d-flex flex-row align-items-center rounded-3 user-card" >
                  <!-- Profile -->
                  <div class="me-3">
                    <?php if (!empty($user['photo']) && file_exists($user['photo'])): ?>
                      <img src="<?= base_url()?><?= $user['photo']?>" alt="Avatar"
                           class="rounded-circle border"
                           style="width: 60px; height: 60px; object-fit: cover;">
                    <?php else: ?>
                      <div class="rounded-circle bg-title-<?= $typeClass ?> text-white d-flex align-items-center justify-content-center"
                           style="width: 60px; height: 60px; font-weight: bold; font-size: 20px;">
                        <?= strtoupper(substr($user['name'], 0, 1)) ?>
                      </div>
                    <?php endif; ?>
                  </div>

                  <!-- Info -->
                  <div class="flex-grow-1 ms-3">
  <h6 class="mb-1 user-name"><?= esc($user['name']) ?></h6>
  <div class="text-muted small">
    <i class="material-icons me-1 text-dark align-middle">mail</i>
    <?php if (!empty($user['email'])): ?>
      <a href="mailto:<?= esc($user['email']) ?>" class="text-decoration-none text-dark">
        <?= esc($user['email']) ?>
      </a>
    <?php else: ?>
      —
    <?php endif; ?>
    <br>

    <i class="material-icons me-1 text-dark align-middle">call</i>
    <?php if (!empty($user['phone'])): ?>
      <a href="tel:<?= esc($user['phone']) ?>" class="text-decoration-none text-dark">
        <?= esc($user['phone']) ?>
      </a>
    <?php else: ?>
      —
    <?php endif; ?>
  </div>
</div>

                  <!-- Badge -->
                  <div>
                    <!-- <span class="badge rounded-pill bg-<?= esc($user['type_color']) ?>">
                      <?= ucfirst(esc($user['type'])) ?>
                    </span> -->
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>
</div>
</div>




<div>

  </div>
    </div>

 
    
</div>

                     

                     
 <!--**********************************
            Content body end
        ***********************************-->

 <!--**********************************
            Footer start
        ***********************************-->
 <?= view('admin/layout/footer') ?>

 <script>
document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.counter').forEach(counter => {
    const target = +counter.dataset.target;
    const speed = 20;
    const increment = Math.ceil(target / 50);

    let current = 0;
    const update = () => {
      if (current < target) {
        current += increment;
        counter.innerText = current;
        setTimeout(update, speed);
      } else {
        counter.innerText = target;
      }
    };
    update();
  });
});
</script>

 


<script src="https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const chartDom = document.getElementById('userTrendChart');
  const myChart = echarts.init(chartDom);

  const option = {
    
    tooltip: {
      trigger: 'axis',
      axisPointer: { type: 'shadow' }
    },
    legend: {
      top: 30,
      data: <?= json_encode(array_column($types, 'label')) ?>
    },
    color: <?= json_encode(array_column($types, 'color')) ?>,
    toolbox: {
      feature: {
        saveAsImage: { title: 'Download' },
        dataView: { readOnly: true },
        restore: {},
        magicType: {
          type: ['line', 'bar'], // allow switching
          title: {
            line: 'Line Chart',
            bar: 'Bar Chart'
          }
        }
      },
      top: 10,
      right: 10
    },
    grid: {
      left: '3%',
      right: '4%',
      bottom: '3%',
      containLabel: true
    },
    xAxis: {
      type: 'category',
      data: <?= json_encode($months) ?>
    },
    yAxis: {
      type: 'value',
    
    
    },
    series: [
     
      <?php foreach ($types as $key => $meta): ?>
      {
        name: "<?= $meta['label'] ?>",
        type: 'bar', // ✅ default is bar
        barGap: 0,
        emphasis: { focus: 'series' },
        data: <?= json_encode($data[$key]) ?>
      },
      <?php endforeach; ?>
    ]
  };

  myChart.setOption(option);
});
</script>



<script>
document.addEventListener('DOMContentLoaded', function () {
  const chart = echarts.init(document.getElementById('userTypeDonut'));

  const option = {
    
    tooltip: {
      trigger: 'item',
      formatter: '{a}<br/>{b}: {c} ({d}%)'
    },
    legend: {
      bottom: 10,
      data: <?= json_encode($legendLabels) ?>
    },
    series: [
      {
        name: 'Main Group',
        type: 'pie',
        selectedMode: 'single',
        radius: [0, '35%'],
        label: {
          position: 'inside',
          formatter: '{b}: {c}',
          fontSize: 14,
          fontWeight: 'bold'
        },
        labelLine: { show: false },
        data: <?= json_encode($innerData) ?> // has custom itemStyle per slice
      },
      {
        name: 'User Type',
        type: 'pie',
        radius: ['45%', '65%'],
        label: {
        formatter: '{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ',
        backgroundColor: '#F6F8FC',
        borderColor: '#8C8D8E',
        borderWidth: 1,
        borderRadius: 4,
        rich: {
          a: {
            color: '#6E7079',
            lineHeight: 22,
            align: 'center'
          },
          hr: {
            borderColor: '#8C8D8E',
            width: '100%',
            borderWidth: 1,
            height: 0
          },
          b: {
            color: '#4C5058',
            fontSize: 14,
            fontWeight: 'bold',
            lineHeight: 33
          },
          per: {
            color: '#fff',
            backgroundColor: '#4C5058',
            padding: [3, 4],
            borderRadius: 4
          }
        }
      },
        labelLine: {
          length: 20,
          length2: 10
        },
        data: <?= json_encode($outerData) ?>,
        itemStyle: {
          color: function (params) {
            const colors = <?= json_encode($outerColors) ?>;
            return colors[params.dataIndex];
          }
        }
      }
    ]
  };

  chart.setOption(option);
});
</script>


<script>
function filterAllGroups() {
  const searchTerm = document.getElementById('globalSearch').value.toLowerCase();

  document.querySelectorAll('.user-group').forEach(group => {
    let visibleCount = 0;

    group.querySelectorAll('.user-card-item').forEach(card => {
      const name = card.querySelector('.user-name')?.textContent.toLowerCase() || '';
      const isVisible = name.includes(searchTerm);
      card.style.display = isVisible ? '' : 'none';
      if (isVisible) visibleCount++;
    });

    const title = group.previousElementSibling; // The <h6> group-title
    const badge = title?.querySelector('.badge');

    // Update group count badge
    if (badge) {
      badge.textContent = visibleCount;
    }

    // Show/hide group title and group content
    const shouldShow = visibleCount > 0;
    if (title && title.classList.contains('group-title')) {
      title.style.display = shouldShow ? '' : 'none';
    }
    group.style.display = shouldShow ? '' : 'none';
  });
}
</script>



