<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>TraceAudit</title>

  <link rel="shortcut icon" type="image/png" href="<?= base_url(); ?>assets/images/favicon.png" />

  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link class="main-css" href="<?= base_url(); ?>assets/css/style.css?<?= mt_rand(); ?>" rel="stylesheet">
  <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">

  <style>
   

  
  </style>
</head>

<body>

  <div class="container-fluid full-height">
    <div class="row h-100">

      <!-- Left Side Image -->
      <div class="col-md-6 d-none d-md-block bg-left"></div>

      <!-- Right Side Login -->
      <div class="col-md-6 d-flex align-items-center justify-content-center">
        <div class=" p-4 w-100" style="max-width: 520px;">
          <div class="text-center mb-4 logo-img">
            <img src="<?= base_url(); ?>assets/logo/krishi-gap-logo.png" alt="" style="max-width: 120px;" />
            <br>
           
            <small><b class="text-primary " style="font-size:1.5rem">TraceAudit </b></small><br>
            <small class="">Your Digital Pathway to Compliance and Market Trust.</small>
          </div>
          <h4 class="text-left mb-2">Forgot Password?</h4>
          <p>If you forgot your password, well, then we’ll email you instructions to reset your password.</p>

                            <?php if (session()->getTempdata('validation_errors')): ?>
                                <div class="alert alert-danger">
                                    <?= session('validation_errors'); ?>
                                </div>
                                <?php session()->removeTempdata('validation_errors'); // manual removal 
                                ?>
                            <?php endif; ?>


                            <div class="col-lg-12 mb-2 mb-md-2 text-left" >
                               <label for="selectjs">Select Account Type*</label>

                                <div class=" mb-3">
                                    <!-- Make sure the id is consistent -->
                                    <select style="width:100%;text-transform: capitalize;" id="selectjs"
                                        class="form-control selectjs selectjs_values" style="width:100%;">
                                        <option value="organisation">login as organization</option>
                                        <option value="fpo">login as farmer organization</option>
                                        <option value="farmer">login as farmer</option>
                                        <option value="audit_company">login as audit company</option>
                                    </select>
                                    <!-- Update the label's for attribute to match the select's id -->
                                    
                                    <div class="form-floating-icon"></div>
                                </div>




                                <div class="text-left py-2">

                                    <form class="Organization  singup_form" action="<?= base_url(); ?>send_otp_for_ferget_password" method="post" enctype="multipart/form-data">



                                    <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">


                                       <label for="input-email">Email ID*</label>
                                        <div class=" mb-3">
                                            <input type="email" name="Email_id" class="form-control" id="input-email1"
                                                placeholder="">
                                            
                                            <div class="form-floating-icon">


                                            </div>
                                        </div>

                                        <div class="render_error"></div>

                                        <div class="mb-3 text-center render_login_as">

                                        </div>



                                        <div class="form-floating form-floating-custom mb-3 entity_organization">



                                        </div>






                                        <div class="mt-3">
                                            <button type="submit" class="btn btn-primary w-100 next_page">submit</button>
                                        </div>
                                    </form><!-- end form -->














                            <div class="text-left mt-3">
                               <h6 class="text-left">Return to <a href="<?= base_url(); ?>" class="text-secondary link-hover"> Login</a></h6>
                            </div>
                            <div class="text-center mt-5">
                                <p class="fw-medium text-gray">Copyright © 2025 - <span class="text-secondary">TraceAudit</span> </p>
                            </div>

                                    <!--<div class="new-account text-center mt-3">-->
                                    <!--    <h6>Return to <a href="<?= base_url(); ?>" class="text-secondary link-hover"> Login</a></h6>-->
                                       
                                    <!--</div>-->

                                </div>


                                <!-- <div class="new-account mt-3">
                                <p>Already have an account? <a class="text-primary" href="page-login.html">Sign in</a>
                                </p>
                            </div> -->
                            </div>
          
        
        </div>
      </div>

    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!--**********************************
    Scripts
***********************************-->
        <!-- Required vendors -->
        <script src="<?= base_url(); ?>assets/vendor/global/global.min.js"></script>
        <!-- <script src="assets/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script> -->
        <!-- <script src="assets/vendor/bootstrap-datepicker-master/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/js/dlabnav-init.js"></script> -->
        <!-- <script src="assets/js/custom.min.js"></script> -->
        <!-- <script src="assets/js/demo.js"></script> -->
        <!-- <script src="assets/js/styleSwitcher.js"></script> -->



        <!-- localizationTool -->
        <!-- <script src="assets/js/jquery.localizationTool.js"></script> -->
        <!-- <script src="assets/js/translator.js"></script>	 -->
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">

        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

        <!-- Selectize CSS -->
        <link rel="stylesheet"
            href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

        <!-- jQuery (Required) -->


        <!-- Selectize JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>
        <style>
            .required {
                color: #000000;
            }

            .step {
                display: none;
            }

            .step.active {
                display: block;
            }

            .error-text {
                display: none;
                color: red;
                font-size: 14px;
            }

            .nav-tabs .nav-link.active {
                background-color: #6591fd;
                color: white;
            }
        </style>




        <script>
            $('.singup_form').on('submit', function(e) {


                const loginAsSelected = $("input[name='login_as']:checked").val();

                if (!loginAsSelected) {
                    e.preventDefault(); // prevent form submission
                    // alert("Please select a role before submitting the form.");
                    // Or show the error in a custom styled div
                    $(".render_error").html(`<div style=" color: red !important; " class="text-danger">this email not registered</div>`);
                } else {


                    let og_login = $(".selectjs_values").val()

                    if ($("input[name='login_as_hidden']").length === 0) {
                        // Append hidden input
                        $(this).append(`<input type="hidden" name="login_as_hidden" value="${og_login}">`);
                    } else {
                        // Update value if already exists
                        $("input[name='login_as_hidden']").val(og_login);
                    }
                    $(".render_login_as_error").html(""); // clear any previous error
                }
            });


            $('#input-email1').on('blur', function() {
                let email = $(this).val();
                let regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                if (regex.test(email)) {
                    console.log('Email OK');


                    if ($("#selectjs").val() == "farmer") {


                        $(".render_login_as").html(`<input type="radio" class="btn-check" name="login_as" id="super_admin" value="farmers" checked>`)


                        $(".password_show").show()

                    } else {

                        console.log($("#selectjs").val());

                        let type_value = $("#selectjs").val();
                        let email_adress = $("#input-email1").val();
                        let csrfName = $('#csrf_token').attr('name');
                        let csrfHash = $('#csrf_token').val();

                        if (email !== '') {
                            $.ajax({
                                url: '<?= base_url(); ?>check_user_roles', // your route/controller method
                                type: 'POST',
                                data: {
                                    [csrfName]: csrfHash,
                                    type_value: type_value,
                                    email: email_adress
                                },
                                dataType: "json",
                                success: function(response) {

                                    let login_as = `<label class="d-block fw-semibold mb-2">Login As:</label>
                             <div class="d-flex flex-wrap gap-2 justify-content-center" id="role-selector">
                                `;





                                    if (response.response.length === 1) {
                                        // If only one result, show it directly
                                        console.log("Only one result found:");
                                        console.log("Table:", );

                                        login_as += give_radio_button(response.response[0].table);


                                        login_as += ` </div>
                                        `;


                                        assosited_organization_detais();



                                    } else if (response.response.length > 1) {
                                        // If multiple results, loop through them


                                        response.response.forEach(function(item) {
                                            login_as += give_radio_button(item.table);
                                        });


                                        login_as += ` </div>
                                        `;



                                    } else {
                                        login_as = "No matching roles found.";
                                    }

                                    if (response.csrfToken) {
                                        $('#csrf_token').val(response.csrfToken);



                                    }

                                    $(".password_show").show()


                                    $('.render_login_as').html(login_as);



                                }
                            });
                        }



                    }



                } else {
                    console.log('Invalid Email');
                }
            });


            function give_radio_button(table_name) {
                switch (table_name) {
                    case "entity_profiles":
                        return `<input type="radio" class="btn-check" name="login_as" id="super_admin" value="entity_profiles">
                    <label class="btn btn-outline-dark" for="super_admin"><i class="bi bi-stars"></i> Super Admin</label>`;
                    case "Contact_Person":
                        return `<input type="radio" class="btn-check" name="login_as" id="admin" value="Contact_Person">
                    <label class="btn btn-outline-dark" for="admin"><i class="bi bi-shield-lock"></i> Contact Person</label>`;
                    case "employee":
                        return `<input type="radio" class="btn-check" name="login_as" id="employee" value="employee">
                    <label class="btn btn-outline-primary" for="employee"><i class="bi bi-person-badge"></i> Employee</label>`;
                    case "subcontractors":
                        return `<input type="radio" class="btn-check" name="login_as" id="subcontractor" value="subcontractors">
                    <label class="btn btn-outline-secondary" for="subcontractor"><i class="bi bi-building"></i> Subcontractor</label>`;
                    case "internal_inspectors":
                        return `<input type="radio" class="btn-check" name="login_as" id="inspector" value="internal_inspectors">
                    <label class="btn btn-outline-warning" for="inspector"><i class="bi bi-eye-fill"></i> Internal Inspector</label>`;
                    case "internal_auditors":
                        return `<input type="radio" class="btn-check" name="login_as" id="internal_auditor" value="internal_auditors">
                    <label class="btn btn-outline-danger" for="internal_auditor"><i class="bi bi-clipboard2-check-fill"></i> Internal Auditor</label>`;
                    case "farmer_supervisors":
                        return `<input type="radio" class="btn-check" name="login_as" id="farmer_supervisor" value="farmer_supervisors">
                    <label class="btn btn-outline-success" for="farmer_supervisor"><i class="bi bi-person-lines-fill"></i> Farmer Supervisor</label>`;
                    case "auditors":
                        return `<input type="radio" class="btn-check" name="login_as" id="auditor" value="auditors">
                    <label class="btn btn-outline-info" for="auditor"><i class="bi bi-journal-check"></i> Auditor</label>`;
                    default:
                        return '';
                }
            }
            $(document).on('change', "input[name='login_as']", function() {



                assosited_organization_detais();



            })
        </script>

        <link href="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/js/tom-select.complete.min.js"></script>
        <script>
            function assosited_organization_detais() {


                 
                var selectedValue = $("input[name='login_as']:checked").val(); // Get selected radio button value


                let csrfName = $('#csrf_token').attr('name');
                let csrfHash = $('#csrf_token').val();

                if (selectedValue != 'entity_profiles') {

                    $.ajax({
                        type: "post",
                        url: "<?= base_url('get_organization_list'); ?>", // Correct URL generation
                        data: {
                            [csrfName]: csrfHash, // Important: Send CSRF token in request
                            selected_enity: $("#selectjs").val(),
                            email_id: $("#input-email1").val(), // <<< You missed closing bracket in your code
                            Loign_as: selectedValue
                        },
                        dataType: "json",
                        success: function(response) {
                            console.log(response);

                            if (response.data === 0) {

                                alert("No entity profile found.")

                            } else {


                                $(".entity_organization").html(response.data);



                                new TomSelect('#entity_select', {
                                    create: false,
                                    allowEmptyOption: true,
                                    // No sortField here — it keeps your original order
                                });


                            }




                            $('#csrf_token').val(response.csrfToken);

                            
                        },
                        error: function(xhr, status, error) {
                            console.error("AJAX Error:", error);
                        }
                    });

                } else {

                     
                }


            }



            document.addEventListener('DOMContentLoaded', function() {
                new TomSelect('#entity_select', {
                    create: false,
                    allowEmptyOption: true,
                    // No sortField here — it keeps your original order
                });
            });
        </script>






</html>
