 <?= view('organisation/layout/header') ?>
 <?= view('organisation/layout/sidebar') ?>

 <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

 <!--**********************************
            Sidebar start
        ***********************************-->

 <!--**********************************
            Sidebar end 
        ***********************************-->

 <!--**********************************
            Content body start
        ***********************************-->

 <style>
.dashboard-card {
    border: none;
    border-radius: 15px;
    padding: 25px;
    color: #fff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
}

.icon-box {
    font-size: 3rem;
    opacity: 0.8;
}

.badge-custom {
    font-size: 0.9rem;
    padding: 5px 10px;
    border-radius: 10px;
}
 </style>

 <div class="content-body">
     <!-- row -->
     <div class="container-fluid">
         <div class="d-flex align-items-center mb-4 flex-wrap">
             <h3 class="me-auto">Implementation Compliance List</h3>
             <div>
                 <?php if (session()->get('add') == true): ?>
                 <a href="<?= base_url("organization/add_ImplementationCompliance") ?>" class="btn btn-primary me-3"><i
                         class="fas fa-plus me-2"></i>Create New </a>

                 <?php endif; ?>
             </div>
         </div>
         <?php if (session()->getFlashdata('success')): ?>
         <div class="alert alert-success">
             <?= session()->getFlashdata('success') ?>
         </div>
         <?php endif; ?>


         <div class="row">

             <div class="col-xl-6">

                 <button onclick="exportToExcel()" id="exportBtn" class="btn btn-success mb-3">Export to Excel</button>

             </div>
             <div class="col-xl-3"></div>
             <div class="col-xl-3">

                 <input type="text" id="searchInput" onkeyup="searchTable()" class="form-control mb-3"
                     placeholder="Search table...">

             </div>
             <div class="col-xl-12">
                 <div class="table-responsive">
                 					<table class="table display mb-4 dataTablesCard job-table table-responsive-xl card-table" id="contactTable">
    <thead>
        <tr>
            <th>S.NO</th>
            <th>Standard Requirement Clause</th>
            <th>Implementation</th>
            <th>Updated by</th>
            <th>Updated at</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $db = \Config\Database::connect();
        $builder = $db->table('implementation_compliance');
        $query = $builder->select('*')
            ->where('status', 1)
            ->where('associated_by', session()->get('user_associated'))
            ->where('entity_id', session()->get('entity_id'))
            ->orderBy('id', 'DESC')
            ->get();

        $results = $query->getResultArray();
        $i = 0;

        foreach ($results as $row):
            $i++;

            // Get first section data from JSON
            $sections = json_decode($row['section_data'], true);
            $firstSection = $sections[0] ?? [
                'requirement_clause' => '',
                'implementation' => '',
                'remarks' => '',
                'file_path' => '',
                'link' => '',
                'heading' => '',
            ];

            // Get created/updated user info
            $updated_user = $db->table('register_log')->where('id', $row['updated_by'])->get()->getRowArray();
            $created_user = $db->table('register_log')->where('id', $row['created_by'])->get()->getRowArray();
        ?>
            <tr
                data-Standard-Requirement-Clause="<?= esc($firstSection['requirement_clause']) ?>"
                data-Implementation="<?= esc($firstSection['implementation']) ?>"
                data-Remarks="<?= esc($firstSection['remarks']) ?>"
                data-Provide-Link="<?= esc($firstSection['link']) ?>"
                data-Upload-Procedure="<?= esc($firstSection['file_path']) ?>"
                data-created-by="<?= esc($created_user['name_of_the_user']) ?>"
                data-created-at="<?= esc($row['created_at']) ?>"
                data-updated-by="<?= esc($updated_user['name_of_the_user']) ?>"
                data-updated-at="<?= esc($row['updated_at']) ?>"
            >
                <td><?= $i ?></td>
                <td><?= esc($firstSection['requirement_clause']) ?></td>
                <td><?= esc($firstSection['implementation']) ?></td>
                <td><?= esc($updated_user['name_of_the_user']) ?></td>
                <td><?= date('d/m/Y H:i', strtotime($row['updated_at'])) ?></td>
                <td>
                    <div class="action-buttons d-flex justify-content-end">
                        <a href="<?= base_url("organization/view_Implementation_Compliance/" . $row['id']) ?>" target="_blank" class="btn btn-success light mr-2">
                            <span class="material-icons">visibility</span>
                        </a>

                        <?php if (session()->get('edit') == true): ?>
                            <a href="<?= base_url("organization/edit_ImplementationCompliance/" . $row['id']) ?>" class="btn btn-secondary light mr-2">
                                <span class="material-icons">edit</span>
                            </a>
                        <?php endif; ?>

                        <?php if (session()->get('delete') == true): ?>
                            <a href="<?= base_url("organization/delete_ImplementationCompliance/" . $row['id']) ?>" class="btn btn-danger light">
                                <span class="material-icons">delete</span>
                            </a>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
                     <nav>
                         <ul class="pagination justify-content-center" id="pagination"></ul>
                     </nav>
                 </div>
             </div>
         </div>
     </div>
 </div>






 <!--**********************************
            Content body end
        ***********************************-->

 <!--**********************************
            Footer start
        ***********************************-->
 <?= view('organisation/layout/footer') ?>


 <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
 <!-- Excel Export -->
 <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>


 <script>

 </script>

 <!-- Selectize CSS -->
 <link rel="stylesheet"
     href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

 <!-- jQuery (Required) -->


 <!-- Selectize JS -->
 <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>



 <script>

 </script>