<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Auditor Chat View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        html,
        body {
            height: 100%;
            margin: 0;
            background-color: #f8f9fa;
        }

        .chat-container {
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .chat-header {
            background-color: #343a40;
            color: white;
            padding: 15px;
            font-size: 20px;
            font-weight: bold;
        }

        .chat-body {
            flex: 1;
            padding: 15px;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .message-row {
            display: flex;
            flex-direction: column;
            max-width: 75%;
        }

        .auditor {
            align-self: flex-start;
        }

        .subscriber {
            align-self: flex-end;
            text-align: right;
        }

        .message-bubble {
            padding: 10px 15px;
            border-radius: 15px;
            background-color: #e9ecef;
            word-wrap: break-word;
        }

        .auditor .message-bubble {
            background-color: #e2f0ff;
            border-top-left-radius: 0;
        }

        .subscriber .message-bubble {
            background-color: #d4edda;
            border-top-right-radius: 0;
        }

        .message-image {
            max-width: 100%;
            margin-top: 10px;
            border-radius: 10px;
        }

        .message-meta {
            font-size: 12px;
            color: #6c757d;
            margin-top: 5px;
        }

        .chat-input {
            padding: 10px;
            background: #fff;
            border-top: 1px solid #dee2e6;
            display: flex;
            gap: 10px;
        }

        .chat-input input {
            flex: 1;
        }

        .label {
            font-weight: bold;
            color: #343a40;
        }
    </style>

    <style>
        .message-bubble {
            padding: 10px 15px;
            border-radius: 15px;
            background-color: #e2f0ff;
            /* auditor bubble color */
            word-wrap: break-word;
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        /* Single line info with pipe separators */
        .info-line {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            margin-bottom: 8px;
            color: #343a40;
        }

        .info-line span {
            margin-right: 12px;
        }

        .info-line span:not(:last-child)::after {
            content: "|";
            margin-left: 12px;
            color: #888;
        }

        /* Label style */
        .label {
            font-weight: 700;
            /* Bold */
            font-size: 14px;
            color: #222;
            margin-right: 4px;
        }

        /* User comment separate line */
        .user-comment {
            font-size: 13px;
            color: #555;
            margin-top: 0;
            white-space: normal;
            word-wrap: break-word;
        }

        a.btn-link {
            padding: 0;
            font-size: 14px;
        }

        .subscriber-bubble {
            padding: 10px 15px;
            border-radius: 15px;
            background-color: #d4f9d2;
            word-wrap: break-word;
            font-family: Arial, sans-serif;
            font-size: 14px;
            margin-bottom: 10px;
            position: relative;
            margin-left: auto;
            max-width: 75%;
            text-align: left;
        }
    </style>

</head>

<body>
    <div class="chat-container">

        <?php
        $db = \Config\Database::connect();
        $template = [];

        if (!empty($subscribe_the_audit_teamplate['audit_teamplate_id'])) {
            $tmpn = $db->table('audit_template')
                ->select('*') // or specify 'role_name' if that's the column
                ->where('id', $subscribe_the_audit_teamplate['audit_teamplate_id'])
                ->get();

            $template = $tmpn->getResultArray();
        }

        $template_name = !empty($template) ? $template[0]['template_name'] : 'Not Assigned';


        $subscriber_name = '';

        if (!empty($subscribe_the_audit_teamplate['associated_by'])) {

            if ($subscribe_the_audit_teamplate['associated_by'] != 'farmers') {

                $regiterylog_cheek = [];

                if (!empty($subscribe_the_audit_teamplate['created_by'])) {
                    $regirty_log = $db->table('entity_profiles')
                        ->select('*') // or specify 'role_name' if that's the column
                        ->where('id', $subscribe_the_audit_teamplate['entity_id'])
                        ->get();

                    $regiterylog_cheek = $regirty_log->getResultArray();
                }

                $subscriber_name = !empty($regiterylog_cheek) ? $regiterylog_cheek[0]['establishment_name'] : 'Not Assigned';
            } else {

                $regiterylog_cheek = [];

                if (!empty($subscribe_the_audit_teamplate['created_by'])) {
                    $regirty_log = $db->table('farmers')
                        ->select('*') // or specify 'role_name' if that's the column
                        ->where('id', $subscribe_the_audit_teamplate['entity_id'])
                        ->get();

                    $regiterylog_cheek = $regirty_log->getResultArray();
                }

                $subscriber_name = !empty($regiterylog_cheek)
                    ? trim($regiterylog_cheek[0]['title'] . ' ' .
                        $regiterylog_cheek[0]['first_name'] . ' ' .
                        $regiterylog_cheek[0]['middle_name'] . ' ' .
                        $regiterylog_cheek[0]['last_name'])
                    : 'Not Assigned';
            }
        }







        // Fallback to dummy value if empty

        $subscriber_from = $subscribe_the_audit_teamplate['associated_by'];


        ?>

        <div class="chat-header">
            🗂️ <?= esc($template_name) ?> — <strong><?= esc($subscriber_from) ?> — <strong><?= esc($subscriber_name) ?> </strong>
        </div>
        <div class="chat-body" id="chatBody">


            <?php foreach ($log as $log): ?>


                <?php



                if ($log['who_send'] == 'subscriber') {


                    // Format date for heading (same as auditor)
                    $messageDate = date('d M Y', strtotime($log['created_at'] ?? $log['created_at'] ?? 'now'));


                ?>

                    <div style="text-align: center; margin: 15px 0;">
                        <span style="
                            background-color: #d4f9d2;
                            padding: 6px 12px;
                            border-radius: 20px;
                            font-weight: bold;
                            color: #2c3e50;
                            font-size: 13px;
                        ">
                            <?= $messageDate ?>
                        </span>
                    </div>

                    <div class="message-row subscriber">







                        <div><span class="label"><?= $log['message_to_auditor'] ?></span></div>
                        <?php $documants = json_decode($log['documents_status'], true); ?>
                        <?php if (!empty($documants) && is_array($documants)): ?>
                            <?php foreach ($documants as $index => $doc): ?>

                                <div class="message-bubble">

                                    <div class="info-line">
                                        <span><span class="label">Name:</span><?= esc($doc['name']) ?: '-' ?></span>
                                        <span><span class="label">Date:</span><?= esc($doc['date']) ?: '-' ?></span>
                                        <span><span class="label">File:</span>
                                            <?php if (!empty($doc['file'])): ?>
                                                <a href="<?= base_url($doc['file']) ?>" target="_blank" class="btn btn-link ps-0">View</a>
                                            <?php else: ?>
                                                No file
                                            <?php endif; ?>
                                        </span>

                                    </div>
                                    <div class="user-comment">
                                        <span class="label">User Comment:</span> <?= esc($doc['user_comments']) ?: 'No comments' ?>
                                    </div>

                                </div>


                            <?php endforeach; ?>




                        <?php endif; ?>


                    </div>

                <?php
                }

                ?>


                <?php



                if ($log['who_send'] == 'auditor') {


                    // Format date for heading (same as auditor)
                    $messageDate = date('d M Y', strtotime($log['created_at'] ?? $log['created_at'] ?? 'now'));


                ?>

                    <div style="text-align: center; margin: 15px 0;">
                        <span style=" background-color: #d0e6ff; padding: 6px 12px; border-radius: 20px; font-weight: bold; color: #2c3e50; font-size: 13px; ">
                            <?= $messageDate ?>
                        </span>
                    </div>

                    <div class="message-row auditor">





                        <?php
                        $auditStatus = $log['audit_Status'] ?? null;
                        $auditStatusText = '';
                        $bgColor = '';
                        $textColor = '';

                        switch ($auditStatus) {
                            case '1':
                                $auditStatusText = 'Audit Assignment Accepted';
                                $bgColor = '#cce5ff';
                                $textColor = '#004085';
                                break;
                            case '2':
                                $auditStatusText = 'Audit Rejected';
                                $bgColor = '#f8d7da';
                                $textColor = '#721c24';
                                break;
                            case '3':
                                $auditStatusText = 'Audit In-Process';
                                $bgColor = '#d1ecf1';
                                $textColor = '#0c5460';
                                break;
                            case '4':
                                $auditStatusText = 'Audit On-hold';
                                $bgColor = '#fff3cd';
                                $textColor = '#856404';
                                break;
                            case '5':
                                $auditStatusText = 'Audit Pending Payment';
                                $bgColor = '#e2e3e5';
                                $textColor = '#383d41';
                                break;
                            case '6':
                                $auditStatusText = 'Audit Completed';
                                $bgColor = '#d4edda';
                                $textColor = '#155724';
                                break;
                            default:
                                $auditStatusText = 'Unknown Status';
                                $bgColor = '#d6d8d9';
                                $textColor = '#1b1e21';
                                break;
                        }
                        ?>

                        <!-- SYSTEM/AUDIT STATUS MESSAGE (CENTER BUBBLE) -->
                        <div style="text-align: center; margin: 15px 0;">
                            <span style="
    background-color: <?= $bgColor ?>;
    color: <?= $textColor ?>;
    padding: 10px 20px;
    border-radius: 25px;
    font-weight: bold;
    font-size: 14px;
    display: inline-block;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
  ">
                                <?= esc($auditStatusText) ?>
                            </span>
                        </div>

                        <div><span class="label"><?= $log['message_from_auditor'] ?></span></div>
                        <?php $documants = json_decode($log['documents_status'], true); ?>
                        <?php if (!empty($documants) && is_array($documants)): ?>
                            <?php foreach ($documants as $index => $doc): ?>

                                <div class="message-bubble">

                                    <div class="info-line">
                                        <span><span class="label">Name:</span><?= esc($doc['name']) ?: '-' ?></span>
                                        <span><span class="label">Date:</span><?= esc($doc['date']) ?: '-' ?></span>
                                        <span><span class="label">File:</span>
                                            <?php if (!empty($doc['file'])): ?>
                                                <a href="<?= base_url($doc['file']) ?>" target="_blank" class="btn btn-link ps-0">View</a>
                                            <?php else: ?>
                                                No file
                                            <?php endif; ?>
                                        </span>
                                        <span><span class="label">document status:</span><?= esc($doc['doc_status']) ?: '-' ?></span>
                                    </div>
                                    <div class="user-comment">
                                        <span class="label">auditor Comment:</span> <?= esc($doc['auditor_comments']) ?: 'No comments' ?>
                                    </div>

                                </div>


                            <?php endforeach; ?>




                        <?php endif; ?>


                    </div>

                <?php
                }

                ?>




            <?php endforeach; ?>


        </div>

    </div>


</body>

</html>