 <?= view('Audit_company/layout/header') ?>
 <?= view('Audit_company/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">New Internal audit</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("audit_company_afl/insert_internal_audit") ?>" id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">


                                <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">audit ID<span class="text-danger scale5 ms-2">*</span></label>

                                    <?php
                                    $session = session();
                                    $entityId = $session->get('entity_id');
                                    $autoGenerate = $session->get('auto_generate');
                                    $buildingId = '';

                                    if ($autoGenerate && $entityId) {
                                        // Connect to the database
                                        $db = \Config\Database::connect();
                                        $builder = $db->table( 'internal_audit');

                                        // Count all rows
                                        $count = $builder->countAll();

                                        // Generate unique building ID
                                        $buildingId = 'audit-' . $entityId . '_' . ($count + 1);
                                    }
                                    ?>

                                    <input type="text" class="form-control" name="facility_id" placeholder="<?= !$autoGenerate ? 'Enter ID' : '' ?>" aria-label="building-id" maxlength="8" value="<?= esc($buildingId) ?>"
                                        <?= $autoGenerate ? 'readonly' : '' ?> required>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4  ">
                                    <label class="form-label">Audit Category <span class="text-danger"></span></label>
                                    <select class="form-control" name="audit_categoery" >
                                        <option value="Initial">Initial</option>
                                        <option value="Surveillance">Surveillance</option>
                                        <option value="Renewal">Renewal</option>

                                    </select>
                                </div>









                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Record Date <span class="text-danger ms-2">*</span></label>
                                    <input type="date" class="form-control" name="recoed_date" placeholder="Select Date" required>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Location<span class="text-danger ms-2"></span></label>
                                    <input type="text" class="form-control" name="location" placeholder="Location" maxlength="100" >
                                </div>







                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Audit For<span class="text-danger ms-2"></span></label>
                                    <select class="form-control" id="locationDropdown"  name="location_for_audit">
                                        <option value="" disabled selected>Select Location</option>
                                        <option value="Corporate_Office">Corporate Office(current entity )</option>
                                       
                                        <option value="factory_builidings">Factory</option>
                                        <option value="storage_details">Storage</option>
                                     
                                        <option value="packaging_unit">Packaging Unit</option>
                                        <option value="Others">Others</option>
                                    </select>
                                </div>







                                <div class="col-xl-3 col-md-3 mb-4  show_options" style="display: none; ">
                                    <label class="form-label">select location <span class="text-danger scale5 ms-2"></span></label>
                                    <select id="selected_locations_show" name="selected_location_id[]" class="form-control" multiple placeholder="Select Factory">
                                        <!-- Options will be populated dynamically -->
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4  Others" style=" display:none; ">
                                    <label class="form-label"> Others<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text" class="form-control" placeholder="Others" aria-label="factory-address1" name="others" >
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4">
                                    <?php  
                                    $db = \Config\Database::connect();
                                    $roles =$db->table('department')
                                    ->select('id, department_name')
                                    ->where('status', 1)
                                    ->where('associated_by', session()->get('user_associated'))
                                    ->where('entity_id', session()->get('entity_id'))
                                    ->get()
                                    ->getResult();
                                    ?>

                                    <label class="form-label">Select Department</label>
                                    <select class="select2" id="designation" name="Department" aria-label="contact_person_designation" >
                                        <option value="">Select Department</option>
                                        <?php if (!empty($roles)): ?>
                                            <?php foreach ($roles as $role): ?>
                                                <option value="<?= esc($role->id) ?>"><?= esc($role->department_name) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4  ">
                                    <label class="form-label">Audit Type <span class="text-danger">*</span></label>
                                    <select class="form-control audit_type" name="audit_type" required>
                                        <option value="Financial">Financial</option>
                                        <option value="Operational">Operational</option>
                                        <option value="Compliance">Compliance</option>
                                        <option value="Environmental">Environmental</option>
                                        <option value="IT">IT</option>
                                        <option value="Others">Others</option>
                                    </select>
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4  auid_others" style=" display:none; ">
                                    <label class="form-label">specify audit type<span class="text-danger scale5 ms-2"></span></label>
                                    <input type="text"  class="form-control" placeholder="specify audit type" aria-label="factory-address1" name="others_in_audit_type" >
                                </div>







                                




                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Audit Schedule<span class="text-danger scale5 ms-2"></span></label>
                                    <textarea class="form-control" name="internal_audit_schedule" placeholder="Specify audit schedule"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Audit Scope<span class="text-danger scale5 ms-2"></span></label>
                                    <textarea class="form-control" name="internal_audit_scope" placeholder="InternalAudit Scope"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Audit Checklist Used<span class="text-danger scale5 ms-2"></span></label>
                                    <textarea class="form-control" name="internal_audit_checklist" placeholder="Checklist Used"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Non-Conformities Reported<span class="text-danger scale5 ms-2">*</span></label>
                                    <textarea class="form-control" required name="internal_non_conformities" placeholder="Non-Conformities Reported"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Opportunities for Improvement<span class="text-danger scale5 ms-2">*</span></label>
                                    <textarea class="form-control" required name="internal_opportunities" placeholder="Opportunities for Improvement"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">  Corrective Actions Taken<span class="text-danger scale5 ms-2">*</span></label>
                                    <textarea class="form-control" required name="internal_corrective_actions_taken" placeholder="Corrective Actions Taken"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">  Corrective Actions Closed<span class="text-danger scale5 ms-2">*</span></label>
                                    <textarea class="form-control" required name="internal_corrective_actions_closed" placeholder="Corrective Actions Closed"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">  Final Audit Report (Summary)<span class="text-danger scale5 ms-2">*</span></label>
                                    <textarea class="form-control" required name="internal_final_audit_report" placeholder="Final Audit Report Summary"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Description (if any)<span class="text-danger scale5 ms-2"></span></label>
                                    <textarea class="form-control" name="description" placeholder="Description (if any)"  ></textarea>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Remarks<span class="text-danger scale5 ms-2"></span></label>

                                    <textarea id="" class="form-control" placeholder="Remarks" name="Remark" aria-label="manufacturing-activities"></textarea>

                                </div>


                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label">Auditors<span class="text-danger scale5 ms-2"></span></label>
                                    <div id="auditorContainer">
                                        <div class="auditor-row row">
                                            <div class="col-xl-4 col-md-4 mb-4">
                                                <label class="form-label">Auditor Name<span class="text-danger ms-2"></span></label>
                                                <input type="text" class="form-control" name="auditor_name[]" placeholder="Enter Auditor Name" >
                                            </div>
                                            <div class="col-xl-4 col-md-4 mb-4">
                                                <label class="form-label">Auditor Photo<span class="text-danger ms-2"></span></label>
                                                <input type="file" class="form-control" name="auditor_photo[]" accept="image/jpeg, image/png" >
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMoreAuditor" class="btn btn-primary mt-3">Add More</button>
                                    </div>
                                </div>






                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label">  Auditee Representative<span class="text-danger scale5 ms-2"></span></label>
                                    <div id="auditeeContainer">
                                        <div class="auditee-row row">
                                            <div class="col-xl-4 col-md-4 mb-4">
                                                <label class="form-label">Representative Name<span class="text-danger ms-2"></span></label>
                                                <input type="text" class="form-control" name="auditee_name[]" placeholder="Enter Representative Name" >
                                            </div>
                                            

                                        </div>
                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMoreAuditee" class="btn btn-primary mt-3">Add More</button>
                                    </div>
                                </div>





                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label">document<span class="text-danger scale5 ms-2"></span></label>
                                    <div id="documentContainer">
                                        <div class="document-row row">
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Document Name<span class="text-danger ms-2"></span></label>
                                                <input type="text" class="form-control" name="doc_name[]" placeholder="Enter Document Name"  accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv"  >
                                            </div>
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Document Date<span class="text-danger ms-2"></span></label>
                                                <input type="date" class="form-control" name="doc_date[]" >
                                            </div>
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Upload document<span class="text-danger ms-2"></span></label>
                                                <input type="file" class="form-control" name="doc_file[]"   >
                                            </div>
                                            <!-- <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                                            <button type="button" class="btn btn-danger remove-btn">Remove</button>
                                        </div> -->
                                        </div>
                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMore" class="btn btn-primary mt-3">Add More</button>

                                    </div>
                                </div>

                            </div>

                    </div>





                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>












<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
 <?= view('Audit_company/layout/footer') ?>


<script>
    $(document).ready(function() {
        $("#addMore").click(function() {
            let newRow = `
                <div class="document-row row">
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Name<span class="text-danger ms-2"></span></label>
                        <input type="text" class="form-control" name="doc_name[]"   accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv" 
 placeholder="Enter Document Name" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Date<span class="text-danger ms-2"></span></label>
                        <input type="date" class="form-control" name="doc_date[]" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                       <label class="form-label">Upload document<span class="text-danger ms-2"></span></label>
                        <input type="file" class="form-control" name="doc_file[]"     accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv">
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#documentContainer").append(newRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".document-row").remove();
        });

        $("#documentForm").submit(function(e) {
            e.preventDefault();
            alert("Form Submitted with " + $("input[name='doc_name[]']").length + " documents!");
        });
    });
</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery () -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>





<script>
    const $selectedLocations = $('#selected_locations_show').selectize({
        plugins: ['remove_button'], // 💡 Enable remove button
        maxItems: null, // Allow multiple selection
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        placeholder: 'Select Locations',
        options: [],
        create: false
    });
    const selectedLocationsSelectize = $selectedLocations[0].selectize;


    $("#locationDropdown").change(function() {



        if ($(this).val() == 'Corporate_Office') {

            $('.show_options').hide()
            $('.Others').hide()
        } else if ($(this).val() == 'Others') {
            console.log($(this).val())
            $('.show_options').hide()
            $('.Others').show()

        } else {
            $('.show_options').show()
            $('.Others').hide()
            let csrfName = $('#csrf_token').attr('name');
            let csrfHash = $('#csrf_token').val();
            $.ajax({
                type: "POST",
                url: "<?= base_url("audit_company_afl/get_details_of_unites") ?>",
                data: {

                    data: $(this).val(),
                    [csrfName]: csrfHash
                },
                dataType: "json",
                success: function(response) {



                    if (response.data && Array.isArray(response.data)) {
                        selectedLocationsSelectize.clear(); // Clear the selected data
                        selectedLocationsSelectize.clearOptions(); // Clear existing options
                        selectedLocationsSelectize.addOption(response.data); // Add the new options
                        selectedLocationsSelectize.refreshOptions(true); // Refresh the options display
                    } else {
                        console.warn('No location data found');
                    }

                    if (response.csrfToken) {
                        $('#csrf_token').val(response.csrfToken);



                    }

                }
            });



        }



    })
</script>


<script>
    $(".audit_type").change(function() {



        if ($(this).val() == "Others") {


            $(".auid_others").show();
        } else {


            $(".auid_others").hide();
        }



    });
</script>


<script>
    $(document).ready(function() {
        $('#designation').selectize({

        });
    });
</script>

<script>
    document.getElementById('addMoreAuditee').addEventListener('click', function() {
        const container = document.getElementById('auditeeContainer');
        const newRow = document.createElement('div');
        newRow.classList.add('auditee-row', 'row');
        newRow.innerHTML = `
            <div class="col-xl-4 col-md-4 mb-4">
                <label class="form-label">Representative Name<span class="text-danger ms-2"></span></label>
                <input type="text" class="form-control" name="auditee_name[]" placeholder="Enter Representative Name" >
            </div>
           
            <div class="col-xl-4 col-md-4 mb-4 d-flex align-items-end">
                <button type="button" class="btn btn-danger remove-auditee-btn">Remove</button>
            </div>
        `;
        container.appendChild(newRow);
    });

    document.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('remove-auditee-btn')) {
            e.target.closest('.auditee-row').remove();
        }
    });
</script>

<script>
    $(document).ready(function() {
        $("#addMoreAuditor").click(function() {
            let newAuditorRow = `
                <div class="auditor-row row">
                    <div class="col-xl-4 col-md-4 mb-4">
                        <label class="form-label">Auditor Name<span class="text-danger ms-2"></span></label>
                        <input type="text" class="form-control" name="auditor_name[]" placeholder="Enter Auditor Name" >
                    </div>
                    <div class="col-xl-4 col-md-4 mb-4">
                        <label class="form-label">Auditor Photo<span class="text-danger ms-2"></span></label>
                        <input type="file" class="form-control" name="auditor_photo[]" accept="image/jpeg, image/png" >
                    </div>
                    <div class="col-xl-4 col-md-4 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#auditorContainer").append(newAuditorRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".auditor-row").remove();
        });
    });
</script>