<?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--**********************************
            Sidebar end 
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
	.dashboard-card {
		border: none;
		border-radius: 15px;
		padding: 25px;
		color: #fff;
		transition: transform 0.3s ease, box-shadow 0.3s ease;
		box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
	}

	.dashboard-card:hover {
		transform: translateY(-5px);
		box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
	}

	.icon-box {
		font-size: 3rem;
		opacity: 0.8;
	}

	.badge-custom {
		font-size: 0.9rem;
		padding: 5px 10px;
		border-radius: 10px;
	}
</style>

<div class="content-body">
	<!-- row -->
	<div class="container-fluid">
		<div class="d-flex align-items-center mb-4 flex-wrap">
			<h3 class="me-auto">Employees List</h3>
			<div>
				<?php if (session()->get('add') == true): ?>
					<a href="<?= base_url("Fpo/add_employess") ?>" class="btn btn-primary me-3"><i class="fas fa-plus me-2"></i>Create New </a>

				<?php endif; ?>
			</div>
		</div>
		<?php if (session()->getFlashdata('success')): ?>
			<div class="alert alert-success">
				<?= session()->getFlashdata('success') ?>
			</div>
		<?php endif; ?>


		<div class="row">

			<div class="col-xl-6">

				<button onclick="exportToExcel()" id="exportBtn" class="btn btn-success mb-3">Export to Excel</button>

			</div>
			<div class="col-xl-3"></div>
			<div class="col-xl-3">

				<input type="text" id="searchInput" onkeyup="searchTable()" class="form-control mb-3" placeholder="Search table...">

			</div>
			<div class="col-xl-12">
				<div class="table-responsive">
					<table class="table display mb-4 dataTablesCard job-table table-responsive-xl card-table" id="contactTable">
						<thead>
							<tr>
								<th>Name</th>

								<th>employee ID</th>
								<th>connected location</th>

								<th>email</th>


								<th>updated by</th>
								<th>updated at</th>


								<th>Action</th>

							</tr>
						</thead>
						<tbody>

							<?php

							$db = \Config\Database::connect();

							$builder = $db->table('employee');

							$query = $builder->select('*') // or specific columns
								->where('status', 1)
								->where('associated_by', session()->get('user_associated'))
								->where('entity_id', session()->get('entity_id'))
								->orderBy('id', 'DESC')
								->get();

							// $results = $query->getResult(); // returns array of object

							$results = $query->getResultArray(); // each row is an associative array

							foreach ($results as $row):




								$updated_by_data = $db->table('register_log');
								$updated_by_data = $updated_by_data->select('*') // or specific columns
									->where('id', $row['updated_by'])
									->get();

								$updated_person = $updated_by_data->getResultArray();

								$created_by = $db->table('register_log');
								$created_by = $created_by->select('*') // or specific columns
									->where('id', $row['created_by'])
									->get();

								$created_by = $created_by->getResultArray();



								$department = [];

								if (!empty($row['department'])) {
									$departmentQuery = $db->table('department')
										->select('*') // or specify 'role_name' if that's the column
										->where('id', $row['department'])
										->get();

									$department = $departmentQuery->getResultArray();
								}

								// Fallback to dummy value if empty
								$department_name = !empty($department) ? $department[0]['department_name'] : 'Not Assigned';



								$Role = [];

								if (!empty($row['role'])) {
									$RoleQuery = $db->table('roles')
										->select('*') // or specify 'role_name' if that's the column
										->where('id', $row['role'])
										->get();

									$Role = $RoleQuery->getResultArray();
								}

								// Fallback to dummy value if empty
								$Role_name = !empty($Role) ? $Role[0]['role_name'] : 'Not Assigned';



								$skill_names = '';
								$having_skill = '';

								if (!empty($row['skills'])) {
									$decodedSkills = json_decode($row['skills'], true); // Decode to array

									if (is_array($decodedSkills)) {
										// Collect all skill IDs from the array keys
										$skill_ids = array_keys($decodedSkills);

										$allSkillValues = [];
										foreach ($decodedSkills as $skillsGroup) {
											if (is_array($skillsGroup)) {
												$allSkillValues = array_merge($allSkillValues, $skillsGroup);
											}
										}

										$having_skill = implode(', ', $allSkillValues); // For example: "gfgdf, fgfdgfd"

										// Fetch all skill records matching the skill_ids
										$skillQuery = $db->table('skills')
											->select('*')
											->whereIn('id', $skill_ids)
											->get();

										$skillsResult = $skillQuery->getResultArray();

										// Extract skill names (adjust 'name' if your column is different)
										foreach ($skillsResult as $skillRow) {
											$skill_names = $skillRow['category_name'];
										}
									}
								}


								$reporting_authority_name = '';

								if (!empty($row['reporting_authority_id'])) {
									$reporting_authority = $db->table('employee')
										->select('*')
										->where('id', $row['reporting_authority_id'])
										->get()
										->getResultArray();

									if (!empty($reporting_authority)) {
										$auth = $reporting_authority[0]; // First row

										$reporting_authority_name = trim(
											$auth['title'] . " " .
												$auth['first_name'] . " " .
												$auth['middle_name'] . " " .
												$auth['last_name']
										);
									}
								}
								// var_dump($row['reporting_authority_id']);




								$connected_with = json_decode($row['location']);
								$location_details = '';

								foreach ($connected_with as $key => $value) {


									if ($key == "Corporate_Office") {

										$location_details = 'corporate office';
									} else if ($key == "Others") {

										$location_details = $value;
									} else {


										if (is_array($value)) {


											$allowed_tables = ['factory_builidings', 'storage_details', 'packaging_unit'];



											if (in_array($key, $allowed_tables)) {
												$ids = implode(",", $value);

												// $ids = implode(",", array_map('intval', $value)); // Ensure all values are integers
												$get_location_name = $db->table($key);
												$get_location_name->select('name');
												$get_location_name->where("id IN ($ids)");  // Use IN with the comma-separated string

												$get_location_name = $get_location_name->get();

												foreach ($get_location_name->getResult() as $row2) {
													$location_details .= $row2->name . ',';
												}

												$location_details = rtrim($location_details, ','); // Remove trailing comma
											}
										}
									}
								}



							?>
								<tr
									data-name="<?= $row['title'] . "  ." . $row['first_name'] . "  " . $row['middle_name'] . "  " . $row['last_name'] ?>"
									data-employee-ID="<?= $row['employee_id'] ?>"
									data-location-selected="<?= $location_details ?>"
									data-appointment-date="<?= $row['appointment_date'] ?>"
									data-qualification="<?= $row['qualification'] ?>"
									data-experience-years="<?= $row['experience_years'] ?>"
									data-experience-months="<?= $row['experience_months'] ?>"
									data-department="<?= $department_name ?>"
									data-designation="<?= $row['designation'] ?>"
									data-Role="<?= $Role_name ?>"
									data-skill-name="<?= $skill_names ?>"
									data-skill_have="<?= $having_skill ?>"
									data-trainings="<?= $row['trainings'] ?>"
									data-responsibilities="<?= $row['responsibilities'] ?>"
									data-reporting-authority="<?= $reporting_authority_name ?>"
									data-email="<?= $row['email'] ?>"


									data-remark="<?= $row['remark'] ?>"
									<?php
									$photos = json_decode($row['photo'], true);
									$photoData = (is_array($photos) && !empty($photos)) ? implode(",", $photos) : '';
									?>
									data-photos='<?= esc($photoData) ?>'
									data-process-flow-files='<?= $row['documents'] ?>'


									data-created-by='<?= $created_by[0]['name_of_the_user'] ?>'
									data-created-at='<?= $row['created_at']  ?>'
									data-updated-by='<?= $updated_person[0]['name_of_the_user'] ?>'
									data-updated-at='<?= $row['updated_at']  ?>'>

									<td><?= $row['title'] . "  ." . $row['first_name'] . "  " . $row['middle_name'] . "  " . $row['last_name'] ?></td>
									<td><?= $row['employee_id']  ?></td>
									<td><?= $location_details  ?></td>


									<td><?= $row['email']  ?></td>




									<td><?= $updated_person[0]['name_of_the_user'] ?></td>
								<td><?= date('d/m/Y H:i', strtotime($row['updated_at']))  ?></td>


									<td>
										<div class="action-buttons d-flex justify-content-end">


											<a href="<?= base_url() ?>Fpo/view_employee/<?= $row['id'] ?>" target="_blank" class="btn btn-success light mr-2">
											<span class="material-icons">visibility</span>
											</a>





											<?php if (session()->get('edit') == true): ?>
												<a href="<?= base_url() ?>Fpo/edit_employee/<?= $row['id'] ?>" class="btn btn-secondary light mr-2">
													<span class="material-icons">edit</span>
												</a>
											<?php endif; ?>

											<?php if (session()->get('delete') == true): ?>
												<a href="<?= base_url() ?>Fpo/delete_employee/<?= $row['id'] ?>" class="btn btn-danger light">
													<span class="material-icons">delete</span>
												</a>

											<?php endif; ?>

										</div>
									</td>

								</tr>
							<?php endforeach; ?>








						</tbody>
					</table>
					<nav>
						<ul class="pagination justify-content-center" id="pagination"></ul>
					</nav>
				</div>
			</div>
		</div>
	</div>
</div>






<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<!-- Excel Export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>


<script>

</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
	href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>



<script>

</script>