 <?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">edit Implementation Compliance</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                         <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



         <form action="<?= base_url('Fpo/update_Implementation_compliance') ?>" id="form_upload" method="post" enctype="multipart/form-data">
  <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
  <input type="hidden" name="updating_id" value="<?= $ImplementationCompliance['id'] ?>">

  <?php
    $payload = json_decode($ImplementationCompliance['section_data'] ?? '[]', true) ?: [];
    $main    = $payload['main_clause'] ?? [];
    $subs    = $payload['subclauses'] ?? [];
  ?>

  <!-- MAIN CLAUSE -->
  <div class="border rounded p-3 mb-4 main-clause">
    <h5 class="mb-3">Main Clause</h5>
    <div class="row g-3">
      <div class="col-12">
        <label class="form-label">Standard Clause No. <span class="text-danger">*</span></label>
        <input type="text" class="form-control" name="main_clause[clause_no]" value="<?= esc($main['clause_no'] ?? '') ?>" placeholder="e.g., 5" required>
      </div>

      <div class="col-12">
        <label class="form-label">Standard Requirement</label>
        <textarea class="form-control" name="main_clause[requirement]" placeholder=""><?= esc($main['requirement'] ?? '') ?></textarea>
      </div>

      <div class="col-12">
        <label class="form-label">Implementation</label>
        <textarea class="form-control" name="main_clause[implementation]" placeholder=""><?= esc($main['implementation'] ?? '') ?></textarea>
      </div>

      <div class="col-md-6">
        <label class="form-label">Link / Upload</label>
        <select class="form-control upload_type_selector" name="main_clause[input_type]">
          <option value="">-- Select (optional) --</option>
          <option value="link" <?= (isset($main['input_type']) && $main['input_type']==='link') ? 'selected' : '' ?>>Link</option>
          <option value="file" <?= (isset($main['input_type']) && $main['input_type']==='file') ? 'selected' : '' ?>>Upload</option>
        </select>
      </div>

      <!-- If Link -->
      <div class="col-md-6 link_section" style="display: <?= (!empty($main['input_type']) && $main['input_type']==='link') ? 'block' : 'none' ?>;">
        <label class="form-label">If Link (URL)</label>
        <input type="url" class="form-control link_input" name="main_clause[link]" value="<?= esc($main['link'] ?? '') ?>" placeholder="https://example.com">
        <?php if (!empty($main['link'])): ?>
          <a href="<?= esc($main['link']) ?>" target="_blank" class="btn btn-outline-primary btn-sm mt-2">View Link</a>
        <?php endif; ?>
      </div>

      <!-- If File -->
      <div class="col-md-6 file_upload_section" style="display: <?= (!empty($main['input_type']) && $main['input_type']==='file') ? 'block' : 'none' ?>;">
        <label class="form-label">If Upload (replace file)</label>
        <input type="file" class="form-control file_path" name="main_clause[file]">
        <input type="hidden" name="main_clause[existing_file]" value="<?= esc($main['file_path'] ?? '') ?>">
        <?php if (!empty($main['file_path'])): ?>
          <a href="<?= base_url($main['file_path']) ?>" target="_blank" class="btn btn-outline-primary btn-sm mt-2">View Existing File</a>
        <?php endif; ?>
      </div>

      <div class="col-12">
        <label class="form-label">Remark</label>
        <textarea class="form-control" name="main_clause[remark]" placeholder=""><?= esc($main['remark'] ?? '') ?></textarea>
      </div>
    </div>
  </div>

  <!-- SUB-CLAUSES -->
  <div class="subclauses">
    <?php if (!empty($subs)): foreach ($subs as $i => $sc): ?>
      <div class="subclause border rounded p-3 mb-3 bg-light">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Sub-Clause <?= $i + 1 ?></h6>
          <button type="button" class="btn btn-sm btn-outline-danger remove_subclause">Remove</button>
        </div>

        <div class="row g-3">
          <div class="col-12">
            <label class="form-label">Standard Clause No. <span class="text-danger">*</span></label>
            <input type="text" class="form-control" name="subclauses[<?= $i ?>][clause_no]" value="<?= esc($sc['clause_no'] ?? '') ?>" required>
          </div>

          <div class="col-12">
            <label class="form-label">Standard Requirement</label>
            <textarea class="form-control" name="subclauses[<?= $i ?>][requirement]"><?= esc($sc['requirement'] ?? '') ?></textarea>
          </div>

          <div class="col-12">
            <label class="form-label">Implementation</label>
            <textarea class="form-control" name="subclauses[<?= $i ?>][implementation]"><?= esc($sc['implementation'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="form-label">Link / Upload</label>
            <select class="form-control upload_type_selector" name="subclauses[<?= $i ?>][input_type]">
              <option value="">-- Select (optional) --</option>
              <option value="link" <?= (isset($sc['input_type']) && $sc['input_type']==='link') ? 'selected' : '' ?>>Link</option>
              <option value="file" <?= (isset($sc['input_type']) && $sc['input_type']==='file') ? 'selected' : '' ?>>Upload</option>
            </select>
          </div>

          <!-- If Link -->
          <div class="col-md-6 link_section" style="display: <?= (!empty($sc['input_type']) && $sc['input_type']==='link') ? 'block' : 'none' ?>;">
            <label class="form-label">If Link (URL)</label>
            <input type="url" class="form-control link_input" name="subclauses[<?= $i ?>][link]" value="<?= esc($sc['link'] ?? '') ?>">
            <?php if (!empty($sc['link'])): ?>
              <a href="<?= esc($sc['link']) ?>" target="_blank" class="btn btn-outline-primary btn-sm mt-2">View Link</a>
            <?php endif; ?>
          </div>

          <!-- If File -->
          <div class="col-md-6 file_upload_section" style="display: <?= (!empty($sc['input_type']) && $sc['input_type']==='file') ? 'block' : 'none' ?>;">
            <label class="form-label">If Upload (replace file)</label>
            <input type="file" class="form-control file_path" name="subclauses[<?= $i ?>][file]">
            <input type="hidden" name="subclauses[<?= $i ?>][existing_file]" value="<?= esc($sc['file_path'] ?? '') ?>">
            <?php if (!empty($sc['file_path'])): ?>
              <a href="<?= base_url($sc['file_path']) ?>" target="_blank" class="btn btn-outline-primary btn-sm mt-2">View Existing File</a>
            <?php endif; ?>
          </div>

          <div class="col-12">
            <label class="form-label">Remark</label>
            <textarea class="form-control" name="subclauses[<?= $i ?>][remark]"><?= esc($sc['remark'] ?? '') ?></textarea>
          </div>
        </div>
      </div>
    <?php endforeach; endif; ?>
  </div>

  <button type="button" class="btn btn-warning mb-3 add_subclause">Add Sub-Clause</button>

  <div class="card-footer text-end">
    <button type="submit" class="btn btn-primary">Update</button>
  </div>
</form>
                </div>
            </div>
        </div>
    </div>
</div>



 








<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<script>
(function(){
  let subIndex = document.querySelectorAll('.subclause').length;

  function subClauseHTML(i){
    return `
      <div class="subclause border rounded p-3 mb-3 bg-light">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Sub-Clause ${i + 1}</h6>
          <button type="button" class="btn btn-sm btn-outline-danger remove_subclause">Remove</button>
        </div>

        <div class="row g-3">
          <div class="col-12">
            <label class="form-label">Standard Clause No. <span class="text-danger">*</span></label>
            <input type="text" class="form-control" name="subclauses[${i}][clause_no]" required>
          </div>

          <div class="col-12">
            <label class="form-label">Standard Requirement</label>
            <textarea class="form-control" name="subclauses[${i}][requirement]"></textarea>
          </div>

          <div class="col-12">
            <label class="form-label">Implementation</label>
            <textarea class="form-control" name="subclauses[${i}][implementation]"></textarea>
          </div>

          <div class="col-md-6">
            <label class="form-label">Link / Upload</label>
            <select class="form-control upload_type_selector" name="subclauses[${i}][input_type]">
              <option value="">-- Select (optional) --</option>
              <option value="link">Link</option>
              <option value="file">Upload</option>
            </select>
          </div>

          <div class="col-md-6 link_section" style="display:none;">
            <label class="form-label">If Link (URL)</label>
            <input type="url" class="form-control link_input" name="subclauses[${i}][link]">
          </div>

          <div class="col-md-6 file_upload_section" style="display:none;">
            <label class="form-label">If Upload (replace file)</label>
            <input type="file" class="form-control file_path" name="subclauses[${i}][file]">
            <input type="hidden" name="subclauses[${i}][existing_file]" value="">
          </div>

          <div class="col-12">
            <label class="form-label">Remark</label>
            <textarea class="form-control" name="subclauses[${i}][remark]"></textarea>
          </div>
        </div>
      </div>
    `;
  }

  // Add new sub-clause
  document.querySelector('.add_subclause').addEventListener('click', function(){
    document.querySelector('.subclauses').insertAdjacentHTML('beforeend', subClauseHTML(subIndex));
    subIndex++;
  });

  // Remove + renumber
  document.addEventListener('click', function(e){
    if(e.target.closest('.remove_subclause')){
      e.target.closest('.subclause').remove();
      renumber();
    }
  });

  function renumber(){
    const blocks = document.querySelectorAll('.subclause');
    blocks.forEach((b, idx)=>{
      b.querySelector('h6').textContent = 'Sub-Clause ' + (idx + 1);
      // update name indices to keep them sequential
      b.querySelectorAll('input, textarea, select').forEach((el)=>{
        el.name = el.name.replace(/subclauses\[\d+\]/, 'subclauses['+idx+']');
      });
    });
    subIndex = blocks.length;
  }

  // Toggle: works for main & sub clauses
  document.addEventListener('change', function(e){
    if(e.target.classList.contains('upload_type_selector')){
      const wrap = e.target.closest('.main-clause, .subclause');
      const val = e.target.value;
      wrap.querySelectorAll('.file_upload_section, .link_section').forEach(s => s.style.display = 'none');
      if(val === 'file'){
        const el = wrap.querySelector('.file_upload_section'); if(el) el.style.display = 'block';
      } else if(val === 'link'){
        const el = wrap.querySelector('.link_section'); if(el) el.style.display = 'block';
      }
    }
  });

  // Minimal client validation: only Clause No. must exist
  document.getElementById('form_upload').addEventListener('submit', function(e){
    let ok = true;
    document.querySelectorAll('.is-invalid').forEach(el=>el.classList.remove('is-invalid'));

    // main clause
    const mc = document.querySelector("input[name='main_clause[clause_no]']");
    if(!mc.value.trim()){ mc.classList.add('is-invalid'); ok = false; }

    // sub-clauses
    document.querySelectorAll(".subclause input[name$='[clause_no]']").forEach(inp=>{
      if(!inp.value.trim()){ inp.classList.add('is-invalid'); ok = false; }
    });

    if(!ok){
      e.preventDefault();
      const first = document.querySelector('.is-invalid');
      if(first){ window.scrollTo({ top: first.getBoundingClientRect().top + window.scrollY - 120, behavior:'smooth' }); }
    }
  });
})();
</script>

<style>
  .bg-light {
    --bs-bg-opacity: 1;
    background-color: rgb(255 255 255) !important;}
</style>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>







<script>
    $(document).ready(function() {
        $('#designation').selectize(); // Only after the DOM is fully ready
    });
</script>