<?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">edit  farm inspection</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("Fpo/UPDATE_farm_inspection") ?>" id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">

                                <input type="hidden" name="updating_id" value="<?= $farm_inspection['id'] ?>">
                                <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">


                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Record Date <span class="text-danger ms-2">*</span></label>
                                    <input type="date" class="form-control " value="<?= $farm_inspection['Record_Date'] ?>" name="Record_Date" id="" required>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Year <span class="text-danger ms-2">*</span></label>
                                    <select class="form-control year_select" name="year" required>
                                        <option value="" disabled>Select Year</option>
                                        <?php
                                        $currentYear = date('Y');
                                        for ($year = 1900; $year <= $currentYear; $year++):
                                        ?>
                                            <option value="<?= $year ?>" <?= (isset($farm_inspection['year']) && $farm_inspection['year'] == $year) ? 'selected' : '' ?>>
                                                <?= $year ?>
                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Season <span class="text-danger ms-2">*</span></label>
                                    <select class="form-control" name="Season" required>
                                        <option value="" disabled <?= !isset($farm_inspection['season']) ? 'selected' : '' ?>>Select Season</option>
                                        <option value="Kharif" <?= (isset($farm_inspection['season']) && $farm_inspection['season'] == 'Kharif') ? 'selected' : '' ?>>Kharif</option>
                                        <option value="Rabi" <?= (isset($farm_inspection['season']) && $farm_inspection['season'] == 'Rabi') ? 'selected' : '' ?>>Rabi</option>
                                        <option value="Zaid" <?= (isset($farm_inspection['season']) && $farm_inspection['season'] == 'Zaid') ? 'selected' : '' ?>>Zaid</option>
                                    </select>
                                </div>



                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">select farmer <span class="text-danger scale5 ms-2">*</span></label>
                                    <?php
                                    $db = \Config\Database::connect();
                                    $farmer = $db->table('farmers')
                                        ->select('id, first_name,farmer_id')
                                        ->where('status', 1)
                                        ->where('associated_by', session()->get('user_associated'))
                                        ->where('entity_id', session()->get('entity_id'))
                                        ->get()
                                        ->getResult();
                                    ?>
                                    <select class="form-control farmer" name="farmer" required>
                                        <option disabled>Select farmer</option>
                                        <?php if (! empty($farmer)): ?>
                                            <?php foreach ($farmer as $f): ?>
                                                <option
                                                    value="<?= esc($f->id) ?>"
                                                    <?= ($f->id == $farm_inspection['farmer_id']) ? 'selected' : '' ?>>
                                                    <?= esc($f->first_name) ?>-<?= esc($f->farmer_id) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4 show_farm">
                                    <label class="form-label">Farm <span class="text-danger">*</span></label>
                                    <select class="form-control farm_land" name="Farm">

                                        <?php
                                        $db      = \Config\Database::connect();
                                        $builder = $db->table('farmer_land_details');

                                        $builder->select('id, farm_iD AS farm')  // aliasing
                                            ->where('status', 1)
                                            ->where('associated_by', session()->get('user_associated'))
                                            ->where('entity_id', session()->get('entity_id'))
                                            ->where('farmer_id', $farm_inspection['farmer_id']);

                                        $rows = $builder->get()->getResultArray();
                                        ?>

                                        <option value="">Select Farm</option>
                                        <?php foreach ($rows as $row): ?>
                                            <option value="<?= esc($row['id']) ?>" <?= $farm_inspection['farm_id'] == $row['id'] ? 'selected' : '' ?>>
                                                <?= esc($row['farm']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>






                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Crop variety <span class="text-danger">*</span></label>
                                    <?php
                                    $db = \Config\Database::connect();
                                    $crop = $db->table('crop_master')
                                        ->select('id,crop_variety')
                                        ->where('status', 1)
                                        ->where('associated_by', session()->get('user_associated'))
                                        ->where('entity_id', session()->get('entity_id'))
                                        ->get()
                                        ->getResult();
                                    ?>
                                    <select class="form-control  crops" name="crop" required>
                                        <option disabled>Select Crop variety </option>
                                        <?php if (!empty($crop)): ?>
                                            <?php foreach ($crop as $crop): ?>
                                                <option <?= $farm_inspection['crop_id'] == $crop->id ? 'selected' : '' ?> value="<?= esc($crop->id) ?>"><?= esc($crop->crop_variety) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4 show_crops">
                                    <label class="form-label">crop<span class="text-danger">*</span></label>

                                    <select class="form-control crop_selection" name="crop_name[]" multiple>


                                        <?php if (!empty($farm_inspection['crop_name'])): ?>
                                            <?php foreach (explode(",", $farm_inspection['crop_name']) as $oldSkillId): ?>
                                                <option value="<?= esc($oldSkillId) ?>" selected>
                                                    <?= esc($oldSkillId) ?> <!-- Replace this with the actual skill name from the database -->
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>





                               


  <!-- Inspection Date -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Inspection Date <span class="text-danger ms-2">*</span></label>
                                    <input type="date" class="form-control" name="inspection_date" value="<?= $farm_inspection['Inspection_Date'] ?>" required>
                                </div>

                                <!-- Inspector Name -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Inspector Name</label>
                                    <input type="text" class="form-control" name="inspector_name"  value="<?= $farm_inspection['Inspector_Name'] ?>"    placeholder="Enter name">
                                </div>

                                <!-- Non-Conformities Reported -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Non-Conformities Reported <span class="text-danger ms-2">*</span></label>
                                    <textarea class="form-control" name="non_conformities_reported"  rows="2" required><?= $farm_inspection['Non-Conformities_Reported'] ?></textarea>
                                </div>

                                <!-- Corrective Actions Taken -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Corrective Actions Taken <span class="text-danger ms-2">*</span></label>
                                    <textarea class="form-control" name="corrective_actions_taken"  rows="2" required><?= $farm_inspection['Corrective_Actions_Taken'] ?></textarea>
                                </div>

                                <!-- Corrective Action Approved and Closed -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Corrective Action Approved and Closed <span class="text-danger ms-2">*</span></label>
                                    <textarea class="form-control" name="corrective_action_approved"  rows="2" required><?= $farm_inspection['Corrective_Action_Approved_and_Closed'] ?></textarea>
                                </div>


                                <!-- Audit Remarks -->
                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Audit Remarks <span class="text-danger ms-2">*</span></label>
                                    <textarea class="form-control" name="Remark"  rows="2" required><?= $farm_inspection['remark'] ?></textarea>
                                </div>
 









 <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label">documents<span class="text-danger scale5 ms-2"></span></label>
                                    <div id="documentContainer">

                                        <?php

                                        $documants = json_decode($farm_inspection['documents'], true);


                                        ?>


                                        <?php if (!empty($documants) && is_array($documants)): ?>
                                            <?php foreach ($documants as $index => $doc): ?>
                                                <div class="document-row row">
                                                    <div class="col-xl-3 mb-3">
                                                        <label class="form-label">Document Name <span class="text-danger ms-2"></span></label>
                                                        <input type="text" name="doc_name[]" class="form-control" value="<?= esc($doc['name']) ?>" >
                                                    </div>
                                                    <div class="col-xl-3 mb-3">
                                                        <label class="form-label">Document Date</label>
                                                        <input type="date" name="doc_date[]" class="form-control" value="<?= esc($doc['date']) ?>" >
                                                    </div>
                                                    <div class="col-xl-3 mb-3">
                                                        <div class="d-flex align-items-center mb-2">
                                                            <label class="me-2 mb-0">Old File:</label>
                                                            <a href="<?= base_url($doc['file']) ?>" target="_blank" class="btn btn-link p-0">View</a>
                                                        </div>
                                                        <label class="form-label">Replace File</label>
                                                        <input type="file" name="doc_file[]" class="form-control">
                                                        <input type="hidden" name="existing_file[]" value="<?= esc($doc['file']) ?>">
                                                    </div>
                                                    <div class="col-xl-3 d-flex align-items-end">
                                                        <button type="button" class="btn btn-danger remove-btn">
                                                            <i class="fas fa-trash-alt me-1"></i> Remove
                                                        </button>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMore" class="btn btn-primary mt-3">Add More</button>

                                    </div>
                                </div>












 




















                            </div>

                    </div>
                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<script>
    $(document).ready(function() {
        $("#addMore").click(function() {
            let newRow = `
                <div class="document-row row">
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Name<span class="text-danger ms-2"></span></label>
                        <input type="text" class="form-control" name="doc_name[]"   accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv" 
 placeholder="Enter Document Name" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Date<span class="text-danger ms-2"></span></label>
                        <input type="date" class="form-control" name="doc_date[]" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                       <label class="form-label">Upload document<span class="text-danger ms-2"></span></label>
                        <input type="file" class="form-control" name="doc_file[]"     accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv">
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#documentContainer").append(newRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".document-row").remove();
        });

        $("#documentForm").submit(function(e) {
            e.preventDefault();
            alert("Form Submitted with " + $("input[name='doc_name[]']").length + " documents!");
        });
    });
</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>





<script>
    $(".Leasehold_details").change(function() {
        $(".leasehold_view").hide();
        $('[name="number_of_years_leasehold"]').removeAttr('required');

        if ($(this).val() == "Leasehold") {
            $(".leasehold_view").show();
            $('[name="number_of_years_leasehold"]').attr('required', true);
        }
    });

    $(document).ready(function() {
        $('.farmer').selectize({

        });
    });


    const $selectFarm = $('.farm_land').selectize({
        maxItems: 1,
        valueField: 'id',
        labelField: 'farm',
        searchField: 'farm',
        options: [], // start empty
        create: false
    });
    const farmSelectize = $selectFarm[0].selectize;

    // 2) On farmer change, fetch farm details
    $('.farmer').on('change', function() {
        $('.show_farm').hide(); // hide until we repopulate
        let csrfName = $('#csrf_token').attr('name');
        let csrfHash = $('#csrf_token').val();
        let farmerId = $(this).val();

        $.ajax({
            type: 'POST',
            url: "<?= base_url('get_farm_details_by_farmer') ?>",
            data: {
                data: farmerId,
                [csrfName]: csrfHash
            },
            dataType: 'json',
            success(response) {
                if (response.data && Array.isArray(response.data)) {
                    farmSelectize.clearOptions();
                    farmSelectize.addOption(response.data);
                    farmSelectize.refreshOptions(false);
                    $('.show_farm').show();
                } else {
                    console.warn('No farm data found');
                    $('.show_farm').hide();
                }
                // update CSRF
                if (response.csrfToken) {
                    $('#csrf_token').val(response.csrfToken);
                }
            },
            error() {
                console.error('AJAX request failed.');
            }
        });
    });










    $(document).ready(function() {
        $('.crops').selectize({

        });


    });


    const $crop_selection = $('.crop_selection').selectize({
        maxItems: null,
        valueField: 'id',
        labelField: 'crop_name',
        searchField: 'crop_name',
        options: [],
        create: false,
        plugins: ['remove_button'],
        onItemRemove: function(value) {
            const selectedItems = this.items;

            if (selectedItems.length < 1) {
                // Prevent removing last item
                this.addItem(value); // Re-add the removed item
                alert('At least one crop must be selected.');
            }
        } // 👈 enables the 'x' button to remove items
    });
    const crop_selection = $crop_selection[0].selectize;

    $('.crops').on('change', function() {
        $('.show_crops').hide();
        let csrfName = $('#csrf_token').attr('name');
        let csrfHash = $('#csrf_token').val();
        let cropId = $(this).val();

        $.ajax({
            type: 'POST',
            url: "<?= base_url('get_crop_veraity_details') ?>",
            data: {
                data: cropId,
                [csrfName]: csrfHash
            },
            dataType: 'json',
            success(response) {

                crop_selection.clear(true); // Clear selected items and options
                crop_selection.clearOptions();

                if (response.data && Array.isArray(response.data)) {
                    crop_selection.addOption(response.data);
                    crop_selection.refreshOptions(false);
                    $('.show_crops').show();
                } else {
                    console.warn('No crop data found');
                    $('.show_crops').hide();
                }

                if (response.csrfToken) {
                    $('#csrf_token').val(response.csrfToken);
                }
            },
            error() {
                console.error('AJAX request failed.');
            }
        });
    });
</script>