<?= view('farmers/layout/header') ?>
<?= view('farmers/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">New crop </h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("farmer_login/insert_crop_form_assinge") ?>" id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">


                                <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Year </label>
                                    <select class="form-control year_select" name="year">
                                        <option value="" selected disabled>Select Year</option>
                                        <?php
                                        $currentYear = date('Y');
                                        for ($year = 1900; $year <= $currentYear; $year++):
                                        ?>
                                            <option value="<?= $year ?>" <?= $year == $currentYear ? 'selected' : '' ?>><?= $year ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>




                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Season </label>
                                    <select class="form-control" name="Season"="">
                                        <option value="" selected disabled>Select Season</option>
                                        <option value="Kharif">Kharif</option>
                                        <option value="Rabi">Rabi</option>
                                        <option value="Zaid">Zaid</option>
                                    </select>
                                </div>

                                <input type="hidden" id="farmer_id" name="farmer" value="<?php echo session()->get('entity_id') ?>">


                                <div class="col-xl-3 col-md-3 mb-4 show_farm" style="<?= old('name_of_the_evaluator') ? 'display: block;' : 'display: none;' ?>">
                                    <label class="form-label">Farm <span class="text-danger">*</span></label>
                                    <select class="form-control farm_land" name="Farm" required>
                                        <?php if (old('Farm')): ?>
                                            <option value="<?= old('Farm') ?>" selected><?= old('Farm') ?></option>
                                        <?php else: ?>
                                            <option selected disabled value="">Select Farm</option>
                                        <?php endif; ?>
                                    </select>
                                </div>





                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Crop variety <span class="text-danger">*</span></label>
                                    <?php
                                    $db = \Config\Database::connect();
                                    $crop = $db->table('crop_master')
                                        ->select('id,crop_variety')
                                        ->where('status', 1)
                                        ->where('associated_by', session()->get('user_associated'))
                                        ->where('entity_id', session()->get('entity_id'))
                                        ->get()
                                        ->getResult();
                                    ?>
                                    <select class="form-control  crops" name="crop" required>
                                        <option selected disabled>Select Crop variety </option>
                                        <?php if (!empty($crop)): ?>
                                            <?php foreach ($crop as $crop): ?>
                                                <option value="<?= esc($crop->id) ?>"><?= esc($crop->crop_variety) ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>




                                <div class="col-xl-3 col-md-3 mb-4 show_crops" style="<?= old('crop_name') ? 'display: block;' : 'display: none;' ?>">
                                    <label class="form-label">crop<span class="text-danger">*</span></label>

                                    <select class="form-control crop_selection" name="crop_name[]" multiple required>


                                        <?php if (!empty(old('crop_name'))): ?>
                                            <?php foreach (old('crop_name') as $oldSkillId): ?>
                                                <option value="<?= esc($oldSkillId) ?>" selected>
                                                    <?= esc($oldSkillId) ?> <!-- Replace this with the actual skill name from the database -->
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>





                                <!-- Farm Mandal -->
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Produce Specifications <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="Produce_Specifications"
                                        placeholder="Produce Specifications "
                                        >
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Crop Quantity Measure</label>
                                    <select class="form-control"="" name="Crop_Quantity_Measure">
                                        <option value="" selected disabled>Select Crop Quantity Measure</option>
                                        <option value="Kilograms">Kilograms</option>
                                        <option value="Qunital">Qunital</option>
                                        <option value="Tonnes">Tonnes</option>
                                        <option value="Pounds">Pounds</option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Production Estimate (Qty) <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="number"
                                        class="form-control"
                                        name="Production_Estimate"
                                        placeholder="Production Estimate (Qty)">
                                </div>


                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Crop Date <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="date"
                                        class="form-control"
                                        name="Crop_Date"
                                        placeholder="Crop Date">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Harvest Date <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="date"
                                        class="form-control"
                                        name="Harvested_Date"
                                        placeholder="Harvested Date  ">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Harvest Qty <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="number"
                                        class="form-control"
                                        name=""
                                        placeholder="Harvest Qty">
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Inventory Date <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="date"
                                        class="form-control"
                                        name=""
                                        placeholder="Inventory Date  ">
                                </div>
                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Inventory Qty <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="number"
                                        class="form-control"
                                        name=""
                                        placeholder="Inventory Qty">
                                </div>





                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Crop Sales Qty <span class="text-danger scale5 ms-2">*</span></label>
                                    <input
                                        type="number"
                                        class="form-control"
                                        name="Crop_Sales_Qty"
                                        placeholder="Crop Sales Qty">
                                </div>











                                <div class="col-xl-3 col-md-3 mb-4" bis_skin_checked="1">
                                    <label class="form-label">Crop Certification Standard </label>
                                    <input type="text" class="form-control" name="Crop_Certification_Standard" placeholder="Enter Certification Standard"="">
                                </div>









                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Remarks<span class="text-danger scale5 ms-2">*</span></label>

                                    <textarea id="" class="form-control" placeholder="Remarks" name="Remark" aria-label="manufacturing-activities"></textarea>
                                    <!-- <input type="text" class="form-control" placeholder="Manufacturing activities" aria-label="manufacturing-activities" > -->
                                </div>














                            </div>

                    </div>
                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" form="form_upload" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('farmers/layout/footer') ?>


<script>
    $(document).ready(function() {
        $("#addMore").click(function() {
            let newRow = `
                <div class="document-row row">
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Name</label>
                        <input type="text" class="form-control" name="doc_name[]"   
 placeholder="Enter Document Name" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Date</label>
                        <input type="date" class="form-control" name="doc_date[]" >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                       <label class="form-label">Upload document</label>
                        <input type="file" class="form-control" name="doc_file[]"     accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv">
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#documentContainer").append(newRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".document-row").remove();
        });

        $("#documentForm").submit(function(e) {
            e.preventDefault();
            alert("Form Submitted with " + $("input[name='doc_name[]']").length + " documents!");
        });
    });
</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery () -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>





<script>

</script>


<script>
    $(".Leasehold_details").change(function() {
        $(".leasehold_view").hide();
        $('[name="number_of_years_leasehold"]').removeAttr('required');

        if ($(this).val() == "Leasehold") {
            $(".leasehold_view").show();
            $('[name="number_of_years_leasehold"]').attr('required', true);
        }
    });

    $(document).ready(function() {
        $('.farmer').selectize({

        });
    });


    const $selectFarm = $('.farm_land').selectize({
        maxItems: 1,
        valueField: 'id',
        labelField: 'farm',
        searchField: 'farm',
        options: [], // start empty
        create: false
    });
    const farmSelectize = $selectFarm[0].selectize;

    load_farmer_land_far_farmer();

    function load_farmer_land_far_farmer() {

        $('.show_farm').hide(); // hide until we repopulate
        let csrfName = $('#csrf_token').attr('name');
        let csrfHash = $('#csrf_token').val();
        let farmerId = $("#farmer_id").val();

        $.ajax({
            type: 'POST',
            url: "<?= base_url('get_farm_details_by_farmer') ?>",
            data: {
                data: farmerId,
                [csrfName]: csrfHash
            },
            dataType: 'json',
            success(response) {
                if (response.data && Array.isArray(response.data)) {
                    farmSelectize.clearOptions();
                    farmSelectize.addOption(response.data);
                    farmSelectize.refreshOptions(false);
                    $('.show_farm').show();
                } else {
                    console.warn('No farm data found');
                    $('.show_farm').hide();
                }
                // update CSRF
                if (response.csrfToken) {
                    $('#csrf_token').val(response.csrfToken);
                }
            },
            error() {
                console.error('AJAX request failed.');
            }
        });
    }





    $(document).ready(function() {
        $('.crops').selectize({

        });


    });


    const $crop_selection = $('.crop_selection').selectize({
        maxItems: null,
        valueField: 'id',
        labelField: 'crop_name',
        searchField: 'crop_name',
        options: [],
        create: false,
        plugins: ['remove_button'],
        onItemRemove: function(value) {
            const selectedItems = this.items;

            if (selectedItems.length < 1) {
                // Prevent removing last item
                this.addItem(value); // Re-add the removed item
                alert('At least one crop must be selected.');
            }
        } // 👈 enables the 'x' button to remove items
    });
    const crop_selection = $crop_selection[0].selectize;

    $('.crops').on('change', function() {
        $('.show_crops').hide();
        let csrfName = $('#csrf_token').attr('name');
        let csrfHash = $('#csrf_token').val();
        let cropId = $(this).val();

        $.ajax({
            type: 'POST',
            url: "<?= base_url('get_crop_veraity_details') ?>",
            data: {
                data: cropId,
                [csrfName]: csrfHash
            },
            dataType: 'json',
            success(response) {

                crop_selection.clear(true); // Clear selected items and options
                crop_selection.clearOptions();

                if (response.data && Array.isArray(response.data)) {
                    crop_selection.addOption(response.data);
                    crop_selection.refreshOptions(false);
                    $('.show_crops').show();
                } else {
                    console.warn('No crop data found');
                    $('.show_crops').hide();
                }

                if (response.csrfToken) {
                    $('#csrf_token').val(response.csrfToken);
                }
            },
            error() {
                console.error('AJAX request failed.');
            }
        });
    });
</script>