<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>TraceAudit - Your Digital Pathway to Compliance and Market Trust.</title>

  <link rel="shortcut icon" type="image/png" href="<?= base_url(); ?>assets/images/favicon.png" />

  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link class="main-css" href="<?= base_url(); ?>assets/css/style.css?<?= mt_rand(); ?>" rel="stylesheet">
  <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">
  <!-- <script src="https://www.google.com/recaptcha/api.js" async defer></script> -->


  <style>
.custom-select-wrapper {
  position: relative;  
  display: inline-block;
  width: 100%;
}

.custom-select-wrapper::after {
  content: '';
  position: absolute;
  top: 50%;
  right: 12px;
  width: 0;
  height: 0;
  pointer-events: none;
  border-left: 6px solid transparent;
  border-right: 6px solid transparent;
  border-top: 6px solid #333;
  transform: translateY(-50%);
}

.custom-select-wrapper select {
  appearance: none;
  -webkit-appearance: none;
  -moz-appearance: none;
  padding-right: 30px; /* Make room for the arrow */
}
</style>
</head>

<body>

  <div class="container-fluid full-height">
    <div class="row h-100">

      <!-- Left Side Image -->
      <div class="col-md-6 d-none d-md-block bg-left"></div>

      <!-- Right Side Login -->
      <div class="col-md-6 d-flex align-items-center justify-content-center">
        <div class=" p-4 w-100" style="max-width: 520px;">
          <div class="text-center mb-4 logo-img">
            <img src="<?= base_url(); ?>assets/logo/krishi-gap-logo.png" alt="" style="max-width: 120px;" />
            <br>
           
            <small><b class="text-primary " style="font-size:1.5rem">TraceAudit </b></small><br>
            <small class="">Your Digital Pathway to Compliance and Market Trust.</small>
          </div>
          <h4 class="text-left mb-2">Sign In</h4>
          <p>Access the <span class="text-secondary">TraceAudit</span> panel using your email and passcode.</p>

          <?php if (session()->getTempdata('validation_errors')): ?>
            <div class="alert alert-danger"><?= session('validation_errors'); ?></div>
            <?php session()->removeTempdata('validation_errors'); ?>
          <?php endif; ?>

          <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
          <?php endif; ?>

          <form action="<?= base_url(); ?>validate_login" method="post" id="loginForm" enctype="multipart/form-data">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>" />

            <label for="emailInput">User Type*</label>
            <div class=" position-relative mb-3 custom-select-wrapper">
            <select id="type" name="type" class="form-control required">
             <option value="0">Please Select</option>
             <option value="organisation">Organization</option>
             <option value="fpo">Farmer organization</option>
             <option value="audit_company">Audit company</option>
             <option value="farmers">Farmer</option>   
             <option value="app_user">TA User</option>       
            </select>
            </div>


             <label for="emailInput">Email*</label>
            <div class=" position-relative mb-3">
                
              
              <input type="email" class="form-control" name="Email_id" id="emailInput" placeholder="" required />
              
            </div>

             <label for="passwordInput">Password*</label>
            <div class="form position-relative mb-3">
                
             
              <input type="password" class="form-control" name="password" id="passwordInput" placeholder="" required />
              
            </div>

            <div class="d-flex justify-content-between mb-3">
              <div></div>
              <div>
                <a href="<?= base_url(); ?>forget_password" class="text-decoration-none text-secondary">Forgot Password?</a>
              </div>
            </div>

            <div class="d-grid mb-3">
                <button
    id="submitBtn"
    class="g-recaptcha btn btn-primary"
    data-sitekey="6LfgOlsrAAAAAPyqVSPW3kEsCcIa-b2MdFsLg1u1"
    data-callback="onSubmit"
    data-action="login"
    type="submit">
    <span id="btnText">Login</span>
    <span id="spinner" style="display: none;">⏳ Verifying...</span>
  </button>
              <!--<button type="submit" id="submit" class="submit btn btn-primary d-none" style="">Login</button>-->
            </div>
          </form>

          <div class="text-left mt-3">
              <h6>New on our platform?<a href="<?= base_url(); ?>" class="text-secondary link-hover"> Create
                                        an account</a></h6>
           
          </div>
          
         <div class="text-center mt-5">
                                <p class="fw-medium text-gray">Copyright © 2025 - <span class="text-secondary">TraceAudit</span> </p>
                            </div>
        </div>
      </div>

    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
  function onSubmit(token) {
      
     
    const form = document.getElementById("loginForm");
    const button = document.getElementById("submitBtn");
    const spinner = document.getElementById("spinner");
    const btnText = document.getElementById("btnText");

    // Disable button and show spinner
    button.disabled = true;
    btnText.style.display = "none";
    spinner.style.display = "inline";

    // Submit the form
    form.submit();
  
    
  }
</script>

</body>

</html>
