 <?= view('organisation/layout/header') ?>
<?= view('organisation/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">Implementation Compliance</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>
                            <?php session()->removeTempdata('validation_errors'); // manual removal 
                            ?>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>


             <form id="form_upload" method="post">
  <style>
    .ic-title-row { background: #f8f9fa; font-weight: bold; }
    .ic-title-cell { color: #198754; font-weight: 700; }
    .ic-wrap { white-space: pre-wrap; }
  </style>

  <?php
    $payload = json_decode($ImplementationCompliance['section_data'] ?? '[]', true) ?: [];
    $main    = $payload['main_clause'] ?? [];
    $subs    = $payload['subclauses'] ?? [];

    $linkCell = function($row) {
        $type = $row['input_type'] ?? '';
        if ($type === 'file') {
            $p = $row['file_path'] ?? '';
            return $p ? '<a href="'.base_url($p).'" target="_blank" rel="noopener">View document</a>' : '<span class="text-muted">-</span>';
        } elseif ($type === 'link') {
            $l = $row['link'] ?? '';
            return $l ? '<a href="'.esc($l).'" target="_blank" rel="noopener">'.esc($l).'</a>' : '<span class="text-muted">-</span>';
        }
        return '<span class="text-muted">-</span>';
    };

    $mNo   = $main['clause_no'] ?? '';
    $mReq  = $main['requirement'] ?? '';
    $mImpl = $main['implementation'] ?? '';
    $mRmk  = $main['remark'] ?? '';
  ?>

  <div class="table-responsive">
    <table class="table table-bordered align-middle">
      <thead class="table-success text-center">
        <tr>
          <th style="width:150px;">Standard Clause No.</th>
          <th>Standard Requirement</th>
          <th>Implementation</th>
          <th style="width:200px;">Link to Documents / Photos for upload</th>
          <th>Remarks</th>
        </tr>
      </thead>
      <tbody>
        <!-- Main clause title row -->
        

        <!-- Main clause detail row -->
        <?php if (!empty(trim($mImpl)) || !empty(trim($main['input_type'] ?? '')) || !empty(trim($mRmk))): ?>
        <tr>
          <td class="text-center"><?= esc($mNo ?: '-') ?></td>
          <td class="ic-wrap"><?= nl2br(esc($mReq)) ?></td>
          <td class="ic-wrap"><?= nl2br(esc($mImpl)) ?></td>
          <td><?= $linkCell($main) ?></td>
          <td class="ic-wrap"><?= nl2br(esc($mRmk)) ?></td>
        </tr>
        <?php endif; ?>

        <!-- Sub-clauses -->
        <?php if (!empty($subs)): ?>
          <?php foreach ($subs as $sc): ?>
            <?php
              $no   = $sc['clause_no'] ?? '';
              $req  = $sc['requirement'] ?? '';
              $impl = $sc['implementation'] ?? '';
              $rmk  = $sc['remark'] ?? '';
              $isHeading = !empty($sc['is_heading'] ?? false);
              if (!$isHeading) {
                $isHeading = (trim($impl) === '' && trim($rmk) === '' && empty($sc['input_type'] ?? ''));
              }
            ?>

            <?php if ($isHeading): ?>
              <!-- Sub-clause section header -->
              <tr class="ic-title-row">
                <td class="text-center"><strong><?= esc($no ?: '-') ?></strong></td>
                <td colspan="4"><strong><?= esc($req ?: '—') ?></strong></td>
              </tr>
            <?php else: ?>
              <!-- Sub-clause detail row -->
              <tr>
                <td class="text-center"><?= esc($no ?: '-') ?></td>
                <td class="ic-wrap"><?= nl2br(esc($req)) ?></td>
                <td class="ic-wrap"><?= nl2br(esc($impl)) ?></td>
                <td><?= $linkCell($sc) ?></td>
                <td class="ic-wrap"><?= nl2br(esc($rmk)) ?></td>
              </tr>
            <?php endif; ?>
          <?php endforeach; ?>
        <?php else: ?>
          <tr>
            <td colspan="5" class="text-center text-muted">No sub-clauses added.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</form>

                </div>
            </div>
        </div>
    </div>
</div>

<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('organisation/layout/footer') ?>


<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>