﻿<?= view('organisation/layout/header') ?>
<?= view('organisation/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--**********************************
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
  .dashboard-card {
    border: none;
    border-radius: 15px;
    padding: 25px;
    color: #fff;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
  }

  .dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
  }

  .icon-box {
    font-size: 3rem;
    opacity: 0.8;
  }

  .badge-custom {
    font-size: 0.9rem;
    padding: 5px 10px;
    border-radius: 10px;
  } 
</style>



<div class="content-body">
  <!-- row -->
  <div class="container-fluid">
    <div class="d-flex align-items-center mb-4 flex-wrap">
      <h3 class="me-auto">Dashboard</h3>
      <div>


      </div>
    </div>
    <div>
      <div class="col-xl-12">
        <div class="">

          <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
              <?= session()->getFlashdata('error') ?>
            </div>
          <?php endif; ?>

          <?php
          $db = \Config\Database::connect();
          $associated_by = session()->get('user_associated');
          $entity_id = session()->get('entity_id');

          function countByDate($db, $table, $associated_by, $entity_id, $month = null, $sumColumn = null)
          {
            $builder = $db->table($table)
              ->where('status', 1)
              ->where('associated_by', $associated_by)
              ->where('entity_id', $entity_id);

            if ($month) {
              $builder->where("MONTH(created_at)", $month['month']);
              $builder->where("YEAR(created_at)", $month['year']);
            }

            if ($sumColumn) {
              return $builder->selectSum($sumColumn)->get()->getRow()->$sumColumn ?? 0;
            }

            return $builder->countAllResults();
          }

          $now = new DateTime();
          $thisMonth = ['month' => $now->format('m'), 'year' => $now->format('Y')];
          $lastMonth = clone $now;
          $lastMonth->modify('-1 month');
          $lastMonth = ['month' => $lastMonth->format('m'), 'year' => $lastMonth->format('Y')];

          $cards = [
            [
              'label' => 'Storage Units',
              'icon' => 'warehouse',
              'bg_color' => 'rgba(33,150,243,1)',
              'table' => 'storage_details',
            ],
            [
              'label' => 'Plant & Machinery',
              'icon' => 'precision_manufacturing',
              'bg_color' => 'rgba(244,67,54,1)',
              'table' => 'plant_and_machinery',
            ],
            [
              'label' => 'Internal Audits Done',
              'icon' => 'assignment',
              'bg_color' => 'rgba(0,150,136,1)',
              'table' => 'internal_audit',
            ],
            [
              'label' => 'Certifications Issued',
              'icon' => 'verified',
              'bg_color' => 'rgba(156,39,176,1)',
              'table' => 'certificate',
            ],
          ];

          // Prepare data with counts
          foreach ($cards as &$card) {
            $card['total'] = countByDate($db, $card['table'], $associated_by, $entity_id, null, $card['sumColumn'] ?? null);
            $card['this_month'] = countByDate($db, $card['table'], $associated_by, $entity_id, $thisMonth, $card['sumColumn'] ?? null);
            $card['last_month'] = countByDate($db, $card['table'], $associated_by, $entity_id, $lastMonth, $card['sumColumn'] ?? null);

            $growth = $card['last_month'] != 0
              ? round((($card['this_month'] - $card['last_month']) / $card['last_month']) * 100)
              : ($card['this_month'] > 0 ? 100 : 0);

            $card['growth'] = $growth;
            $card['growth_color'] = $growth >= 0 ? 'text-success' : 'text-danger';
            $card['growth_icon'] = $growth >= 0 ? 'trending_up' : 'trending_down';
          }
          unset($card);
          ?>

          <!-- Material Icons -->
          <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
          <style>
            .icon-circle {
              display: inline-flex;
              align-items: center;
              justify-content: center;
              border-radius: 50%;
              width: 48px;
              height: 48px;
            }

            .summary-card h3 {
              font-size: 1.8rem;
            }
          </style>

          <div class="row">
            <?php foreach ($cards as $card): ?>
              <div class="col-12 col-md-6 col-lg-3 ">
                <div class="card shadow-sm summary-card p-3">
                  <div class="d-flex justify-content-between align-items-center" style="padding-bottom:10px !important">
                    <div>
                      <h6 class="text-muted"><?= $card['label'] ?></h6>
                      <h3 class="mb-0 counter"><?= $card['total'] ?></h3>

                      <small class="text-info d-block">
                        +<?= $card['this_month'] ?> this month
                      </small>

                      <small class="text-secondary d-block">
                        +<?= $card['last_month'] ?> last month
                      </small>

                      <small class="<?= $card['growth_color'] ?>">
                        <?= abs($card['growth']) ?>%
                        <span class="material-icons align-middle" style="font-size: 16px;">
                          <?= $card['growth_icon'] ?>
                        </span> vs last month
                      </small>
                    </div>
                    <div>
                      <div class="icon-circle" style="background-color:<?= $card['bg_color'] ?>;">
                        <span class="material-icons text-white"><?= $card['icon'] ?></span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>


          <?php
          $db = \Config\Database::connect();
          $associated_by = session()->get('user_associated');
          $entity_id = session()->get('entity_id');



          // Cards (excluding Land)
          $cards = [
            [
              'label' => 'Storage',
              'table' => 'storage_details',
              'color' => 'rgba(33,150,243,1)',
            ],
            [
              'label' => 'Plant & Machinery',
              'table' => 'plant_and_machinery',
              'color' => 'rgba(244,67,54,1)',
            ],
            [
              'label' => 'Internal Audits Done',
              'table' => 'internal_audit',
              'color' => 'rgba(0,150,136,1)',
            ],
            [
              'label' => 'Certifications Issued',
              'table' => 'certificate',
              'color' => 'rgba(156,39,176,1)',
            ],
          ];

          // Build trend data
          $months = [];
          $monthlySeries = [];
          $colors = [];

          for ($i = 11; $i >= 0; $i--) {
            $monthObj = (new DateTime())->modify("-$i months");
            $label = $monthObj->format('M Y');
            $months[] = $label;

            foreach ($cards as &$card) {
              $key = $card['label'];
              $filter = ['month' => $monthObj->format('m'), 'year' => $monthObj->format('Y')];
              $monthlySeries[$key][] = (float) countByDate($db, $card['table'], $associated_by, $entity_id, $filter, $card['sumColumn'] ?? null);
            }
          }
          unset($card);

          // Extract color array
          foreach ($cards as $card) {
            $colors[] = $card['color'];
          }
          ?>



          <!-- Chart Container -->
          <div class="col-12 ">
            <div class="card">
              <div class="card-header">
                <h4 class="card-title"> Trend Overview</h4>
              </div>
              <div class="card-body">
                <div id="trendChart" style="height: 500px;"></div>
              </div>
            </div>
          </div>

          <!-- Chart Script -->
          <script>
            document.addEventListener("DOMContentLoaded", function() {
              const chartDom = document.getElementById('trendChart');
              const trendChart = echarts.init(chartDom);

              const option = {
                tooltip: {
                  trigger: 'axis',
                  axisPointer: {
                    type: 'shadow'
                  }
                },
                legend: {
                  bottom: 0
                },
                color: <?= json_encode($colors) ?>,
                grid: {
                  left: '3%',
                  right: '4%',
                  bottom: '12%',
                  containLabel: true
                },
                xAxis: {
                  type: 'category',
                  data: <?= json_encode($months) ?>
                },
                yAxis: {
                  type: 'value',


                },
                series: [
                  <?php foreach ($monthlySeries as $label => $data): ?> {
                      name: <?= json_encode($label) ?>,
                      type: 'bar',
                      emphasis: {
                        focus: 'series'
                      },
                      data: <?= json_encode($data) ?>
                    },
                  <?php endforeach; ?>
                ]
              };

              trendChart.setOption(option);
              window.addEventListener('resize', () => trendChart.resize());
            });
          </script>




          <div class="col-xl-12">

            <div class="card " id="user-activity">
              <div class="card-header border-0 pb-0 flex-wrap">
                <h4 class="card-title mb-0">Audit Process Status </h4>

              </div>

              <div class="card-body pt-3 px-sm-3 px-0 pb-1">

                <table class="table table-responsive-md" id="contactTable">
                  <thead>
                    <tr>

                      <th>Audit Company</th>
                      <th>Audit template</th>
                      <th>status</th>







                      <th>Action</th>

                    </tr>
                  </thead>
                  <tbody>
                    <?php

                    $db = \Config\Database::connect();

                    $builder = $db->table('subscribe_the_audit_teamplate');

                    $query = $builder->select('*') // or specific columns

                      ->where('associated_by', session()->get('user_associated'))
                      ->where('entity_id', session()->get('entity_id'))
                      ->orderBy('id', 'DESC') // or use 'created_at' if that exists
                      ->limit(10)
                      ->get();

                    // $results = $query->getResult(); // returns array of object

                    $results = $query->getResultArray(); // each row is an associative array

                    foreach ($results as $row):








                      $audit_company_name = [];

                      if (!empty($row['audit_company'])) {
                        $acn = $db->table('entity_profiles')
                          ->select('*') // or specify 'role_name' if that's the column
                          ->where('id', $row['audit_company'])
                          ->get();

                        $audit_company_name = $acn->getResultArray();
                      }

                      // Fallback to dummy value if empty
                      $name_of_the_audit_cmp = !empty($audit_company_name) ? $audit_company_name[0]['establishment_name'] : 'Not Assigned';

                      $audit_company_template = [];

                      if (!empty($row['audit_teamplate_id'])) {
                        $act = $db->table('audit_template')
                          ->select('*') // or specify 'role_name' if that's the column
                          ->where('id', $row['audit_teamplate_id'])
                          ->get();

                        $audit_company_template = $act->getResultArray();
                      }

                      // Fallback to dummy value if empty
                      $name_of_the_template = !empty($audit_company_template) ? $audit_company_template[0]['template_name'] : 'Not Assigned';

                      $auditStatusLabel = '';
                      switch ($row['status'] ?? null) {
                        case '1':
                          $auditStatusLabel = '<span style="background-color: #cce5ff; color: #004085; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit Assignment Accepted</span>';
                          break;
                        case '2':
                          $auditStatusLabel = '<span style="background-color: #f8d7da; color: #721c24; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit Rejected</span>';
                          break;
                        case '3':
                          $auditStatusLabel = '<span style="background-color: #d1ecf1; color: #0c5460; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit In-Process</span>';
                          break;
                        case '4':
                          $auditStatusLabel = '<span style="background-color: #fff3cd; color: #856404; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit On-hold</span>';
                          break;
                        case '5':
                          $auditStatusLabel = '<span style="background-color: #e2e3e5; color: #383d41; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit Pending Payment</span>';
                          break;
                        case '6':
                          $auditStatusLabel = '<span style="background-color: #d4edda; color: #155724; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Audit Completed</span>';
                          break;
                        default:
                          $auditStatusLabel = '<span style="background-color: #d6d8d9; color: #1b1e21; padding: 8px 14px; border-radius: 8px; font-weight: bold; font-size: 14px; display: inline-block;">Unknown Status</span>';
                      }

                    ?>
                      <tr>



                        <td><?= $name_of_the_audit_cmp  ?></td>
                        <td><?= $name_of_the_template  ?></td>
                        <td><?= $auditStatusLabel  ?></td>










                        <td>
                          <div class="action-buttons d-flex justify-content-end">





                            <?php
                            if ($row['status'] == 2 or $row['status'] == 6) {
                            ?>

                              <a href="<?= base_url() ?>Fpo/view_audit_subcribed_template/<?= $row['id'] ?>" target="_blank" class="btn btn-success light mr-2">
                                <span class="material-icons">visibility</span>
                              </a>

                            <?php
                            } else {
                            ?>

                              <?php if (session()->get('edit') == true): ?>
                                <a href="<?= base_url() ?>Fpo/edit_subscribed_template_audit_mapping/<?= $row['id'] ?>" class="btn btn-secondary light mr-2">
                                  <span class="material-icons">edit</span>
                                </a>
                              <?php endif; ?>
                            <?php


                            }

                            ?>




                            <a href="<?= base_url() ?>Fpo/view_audit_log/<?= $row['id'] ?>" target="_blank" class="btn btn-info light">
                              <span class="material-icons">history</span>

                            </a>


                          </div>
                        </td>

                      </tr>
                    <?php endforeach; ?>



                  </tbody>
                </table>

              </div>

            </div>
          </div>



          <div class="col-xl-12">

            <div class="card " id="user-activity">
              <div class="card-header border-0 pb-0 flex-wrap">
                <h4 class="card-title mb-0">Audits</h4>

              </div>









              <div class="card-body pt-3 px-sm-3 px-0 ">

                <div class="row" id="summaryCards">
                  <!-- Total Audits -->
                  <div class="col-md-4 mb-3">
                    <div class="card shadow-sm p-3 border-left-primary">
                      <div class="d-flex justify-content-between align-items-center">
                        <div>
                          <h6 class="text-muted">Total Audits</h6>
                          <h3 id="total_audits_in_list" class="mb-0">0</h3>
                        </div>
                        <div class="icon-circle bg-primary text-white d-flex align-items-center justify-content-center" style="width: 50px; height: 50px; border-radius: 50%;">
                          <span class="material-icons">fact_check</span>
                        </div>
                      </div>
                    </div>
                  </div>









                  <table class="table table-responsive-md" id="audits_list">
                    <thead>
                      <tr>

                        <th>audit type</th>
                        <th>Category</th>

                        <th>Department</th>
                        <th>Year</th>

                        <th>Record Date</th>

                      </tr>
                      <tr>

                        <th>
                          <select class="form-control filter_internal_audit_1" name="new_type" id="audit_type_filter_new">

                            <option value="All">All</option>
                            <option value="certification_body_audit">Certificate Body Audit</option>

                            <option value="internal_audit">Internal Audit</option>

                          </select>

                        </th>
                        <th>
                          <select class="form-control filter_internal_audit_1" name="audit_categoery" id="audit_category_filter_new">
                            <option value="All">All</option>
                            <option value="Initial">Initial</option>
                            <option value="Surveillance">Surveillance</option>
                            <option value="Renewal">Renewal</option>

                          </select>
                        </th>

                        <th>
                          <?php
                          $db = \Config\Database::connect();
                          $roles = $db->table('department')
                            ->select('id, department_name')
                            ->where('status', 1)
                            ->where('associated_by', session()->get('user_associated'))
                            ->where('entity_id', session()->get('entity_id'))
                            ->get()
                            ->getResult();
                          ?>


                          <select class="form-control filter_internal_audit_1" aria-label="contact_person_designation" id="audit_department_filter_new">
                            <option value="">Select Department</option>
                            <?php if (!empty($roles)): ?>
                              <?php foreach ($roles as $role): ?>
                                <option value="<?= esc($role->id) ?>"><?= esc($role->department_name) ?></option>
                              <?php endforeach; ?>
                            <?php endif; ?>
                          </select>
                        </th>
                        <th>
                          <select class="form-control year_select filter_internal_audit_1" name="year" id="filter_internal_audit_year_new">
                            <option value="" disabled>Select Year</option>
                            <?php
                            $currentYear = date('Y');
                            for ($year = 1900; $year <= $currentYear; $year++):
                            ?>
                              <option value="<?= $year ?>" <?= $year == $currentYear ? 'selected' : '' ?>><?= $year ?></option>
                            <?php endfor; ?>
                          </select>

                        </th>

                        <th></th>

                      </tr>
                    </thead>
                    <tbody>


                    </tbody>
                  </table>

                </div>

              </div>
            </div>




            <div class="col-xl-12">

              <div class="card " id="user-activity">
                <div class="card-header border-0 pb-0 flex-wrap">
                  <h4 class="card-title mb-0">auditors</h4>

                </div>









                <div class="card-body pt-3 px-sm-3 px-0 ">

                  <div class="row" id="summaryCards">
                    <!-- Total Audits -->
                    <div class="col-md-4 mb-3">
                      <div class="card shadow-sm p-3 border-left-primary">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h6 class="text-muted">Total Audits</h6>
                            <h3 id="total_auditors_in_list" class="mb-0">0</h3>
                          </div>
                          <div class="icon-circle bg-primary text-white d-flex align-items-center justify-content-center" style="width: 50px; height: 50px; border-radius: 50%;">
                            <span class="material-icons">fact_check</span>
                          </div>
                        </div>
                      </div>
                    </div>









                    <table class="table table-responsive-md" id="auditors_lists">
                      <thead>
                        <tr>

                          <th>audit type</th>
                          <th>audit category</th>
                          <th>auditor name </th>







                        </tr>
                        <tr>

                          <th>
                            <select class="form-control filter_internal_audit_2" name="audit_type" id="audit_type_filter_new_1">

                              <option value="All">All</option>
                              <option value="certification_body_audit">Certificate Body Audit</option>

                              <option value="internal_audit">Internal Audit</option>

                            </select>

                          </th>
                          <th>
                            <select class="form-control filter_internal_audit_2" name="audit_categoery" id="audit_category_filter_new_1">
                              <option value="All">All</option>
                              <option value="Initial">Initial</option>
                              <option value="Surveillance">Surveillance</option>
                              <option value="Renewal">Renewal</option>

                            </select>
                          </th>

                          <th>
                            <?php
                            $db = \Config\Database::connect();

                            // Get auditors JSON from both audit tables
                            $internal = $db->table('internal_audit')
                              ->select('auditors')
                              ->where('status', 1)
                              ->where('associated_by', session()->get('user_associated'))
                              ->where('entity_id', session()->get('entity_id'))
                              ->get()
                              ->getResult();

                            $certification = $db->table('certification_body_audit')
                              ->select('auditors')
                              ->where('status', 1)
                              ->where('associated_by', session()->get('user_associated'))
                              ->where('entity_id', session()->get('entity_id'))
                              ->get()
                              ->getResult();

                            // Collect and deduplicate auditor names
                            $auditorNames = [];

                            foreach (array_merge($internal, $certification) as $row) {
                              if (!empty($row->auditors)) {
                                $auditors = json_decode($row->auditors, true);
                                if (is_array($auditors)) {
                                  foreach ($auditors as $auditor) {
                                    if (!empty($auditor['name'])) {
                                      $auditorNames[] = $auditor['name'];
                                    }
                                  }
                                }
                              }
                            }

                            // Remove duplicates and sort
                            $auditorNames = array_unique($auditorNames);
                            sort($auditorNames);
                            ?>


                            <select class="form-control filter_internal_audit_2" aria-label="auditor_name_filter" id="auditor_name_filter_new">
                              <option value="All">Select Auditor</option>
                              <?php foreach ($auditorNames as $name): ?>
                                <option value="<?= esc($name) ?>"><?= esc($name) ?></option>
                              <?php endforeach; ?>
                            </select>
                          </th>





                        </tr>
                      </thead>
                      <tbody>


                      </tbody>
                    </table>

                  </div>

                </div>
              </div>







              <?php
              // ---------- PHP: fetch data ----------
              $db = \Config\Database::connect();
              $associated_by = session()->get('user_associated');
              $entity_id     = session()->get('entity_id');

              $builder = $db->table('skills s');
              $builder->select("
    s.category_name,
    (
        COUNT(DISTINCT e.id) +
        COUNT(DISTINCT sc.id) +
        COUNT(DISTINCT ia.id) +
        COUNT(DISTINCT ii.id)
    ) AS employee_count
");
              $builder->join('employee            e', 'e.skill_distribution         = s.id', 'left');
              $builder->join('subcontractors      sc', 'sc.skill_distribution       = s.id', 'left');
              $builder->join('internal_auditors   ia', 'ia.skill_distribution       = s.id', 'left');
              $builder->join('internal_inspectors ii', 'ii.skill_distribution       = s.id', 'left');
              $builder->where('s.status', 1);
              $builder->where('s.associated_by', $associated_by);
              $builder->where('s.entity_id', $entity_id);
              $builder->groupBy('s.id');

              $results = $builder->get()->getResult();

              $data = [];
              foreach ($results as $row) {
                $data[] = [
                  'name'  => $row->category_name,
                  'value' => (int) $row->employee_count,
                ];
              }
              ?>

              <!-- HTML Container -->
              <div class="col-xl-12">
                <div class="card" id="user-activity">
                  <div class="card-header border-0 pb-0 flex-wrap">
                    <h4 class="card-title mb-0">Skills-wise Employee Distribution</h4>
                  </div>
                  <div class="card-body pt-3 px-sm-3 px-0 pb-1">
                    <div id="echart-donut" style="width: 100%; height: 400px;"></div>
                  </div>
                </div>
              </div>

              <!-- Apache ECharts CDN -->
              <script src="https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js"></script>

              <!-- Chart Script -->
              <script>
                document.addEventListener("DOMContentLoaded", function() {
                  const chartDom = document.getElementById('echart-donut');
                  const myChart = echarts.init(chartDom);

                  const option = {
                    tooltip: {
                      trigger: 'item',
                      formatter: '{b}: {c} ({d}%)'
                    },
                    legend: {
                      bottom: '0',
                      left: 'center',
                      textStyle: {
                        fontSize: 12
                      }
                    },
                    series: [{
                      name: 'Employees',
                      type: 'pie',
                      radius: ['40%', '70%'],
                      avoidLabelOverlap: false,
                      label: {
                        show: false,
                        position: 'center'
                      },
                      emphasis: {
                        label: {
                          show: true,
                          fontSize: '16',
                          fontWeight: 'bold'
                        }
                      },
                      label: {
                        formatter: '{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ',
                        backgroundColor: '#F6F8FC',
                        borderColor: '#8C8D8E',
                        borderWidth: 1,
                        borderRadius: 4,
                        rich: {
                          a: {
                            color: '#6E7079',
                            lineHeight: 22,
                            align: 'center'
                          },
                          hr: {
                            borderColor: '#8C8D8E',
                            width: '100%',
                            borderWidth: 1,
                            height: 0
                          },
                          b: {
                            color: '#4C5058',
                            fontSize: 14,
                            fontWeight: 'bold',
                            lineHeight: 33
                          },
                          per: {
                            color: '#fff',
                            backgroundColor: '#4C5058',
                            padding: [3, 4],
                            borderRadius: 4
                          }
                        }
                      },
                      labelLine: {
                        length: 20,
                        length2: 10
                      },
                      data: <?= json_encode($data) ?>
                    }]
                  };

                  myChart.setOption(option);
                  window.addEventListener('resize', () => myChart.resize());
                });
              </script>



            </div>
          </div>


        </div>
      </div>
    </div>
    <!--**********************************
            Content body end
        ***********************************-->

    <!--**********************************
            Footer start
        ***********************************-->
    <?= view('organisation/layout/footer') ?>