<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>TraceAudit</title>

  <link rel="shortcut icon" type="image/png" href="<?= base_url(); ?>assets/images/favicon.png" />

  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Material Icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link class="main-css" href="<?= base_url(); ?>assets/css/style.css?<?= mt_rand(); ?>" rel="stylesheet">
  <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">

  <style>
   

  
  </style>
</head>

<body>
    
    
    <?php if (session()->has('otp_code')): ?>
    
    <div class="container-fluid full-height">
    <div class="row h-100">

      <!-- Left Side Image -->
      <div class="col-md-6 d-none d-md-block bg-left"></div>

      <!-- Right Side Login -->
      <div class="col-md-6 d-flex align-items-center justify-content-center">
          <div class=" p-4 w-100" style="max-width: 520px;">
          <div class="text-center mb-4 logo-img">
            <img src="<?= base_url(); ?>assets/logo/krishi-gap-logo.png" alt="" style="max-width: 120px;" />
            <br>
           
            <small><b class="text-primary " style="font-size:1.5rem">TraceAudit </b></small><br>
            <small class="">Your Digital Pathway to Compliance and Market Trust.</small>
          </div>
          
          
           <?php if (session()->has('new_otp')): ?>
           <h4 class="text-left mb-2">A New OTP has been Sent.</h4>
            
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
            <p style="color: red;"><?= session()->getFlashdata('error') ?></p>
            <?php endif; ?>

                   
                            <!--<div class="text-center mb-3 logo-img">-->
                            <!--<img class="logo-auth light" src="<?= base_url(); ?>assets/logo/krishi-gap-logo.png" alt="">-->
                            <!--<img class="logo-auth dark" src="<?= base_url(); ?>assets/logo/krishi-gap-logo.png" alt="">-->
                            <!--</div>-->

                       
                            <h4 class="text-center mb-4">Enter OTP </h4>
                            <form action="<?= base_url('verify_otp_screen') ?>" method="POST">
                                <div class="mb-sm-4 mb-3 position-relative">
                                    <label class="form-label" for="dlab-password">OTP</label>
                                    <input type="text" id="dlab-password" class="form-control" value="" name="otp" required>
                                     
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-block">Verify OTP</button>
                                </div>
                            </form>

                            <div class="new-account mt-3">
    <p>
        Didn't receive the OTP?
        <a id="resendLink" class="text-primary" href="<?= base_url(); ?>resend_otp">Resend OTP</a>
        <span id="timer" class="text-muted"></span>
    </p>
</div>
          
          
          
          </div>
          
          
          
      </div>
      </div>
      </div>

       
    <!--                            <div class="fix-wrapper">-->
    <!--    <div class="container">-->
    <!--        <div class="row justify-content-center">-->
    <!--            <div class="col-lg-5 col-md-6">-->
    <!--                <div class="card mb-0 h-auto">-->
    <!--                    <div class="card-body">-->
                            
                       
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
<?php endif; ?>
    

    <!--**********************************
    Scripts
***********************************-->
    <!-- Required vendors -->
    <script src="<?= base_url(); ?>assets/vendor/global/global.min.js"></script>
    <!-- <script src="assets/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script> -->
    <!-- <script src="assets/vendor/bootstrap-datepicker-master/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/js/dlabnav-init.js"></script> -->
    <!-- <script src="assets/js/custom.min.js"></script> -->
    <!-- <script src="assets/js/demo.js"></script> -->
    <!-- <script src="assets/js/styleSwitcher.js"></script> -->



    <!-- localizationTool -->
    <!-- <script src="assets/js/jquery.localizationTool.js"></script> -->
    <!-- <script src="assets/js/translator.js"></script>	 -->

    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <!-- Selectize CSS -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

    <!-- jQuery (Required) -->


    <!-- Selectize JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>
    <style>
        .required {
            color: #000000;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        .error-text {
            display: none;
            color: red;
            font-size: 14px;
        }

        .nav-tabs .nav-link.active {
            background-color: #6591fd;
            color: white;
        }
    </style>











    <script>
        $(".selectjs").change(function() {

            let curent_class = $(this).val();

            if (curent_class == "Organization") {

                location.replace("<?= base_url(); ?>/")
            } else if (curent_class == "farmer_organization") {

                location.replace("<?= base_url(); ?>/farmer_organization")
            } else if (curent_class == "farmer") {

                location.replace("<?= base_url(); ?>/farmer")
            } else if (curent_class == "audit_company") {


                location.replace("<?= base_url(); ?>/audit_company")
            }


        })







        $(document).ready(function() {
            $('input[name="Organization_Registration_Number"]').on('input', function() {
                if ($(this).val().length > 30) {
                    $(this).val($(this).val().substring(0, 30));
                }
            });




            $('input[name="GST_Registration"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Company_Logo"]').on('change', function() {
                var file = this.files[0]; // Get the uploaded file
                var allowedTypes = ['image/jpeg', 'image/png']; // Allowed file types
                var maxSize = 5 * 1024 * 1024; // 5 MB in bytes

                if (file) {
                    if (!allowedTypes.includes(file.type)) {
                        alert('Only JPEG and PNG formats are allowed.');
                        $(this).val(''); // Clear the input field
                        return;
                    }

                    if (file.size > maxSize) {
                        alert('File size must be less than 5 MB.');
                        $(this).val(''); // Clear the input field
                    }
                }
            });



            $('input[name="Income_Tax_PAN_No"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Income_Tax_PAN_No"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Income_Tax_tan_No"]').on('input', function() {
                let value = $(this).val().toUpperCase(); // Convert input to uppercase
                let validValue = value.replace(/[^A-Z0-9]/g, ''); // Allow only alphanumeric characters

                if (validValue.length > 10) {
                    validValue = validValue.substring(0, 10); // Limit to 10 characters
                }

                $(this).val(validValue);
            });




        });



        $(document).ready(function() {
            function initSelectize(selector) {
                return $(selector).selectize({
                    create: false,
                    sortField: "text",
                    placeholder: "Select an option",
                })[0].selectize;
            }

            // Initialize Selectize for dynamic selects
            initSelectize("#country");
            initSelectize("#state");
            initSelectize("#city");

            function loadCountries() {
                $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                    if (!response.error) {
                        var countrySelect = $("#country")[0].selectize;
                        response.data.forEach(country => {
                            countrySelect.addOption({
                                value: country.name,
                                text: country.name
                            });
                        });
                    }
                });
            }

            function loadStates(country) {
                var stateSelect = $("#state")[0].selectize;
                stateSelect.clear();
                stateSelect.clearOptions();

                if (country) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/states",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.states.forEach(state => {
                                    stateSelect.addOption({
                                        value: state.name,
                                        text: state.name
                                    });
                                });
                            }
                        }
                    });
                }
            }

            function loadCities(country, state) {
                var citySelect = $("#city")[0].selectize;
                citySelect.clear();
                citySelect.clearOptions();

                if (country && state) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country,
                            state: state
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.forEach(city => {
                                    citySelect.addOption({
                                        value: city,
                                        text: city
                                    });
                                });
                            }
                        }
                    });
                }
            }

            loadCountries(); // Load Countries on Page Load

            $("#country").change(function() {
                loadStates($(this).val());
            });

            $("#state").change(function() {
                loadCities($("#country").val(), $(this).val());
            });


        });
    </script>




    <script>
        $(document).ready(function() {
            let steps = $(".step");
            let tabs = $(".nav-tabs .nav-link");
            let currentStep = 0;

            function showStep(index) {
                steps.removeClass("active").eq(index).addClass("active");
                tabs.removeClass("active").eq(index).addClass("active");
                currentStep = index;
            }

            $(".next-btn").click(function() {
                showStep(currentStep + 1);
            });

            $(".prev-btn").click(function() {
                showStep(currentStep - 1);
            });

            $(".nav-link").click(function() {
                let index = $(this).data("tab");
                showStep(index);
            });

            // Remove error message when input is valid
            $(".required").on("input change", function() {
                if ($(this).val().trim() !== "") {
                    $(this).siblings(".error-text").hide();
                }
            });

            $("#multiStepForm").submit(function(e) {
                let valid = true;
                let firstErrorTab = null;

                $(".required").filter("input, select").each(function() {
                    let value = $(this).val().trim();
                    let minLength = $(this).attr("minlength");

                    if (!value || (minLength && value.length < parseInt(minLength))) {
                        $(this).siblings(".error-text").show();

                        let stepIndex = steps.index($(this).closest(".step"));
                        if (firstErrorTab === null) firstErrorTab = stepIndex;

                        valid = false;
                    } else {
                        $(this).siblings(".error-text").hide(); // Hide error if corrected
                    }
                });

                if (!valid) {
                    console.log(firstErrorTab);
                    showStep(firstErrorTab);
                    e.preventDefault();
                }
            });
        });
    </script>
    <style>
        label {
            text-transform: capitalize;

        }
    </style>
</body>
<script>
    const resendLink = document.getElementById('resendLink');
    const timerDisplay = document.getElementById('timer');
    let countdown;

    function startTimer(duration = 60) {
        let timeLeft = duration;
        resendLink.style.pointerEvents = 'none';
        resendLink.style.opacity = '0.5';
        resendLink.style.textDecoration = 'none';

        countdown = setInterval(() => {
            timerDisplay.textContent = ` (Wait ${timeLeft}s)`;
            timeLeft--;

            if (timeLeft < 0) {
                clearInterval(countdown);
                resendLink.style.pointerEvents = 'auto';
                resendLink.style.opacity = '1';
                resendLink.style.textDecoration = 'underline';
                timerDisplay.textContent = '';
            }
        }, 1000);
    }

    // Initial 1 minute lock
    startTimer();

    resendLink.addEventListener('click', function (event) {
        if (resendLink.style.pointerEvents === 'none') {
            event.preventDefault(); // Prevent link from firing
        } else {
            // Start timer again after clicking
            startTimer();
        }
    });
</script>


</html>