<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes 
 */ 

$routes->get('/', 'EntityRegister::index');
$routes->get('organization_registy/(:any)', 'EntityRegister::farmer_organization/$1');
$routes->get('farmer', 'EntityRegister::farmer');
$routes->get('audit_company', 'EntityRegister::audit_company');
$routes->get('verify_otp', 'EntityRegister::otp_screen');
$routes->get('resend_otp', 'EntityRegister::resend_otp');
$routes->post('verify_otp_screen', 'EntityRegister::verify_otp_submit');


$routes->post('entity_register/store', 'EntityRegister::store');
$routes->post('entity_register/store_formar', 'EntityRegister::store_farmar');

$routes->post('check_user_roles', 'EntityRegister::check_user_roles');

$routes->get('entity_login', 'EntityRegister::login');
$routes->get('forget_password', 'EntityRegister::forget_password');

$routes->post('validate_login', 'EntityRegister::login_funtion');
$routes->post('send_otp_for_ferget_password', 'EntityRegister::send_otp_for_ferget_password');
$routes->post('for_get_otp_verifying', 'EntityRegister::for_get_otp_verifying');
$routes->post('reset_password', 'EntityRegister::reset_password');
$routes->get('otp_screen_for_forget', 'EntityRegister::otp_screen_for_forget');



$routes->get('logout', 'EntityRegister::logout');




$routes->post('get_organization_list', 'Comon_details::get_organization_list');


$routes->post('get_skill_details', 'Comon_details::get_skill_data');
$routes->post('get_evalved_by_data', 'Comon_details::get_evalved_by_data');
$routes->post('get_designation_name', 'Comon_details::get_designation_name');
$routes->post('get_farm_details_by_farmer', 'Comon_details::get_farm_details_by_farmer');
$routes->post('get_crop_veraity_details', 'Comon_details::get_crop_veraity_details');
$routes->post('get_crop_catagery_by_farm_and_land', 'Comon_details::get_crop_catagery_by_farm_and_land');
$routes->post('get_crop_asseiged_farm', 'Comon_details::get_crop_asseiged_farm');
$routes->post('select_audit_template_based_on_audit_company', 'Comon_details::select_audit_template_based_on_audit_company');
$routes->post('get_template_details_audit_company', 'Comon_details::get_template_details_audit_company');
$routes->get('exit', 'EntityRegister::exit');







$routes->group('farmer_login', ['filter' => 'authGuard:farmers'], function ($routes) {



    $routes->get('/', 'Farmer_controller::index');
    $routes->post('toggleAutoId', 'Farmer_controller::toggleAutoId');
    $routes->get('org_Profile', 'Farmer_controller::org_Profile');
    $routes->get('verify_otp', 'Farmer_controller::verify_otp');

    $routes->post('org_Profile_edit', 'Farmer_controller::org_profile_edit');
    $routes->post('verify_otp', 'Farmer_controller::verify_otp_and_update_profile');




    // for crop master with permission filters
    $routes->get('Crop_master', 'Crop_master\Crop_master::index');
    $routes->get('add_new_crop', 'Crop_master\Crop_master::add_new_crop');
    $routes->post('insert_crop', 'Crop_master\Crop_master::insert_crop');
    $routes->get('edit_crop/(:any)', 'Crop_master\Crop_master::edit_crop/$1');
    $routes->post('update_crop', 'Crop_master\Crop_master::update_crop');
    $routes->get('delete_crop/(:any)', 'Crop_master\Crop_master::delete_crop/$1');


    $routes->get('farmer_land_details', 'Farmer_land_details\Farmer_land_details::index');
    $routes->get('add_new_farmer_land', 'Farmer_land_details\Farmer_land_details::add_new_farmer_land');
    $routes->post('insert_farm', 'Farmer_land_details\Farmer_land_details::insert_farm');
    $routes->get('view_farm/(:any)', 'Farmer_land_details\Farmer_land_details::view_farm/$1');
    $routes->get('edit_farm_details/(:any)', 'Farmer_land_details\Farmer_land_details::edit_farm_details/$1');
    $routes->post('update_farm', 'Farmer_land_details\Farmer_land_details::update_farm');
    $routes->get('delete_farm/(:any)', 'Farmer_land_details\Farmer_land_details::delete_farm/$1');




    // Crop  assing to farm routes with permission filters
    $routes->get('Crop_details', 'Crop_details\Crop_details::index');
    $routes->get('assing_crop_to_form', 'Crop_details\Crop_details::add_new_crop');
    $routes->post('insert_crop_form_assinge', 'Crop_details\Crop_details::insert_crop_form_assinge');
    $routes->get('view_farm_crop/(:any)', 'Crop_details\Crop_details::view_farm_crop/$1');
    $routes->get('edit_farm_crop/(:any)', 'Crop_details\Crop_details::edit_farm_crop/$1');
    $routes->post('update_crop_farm', 'Crop_details\Crop_details::update_crop_farm');
    $routes->get('delete_farm_crop/(:any)', 'Crop_details\Crop_details::delete_farm_crop/$1');



    // soil management routes with permission filters
    $routes->get('Soil_management', 'Soil_management\Soil_management::index',);
    $routes->get('add_new_soil_management', 'Soil_management\Soil_management::add_new_soil_management');
    $routes->post('inser_soil', 'Soil_management\Soil_management::inser_soil');
    $routes->get('view_soil_management/(:any)', 'Soil_management\Soil_management::view_soil_management/$1');
    $routes->get('edit_soil_type/(:any)', 'Soil_management\Soil_management::edit_soil_type/$1');
    $routes->post('update_soil_type', 'Soil_management\Soil_management::update_soil_type');
    $routes->get('delete_soil_type/(:any)', 'Soil_management\Soil_management::delete_soil_type/$1');



    // water management routes with permission filters
    $routes->get('water_magagement', 'Water_management\Water_management::index');
    $routes->get('add_new_water_management', 'Water_management\Water_management::add_new_water_management');
    $routes->post('insert_water_management', 'Water_management\Water_management::insert_water_management');
    $routes->get('view_water_management/(:any)', 'Water_management\Water_management::view_water_management/$1');
    $routes->get('edit_water_management/(:any)', 'Water_management\Water_management::edit_water_management/$1');
    $routes->post('update_water_management', 'Water_management\Water_management::update_water_management');
    $routes->get('delete_water_management/(:any)', 'Water_management\Water_management::delete_water_management/$1');


    // Irrigation Methods routes with permission filters
    $routes->get('Irrigation_Methods', 'Irrigation_Methods\Irrigation_Methods::index');
    $routes->get('add_new_Irrigation_Methods', 'Irrigation_Methods\Irrigation_Methods::add_new_Irrigation_Methods');
    $routes->post('insert_Irrigation_Method', 'Irrigation_Methods\Irrigation_Methods::insert_Irrigation_Method');
    $routes->get('view_Irrigation_Method/(:any)', 'Irrigation_Methods\Irrigation_Methods::view_Irrigation_Method/$1');
    $routes->get('edit_irrigation_method/(:any)', 'Irrigation_Methods\Irrigation_Methods::edit_irrigation_method/$1');
    $routes->post('update_Irrigation_Method', 'Irrigation_Methods\Irrigation_Methods::update_Irrigation_Method');
    $routes->get('delete_irrigation_method/(:any)', 'Irrigation_Methods\Irrigation_Methods::delete_irrigation_method/$1');



    $routes->get('audit_maping', 'Audit_maping\Audit_maping::index');
    $routes->get('add_audit_mapping', 'Audit_maping\Audit_maping::add_audit_mapping');
    $routes->post('insert_audit_mapping', 'Audit_maping\Audit_maping::insert_audit_mapping');
    $routes->post('update_audit_template_subscribed_version', 'Audit_maping\Audit_maping::update_audit_template_subscribed_version');
    $routes->get('edit_subscribed_template_audit_mapping/(:num)', 'Audit_maping\Audit_maping::edit_subscribed_template_audit_mapping/$1');
    $routes->get('view_audit_subcribed_template/(:num)', 'Audit_maping\Audit_maping::view_audit_subcribed_template/$1');
    $routes->get('view_audit_log/(:num)', 'Audit_maping\Audit_maping::view_audit_log/$1');
    //  $routes->get('audit_maping', 'Audit_maping\Audit_maping::index', ['filter' => 'Permissionfilter:role-and-designation']);
    // more routes
});



$routes->group('admin', ['filter' => 'authGuard:app_user'], function ($routes) {
    $routes->get('/', 'AdminController::index');
    $routes->post('toggleAutoId', 'AdminController::toggleAutoId');
    $routes->get('settings', 'AdminController::org_Profile', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('verify_otp', 'AdminController::verify_otp', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('settings', 'AdminController::org_profile_edit', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('verify_otp', 'AdminController::verify_otp_and_update_profile', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->get('personal_employee_edit_screen/(:any)', 'Employees\Employees::edit_employee/$1');

    // Skill routes with permission filters
    $routes->get('skills', 'Skill\Skill::index', ['filter' => 'Permissionfilter:skill']);
    $routes->get('add_skill', 'Skill\Skill::add_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->post('insert_skill', 'Skill\Skill::insert_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->get('edit_skill/(:any)', 'Skill\Skill::edit_skill/$1', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->post('update_skill', 'Skill\Skill::update_skill', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->get('delete_skill/(:any)', 'Skill\Skill::delete_skill/$1', ['filter' => 'Permissionfilter:skill,delete']);

    // Department routes with permission filters
    $routes->get('department', 'Departement\Departement::index', ['filter' => 'Permissionfilter:department']);
    $routes->get('add_department', 'Departement\Departement::add_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->post('insert_department', 'Departement\Departement::insert_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->get('edit_department/(:any)', 'Departement\Departement::edit_department/$1', ['filter' => 'Permissionfilter:department,edit']);
    $routes->post('update_department', 'Departement\Departement::update_department', ['filter' => 'Permissionfilter:department,edit']);
    $routes->get('delete_department/(:any)', 'Departement\Departement::delete_department/$1', ['filter' => 'Permissionfilter:department,delete']);

    // Role and Designation routes with permission filters
    $routes->get('roll_index', 'Roll\Roll::index', ['filter' => 'Permissionfilter:role-and-designation']);
    $routes->get('add_new_roll', 'Roll\Roll::add_new_roll', ['filter' => 'Permissionfilter:role-and-designation,add']);
    $routes->post('insert_roll', 'Roll\Roll::insert_roll', ['filter' => 'Permissionfilter:role-and-designation,add']);
    $routes->get('view_role/(:any)', 'Roll\Roll::view_role/$1', ['filter' => 'Permissionfilter:role-and-designation']);
    $routes->get('edit_roll/(:any)', 'Roll\Roll::edit_roll/$1', ['filter' => 'Permissionfilter:role-and-designation,edit']);
    $routes->get('delete_roll/(:any)', 'Roll\Roll::delete_roll/$1', ['filter' => 'Permissionfilter:role-and-designation,delete']);
    $routes->post('update_role', 'Roll\Roll::update_role', ['filter' => 'Permissionfilter:role-and-designation,edit']);

    // Employee routes with permission filters
    $routes->get('employees', 'Employees\Employees::index', ['filter' => 'Permissionfilter:TA-User']);
    $routes->get('add_employess', 'Employees\Employees::add_employess', ['filter' => 'Permissionfilter:TA-User,add']);
    $routes->post('insert_employee', 'Employees\Employees::insert_employee', ['filter' => 'Permissionfilter:TA-User,add']);
    $routes->get('view_employee/(:any)', 'Employees\Employees::view_employee/$1', ['filter' => 'Permissionfilter:TA-User']);
    $routes->get('edit_employee/(:any)', 'Employees\Employees::edit_employee/$1', ['filter' => 'Permissionfilter:TA-User,edit']);
    $routes->post('update_employee', 'Employees\Employees::update_employee');
    $routes->get('delete_employee/(:any)', 'Employees\Employees::delete_employee/$1', ['filter' => 'Permissionfilter:TA-User,delete']);

    // farmer routes with permission filters
    $routes->get('farmer', 'AdminController::farmer', ['filter' => 'Permissionfilter:TA-Farmer']);
    $routes->get('add_farmer', 'AdminController::add_farmer', ['filter' => 'Permissionfilter:TA-Farmer,add']);
    $routes->post('insert_farmer', 'AdminController::insert_farmer', ['filter' => 'Permissionfilter:TA-Farmer,add']);
    $routes->get('view_farmer/(:any)', 'AdminController::view_farmer/$1', ['filter' => 'Permissionfilter:TA-Farmer']);
    $routes->get('edit_farmer/(:any)', 'AdminController::edit_farmer/$1', ['filter' => 'Permissionfilter:TA-Farmer,edit']);
    $routes->post('update_farmer/(:any)', 'AdminController::update_farmer/$1', ['filter' => 'Permissionfilter:TA-Farmer,edit']);
    $routes->get('delete_farmer/(:any)', 'AdminController::delete_farmer/$1', ['filter' => 'Permissionfilter:TA-Farmer,delete']);

    // entities routes with permission filters
    $routes->get('entities', 'AdminController::entities', ['filter' => 'Permissionfilter:TA-Entities']);
    $routes->get('add_entity', 'AdminController::add_entity', ['filter' => 'Permissionfilter:TA-Entities,add']);
    $routes->post('insert_entity', 'AdminController::insert_entity', ['filter' => 'Permissionfilter:TA-Entities,add']);
    $routes->get('view_entities/(:any)', 'AdminController::view_entity/$1', ['filter' => 'Permissionfilter:TA-Entities']);
    $routes->get('edit_entity/(:any)', 'AdminController::edit_entity/$1', ['filter' => 'Permissionfilter:TA-Entities,edit']);
    $routes->post('update_entity/(:any)', 'AdminController::update_entity/$1', ['filter' => 'Permissionfilter:TA-Entities,edit']);
    $routes->get('delete_entities/(:any)', 'AdminController::delete_entity/$1', ['filter' => 'Permissionfilter:TA-Entities,delete']);
    $routes->post('ajax_update_entity_status', 'AdminController::ajax_update_entity_status', ['filter' => 'Permissionfilter:entities,edit']);
    $routes->post('ajax_update_farmer_status', 'AdminController::ajax_update_farmer_status', ['filter' => 'Permissionfilter:entities,edit']);
    $routes->get('login_as_entity/(:any)', 'AdminController::login_as_entity/$1', ['filter' => 'Permissionfilter:TA-Entities']);
    $routes->get('login_as_farmer/(:any)', 'AdminController::login_as_farmer/$1', ['filter' => 'Permissionfilter:TA-Entities']);
});

$routes->group('organization', ['filter' => 'authGuard:organisation'], function ($routes) {
    $routes->get('/', 'Organisation::index');
    $routes->post('toggleAutoId', 'Organisation::toggleAutoId');
    $routes->get('org_Profile', 'Organisation::org_Profile', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('verify_otp', 'Organisation::verify_otp', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('org_Profile', 'Organisation::org_profile_edit', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('verify_otp', 'Organisation::verify_otp_and_update_profile', ['filter' => 'Permissionfilter:organization-profile-page,edit']);

    //for personal edit screen 
    $routes->get('personal_contact_edit/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1');
    $routes->get('personal_employee_edit_screen/(:any)', 'Employees\Employees::edit_employee/$1');
    $routes->get('personal_edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1');
    $routes->get('personal_edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1');
    $routes->get('personal_edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1');


    //for contact person 
    $routes->get('Contact_Person', 'ContactPerson\ContactPerson::Contact_Person', ['filter' => 'Permissionfilter:contact-person']);
    $routes->get('add_Contact_Person', 'ContactPerson\ContactPerson::add_Contact_Person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->get('view_edit_contact_person/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1', ['filter' => 'Permissionfilter:contact-person,edit']);
    $routes->get('delete_contact_person/(:any)', 'ContactPerson\ContactPerson::delete_contact_person/$1', ['filter' => 'Permissionfilter:contact-person,delete']);
    $routes->post('insert_contact_person', 'ContactPerson\ContactPerson::insert_contact_person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->post('edit_contact_person', 'ContactPerson\ContactPerson::edit_contact_screen');


    //for certificate    
    $routes->get('certificate', 'Certificate\Certificate::index', ['filter' => 'Permissionfilter:certificate']);
    $routes->post('add_certificate', 'Certificate\Certificate::add_certificate', ['filter' => 'Permissionfilter:certificate,add']);
    $routes->post('give_data_for_edit_cirtificate', 'Certificate\Certificate::give_certificate_data', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->post('update_cirtificate', 'Certificate\Certificate::update_cirtificate', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->get('delete_cirtificate/(:any)', 'Certificate\Certificate::delete_cirtificate/$1', ['filter' => 'Permissionfilter:certificate,delete']);

    // Skill routes with permission filters
    $routes->get('skills', 'Skill\Skill::index', ['filter' => 'Permissionfilter:skill']);
    $routes->get('add_skill', 'Skill\Skill::add_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->post('insert_skill', 'Skill\Skill::insert_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->get('edit_skill/(:any)', 'Skill\Skill::edit_skill/$1', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->post('update_skill', 'Skill\Skill::update_skill', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->get('delete_skill/(:any)', 'Skill\Skill::delete_skill/$1', ['filter' => 'Permissionfilter:skill,delete']);

    // Department routes with permission filters
    $routes->get('department', 'Departement\Departement::index', ['filter' => 'Permissionfilter:department']);
    $routes->get('add_department', 'Departement\Departement::add_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->post('insert_department', 'Departement\Departement::insert_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->get('edit_department/(:any)', 'Departement\Departement::edit_department/$1', ['filter' => 'Permissionfilter:department,edit']);
    $routes->post('update_department', 'Departement\Departement::update_department', ['filter' => 'Permissionfilter:department,edit']);
    $routes->get('delete_department/(:any)', 'Departement\Departement::delete_department/$1', ['filter' => 'Permissionfilter:department,delete']);

    // Factory routes with permission filters
    $routes->get('factory', 'factory\Factory::index', ['filter' => 'Permissionfilter:factory']);
    $routes->get('add_factory', 'factory\Factory::add_factory', ['filter' => 'Permissionfilter:factory,add']);
    $routes->post('insert_factory', 'factory\Factory::insert_factory', ['filter' => 'Permissionfilter:factory,add']);
    $routes->get('view_factoery_details/(:any)', 'factory\Factory::view_factoery_details/$1', ['filter' => 'Permissionfilter:factory']);
    $routes->get('edit_factoery/(:any)', 'factory\Factory::edit_factoery/$1', ['filter' => 'Permissionfilter:factory,edit']);
    $routes->post('update_factory', 'factory\Factory::update_factoery', ['filter' => 'Permissionfilter:factory,edit']);
    $routes->get('delete_factoery/(:any)', 'factory\Factory::delete_factoery/$1', ['filter' => 'Permissionfilter:factory,delete']);

    // Storage routes with permission filters
    $routes->get('storage', 'storage\Storage::index', ['filter' => 'Permissionfilter:storage']);
    $routes->get('add_storage', 'storage\Storage::add_storage', ['filter' => 'Permissionfilter:storage,add']);
    $routes->post('insert_storage', 'storage\Storage::insert_storage', ['filter' => 'Permissionfilter:storage,add']);
    $routes->get('view_storage_details/(:any)', 'storage\Storage::view_storage_details/$1', ['filter' => 'Permissionfilter:storage']);
    $routes->get('edit_storage/(:any)', 'storage\Storage::edit_storage/$1', ['filter' => 'Permissionfilter:storage,edit']);
    $routes->post('update_storage', 'storage\Storage::update_storage', ['filter' => 'Permissionfilter:storage,edit']);
    $routes->get('delete_storage/(:any)', 'storage\Storage::delete_storage/$1', ['filter' => 'Permissionfilter:storage,delete']);
    $routes->post('get_details_of_unites', 'storage\Storage::get_details_of_unites');

    // Packaging routes with permission filters
    $routes->get('packaging', 'pakaging_unit\Pakaging_unit::index', ['filter' => 'Permissionfilter:packaging']);
    $routes->get('add_packaging_unit', 'pakaging_unit\Pakaging_unit::add_packaging_unit', ['filter' => 'Permissionfilter:packaging,add']);
    $routes->post('insert_pakaging', 'pakaging_unit\Pakaging_unit::insert_pakaging', ['filter' => 'Permissionfilter:packaging,add']);
    $routes->get('view_pakaging/(:any)', 'pakaging_unit\Pakaging_unit::view_pakaging/$1', ['filter' => 'Permissionfilter:packaging']);
    $routes->get('edit_pakaging/(:any)', 'pakaging_unit\Pakaging_unit::edit_pakaging/$1', ['filter' => 'Permissionfilter:packaging,edit']);
    $routes->post('update_pakaging', 'pakaging_unit\Pakaging_unit::update_pakaging', ['filter' => 'Permissionfilter:packaging,edit']);
    $routes->get('delete_pakaginig_unit/(:any)', 'pakaging_unit\Pakaging_unit::delete_pakaginig_unit/$1', ['filter' => 'Permissionfilter:packaging,delete']);

    //    for plant_end_meachinery  
    $routes->get('Plant_and_Machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::index/$1', ['filter' => 'Permissionfilter:plant-and-machinery']);
    $routes->get('add_plant_and_meachinery', 'Plant_and_Machinery\Plant_and_Machinery::add_plant_and_meachinery', ['filter' => 'Permissionfilter:plant-and-machinery,add']);
    $routes->post('insert_plant_and_machinery', 'Plant_and_Machinery\Plant_and_Machinery::insert_plant_and_machinery', ['filter' => 'Permissionfilter:plant-and-machinery,add']);
    $routes->get('view_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::view_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery']);
    $routes->get('edit_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::edit_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery,edit']);
    $routes->get('delete_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::delete_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery,delete']);
    $routes->post('update_plant_and_machinery', 'Plant_and_Machinery\Plant_and_Machinery::update_plant_and_machinery', ['filter' => 'Permissionfilter:plant-and-machinery,edit']);

    // Employee routes with permission filters
    $routes->get('employees', 'Employees\Employees::index', ['filter' => 'Permissionfilter:employment']);
    $routes->get('add_employess', 'Employees\Employees::add_employess', ['filter' => 'Permissionfilter:employment,add']);
    $routes->post('insert_employee', 'Employees\Employees::insert_employee', ['filter' => 'Permissionfilter:employment,add']);
    $routes->get('view_employee/(:any)', 'Employees\Employees::view_employee/$1', ['filter' => 'Permissionfilter:employment']);
    $routes->get('edit_employee/(:any)', 'Employees\Employees::edit_employee/$1', ['filter' => 'Permissionfilter:employment,edit']);
    $routes->post('update_employee', 'Employees\Employees::update_employee');
    $routes->get('delete_employee/(:any)', 'Employees\Employees::delete_employee/$1', ['filter' => 'Permissionfilter:employment,delete']);

    // Subcontractor routes with permission filters
    $routes->get('subcontractors', 'subcontractors\subcontractors::index', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('add_subcontractors', 'subcontractors\subcontractors::add_subcontractors', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->post('insert_subcontractor', 'subcontractors\subcontractors::insert_subcontractor', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->get('view_sub_contractor/(:any)', 'subcontractors\subcontractors::view_sub_contractor/$1', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,edit']);
    $routes->get('delete_contractor/(:any)', 'subcontractors\subcontractors::delete_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,delete']);
    $routes->post('update_subcontractor', 'subcontractors\subcontractors::update_subcontractor');

    // Internal Inspectors routes with permission filters
    $routes->get('Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::index', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('add_internal_inspectors', 'Internal_Inspectors\Internal_Inspectors::add_internal_inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->post('insert_Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::insert_Internal_Inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->get('view_internal_inspectors/(:any)', 'Internal_Inspectors\Internal_Inspectors::view_internal_inspectors/$1', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,edit']);
    $routes->get('delete_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::delete_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,delete']);
    $routes->post('update_internal_inspector', 'Internal_Inspectors\Internal_Inspectors::update_internal_inspector');




    // Internal Auditors routes with permission filters
    $routes->get('internal_auditors', 'Internal_auditors\Internal_auditors::index', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('add_internal_auditors', 'Internal_auditors\Internal_auditors::add_internal_auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->post('insert_internal_Auditors', 'Internal_auditors\Internal_auditors::insert_internal_Auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->get('view_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::view_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor,edit']);
    $routes->get('delete_internal_auditors/(:any)', 'Internal_auditors\Internal_auditors::delete_internal_auditors/$1', ['filter' => 'Permissionfilter:internal-auditor,delete']);
    $routes->post('update_internal_auditors', 'Internal_auditors\Internal_auditors::update_internal_auditors');





    // Manuals & Documents routes with permission filters
    $routes->get('manuals_documanents', 'Manuals_and_documants\Manuals_and_documants::index', ['filter' => 'Permissionfilter:manuals-and-documents']);
    $routes->get('add_manuals_documents', 'Manuals_and_documants\Manuals_and_documants::add_manuals_documents', ['filter' => 'Permissionfilter:manuals-and-documents,add']);
    $routes->post('insert_Department', 'Manuals_and_documants\Manuals_and_documants::insert_Department', ['filter' => 'Permissionfilter:manuals-and-documents,add']);
    $routes->get('view_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::view_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents']);
    $routes->get('edit_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::edit_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents,edit']);
    $routes->get('delete_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::delete_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents,delete']);
    $routes->post('update_manuvals_and_documants', 'Manuals_and_documants\Manuals_and_documants::update_manuvals_and_documants', ['filter' => 'Permissionfilter:manuals-and-documents,edit']);






    // ImplementationCompliance routes with permission filters
    $routes->get('ImplementationCompliance', 'Implementation_compliance\Implementation_compliance::index', ['filter' => 'Permissionfilter:Implementation-compliance']);
    $routes->get('add_ImplementationCompliance', 'Implementation_compliance\Implementation_compliance::add_ImplementationCompliance', ['filter' => 'Permissionfilter:Implementation-compliance,add']);

    $routes->get('viewSubClause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::viewSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,add']);
    
    // app/Config/Routes.php
$routes->get ('edit_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::editSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
$routes->post('update_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::updateSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
// app/Config/Routes.php
$routes->get('delete_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::deleteSubClause/$1/$2');



    $routes->post('insert_Implementation_compliance', 'Implementation_compliance\Implementation_compliance::insert_Implementation_compliance', ['filter' => 'Permissionfilter:Implementation-compliance,add']);
    $routes->get('view_Implementation_Compliance/(:any)', 'Implementation_compliance\Implementation_compliance::view_Implementation_Compliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance']);
    $routes->get('edit_ImplementationCompliance/(:any)', 'Implementation_compliance\Implementation_compliance::edit_ImplementationCompliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
    $routes->get('delete_ImplementationCompliance/(:any)', 'Implementation_compliance\Implementation_compliance::delete_ImplementationCompliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance,delete']);
    $routes->post('update_Implementation_compliance', 'Implementation_compliance\Implementation_compliance::update_Implementation_compliance', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);






    // Product Sampling routes with permission filters
    $routes->get('product_sampling', 'Product_sampling\Product_sampling::index', ['filter' => 'Permissionfilter:product-sampling']);
    $routes->get('add_product_sampling', 'Product_sampling\Product_sampling::add_product_sampling', ['filter' => 'Permissionfilter:product-sampling,add']);
    $routes->post('insert_product_Sampling', 'Product_sampling\Product_sampling::insert_product_Sampling', ['filter' => 'Permissionfilter:product-sampling,add']);
    $routes->get('view_product_sampling/(:any)', 'Product_sampling\Product_sampling::view_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling']);
    $routes->get('edit_product_sampling/(:any)', 'Product_sampling\Product_sampling::edit_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling,edit']);
    $routes->get('delete_product_sampling/(:any)', 'Product_sampling\Product_sampling::delete_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling,delete']);
    $routes->post('update_product_sampling', 'Product_sampling\Product_sampling::update_product_sampling', ['filter' => 'Permissionfilter:product-sampling,edit']);




    // Internal Audit routes with permission filters
    $routes->get('internal_audit', 'Internal_audit\Internal_audit::index', ['filter' => 'Permissionfilter:internal-audit']);
    $routes->get('add_internal_audit', 'Internal_audit\Internal_audit::add_internal_audit', ['filter' => 'Permissionfilter:internal-audit,add']);
    $routes->post('insert_internal_audit', 'Internal_audit\Internal_audit::insert_internal_audit', ['filter' => 'Permissionfilter:internal-audit,add']);
    $routes->get('view_internal_audit/(:any)', 'Internal_audit\Internal_audit::view_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit']);
    $routes->get('edit_internal_audit/(:any)', 'Internal_audit\Internal_audit::edit_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit,edit']);
    $routes->get('delete_internal_audit/(:any)', 'Internal_audit\Internal_audit::delete_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit,delete']);
    $routes->post('update_internal_audit', 'Internal_audit\Internal_audit::update_internal_audit', ['filter' => 'Permissionfilter:internal-audit,edit']);



    // Certification Body Audit routes with permission filters
    $routes->get('certification_body_audit', 'Certification_body_audit\Certification_body_audit::index', ['filter' => 'Permissionfilter:certification-body-audit']);
    $routes->get('add_Certification_body_audit', 'Certification_body_audit\Certification_body_audit::add_Certification_body_audit', ['filter' => 'Permissionfilter:certification-body-audit,add']);
    $routes->post('cirtificate_body_insert', 'Certification_body_audit\Certification_body_audit::cirtificate_body_insert', ['filter' => 'Permissionfilter:certification-body-audit,add']);
    $routes->get('view_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::view_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit']);
    $routes->get('edit_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::edit_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit,edit']);
    $routes->get('delete_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::delete_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit,delete']);
    $routes->post('update_cirtificate_Audit', 'Certification_body_audit\Certification_body_audit::update_cirtificate_Audit', ['filter' => 'Permissionfilter:certification-body-audit,edit']);




    // Standard Certificate routes with permission filters
    $routes->get('standerd_citificate', 'Standerd_cirtificate\Standerd_cirtificate::index', ['filter' => 'Permissionfilter:standard-certificate']);
    $routes->get('add_new_standerd_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::add_new_standerd_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,add']);
    $routes->post('insert_standerd_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::insert_standerd_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,add']);
    $routes->get('view_standerd_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::view_standerd_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate']);
    $routes->get('edit_standerd_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::edit_standerd_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate,edit']);
    $routes->get('delete_standed_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::delete_standed_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate,delete']);
    $routes->post('update_Standed_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::update_Standed_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,edit']);




    // Role and Designation routes with permission filters
    $routes->get('roll_index', 'Roll\Roll::index', ['filter' => 'Permissionfilter:role-and-designation']);
    $routes->get('add_new_roll', 'Roll\Roll::add_new_roll', ['filter' => 'Permissionfilter:role-and-designation,add']);
    $routes->post('insert_roll', 'Roll\Roll::insert_roll', ['filter' => 'Permissionfilter:role-and-designation,add']);
    $routes->get('view_role/(:any)', 'Roll\Roll::view_role/$1', ['filter' => 'Permissionfilter:role-and-designation']);
    $routes->get('edit_roll/(:any)', 'Roll\Roll::edit_roll/$1', ['filter' => 'Permissionfilter:role-and-designation,edit']);
    $routes->get('delete_roll/(:any)', 'Roll\Roll::delete_roll/$1', ['filter' => 'Permissionfilter:role-and-designation,delete']);
    $routes->post('update_role', 'Roll\Roll::update_role', ['filter' => 'Permissionfilter:role-and-designation,edit']);



    $routes->get('audit_maping', 'Audit_maping\Audit_maping::index', ['filter' => 'Permissionfilter:audit-mapping']);
    $routes->get('add_audit_mapping', 'Audit_maping\Audit_maping::add_audit_mapping', ['filter' => 'Permissionfilter:audit-mapping,add']);
    $routes->post('insert_audit_mapping', 'Audit_maping\Audit_maping::insert_audit_mapping', ['filter' => 'Permissionfilter:audit-mapping,add']);
    $routes->post('update_audit_template_subscribed_version', 'Audit_maping\Audit_maping::update_audit_template_subscribed_version', ['filter' => 'Permissionfilter:audit-mapping,edit']);
    $routes->get('edit_subscribed_template_audit_mapping/(:num)', 'Audit_maping\Audit_maping::edit_subscribed_template_audit_mapping/$1', ['filter' => 'Permissionfilter:audit-mapping,edit']);
    $routes->get('view_audit_subcribed_template/(:num)', 'Audit_maping\Audit_maping::view_audit_subcribed_template/$1', ['filter' => 'Permissionfilter:audit-mapping']);
    $routes->get('view_audit_log/(:num)', 'Audit_maping\Audit_maping::view_audit_log/$1', ['filter' => 'Permissionfilter:audit-mapping']);
    //  $routes->get('audit_maping', 'Audit_maping\Audit_maping::index', ['filter' => 'Permissionfilter:role-and-designation']);



 $routes->get('audit_type_details', 'Organisation::audit_type_get');
 $routes->get('auditors_lists', 'Organisation::auditors_lists');

    // more routes
});


$routes->group('Fpo', ['filter' => 'authGuard:fpo'], function ($routes) {
 

    // ImplementationCompliance routes with permission filters
    $routes->get('ImplementationCompliance', 'Implementation_compliance\Implementation_compliance::index', ['filter' => 'Permissionfilter:Implementation-compliance']);
    $routes->get('add_ImplementationCompliance', 'Implementation_compliance\Implementation_compliance::add_ImplementationCompliance', ['filter' => 'Permissionfilter:Implementation-compliance,add']);

    $routes->get('viewSubClause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::viewSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,add']);
    
    // app/Config/Routes.php
$routes->get ('edit_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::editSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
$routes->post('update_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::updateSubClause/$1/$2', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
// app/Config/Routes.php
$routes->get('delete_subclause/(:num)/(:num)', 'Implementation_compliance\Implementation_compliance::deleteSubClause/$1/$2');



    $routes->post('insert_Implementation_compliance', 'Implementation_compliance\Implementation_compliance::insert_Implementation_compliance', ['filter' => 'Permissionfilter:Implementation-compliance,add']);
    $routes->get('view_Implementation_Compliance/(:any)', 'Implementation_compliance\Implementation_compliance::view_Implementation_Compliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance']);
    $routes->get('edit_ImplementationCompliance/(:any)', 'Implementation_compliance\Implementation_compliance::edit_ImplementationCompliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);
    $routes->get('delete_ImplementationCompliance/(:any)', 'Implementation_compliance\Implementation_compliance::delete_ImplementationCompliance/$1', ['filter' => 'Permissionfilter:Implementation-compliance,delete']);
    $routes->post('update_Implementation_compliance', 'Implementation_compliance\Implementation_compliance::update_Implementation_compliance', ['filter' => 'Permissionfilter:Implementation-compliance,edit']);




    
 $routes->get('audit_type_details', 'Fpo::audit_type_get');
 $routes->get('auditors_lists', 'Fpo::auditors_lists');




    $routes->get('/', 'Fpo::index');

    $routes->post('toggleAutoId', 'Fpo::toggleAutoId');
    $routes->post('get-crops-by-farm_land', 'Fpo::getCropsByFarmer');
    $routes->get('org_Profile', 'Fpo::org_Profile', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('verify_otp', 'Fpo::verify_otp', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('org_Profile', 'Fpo::org_profile_edit', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('verify_otp', 'Fpo::verify_otp_and_update_profile', ['filter' => 'Permissionfilter:organization-profile-page,edit']);

    // for personal edit screen 


    $routes->get('cropInventory', 'Fpo::cropInventory', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('internalFarmInspection', 'Fpo::internalFarmInspection', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('internalAuditDashboard', 'Fpo::internalAuditDashboard', ['filter' => 'Permissionfilter:organization-profile-page']);













    $routes->get('personal_contact_edit/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1');
    $routes->get('personal_employee_edit_screen/(:any)', 'Employees\Employees::edit_employee/$1');
    $routes->get('personal_edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1');
    $routes->get('personal_edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1');

    $routes->get('personal_edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1');


    //    for contact person 
    $routes->get('Contact_Person', 'ContactPerson\ContactPerson::Contact_Person', ['filter' => 'Permissionfilter:contact-person']);
    $routes->get('add_Contact_Person', 'ContactPerson\ContactPerson::add_Contact_Person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->get('view_edit_contact_person/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1', ['filter' => 'Permissionfilter:contact-person,edit']);
    $routes->get('delete_contact_person/(:any)', 'ContactPerson\ContactPerson::delete_contact_person/$1', ['filter' => 'Permissionfilter:contact-person,delete']);

    $routes->post('insert_contact_person', 'ContactPerson\ContactPerson::insert_contact_person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->post('edit_contact_person', 'ContactPerson\ContactPerson::edit_contact_screen', ['filter' => 'Permissionfilter:contact-person,edit']);


    //    for certificate   

    $routes->get('certificate', 'Certificate\Certificate::index', ['filter' => 'Permissionfilter:certificate']);
    $routes->post('add_certificate', 'Certificate\Certificate::add_certificate', ['filter' => 'Permissionfilter:certificate,add']);
    $routes->post('give_data_for_edit_cirtificate', 'Certificate\Certificate::give_certificate_data', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->post('update_cirtificate', 'Certificate\Certificate::update_cirtificate', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->get('delete_cirtificate/(:any)', 'Certificate\Certificate::delete_cirtificate/$1', ['filter' => 'Permissionfilter:certificate,delete']);




    // Skill routes with permission filters
    $routes->get('skills', 'Skill\Skill::index', ['filter' => 'Permissionfilter:skill']);
    $routes->get('add_skill', 'Skill\Skill::add_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->post('insert_skill', 'Skill\Skill::insert_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->get('edit_skill/(:any)', 'Skill\Skill::edit_skill/$1', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->post('update_skill', 'Skill\Skill::update_skill', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->get('delete_skill/(:any)', 'Skill\Skill::delete_skill/$1', ['filter' => 'Permissionfilter:skill,delete']);


    // Department routes with permission filters
    $routes->get('department', 'Departement\Departement::index', ['filter' => 'Permissionfilter:department']);
    $routes->get('add_department', 'Departement\Departement::add_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->post('insert_department', 'Departement\Departement::insert_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->get('edit_department/(:any)', 'Departement\Departement::edit_department/$1', ['filter' => 'Permissionfilter:department,edit']);
    $routes->post('update_department', 'Departement\Departement::update_department', ['filter' => 'Permissionfilter:department,edit']);
    $routes->get('delete_department/(:any)', 'Departement\Departement::delete_department/$1', ['filter' => 'Permissionfilter:department,delete']);

    // for crop master with permission filters
    $routes->get('Crop_master', 'Crop_master\Crop_master::index', ['filter' => 'Permissionfilter:Crop-master']);
    $routes->get('add_new_crop', 'Crop_master\Crop_master::add_new_crop', ['filter' => 'Permissionfilter:Crop-master,add']);
    $routes->post('insert_crop', 'Crop_master\Crop_master::insert_crop', ['filter' => 'Permissionfilter:Crop-master,add']);
    $routes->get('edit_crop/(:any)', 'Crop_master\Crop_master::edit_crop/$1', ['filter' => 'Permissionfilter:Crop-master,edit']);
    $routes->post('update_crop', 'Crop_master\Crop_master::update_crop', ['filter' => 'Permissionfilter:Crop-master,edit']);
    $routes->get('delete_crop/(:any)', 'Crop_master\Crop_master::delete_crop/$1', ['filter' => 'Permissionfilter:Crop-master,delete']);

    // Factory routes with permission filters
    $routes->get('factory', 'factory\Factory::index', ['filter' => 'Permissionfilter:factory']);
    $routes->get('add_factory', 'factory\Factory::add_factory', ['filter' => 'Permissionfilter:factory,add']);
    $routes->post('insert_factory', 'factory\Factory::insert_factory', ['filter' => 'Permissionfilter:factory,add']);
    $routes->get('view_factoery_details/(:any)', 'factory\Factory::view_factoery_details/$1', ['filter' => 'Permissionfilter:factory']);
    $routes->get('edit_factoery/(:any)', 'factory\Factory::edit_factoery/$1', ['filter' => 'Permissionfilter:factory,edit']);
    $routes->post('update_factory', 'factory\Factory::update_factoery', ['filter' => 'Permissionfilter:factory,edit']);
    $routes->get('delete_factoery/(:any)', 'factory\Factory::delete_factoery/$1', ['filter' => 'Permissionfilter:factory,delete']);

    // Storage routes with permission filters
    $routes->get('storage', 'storage\Storage::index', ['filter' => 'Permissionfilter:storage']);
    $routes->get('add_storage', 'storage\Storage::add_storage', ['filter' => 'Permissionfilter:storage,add']);
    $routes->post('insert_storage', 'storage\Storage::insert_storage', ['filter' => 'Permissionfilter:storage,add']);
    $routes->get('view_storage_details/(:any)', 'storage\Storage::view_storage_details/$1', ['filter' => 'Permissionfilter:storage']);
    $routes->get('edit_storage/(:any)', 'storage\Storage::edit_storage/$1', ['filter' => 'Permissionfilter:storage,edit']);
    $routes->post('update_storage', 'storage\Storage::update_storage', ['filter' => 'Permissionfilter:storage,edit']);
    $routes->get('delete_storage/(:any)', 'storage\Storage::delete_storage/$1', ['filter' => 'Permissionfilter:storage,delete']);
    $routes->post('get_details_of_unites', 'storage\Storage::get_details_of_unites');

    // Packaging routes with permission filters
    $routes->get('packaging', 'pakaging_unit\Pakaging_unit::index', ['filter' => 'Permissionfilter:packaging']);
    $routes->get('add_packaging_unit', 'pakaging_unit\Pakaging_unit::add_packaging_unit', ['filter' => 'Permissionfilter:packaging,add']);
    $routes->post('insert_pakaging', 'pakaging_unit\Pakaging_unit::insert_pakaging', ['filter' => 'Permissionfilter:packaging,add']);
    $routes->get('view_pakaging/(:any)', 'pakaging_unit\Pakaging_unit::view_pakaging/$1', ['filter' => 'Permissionfilter:packaging']);
    $routes->get('edit_pakaging/(:any)', 'pakaging_unit\Pakaging_unit::edit_pakaging/$1', ['filter' => 'Permissionfilter:packaging,edit']);
    $routes->post('update_pakaging', 'pakaging_unit\Pakaging_unit::update_pakaging', ['filter' => 'Permissionfilter:packaging,edit']);
    $routes->get('delete_pakaginig_unit/(:any)', 'pakaging_unit\Pakaging_unit::delete_pakaginig_unit/$1', ['filter' => 'Permissionfilter:packaging,delete']);

    //    for plant_end_meachinery  
    $routes->get('Plant_and_Machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::index/$1', ['filter' => 'Permissionfilter:plant-and-machinery']);
    $routes->get('add_plant_and_meachinery', 'Plant_and_Machinery\Plant_and_Machinery::add_plant_and_meachinery', ['filter' => 'Permissionfilter:plant-and-machinery,add']);
    $routes->post('insert_plant_and_machinery', 'Plant_and_Machinery\Plant_and_Machinery::insert_plant_and_machinery', ['filter' => 'Permissionfilter:plant-and-machinery,add']);
    $routes->get('view_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::view_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery']);
    $routes->get('edit_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::edit_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery,edit']);
    $routes->get('delete_plant_and_machinery/(:any)', 'Plant_and_Machinery\Plant_and_Machinery::delete_plant_and_machinery/$1', ['filter' => 'Permissionfilter:plant-and-machinery,delete']);
    $routes->post('update_plant_and_machinery', 'Plant_and_Machinery\Plant_and_Machinery::update_plant_and_machinery', ['filter' => 'Permissionfilter:plant-and-machinery,edit']);

    // Employee routes with permission filters
    $routes->get('employees', 'Employees\Employees::index', ['filter' => 'Permissionfilter:employment']);
    $routes->get('add_employess', 'Employees\Employees::add_employess', ['filter' => 'Permissionfilter:employment,add']);
    $routes->post('insert_employee', 'Employees\Employees::insert_employee', ['filter' => 'Permissionfilter:employment,add']);
    $routes->get('view_employee/(:any)', 'Employees\Employees::view_employee/$1', ['filter' => 'Permissionfilter:employment']);
    $routes->get('edit_employee/(:any)', 'Employees\Employees::edit_employee/$1', ['filter' => 'Permissionfilter:employment,edit']);
    $routes->post('update_employee', 'Employees\Employees::update_employee', ['filter' => 'Permissionfilter:employment,edit']);
    $routes->get('delete_employee/(:any)', 'Employees\Employees::delete_employee/$1', ['filter' => 'Permissionfilter:employment,delete']);

    // farmer routes with permission filters
    $routes->get('farmer', 'Farmers\Farmers::index', ['filter' => 'Permissionfilter:farmer']);
    $routes->get('add_farmer', 'Farmers\Farmers::add_farmer', ['filter' => 'Permissionfilter:farmer,add']);
    $routes->post('insert_farmer', 'Farmers\Farmers::insert_farmer', ['filter' => 'Permissionfilter:farmer,add']);
    $routes->get('view_farmer/(:any)', 'Farmers\Farmers::view_farmer/$1', ['filter' => 'Permissionfilter:farmer']);
    $routes->get('edit_farmer/(:any)', 'Farmers\Farmers::edit_farmer/$1', ['filter' => 'Permissionfilter:farmer,edit']);
    $routes->post('update_farmer', 'Farmers\Farmers::update_farmer', ['filter' => 'Permissionfilter:farmer,edit']);
    $routes->get('delete_farmer/(:any)', 'Farmers\Farmers::delete_farmer/$1', ['filter' => 'Permissionfilter:farmer,delete']);

    // land_details routes with permission filters
    $routes->get('farmer_land_details', 'Farmer_land_details\Farmer_land_details::index', ['filter' => 'Permissionfilter:farmer_land_details']);
    $routes->get('add_new_farmer_land', 'Farmer_land_details\Farmer_land_details::add_new_farmer_land', ['filter' => 'Permissionfilter:farmer_land_details,add']);
    $routes->post('insert_farm', 'Farmer_land_details\Farmer_land_details::insert_farm', ['filter' => 'Permissionfilter:farmer_land_details,add']);
    $routes->get('view_farm/(:any)', 'Farmer_land_details\Farmer_land_details::view_farm/$1', ['filter' => 'Permissionfilter:farmer_land_details']);
    $routes->get('edit_farm_details/(:any)', 'Farmer_land_details\Farmer_land_details::edit_farm_details/$1', ['filter' => 'Permissionfilter:farmer_land_details,edit']);
    $routes->post('update_farm', 'Farmer_land_details\Farmer_land_details::update_farm', ['filter' => 'Permissionfilter:farmer_land_details,edit']);
    $routes->get('delete_farm/(:any)', 'Farmer_land_details\Farmer_land_details::delete_farm/$1', ['filter' => 'Permissionfilter:farmer_land_details,delete']);

    // Crop  assing to farm routes with permission filters
    $routes->get('Crop_details', 'Crop_details\Crop_details::index', ['filter' => 'Permissionfilter:crop_details']);
    $routes->get('assing_crop_to_form', 'Crop_details\Crop_details::add_new_crop', ['filter' => 'Permissionfilter:crop_details,add']);
    $routes->post('insert_crop_form_assinge', 'Crop_details\Crop_details::insert_crop_form_assinge', ['filter' => 'Permissionfilter:crop_details,add']);
    $routes->get('view_farm_crop/(:any)', 'Crop_details\Crop_details::view_farm_crop/$1', ['filter' => 'Permissionfilter:crop_details']);
    $routes->get('edit_farm_crop/(:any)', 'Crop_details\Crop_details::edit_farm_crop/$1', ['filter' => 'Permissionfilter:crop_details,edit']);
    $routes->post('update_crop_farm', 'Crop_details\Crop_details::update_crop_farm', ['filter' => 'Permissionfilter:crop_details,edit']);
    $routes->get('delete_farm_crop/(:any)', 'Crop_details\Crop_details::delete_farm_crop/$1', ['filter' => 'Permissionfilter:crop_details,delete']);

    // soil management routes with permission filters
    $routes->get('Soil_management', 'Soil_management\Soil_management::index', ['filter' => 'Permissionfilter:soil-management']);
    $routes->get('add_new_soil_management', 'Soil_management\Soil_management::add_new_soil_management', ['filter' => 'Permissionfilter:soil-management,add']);
    $routes->post('inser_soil', 'Soil_management\Soil_management::inser_soil', ['filter' => 'Permissionfilter:soil-management,add']);
    $routes->get('view_soil_management/(:any)', 'Soil_management\Soil_management::view_soil_management/$1', ['filter' => 'Permissionfilter:soil-management']);
    $routes->get('edit_soil_type/(:any)', 'Soil_management\Soil_management::edit_soil_type/$1', ['filter' => 'Permissionfilter:soil-management,edit']);
    $routes->post('update_soil_type', 'Soil_management\Soil_management::update_soil_type', ['filter' => 'Permissionfilter:soil-management,edit']);
    $routes->get('delete_soil_type/(:any)', 'Soil_management\Soil_management::delete_soil_type/$1', ['filter' => 'Permissionfilter:soil-management,delete']);



    // water management routes with permission filters
    $routes->get('water_magagement', 'Water_management\Water_management::index', ['filter' => 'Permissionfilter:water-management']);
    $routes->get('add_new_water_management', 'Water_management\Water_management::add_new_water_management', ['filter' => 'Permissionfilter:water-management,add']);
    $routes->post('insert_water_management', 'Water_management\Water_management::insert_water_management', ['filter' => 'Permissionfilter:water-management,add']);
    $routes->get('view_water_management/(:any)', 'Water_management\Water_management::view_water_management/$1', ['filter' => 'Permissionfilter:water-management']);
    $routes->get('edit_water_management/(:any)', 'Water_management\Water_management::edit_water_management/$1', ['filter' => 'Permissionfilter:water-management,edit']);
    $routes->post('update_water_management', 'Water_management\Water_management::update_water_management', ['filter' => 'Permissionfilter:water-management,edit']);
    $routes->get('delete_water_management/(:any)', 'Water_management\Water_management::delete_water_management/$1', ['filter' => 'Permissionfilter:water-management,delete']);


    // Irrigation Methods routes with permission filters
    $routes->get('Irrigation_Methods', 'Irrigation_Methods\Irrigation_Methods::index', ['filter' => 'Permissionfilter:irrigation-methods']);
    $routes->get('add_new_Irrigation_Methods', 'Irrigation_Methods\Irrigation_Methods::add_new_Irrigation_Methods', ['filter' => 'Permissionfilter:irrigation-methods,add']);
    $routes->post('insert_Irrigation_Method', 'Irrigation_Methods\Irrigation_Methods::insert_Irrigation_Method', ['filter' => 'Permissionfilter:irrigation-methods,add']);
    $routes->get('view_Irrigation_Method/(:any)', 'Irrigation_Methods\Irrigation_Methods::view_Irrigation_Method/$1', ['filter' => 'Permissionfilter:irrigation-methods']);
    $routes->get('edit_irrigation_method/(:any)', 'Irrigation_Methods\Irrigation_Methods::edit_irrigation_method/$1', ['filter' => 'Permissionfilter:irrigation-methods,edit']);
    $routes->post('update_Irrigation_Method', 'Irrigation_Methods\Irrigation_Methods::update_Irrigation_Method', ['filter' => 'Permissionfilter:irrigation-methods,edit']);
    $routes->get('delete_irrigation_method/(:any)', 'Irrigation_Methods\Irrigation_Methods::delete_irrigation_method/$1', ['filter' => 'Permissionfilter:irrigation-methods,delete']);


    // Other Documents & Reports routes with permission filters
    $routes->get('Other_Documents_Reports', 'Other_documents_reports\Other_documents_reports::index', ['filter' => 'Permissionfilter:other-documents-reports']);
    $routes->get('add_documants_and_reports', 'Other_documents_reports\Other_documents_reports::add_documants_and_reports', ['filter' => 'Permissionfilter:other-documents-reports,add']);
    $routes->post('insert_document_and_report', 'Other_documents_reports\Other_documents_reports::insert_document_and_report', ['filter' => 'Permissionfilter:other-documents-reports,add']);
    $routes->get('view_document_report/(:any)', 'Other_documents_reports\Other_documents_reports::view_document_report/$1', ['filter' => 'Permissionfilter:other-documents-reports']);
    $routes->get('edit_document_report/(:any)', 'Other_documents_reports\Other_documents_reports::edit_document_report/$1', ['filter' => 'Permissionfilter:other-documents-reports,edit']);
    $routes->post('update_document_report', 'Other_documents_reports\Other_documents_reports::update_document_report', ['filter' => 'Permissionfilter:other-documents-reports,edit']);
    $routes->get('delete_document_report/(:any)', 'Other_documents_reports\Other_documents_reports::delete_document_report/$1', ['filter' => 'Permissionfilter:other-documents-reports,delete']);



    // Mass Balance Register routes with permission filters
    $routes->get('Mass_Balance_Register', 'Mass_Balance_Register\Mass_Balance_Register::index', ['filter' => 'Permissionfilter:mass-balance-register']);
    $routes->get('add_new_Mass_Balance_Register', 'Mass_Balance_Register\Mass_Balance_Register::add_new_Mass_Balance_Register', ['filter' => 'Permissionfilter:mass-balance-register,add']);
    $routes->post('insert_mass_balance_register', 'Mass_Balance_Register\Mass_Balance_Register::insert_mass_balance_register', ['filter' => 'Permissionfilter:mass-balance-register,add']);
    $routes->get('view_mass_balance_registry/(:any)', 'Mass_Balance_Register\Mass_Balance_Register::view_mass_balance_registry/$1', ['filter' => 'Permissionfilter:mass-balance-register']);
    $routes->get('edit_mass_balance_register/(:any)', 'Mass_Balance_Register\Mass_Balance_Register::edit_mass_balance_register/$1', ['filter' => 'Permissionfilter:mass-balance-register,edit']);
    $routes->post('update_mass_balance_register', 'Mass_Balance_Register\Mass_Balance_Register::update_mass_balance_register', ['filter' => 'Permissionfilter:mass-balance-register,edit']);
    $routes->get('delete_mass_balance_register/(:any)', 'Mass_Balance_Register\Mass_Balance_Register::delete_mass_balance_register/$1', ['filter' => 'Permissionfilter:mass-balance-register,delete']);




    // internal_farm_inspection routes with permission filters
    $routes->get('internal_farm_inspection', 'Internal_farm_inspection\Internal_farm_inspection::index', ['filter' => 'Permissionfilter:internal-farm-inspection']);
    $routes->get('add_Internal_farm_inspection', 'Internal_farm_inspection\Internal_farm_inspection::add_Internal_farm_inspection', ['filter' => 'Permissionfilter:internal-farm-inspection,add']);
    $routes->post('insert_internal_farm_inspection', 'Internal_farm_inspection\Internal_farm_inspection::insert_internal_farm_inspection', ['filter' => 'Permissionfilter:internal-farm-inspection,add']);
    $routes->get('view_farm_inspection/(:any)', 'Internal_farm_inspection\Internal_farm_inspection::view_farm_inspection/$1', ['filter' => 'Permissionfilter:internal-farm-inspection']);
    $routes->get('edit_internal_farm_inspection/(:any)', 'Internal_farm_inspection\Internal_farm_inspection::edit_internal_farm_inspection/$1', ['filter' => 'Permissionfilter:internal-farm-inspection,edit']);
    $routes->post('UPDATE_internal_farm_inspection', 'Internal_farm_inspection\Internal_farm_inspection::UPDATE_internal_farm_inspection', ['filter' => 'Permissionfilter:internal-farm-inspection,edit']);
    $routes->get('delete_internal_farm_inspection/(:any)', 'Internal_farm_inspection\Internal_farm_inspection::delete_internal_farm_inspection/$1', ['filter' => 'Permissionfilter:internal-farm-inspection,delete']);





    // Certified_Audit routes with permission filters
    $routes->get('Certified_Audit', 'Certified_Audit\Certified_Audit::index', ['filter' => 'Permissionfilter:certified-audit']);
    $routes->get('add_new_Certified_audit', 'Certified_Audit\Certified_Audit::add_new_Certified_audit', ['filter' => 'Permissionfilter:certified-audit,add']);
    $routes->post('certified_audit_insert', 'Certified_Audit\Certified_Audit::certified_audit_insert', ['filter' => 'Permissionfilter:certified-audit,add']);
    $routes->get('view_citified_audit/(:any)', 'Certified_Audit\Certified_Audit::view_citified_audit/$1', ['filter' => 'Permissionfilter:certified-audit']);
    $routes->get('edit_cirtified_audit/(:any)', 'Certified_Audit\Certified_Audit::edit_cirtified_audit/$1', ['filter' => 'Permissionfilter:certified-audit,edit']);
    $routes->post('update_certified_audit', 'Certified_Audit\Certified_Audit::update_certified_audit', ['filter' => 'Permissionfilter:certified-audit,edit']);
    $routes->get('delete_cirtified_audit/(:any)', 'Certified_Audit\Certified_Audit::delete_cirtified_audit/$1', ['filter' => 'Permissionfilter:certified-audit,delete']);




    //farm_inspection routes with permission filters
    $routes->get('farm_inspection', 'Farm_inspection\Farm_inspection::index', ['filter' => 'Permissionfilter:farm-inspectio']);
    $routes->get('add_farm_inspection', 'Farm_inspection\Farm_inspection::add_farm_inspection', ['filter' => 'Permissionfilter:farm-inspectio,add']);
    $routes->post('insert_farm_inspection', 'Farm_inspection\Farm_inspection::insert_farm_inspection', ['filter' => 'Permissionfilter:farm-inspectio,add']);
    $routes->get('view_non_internal_farm_inspection/(:any)', 'Farm_inspection\Farm_inspection::view_non_internal_farm_inspection/$1', ['filter' => 'Permissionfilter:farm-inspectio']);
    $routes->get('edit_farm_inspection/(:any)', 'Farm_inspection\Farm_inspection::edit_farm_inspection/$1', ['filter' => 'Permissionfilter:farm-inspectio,edit']);
    $routes->post('UPDATE_farm_inspection', 'Farm_inspection\Farm_inspection::UPDATE_farm_inspection', ['filter' => 'Permissionfilter:farm-inspectio,edit']);
    $routes->get('delete_farm_inspection/(:any)', 'Farm_inspection\Farm_inspection::delete_farm_inspection/$1', ['filter' => 'Permissionfilter:farm-inspectio,delete']);



    //Referance_documents routes with permission filters
    $routes->get('Referance_documents', 'Referance_documents\Referance_documents::index', ['filter' => 'Permissionfilter:reference-document']);
    $routes->get('add_new_Referance_documents', 'Referance_documents\Referance_documents::add_new_Referance_documents', ['filter' => 'Permissionfilter:reference-document,add']);
    $routes->post('insert_Reference_Documents', 'Referance_documents\Referance_documents::insert_Reference_Documents', ['filter' => 'Permissionfilter:reference-document,add']);
    $routes->get('view_referal_document/(:any)', 'Referance_documents\Referance_documents::view_referal_document/$1', ['filter' => 'Permissionfilter:reference-document']);
    $routes->get('edit_referance_document/(:any)', 'Referance_documents\Referance_documents::edit_referance_document/$1', ['filter' => 'Permissionfilter:reference-document,edit']);
    $routes->post('update_referral_document', 'Referance_documents\Referance_documents::update_referral_document', ['filter' => 'Permissionfilter:reference-document,edit']);
    $routes->get('delete_referal_document/(:any)', 'Referance_documents\Referance_documents::delete_referal_document/$1', ['filter' => 'Permissionfilter:reference-document,delete']);



    //impact_Creation routes with permission filters
    $routes->get('impact_Creation', 'impact_Creation\impact_Creation::index', ['filter' => 'Permissionfilter:impact-creation']);
    $routes->get('add_new_impact_Creation', 'impact_Creation\impact_Creation::add_new_impact_Creation', ['filter' => 'Permissionfilter:impact-creation,add']);
    $routes->post('insert_impact_creation', 'impact_Creation\impact_Creation::insert_impact_creation', ['filter' => 'Permissionfilter:impact-creation,add']);
    $routes->get('view_impact_creation/(:any)', 'impact_Creation\impact_Creation::view_impact_creation/$1', ['filter' => 'Permissionfilter:impact-creation']);
    $routes->get('edit_impact_creation/(:any)', 'impact_Creation\impact_Creation::edit_impact_creation/$1', ['filter' => 'Permissionfilter:impact-creation,edit']);
    $routes->post('update_impact_creation', 'impact_Creation\impact_Creation::update_impact_creation', ['filter' => 'Permissionfilter:impact-creation,edit']);
    $routes->get('delete_impact_creation/(:any)', 'impact_Creation\impact_Creation::delete_impact_creation/$1', ['filter' => 'Permissionfilter:impact-creation,delete']);


    //Challenges_and_Feedback routes with permission filters
    $routes->get('Challenges_and_Feedback', 'Challenges_and_Feedback\Challenges_and_Feedback::index', ['filter' => 'Permissionfilter:challenges-and-feedback']);
    $routes->get('add_new_Challenges_and_Feedback', 'Challenges_and_Feedback\Challenges_and_Feedback::add_new_Challenges_and_Feedback', ['filter' => 'Permissionfilter:challenges-and-feedback,add']);
    $routes->post('insert_challenges_and_feedback', 'Challenges_and_Feedback\Challenges_and_Feedback::insert_challenges_and_feedback', ['filter' => 'Permissionfilter:challenges-and-feedback,add']);
    $routes->get('view_challenges_and_feedback/(:any)', 'Challenges_and_Feedback\Challenges_and_Feedback::view_challenges_and_feedback/$1', ['filter' => 'Permissionfilter:challenges-and-feedback']);
    $routes->get('edit_challenges_and_feedback/(:any)', 'Challenges_and_Feedback\Challenges_and_Feedback::edit_challenges_and_feedback/$1', ['filter' => 'Permissionfilter:challenges-and-feedback,edit']);
    $routes->post('update_challenes_and_feed_back', 'Challenges_and_Feedback\Challenges_and_Feedback::update_challenes_and_feed_back', ['filter' => 'Permissionfilter:challenges-and-feedback,edit']);
    $routes->get('delete_challenes_and_feedback/(:any)', 'Challenges_and_Feedback\Challenges_and_Feedback::delete_challenes_and_feedback/$1', ['filter' => 'Permissionfilter:challenges-and-feedback,delete']);



    //Famer_Supervisor routes with permission filters
    $routes->get('Famer_Supervisor', 'Famer_Supervisor\Famer_Supervisor::index', ['filter' => 'Permissionfilter:farmer-supervisor']);
    $routes->get('add_Farmer_Supervisor', 'Famer_Supervisor\Famer_Supervisor::add_Farmer_Supervisor', ['filter' => 'Permissionfilter:farmer-supervisor,add']);
    $routes->post('insert_farmer_supervisor', 'Famer_Supervisor\Famer_Supervisor::insert_farmer_supervisor', ['filter' => 'Permissionfilter:farmer-supervisor,add']);
    $routes->get('view_farmer_supervisor/(:any)', 'Famer_Supervisor\Famer_Supervisor::view_farmer_supervisor/$1', ['filter' => 'Permissionfilter:farmer-supervisor']);
    $routes->get('edit_farmer_supervisor/(:any)', 'Famer_Supervisor\Famer_Supervisor::edit_farmer_supervisor/$1', ['filter' => 'Permissionfilter:farmer-supervisor,edit']);
    $routes->post('update_farmer_supervisor', 'Famer_Supervisor\Famer_Supervisor::update_farmer_supervisor', ['filter' => 'Permissionfilter:farmer-supervisor,edit']);
    $routes->get('delete_farmer_supervisor/(:any)', 'Famer_Supervisor\Famer_Supervisor::delete_farmer_supervisor/$1', ['filter' => 'Permissionfilter:farmer-supervisor,delete']);





    // Subcontractor routes with permission filters
    $routes->get('subcontractors', 'subcontractors\subcontractors::index', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('add_subcontractors', 'subcontractors\subcontractors::add_subcontractors', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->post('insert_subcontractor', 'subcontractors\subcontractors::insert_subcontractor', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->get('view_sub_contractor/(:any)', 'subcontractors\subcontractors::view_sub_contractor/$1', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,edit']);
    $routes->get('delete_contractor/(:any)', 'subcontractors\subcontractors::delete_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,delete']);
    $routes->post('update_subcontractor', 'subcontractors\subcontractors::update_subcontractor', ['filter' => 'Permissionfilter:subcontractor,edit']);






    // Internal Inspectors routes with permission filters
    $routes->get('Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::index', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('add_internal_inspectors', 'Internal_Inspectors\Internal_Inspectors::add_internal_inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->post('insert_Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::insert_Internal_Inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->get('view_internal_inspectors/(:any)', 'Internal_Inspectors\Internal_Inspectors::view_internal_inspectors/$1', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,edit']);
    $routes->get('delete_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::delete_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,delete']);
    $routes->post('update_internal_inspector', 'Internal_Inspectors\Internal_Inspectors::update_internal_inspector', ['filter' => 'Permissionfilter:internal-inspector,edit']);




    // Internal Auditors routes with permission filters
    $routes->get('internal_auditors', 'Internal_auditors\Internal_auditors::index', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('add_internal_auditors', 'Internal_auditors\Internal_auditors::add_internal_auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->post('insert_internal_Auditors', 'Internal_auditors\Internal_auditors::insert_internal_Auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->get('view_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::view_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor,edit']);
    $routes->get('delete_internal_auditors/(:any)', 'Internal_auditors\Internal_auditors::delete_internal_auditors/$1', ['filter' => 'Permissionfilter:internal-auditor,delete']);
    $routes->post('update_internal_auditors', 'Internal_auditors\Internal_auditors::update_internal_auditors', ['filter' => 'Permissionfilter:internal-auditor,edit']);





    // Manuals & Documents routes with permission filters
    $routes->get('manuals_documanents', 'Manuals_and_documants\Manuals_and_documants::index', ['filter' => 'Permissionfilter:manuals-and-documents']);
    $routes->get('add_manuals_documents', 'Manuals_and_documants\Manuals_and_documants::add_manuals_documents', ['filter' => 'Permissionfilter:manuals-and-documents,add']);
    $routes->post('insert_Department', 'Manuals_and_documants\Manuals_and_documants::insert_Department', ['filter' => 'Permissionfilter:manuals-and-documents,add']);
    $routes->get('view_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::view_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents']);
    $routes->get('edit_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::edit_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents,edit']);
    $routes->get('delete_manuvals_and_documants/(:any)', 'Manuals_and_documants\Manuals_and_documants::delete_manuvals_and_documants/$1', ['filter' => 'Permissionfilter:manuals-and-documents,delete']);
    $routes->post('update_manuvals_and_documants', 'Manuals_and_documants\Manuals_and_documants::update_manuvals_and_documants', ['filter' => 'Permissionfilter:manuals-and-documents,edit']);



    // Product Sampling routes with permission filters
    $routes->get('product_sampling', 'Product_sampling\Product_sampling::index', ['filter' => 'Permissionfilter:product-sampling']);
    $routes->get('add_product_sampling', 'Product_sampling\Product_sampling::add_product_sampling', ['filter' => 'Permissionfilter:product-sampling,add']);
    $routes->post('insert_product_Sampling', 'Product_sampling\Product_sampling::insert_product_Sampling', ['filter' => 'Permissionfilter:product-sampling,add']);
    $routes->get('view_product_sampling/(:any)', 'Product_sampling\Product_sampling::view_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling']);
    $routes->get('edit_product_sampling/(:any)', 'Product_sampling\Product_sampling::edit_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling,edit']);
    $routes->get('delete_product_sampling/(:any)', 'Product_sampling\Product_sampling::delete_product_sampling/$1', ['filter' => 'Permissionfilter:product-sampling,delete']);
    $routes->post('update_product_sampling', 'Product_sampling\Product_sampling::update_product_sampling', ['filter' => 'Permissionfilter:product-sampling,edit']);




    // Internal Audit routes with permission filters
    $routes->get('internal_audit', 'Internal_audit\Internal_audit::index', ['filter' => 'Permissionfilter:internal-audit']);
    $routes->get('add_internal_audit', 'Internal_audit\Internal_audit::add_internal_audit', ['filter' => 'Permissionfilter:internal-audit,add']);
    $routes->post('insert_internal_audit', 'Internal_audit\Internal_audit::insert_internal_audit', ['filter' => 'Permissionfilter:internal-audit,add']);
    $routes->get('view_internal_audit/(:any)', 'Internal_audit\Internal_audit::view_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit']);
    $routes->get('edit_internal_audit/(:any)', 'Internal_audit\Internal_audit::edit_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit,edit']);
    $routes->get('delete_internal_audit/(:any)', 'Internal_audit\Internal_audit::delete_internal_audit/$1', ['filter' => 'Permissionfilter:internal-audit,delete']);
    $routes->post('update_internal_audit', 'Internal_audit\Internal_audit::update_internal_audit', ['filter' => 'Permissionfilter:internal-audit,edit']);



    // Certification Body Audit routes with permission filters
    $routes->get('certification_body_audit', 'Certification_body_audit\Certification_body_audit::index', ['filter' => 'Permissionfilter:certification-body-audit']);
    $routes->get('add_Certification_body_audit', 'Certification_body_audit\Certification_body_audit::add_Certification_body_audit', ['filter' => 'Permissionfilter:certification-body-audit,add']);
    $routes->post('cirtificate_body_insert', 'Certification_body_audit\Certification_body_audit::cirtificate_body_insert', ['filter' => 'Permissionfilter:certification-body-audit,add']);
    $routes->get('view_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::view_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit']);
    $routes->get('edit_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::edit_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit,edit']);
    $routes->get('delete_cirtificate_body/(:any)', 'Certification_body_audit\Certification_body_audit::delete_cirtificate_body/$1', ['filter' => 'Permissionfilter:certification-body-audit,delete']);
    $routes->post('update_cirtificate_Audit', 'Certification_body_audit\Certification_body_audit::update_cirtificate_Audit', ['filter' => 'Permissionfilter:certification-body-audit,edit']);




    // Standard Certificate routes with permission filters
    $routes->get('standerd_citificate', 'Standerd_cirtificate\Standerd_cirtificate::index', ['filter' => 'Permissionfilter:standard-certificate']);
    $routes->get('add_new_standerd_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::add_new_standerd_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,add']);
    $routes->post('insert_standerd_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::insert_standerd_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,add']);
    $routes->get('view_standerd_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::view_standerd_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate']);
    $routes->get('edit_standerd_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::edit_standerd_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate,edit']);
    $routes->get('delete_standed_cirtificate/(:any)', 'Standerd_cirtificate\Standerd_cirtificate::delete_standed_cirtificate/$1', ['filter' => 'Permissionfilter:standard-certificate,delete']);
    $routes->post('update_Standed_cirtificate', 'Standerd_cirtificate\Standerd_cirtificate::update_Standed_cirtificate', ['filter' => 'Permissionfilter:standard-certificate,edit']);




    // Role and Designation routes with permission filters
    $routes->get('roll_index', 'Roll\Roll::index', ['filter' => 'Permissionfilter:role']);
    $routes->get('add_new_roll', 'Roll\Roll::add_new_roll', ['filter' => 'Permissionfilter:role,add']);
    $routes->post('insert_roll', 'Roll\Roll::insert_roll', ['filter' => 'Permissionfilter:role,add']);
    $routes->get('view_role/(:any)', 'Roll\Roll::view_role/$1', ['filter' => 'Permissionfilter:role']);
    $routes->get('edit_roll/(:any)', 'Roll\Roll::edit_roll/$1', ['filter' => 'Permissionfilter:role,edit']);
    $routes->get('delete_roll/(:any)', 'Roll\Roll::delete_roll/$1', ['filter' => 'Permissionfilter:role,delete']);
    $routes->post('update_role', 'Roll\Roll::update_role', ['filter' => 'Permissionfilter:role,edit']);


    $routes->get('audit_maping', 'Audit_maping\Audit_maping::index', ['filter' => 'Permissionfilter:audit-mapping']);
    $routes->get('add_audit_mapping', 'Audit_maping\Audit_maping::add_audit_mapping', ['filter' => 'Permissionfilter:audit-mapping,add']);
    $routes->post('insert_audit_mapping', 'Audit_maping\Audit_maping::insert_audit_mapping', ['filter' => 'Permissionfilter:audit-mapping,add']);
    $routes->post('update_audit_template_subscribed_version', 'Audit_maping\Audit_maping::update_audit_template_subscribed_version', ['filter' => 'Permissionfilter:audit-mapping,edit']);
    $routes->get('edit_subscribed_template_audit_mapping/(:num)', 'Audit_maping\Audit_maping::edit_subscribed_template_audit_mapping/$1', ['filter' => 'Permissionfilter:audit-mapping,edit']);
    $routes->get('view_audit_subcribed_template/(:num)', 'Audit_maping\Audit_maping::view_audit_subcribed_template/$1', ['filter' => 'Permissionfilter:audit-mapping']);
    $routes->get('view_audit_log/(:num)', 'Audit_maping\Audit_maping::view_audit_log/$1', ['filter' => 'Permissionfilter:audit-mapping']);
    //  $routes->get('audit_maping', 'Audit_maping\Audit_maping::index', ['filter' => 'Permissionfilter:role-and-designation']);






});
$routes->group('audit_company_afl', ['filter' => 'authGuard:audit_company'], function ($routes) {
    $routes->get('/', 'Audit_company::index');


    $routes->post('toggleAutoId', 'Audit_company::toggleAutoId');
    $routes->get('org_Profile', 'Audit_company::org_Profile', ['filter' => 'Permissionfilter:organization-profile-page']);
    $routes->get('verify_otp', 'Audit_company::verify_otp', ['filter' => 'Permissionfilter:organization-profile-page,edit']);


    $routes->post('org_Profile', 'Audit_company::org_profile_edit', ['filter' => 'Permissionfilter:organization-profile-page,edit']);
    $routes->post('verify_otp', 'Audit_company::verify_otp_and_update_profile', ['filter' => 'Permissionfilter:organization-profile-page,edit']);

    // for personal edit screen 














    $routes->get('personal_contact_edit/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1');
    $routes->get('personal_employee_edit_screen/(:any)', 'Employees\Employees::edit_employee/$1');
    $routes->get('personal_edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1');
    $routes->get('personal_edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1');

    $routes->get('personal_edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1');


    //    for contact person 
    $routes->get('Contact_Person', 'ContactPerson\ContactPerson::Contact_Person', ['filter' => 'Permissionfilter:contact-person']);
    $routes->get('add_Contact_Person', 'ContactPerson\ContactPerson::add_Contact_Person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->get('view_edit_contact_person/(:any)', 'ContactPerson\ContactPerson::view_edit_screen/$1', ['filter' => 'Permissionfilter:contact-person,edit']);
    $routes->get('delete_contact_person/(:any)', 'ContactPerson\ContactPerson::delete_contact_person/$1', ['filter' => 'Permissionfilter:contact-person,delete']);

    $routes->post('insert_contact_person', 'ContactPerson\ContactPerson::insert_contact_person', ['filter' => 'Permissionfilter:contact-person,add']);
    $routes->post('edit_contact_person', 'ContactPerson\ContactPerson::edit_contact_screen', ['filter' => 'Permissionfilter:contact-person,edit']);


    //    for certificate   

    $routes->get('certificate', 'Certificate\Certificate::index', ['filter' => 'Permissionfilter:certificate']);
    $routes->post('add_certificate', 'Certificate\Certificate::add_certificate', ['filter' => 'Permissionfilter:certificate,add']);
    $routes->post('give_data_for_edit_cirtificate', 'Certificate\Certificate::give_certificate_data', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->post('update_cirtificate', 'Certificate\Certificate::update_cirtificate', ['filter' => 'Permissionfilter:certificate,edit']);
    $routes->get('delete_cirtificate/(:any)', 'Certificate\Certificate::delete_cirtificate/$1', ['filter' => 'Permissionfilter:certificate,delete']);




    // Skill routes with permission filters
    $routes->get('skills', 'Skill\Skill::index', ['filter' => 'Permissionfilter:skill']);
    $routes->get('add_skill', 'Skill\Skill::add_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->post('insert_skill', 'Skill\Skill::insert_skill', ['filter' => 'Permissionfilter:skill,add']);
    $routes->get('edit_skill/(:any)', 'Skill\Skill::edit_skill/$1', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->post('update_skill', 'Skill\Skill::update_skill', ['filter' => 'Permissionfilter:skill,edit']);
    $routes->get('delete_skill/(:any)', 'Skill\Skill::delete_skill/$1', ['filter' => 'Permissionfilter:skill,delete']);


    // Department routes with permission filters
    $routes->get('department', 'Departement\Departement::index', ['filter' => 'Permissionfilter:department']);
    $routes->get('add_department', 'Departement\Departement::add_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->post('insert_department', 'Departement\Departement::insert_department', ['filter' => 'Permissionfilter:department,add']);
    $routes->get('edit_department/(:any)', 'Departement\Departement::edit_department/$1', ['filter' => 'Permissionfilter:department,edit']);
    $routes->post('update_department', 'Departement\Departement::update_department', ['filter' => 'Permissionfilter:department,edit']);
    $routes->get('delete_department/(:any)', 'Departement\Departement::delete_department/$1', ['filter' => 'Permissionfilter:department,delete']);

    // Employee routes with permission filters
    $routes->get('employees', 'Employees\Employees::index', ['filter' => 'Permissionfilter:employment']);
    $routes->get('add_employess', 'Employees\Employees::add_employess', ['filter' => 'Permissionfilter:employment,add']);
    $routes->post('insert_employee', 'Employees\Employees::insert_employee', ['filter' => 'Permissionfilter:employment,add']);
    $routes->get('view_employee/(:any)', 'Employees\Employees::view_employee/$1', ['filter' => 'Permissionfilter:employment']);
    $routes->get('edit_employee/(:any)', 'Employees\Employees::edit_employee/$1', ['filter' => 'Permissionfilter:employment,edit']);
    $routes->post('update_employee', 'Employees\Employees::update_employee', ['filter' => 'Permissionfilter:employment,edit']);
    $routes->get('delete_employee/(:any)', 'Employees\Employees::delete_employee/$1', ['filter' => 'Permissionfilter:employment,delete']);




    // Subcontractor routes with permission filters
    $routes->get('subcontractors', 'subcontractors\subcontractors::index', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('add_subcontractors', 'subcontractors\subcontractors::add_subcontractors', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->post('insert_subcontractor', 'subcontractors\subcontractors::insert_subcontractor', ['filter' => 'Permissionfilter:subcontractor,add']);
    $routes->get('view_sub_contractor/(:any)', 'subcontractors\subcontractors::view_sub_contractor/$1', ['filter' => 'Permissionfilter:subcontractor']);
    $routes->get('edit_contractor/(:any)', 'subcontractors\subcontractors::edit_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,edit']);
    $routes->get('delete_contractor/(:any)', 'subcontractors\subcontractors::delete_contractor/$1', ['filter' => 'Permissionfilter:subcontractor,delete']);
    $routes->post('update_subcontractor', 'subcontractors\subcontractors::update_subcontractor', ['filter' => 'Permissionfilter:subcontractor,edit']);






    // Internal Inspectors routes with permission filters
    $routes->get('Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::index', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('add_internal_inspectors', 'Internal_Inspectors\Internal_Inspectors::add_internal_inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->post('insert_Internal_Inspectors', 'Internal_Inspectors\Internal_Inspectors::insert_Internal_Inspectors', ['filter' => 'Permissionfilter:internal-inspector,add']);
    $routes->get('view_internal_inspectors/(:any)', 'Internal_Inspectors\Internal_Inspectors::view_internal_inspectors/$1', ['filter' => 'Permissionfilter:internal-inspector']);
    $routes->get('edit_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::edit_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,edit']);
    $routes->get('delete_internal_inspector/(:any)', 'Internal_Inspectors\Internal_Inspectors::delete_internal_inspector/$1', ['filter' => 'Permissionfilter:internal-inspector,delete']);
    $routes->post('update_internal_inspector', 'Internal_Inspectors\Internal_Inspectors::update_internal_inspector', ['filter' => 'Permissionfilter:internal-inspector,edit']);




    // Role and Designation routes with permission filters
    $routes->get('roll_index', 'Roll\Roll::index', ['filter' => 'Permissionfilter:role']);
    $routes->get('add_new_roll', 'Roll\Roll::add_new_roll', ['filter' => 'Permissionfilter:role,add']);
    $routes->post('insert_roll', 'Roll\Roll::insert_roll', ['filter' => 'Permissionfilter:role,add']);
    $routes->get('view_role/(:any)', 'Roll\Roll::view_role/$1', ['filter' => 'Permissionfilter:role']);
    $routes->get('edit_roll/(:any)', 'Roll\Roll::edit_roll/$1', ['filter' => 'Permissionfilter:role,edit']);
    $routes->get('delete_roll/(:any)', 'Roll\Roll::delete_roll/$1', ['filter' => 'Permissionfilter:role,delete']);
    $routes->post('update_role', 'Roll\Roll::update_role', ['filter' => 'Permissionfilter:role,edit']);


    // Internal Auditors routes with permission filters
    $routes->get('internal_auditors', 'Internal_auditors\Internal_auditors::index', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('add_internal_auditors', 'Internal_auditors\Internal_auditors::add_internal_auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->post('insert_internal_Auditors', 'Internal_auditors\Internal_auditors::insert_internal_Auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->get('view_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::view_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('edit_internal_auditor/(:any)', 'Internal_auditors\Internal_auditors::edit_internal_auditor/$1', ['filter' => 'Permissionfilter:internal-auditor,edit']);
    $routes->get('delete_internal_auditors/(:any)', 'Internal_auditors\Internal_auditors::delete_internal_auditors/$1', ['filter' => 'Permissionfilter:internal-auditor,delete']);
    $routes->post('update_internal_auditors', 'Internal_auditors\Internal_auditors::update_internal_auditors', ['filter' => 'Permissionfilter:internal-auditor,edit']);



    //   Auditors routes with permission filters
    $routes->get('auditor', 'Auditors\Auditors::index', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('add_auditors', 'Auditors\Auditors::add_auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->post('insert_Auditors', 'Auditors\Auditors::insert_Auditors', ['filter' => 'Permissionfilter:internal-auditor,add']);
    $routes->get('view__auditor/(:any)', 'Auditors\Auditors::view__auditor/$1', ['filter' => 'Permissionfilter:internal-auditor']);
    $routes->get('edit__auditor/(:any)', 'Auditors\Auditors::edit__auditor/$1', ['filter' => 'Permissionfilter:internal-auditor,edit']);
    $routes->get('delete__auditors/(:any)', 'Auditors\Auditors::delete__auditors/$1', ['filter' => 'Permissionfilter:internal-auditor,delete']);
    $routes->post('update__auditors', 'Auditors\Auditors::update__auditors', ['filter' => 'Permissionfilter:internal-auditor,edit']);




    //   audit_template_creation

    $routes->get('audit_template', 'Audit_template\Audit_template::index', ['filter' => 'Permissionfilter:audit-template']);
    $routes->get('add_new_audit_Template', 'Audit_template\Audit_template::add_new_audit_Template', ['filter' => 'Permissionfilter:audit-template,add']);
    $routes->post('insert_audit_template', 'Audit_template\Audit_template::insert_audit_template', ['filter' => 'Permissionfilter:audit-template,add']);
    $routes->get('view_audit_template/(:any)', 'Audit_template\Audit_template::view_audit_template/$1', ['filter' => 'Permissionfilter:audit-template']);
    $routes->get('edit_audit_template/(:any)', 'Audit_template\Audit_template::edit_audit_template/$1', ['filter' => 'Permissionfilter:audit-template,edit']);
    $routes->get('delete_audit_template/(:any)', 'Audit_template\Audit_template::delete_audit_template/$1', ['filter' => 'Permissionfilter:audit-template,delete']);
    $routes->post('update_audit_template', 'Audit_template\Audit_template::update_audit_template', ['filter' => 'Permissionfilter:audit-template,edit']);


    //  review audit template

    $routes->get('review_audit', 'Review_audit_template\Review_audit_template::index', ['filter' => 'Permissionfilter:review-audit']);

    $routes->get('review_the_template/(:any)', 'Review_audit_template\Review_audit_template::review_the_template/$1', ['filter' => 'Permissionfilter:review-audit,edit']);
    $routes->get('view_audit_subcribed_template_auditor/(:any)', 'Review_audit_template\Review_audit_template::view_audit_subcribed_template_auditor/$1', ['filter' => 'Permissionfilter:review-audit']);
    $routes->get('audit_log_show_auditor_version/(:any)', 'Review_audit_template\Review_audit_template::audit_log_show_auditor_version/$1', ['filter' => 'Permissionfilter:review-audit,edit']);
    $routes->post('update_subscribed_template', 'Review_audit_template\Review_audit_template::update_subscribed_template', ['filter' => 'Permissionfilter:review-audit,edit']);


    // more routes
});