<?php

namespace App\Controllers;

use App\Models\Loginmodel;
use CodeIgniter\Database\Exceptions\DataException;
use App\Models\Farmer_module;

class AdminController extends BaseController
{






    public function toggleAutoId()
    {

        $newValue = $this->request->getPost('value');
        $entityId = session()->get('entity_id');

        // Example update
        $db = \Config\Database::connect();
        $db->table('entity_profiles')
            ->where('id', $entityId)
            ->update(['audo_id_gendrator' => $newValue]);

        return $this->response->setJSON(['status' => 'success', 'newValue' => $newValue]);
    }


    public function verify_otp_and_update_profile()
    {


        $inputOtp = $this->request->getPost('otp');

        $inputOtp = (int)$inputOtp;

        // echo gettype(session()->get('otp_code'));



        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {
                // session()->remove('otp_code');

                $tableName = session()->get('table');
                $insertId = session()->get('entity_id');

                $data_to_update = session()->get('updated_data');

                $loginModel = new Loginmodel();
                $session = session();
                $id = $session->get('entity_id'); // or session('id');
                // var_dump($data_to_update);

                if (session()->get('is_file_uploaded') === true && session()->has('file_path')) {

                    $tempPath = FCPATH . session()->get('file_path'); // full path from session


                    $destinationDir = FCPATH . "uploads/entity_profile/{$insertId}/logo/";
                    $fileName = basename($tempPath);

                    $newFilePath = $destinationDir . $fileName;

                    if (rename($tempPath, $newFilePath)) {
                        // ✅ Move successful, you can update DB or continue process
                        // Optionally unset session






                        $organization = $loginModel->find($id);

                        $oldFilePath = FCPATH . $organization['company_logo'];
                        if (is_file($oldFilePath)) {
                            unlink($oldFilePath);
                        }

                        // Update new file path in DB (relative path)
                        $relativePath = "uploads/entity_profile/{$id}/logo/" . $fileName;
                        $loginModel->update($id, ['company_logo' => $relativePath]);
                        // var_dump($newFilePath);
                        // session()->remove('is_file_uploaded');
                        // session()->remove('file_path');
                    } else {
                        // ❌ Failed to move
                        log_message('error', 'Failed to move uploaded file to organization folder.');
                    }
                }
                session()->remove('otp_code');
                if ($loginModel->update($id, $data_to_update)) {




                    $db = \Config\Database::connect();

                    // Define the data to update
                    $data = [
                        'name_of_the_user' => $data_to_update['establishment_name'],

                    ];

                    // Specify the condition for which the record should be updated
                    $builder = $db->table('register_log');

                    // Perform the update
                    $builder->set($data)
                        ->where('user_id', $id)  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->where('user_table', 'entity_profiles')  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->update();




                    return redirect()->to('admin/settings')->with('success', 'Profile data updated successfully!');
                } else {
                    return redirect()->back()->with('error', 'Failed to update data');
                }



                // return redirect()->to('entity_login')->with('success', 'Account created successfully.');
            } else {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }
        } else {
            return redirect()->back()->with('error', 'OTP expired.');
        }
    }



    public function verify_otp()
    {

        return view('admin/verify_otp');
    }
    public function index()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        // var_dump($organization);
        return view('admin/index', ['organization' => $organization]);
    }



    public function org_Profile()
    {

        $session = session();


        $id = $session->get('entity_id');
        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        // var_dump($organization);
        return view('admin/org_profile_page', ['organization' => $organization]);
    }


    public function org_profile_edit()
    {

        $rules = [
            'comp_name' => [
                'label' => 'Establishment Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],

            'legal_identity' => [
                'label' => 'Legal Identity',
                'rules' => 'required|in_list[Private Limited,Public Company,Partnership,Limited Liability Company]',
                'errors' => [
                    'required' => 'Please select the legal identity.',
                    'in_list' => 'Legal identity must be one of: Private Limited, Public Company, Partnership, or Limited Liability Company.',
                ]
            ],

            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Registration_number' => [
                'label' => 'Registration Number',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'gst_registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'income_tax_pan_no' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                ]
            ],
            'income_tax_tan_no' => [
                'label' => 'Income Tax TAN Number',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax TAN Number must be alphanumeric.',
                    'max_length' => 'Income Tax TAN Number must not exceed 15 characters.',
                ]
            ],

            'adress_1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'address_2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'country' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'state' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'city' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Pincode' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'contact_number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],

            'contact_number_fixed_line' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'email' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|unique_email_across_tables_on_update[entity_profiles.email]',
                'errors' => [
                    'required' => 'Email is required.', 
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email ID is already registered. Please use another one.',
                    'unique_email_across_tables_on_update' => 'This email ID is already registered for the selected user type.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'permit_empty|min_length[8]',
                'errors' => [
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ],


            'comp_logo' => [
                'label' => 'Company Logo',
                'rules' => 'permit_empty|is_image[comp_logo]'
                    . '|mime_in[comp_logo,image/jpeg,image/png,image/jpg]'
                    . '|ext_in[comp_logo,jpg,jpeg,png]'
                    . '|max_size[comp_logo,5120]',
                'errors' => [
                    'is_image' => 'The file must be a valid image.',
                    'mime_in' => 'Only JPEG and PNG images are allowed.',
                    'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
                    'max_size' => 'The image size must not exceed 5MB.',
                ]
            ]

        ];

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
            // var_dump($this->validator->listErrors());
        }
        session()->set('is_file_uploaded', false);

        $data = [
            'establishment_name' => $this->request->getPost('comp_name'),
            'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
            'registration_number' => $this->request->getPost('Registration_number'),
            'gstin_or_vat_id' => $this->request->getPost('gst_registration'),
            // 'company_logo' => $logoName,
            'employer_income_tax_number' => $this->request->getPost('income_tax_pan_no'),
            // 'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
            'address_line1' => $this->request->getPost('adress_1'),
            'address_line2' => $this->request->getPost('address_2'),
            'village' => $this->request->getPost('village'),
            'country' => $this->request->getPost('country'),
            'state' => $this->request->getPost('state'),
            'city' => $this->request->getPost('city'),
            'pin_code' => $this->request->getPost('Pincode'),
            'contact_mobile' => $this->request->getPost('contact_number_mobile'),
            'contact_fixedline' => $this->request->getPost('contact_number_fixed_line'),
            'email' => $this->request->getPost('email'),
            'Legal_identity' => $this->request->getPost('legal_identity'),
            'updated_by' => session()->get('logined_user_id'),
            'Income_Tax_TAN_No' =>  session()->get('income_tax_tan_no'),



        ];

        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }


        // var_dump($data);

        // die();

        $logo = $this->request->getFile('comp_logo');


        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            // Re-validate file type for double safety (optional)
            $ext = $logo->getClientExtension();
            if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
                session()->set('validation_errors', "Invalid file type uploaded.");
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds




                return redirect()->back()->withInput();
            }

            $logoName = $logo->getRandomName();
            $logoDir = "uploads/temp/logo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file to destination
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            session()->set('is_file_uploaded', true);
            session()->set('file_path', $relativePath);
        }

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);

        // 1. Generate 6-digit OTP
        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($organization['email']);
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $organization['establishment_name'] . '!</h3>
        <p>Your One-Time Password (OTP) for updating profile is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {

            var_dump($data);
            session()->set('otp_code', $otp);

            session()->set('updated_data', $data);
            session()->set('reciver_email', $organization['email']);
            session()->set('user_name', $organization['establishment_name']);
            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

            return redirect()->to('admin/verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }


    public function entities()
    {
        $session = session();
        $id = $session->get('entity_id');
        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
        return view('admin/entities/index', ['organization' => $organization]);

    }

    
    public function ajax_update_entity_status()
{
    if ($this->request->isAJAX()) {
        $id = $this->request->getPost('id');
        $status = $this->request->getPost('status');

        $builder = \Config\Database::connect()->table('entity_profiles');

        $updated = $builder->where('id', $id)->update(['status' => $status]);

        if ($updated) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'DB update failed']);
        }
    }

    return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
}


public function ajax_update_farmer_status()
{
    if ($this->request->isAJAX()) {
        $id = $this->request->getPost('id');
        $status = $this->request->getPost('status');

        $builder = \Config\Database::connect()->table('farmers');

        $updated = $builder->where('id', $id)->update(['status' => $status]);

        if ($updated) {
            return $this->response->setJSON(['success' => true]);
        } else {
            return $this->response->setJSON(['success' => false, 'message' => 'DB update failed']);
        }
    }

    return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
}

public function login_as_entity($id){

        $session = session(); 

        $admin_id = session()->get('logined_user_id');
        $admin_table           = session()->get('table');
        $admin_user_email      = session()->get('user_email');
        $admin_user_associated = session()->get('user_associated');
        $admin_entity_id       = session()->get('entity_id');
        $admin_this_is_entity_login = session()->get('this_is_entity_login');
        $admin_table = session()->get('table');
        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
        session()->set([
            'admin_id'        => $admin_id,
            'admin_table'     => $admin_table,
            'admin_user_email'     => $admin_user_email,
            'admin_user_associated'     => $admin_user_associated,
            'admin_entity_id'     => $admin_entity_id,
            'admin_this_is_entity_login'     => $admin_this_is_entity_login,
            'is_logged_as_admin' => true,
            'logined_user_id' => $organization["id"],
            'user_email' => $organization['email'],
            'user_associated' => $organization['user_type'],
            'table' => "entity_profiles",
            'entity_id' => $organization['id'],
            'this_is_entity_login' => true,
            'isLoggedIn' => true
        ]);



        switch (session()->get('user_associated')) {
            case "organisation":
                return redirect()->to('/organization');
            case "fpo":
                return redirect()->to('/Fpo');
            case "audit_company":
                return redirect()->to('/audit_company_afl');
            case "app_user":
                return redirect()->to('/admin');
            default: 

            return redirect()->to('/admin')->with('error', 'Invalid login type.');
        }
}


public function exit(){

    $session = session(); 

    $admin_id = session()->get('admin_id');
    $loginModel = new Loginmodel();
    $organization = $loginModel->find($admin_id);
    session()->set([
        'logined_user_id' => $organization["id"],
        'user_email' => $organization['email'],
        'user_associated' => $organization['user_type'],
        'table' => "entity_profiles",
        'entity_id' => $organization['id'],
        'this_is_entity_login' => true,
        'isLoggedIn' => true
    ]);
    return redirect()->to('/admin');
        
 }

public function login_as_farmer($id){

    $session               = session(); 

    $admin_id              = session()->get('logined_user_id');
    $admin_table           = session()->get('table');
    $admin_user_email      = session()->get('user_email');
    $admin_user_associated = session()->get('user_associated');
    $admin_entity_id       = session()->get('entity_id');
    $admin_this_is_entity_login = session()->get('this_is_entity_login');

    $db                 = \Config\Database::connect();
    $builder            = $db->table('farmers');
    $row                = $builder->select('*')
                          ->where('id', $id) // filter by specific ID
                          ->where('associated_by','farmers')
                          ->get()
                          ->getRowArray(); // get single row as associative array

    session()->set([
        'admin_id'        => $admin_id,
        'admin_table'     => $admin_table,
        'admin_user_email'     => $admin_user_email,
        'admin_user_associated'     => $admin_user_associated,
        'admin_entity_id'     => $admin_entity_id,
        'admin_this_is_entity_login'     => $admin_this_is_entity_login,
        'is_logged_as_admin' => true,
        'admin_table'     => $admin_table,
        'logined_user_id' => $row["id"],
        'user_email' => $row['email'],
        'user_associated' => 'farmers',
        'user_type' => "farmers",
        'table' => "farmers",
        'entity_id' => $row['id'],
        'this_is_entity_login' => true,
        'isLoggedIn' => true
    ]);
    return redirect()->to('/farmer_login'); 

}


public function add_entity(){

    $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        // var_dump($organization);
    return view('admin/entities/add', ['organization' => $organization]);
}


public function insert_entity(){

    $throttler = \Config\Services::throttler();
        $ip = $this->request->getIPAddress();
        $sanitizedKey = 'throttler_' . md5($ip); // or hash anything else like username/email
        $throttler->check($sanitizedKey, 5, 60);
        // var_dump($_POST);

        // helper(['form', 'url']);

        $rules = [
            'Organization_name' => [
                'label' => 'Establishment Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],
            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Organization_Registration_Number' => [
                'label' => 'Registration Number',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'GST_Registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                    'required' => 'GSTIN / VAT ID number is required.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'Income_Tax_PAN_No' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                    'required' => 'Employer Income Tax  number is required.',
                ]
            ],
            'income_tax_tan_no' => [
                'label' => 'Income Tax TAN Number',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax TAN Number must be alphanumeric.',
                    'max_length' => 'Income Tax TAN Number must not exceed 15 characters.',
                    'required' => 'Income Tax TAN Number  number is required.',
                ]
            ],

            'Office_Address1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'Office_Address2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'Office_Village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'cuntry' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'State' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'City' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Office_PIN_Code' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'Office_Contact_Mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                    'required' => 'Mobile Number is required.',
                ]
            ],

            'contact_fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],
            'entity_type' => [
                'label' => 'User Type',
                'rules' => 'required|in_list[organisation,fpo,audit_company]',
                'errors' => [
                    'required' => 'Please select a user type.',
                    'in_list' => 'User type must be Organisation, FPO, or Audit Company.',
                ]
            ],

            'Email_id' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email||unique_entity_email_with_type[{entity_type}]',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email ID is already registered. Please use another one.',
                    'unique_entity_email_with_type' => 'This email ID is already registered for the selected user type.',
                ]
            ],
            'password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ],
            'Company_Logo' => [
                'label' => 'Company Logo',
                'rules' => 'uploaded[Company_Logo]'
                    . '|is_image[Company_Logo]'
                    . '|mime_in[Company_Logo,image/jpeg,image/png]'
                    . '|ext_in[Company_Logo,jpg,jpeg,png]'
                    . '|max_size[Company_Logo,5120]', // 5120 KB = 5 MB
                'errors' => [
                    'uploaded' => 'Please upload a company logo.',
                    'is_image' => 'The file must be an image.',
                    'mime_in' => 'Only JPEG and PNG images are allowed.',
                    'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
                    'max_size' => 'The image size must not exceed 5MB.',
                ]
            ],
        ];


        // if (!$this->validate($rules)) {
        //     return redirect()->back()->withInput()->with('validation', $this->validator);
        // }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }

        $model = new Loginmodel();
        $data = [
            'establishment_name' => $this->request->getPost('Organization_name'),
            'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
            'registration_number' => $this->request->getPost('Organization_Registration_Number'),
            'Income_Tax_TAN_No	' => $this->request->getPost('GST_Registration'),
            // 'company_logo' => $logoName,
            'employer_income_tax_number' => $this->request->getPost('Income_Tax_PAN_No'),
            'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
            'address_line1' => $this->request->getPost('Office_Address1'),
            'address_line2' => $this->request->getPost('Office_Address2'),
            'village' => $this->request->getPost('Office_Village'),
            'country' => $this->request->getPost('cuntry'),
            'state' => $this->request->getPost('State'),
            'city' => $this->request->getPost('City'),
            'pin_code' => $this->request->getPost('Office_PIN_Code'),
            'contact_mobile' => $this->request->getPost('Office_Contact_Mobile'),
            'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            'email' => $this->request->getPost('Email_id'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'user_type' => $this->request->getPost('entity_type'),
            'status'=> 1,
            'Income_Tax_TAN_No'=> $this->request->getPost('income_tax_tan_no')
        ];

        // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

        $logo = $this->request->getFile('Company_Logo');
        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            $logoName = $logo->getRandomName();
            $logoDir = "uploads/entity_profile/{$insertId}/logo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            // Update DB with logo path
            $model->update($insertId, ['company_logo' => $relativePath]);
        }

        
                $db = \Config\Database::connect();
                
                // Step 2: Insert into thamil_krishigap table
                $logBuilder = $db->table('register_log');
                $logBuilder->insert([
                    'user_id'    => $insertId,
                    'user_table' => 'entity_profiles',
                    'name_of_the_user' => $this->request->getPost('Organization_name')
                ]);


        return redirect()->to('admin/entities?entity_type=all&entity_status=1')->with('success', 'Added successful!');

}

public function edit_entity($id)
{

    $session = session();


    $e_id = $session->get('entity_id');
    $loginModel = new Loginmodel();

    $organization = $loginModel->find($e_id);
    $entity       = $loginModel->find($id);


    // var_dump($organization);
    return view('admin/entities/edit', ['organization' => $organization,'entity'=>$entity]);
}

public function update_entity($id){

    $throttler = \Config\Services::throttler();
        $ip = $this->request->getIPAddress();
        $sanitizedKey = 'throttler_' . md5($ip); // or hash anything else like username/email
        $throttler->check($sanitizedKey, 5, 60);
        // var_dump($_POST);

        // helper(['form', 'url']);

        $rules = [
            'Organization_name' => [
                'label' => 'Establishment Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],
            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Organization_Registration_Number' => [
                'label' => 'Registration Number',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'GST_Registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                    'required' => 'GSTIN / VAT ID number is required.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'Income_Tax_PAN_No' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                    'required' => 'Employer Income Tax  number is required.',
                ]
            ],
            'income_tax_tan_no' => [
                'label' => 'Income Tax TAN Number',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax TAN Number must be alphanumeric.',
                    'max_length' => 'Income Tax TAN Number must not exceed 15 characters.',
                    'required' => 'Income Tax TAN Number  number is required.',
                ]
            ],

            'Office_Address1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'Office_Address2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'Office_Village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'cuntry' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'State' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'City' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Office_PIN_Code' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'Office_Contact_Mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                    'required' => 'Mobile Number is required.',
                ]
            ],

            'contact_fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'Email_id' => [
    'label' => 'Email ID',
    'rules' => "required|valid_email|is_unique[entity_profiles.email,id,{$id}]",
    'errors' => [
        'required' => 'Email is required.',
        'valid_email' => 'Please enter a valid email address.',
        'max_length' => 'Email must not exceed 50 characters.',
        'is_unique' => 'This email ID is already registered. Please use another one.',
    ]
]

        ];


        // if (!$this->validate($rules)) {
        //     return redirect()->back()->withInput()->with('validation', $this->validator);
        // }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }

        $loginModel = new Loginmodel();
        $data = [
            'establishment_name' => $this->request->getPost('Organization_name'),
            'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
            'registration_number' => $this->request->getPost('Organization_Registration_Number'),
            'Income_Tax_TAN_No	' => $this->request->getPost('GST_Registration'),
            // 'company_logo' => $logoName,
            'employer_income_tax_number' => $this->request->getPost('Income_Tax_PAN_No'),
            'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
            'address_line1' => $this->request->getPost('Office_Address1'),
            'address_line2' => $this->request->getPost('Office_Address2'),
            'village' => $this->request->getPost('Office_Village'),
            'country' => $this->request->getPost('cuntry'),
            'state' => $this->request->getPost('State'),
            'city' => $this->request->getPost('City'),
            'pin_code' => $this->request->getPost('Office_PIN_Code'),
            'contact_mobile' => $this->request->getPost('Office_Contact_Mobile'),
            'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            'email' => $this->request->getPost('Email_id'),
            'user_type' => $this->request->getPost('entity_type'),
            'Income_Tax_TAN_No'=> $this->request->getPost('income_tax_tan_no')
        ];


        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }

        // var_dump($data);
        $loginModel->update($id,$data);
        $insertId = $id;

        $logo = $this->request->getFile('Company_Logo');
        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            $logoName = $logo->getRandomName();
            $logoDir = "uploads/entity_profile/{$insertId}/logo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            // Update DB with logo path
            $model->update($insertId, ['company_logo' => $relativePath]);
        }

        
               


        return redirect()->to('admin/entities?entity_type=all&entity_status=1')->with('success', 'Updated successful!');

}


public function farmer()
    {
        $session = session();
        $id = $session->get('entity_id');
        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
        return view('admin/Farmer/index', ['organization' => $organization]);

    }


    public function add_farmer(){

        $session = session();
            $id = $session->get('entity_id'); // or session('id');
    
            $loginModel = new Loginmodel();
    
            $organization = $loginModel->find($id);
    
    
            // var_dump($organization);
        return view('admin/Farmer/add', ['organization' => $organization]);
    }

public function insert_farmer(){

    $throttler = \Config\Services::throttler();
        $ip = $this->request->getIPAddress();
        $sanitizedKey = 'throttler_' . md5($ip); // or hash anything else like username/email
        $throttler->check($sanitizedKey, 5, 60);
        // var_dump($_POST);

        // helper(['form', 'url']);

        $rules = [
            'Title' => [
                'label' => 'Title',
                'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
                'errors' => [
                    'in_list' => 'Title must be Mr, Mrs, or Ms.',
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'First name is required.',
                    'max_length' => 'First name must not exceed 30 characters.',
                ]
            ],
            'middle_name' => [
                'label' => 'Middle Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Middle name must not exceed 30 characters.',
                ]
            ],
            'last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Last name must not exceed 30 characters.',
                ]
            ],
            'Date_of_Birth' => [
                'label' => 'Date of Birth',
                'rules' => 'permit_empty|valid_date',
                'errors' => [
                    'valid_date' => 'Please enter a valid date.',
                ]
            ],
            'Income_Tax_Number' => [
                'label' => 'Income Tax Number',
                'rules' => 'required|alpha_numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Income Tax Number is required.',
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'exact_length' => 'Income Tax Number must be exactly 10 characters.',
                ]
            ],

            // Permanent Address
            'Permanent_Address1' => [
                'label' => 'Permanent Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Permanent Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Address2' => [
                'label' => 'Permanent Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Village' => [
                'label' => 'Permanent Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Permanent_cuntry' => [
                'label' => 'Permanent Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent country.',
                ]
            ],
            'Permanent_State' => [
                'label' => 'Permanent State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent state.',
                ]
            ],
            'Permanent_city' => [
                'label' => 'Permanent City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent city.',
                ]
            ],
            'Permanent_PIN_Code' => [
                'label' => 'Permanent PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Communication Address
            'Communication_Address1' => [
                'label' => 'Communication Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Communication Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Address2' => [
                'label' => 'Communication Address Line 2',
                'rules' => 'required',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Village' => [
                'label' => 'Communication Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Communication_cuntry' => [
                'label' => 'Communication Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication country.',
                ]
            ],
            'Communication_State' => [
                'label' => 'Communication State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication state.',
                ]
            ],
            'Communication_City' => [
                'label' => 'Communication City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication city.',
                ]
            ],
            'Communication_PIN_Code' => [
                'label' => 'Communication PIN Code',
                'rules' => 'required',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Contact Info
            'Contact_Number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Mobile number is required.',
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],
            'Contact_Number_Fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'Email_id' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|unique_farmer_email[farmers]',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'unique_farmer_email' => 'This email is already registered.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ]
        ];


        // if (!$this->validate($rules)) {
        //     return redirect()->back()->withInput()->with('validation', $this->validator);
        // }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }

           


            $data = [
                'title' => $this->request->getPost('Title'),
                'first_name' => $this->request->getPost('first_name'),
                'middle_name' => $this->request->getPost('middle_name'),
                'last_name' => $this->request->getPost('last_name'),
                'dob' => $this->request->getPost('Date_of_Birth'),
                'income_tax_number' => $this->request->getPost('Income_Tax_Number'),

                // Permanent Address
                'permanent_address1' => $this->request->getPost('Permanent_Address1'),
                'permanent_address2' => $this->request->getPost('Permanent_Address2'),
                'permanent_village' => $this->request->getPost('Permanent_Village'),
                'permanent_country' => $this->request->getPost('Permanent_cuntry'),
                'permanent_state' => $this->request->getPost('Permanent_State'),
                'permanent_city' => $this->request->getPost('Permanent_City'),
                'permanent_pincode' => $this->request->getPost('Permanent_PIN_Code'),

                // Communication Address
                'communication_address1' => $this->request->getPost('Communication_Address1'),
                'communication_address2' => $this->request->getPost('Communication_Address2'),
                'communication_village' => $this->request->getPost('Communication_Village'),
                'communication_country' => $this->request->getPost('Communication_cuntry'),
                'communication_state' => $this->request->getPost('Communication_State'),
                'communication_city' => $this->request->getPost('Communication_City'),
                'communication_pincode' => $this->request->getPost('Communication_PIN_Code'),

                // Contact Info
                'contact_mobile' => $this->request->getPost('Contact_Number_mobile'),
                'contact_fixedline' => $this->request->getPost('Contact_Number_Fixedline'),

                // Credentials
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'email' => $this->request->getPost('Email_id'),
                'status'=> 1
            ];
            $model = new Farmer_module();
            $model->insert($data);
            $insertId = $model->getInsertID();
            $db = \Config\Database::connect();
            $logBuilder = $db->table('register_log');
            $logBuilder->insert([
                    'user_id'    => $insertId,
                    'user_table' => 'farmers',
                    'name_of_the_user' => $this->request->getPost('first_name')
            ]);
        return redirect()->to('admin/farmer?entity_status=1')->with('success', 'Added successful!');

}


public function edit_farmer($id)
{

    $session = session();


    $e_id = $session->get('entity_id');
    $loginModel = new Loginmodel();
    $farmerModel = new Farmer_module();

    $organization = $loginModel->find($e_id);
    $farmer       = $farmerModel->find($id);


    // var_dump($organization);
    return view('admin/Farmer/edit', ['organization' => $organization,'farmer'=>$farmer]);
}


public function update_farmer($id){

    $throttler = \Config\Services::throttler();
        $ip = $this->request->getIPAddress();
        $sanitizedKey = 'throttler_' . md5($ip); // or hash anything else like username/email
        $throttler->check($sanitizedKey, 5, 60);
        // var_dump($_POST);

        // helper(['form', 'url']);

        $rules = [
            'Title' => [
                'label' => 'Title',
                'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
                'errors' => [
                    'in_list' => 'Title must be Mr, Mrs, or Ms.',
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required',
                'errors' => [
                    'required' => 'First name is required.',
                    'max_length' => 'First name must not exceed 30 characters.',
                ]
            ],
            'middle_name' => [
                'label' => 'Middle Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Middle name must not exceed 30 characters.',
                ]
            ],
            'last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Last name must not exceed 30 characters.',
                ]
            ],
            'Date_of_Birth' => [
                'label' => 'Date of Birth',
                'rules' => 'permit_empty|valid_date',
                'errors' => [
                    'valid_date' => 'Please enter a valid date.',
                ]
            ],
            'Income_Tax_Number' => [
                'label' => 'Income Tax Number',
                'rules' => 'required|alpha_numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Income Tax Number is required.',
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'exact_length' => 'Income Tax Number must be exactly 10 characters.',
                ]
            ],

            // Permanent Address
            'Permanent_Address1' => [
                'label' => 'Permanent Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Permanent Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Address2' => [
                'label' => 'Permanent Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Village' => [
                'label' => 'Permanent Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Permanent_cuntry' => [
                'label' => 'Permanent Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent country.',
                ]
            ],
            'Permanent_State' => [
                'label' => 'Permanent State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent state.',
                ]
            ],
            'Permanent_city' => [
                'label' => 'Permanent City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent city.',
                ]
            ],
            'Permanent_PIN_Code' => [
                'label' => 'Permanent PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Communication Address
            'Communication_Address1' => [
                'label' => 'Communication Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Communication Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Address2' => [
                'label' => 'Communication Address Line 2',
                'rules' => 'required',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Village' => [
                'label' => 'Communication Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Communication_cuntry' => [
                'label' => 'Communication Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication country.',
                ]
            ],
            'Communication_State' => [
                'label' => 'Communication State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication state.',
                ]
            ],
            'Communication_City' => [
                'label' => 'Communication City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication city.',
                ]
            ],
            'Communication_PIN_Code' => [
                'label' => 'Communication PIN Code',
                'rules' => 'required',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Contact Info
            'Contact_Number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Mobile number is required.',
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],
            'Contact_Number_Fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'Email_id' => [
                'label' => 'Email ID',
                'rules' => "required|valid_email|is_unique[entity_profiles.email,id,{$id}]",
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email is already registered.',
                ]
            ]
        ];

        // Add password rule only if it's not empty
if (!empty($this->request->getPost('password'))) {
    $rules['password'] = [
        'label' => 'Password',
        'rules' => 'min_length[8]|regex_match[/^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\W_]).{8,}$/]',
        'errors' => [
            'min_length' => 'Password must be at least 8 characters.',
            'regex_match' => 'Password must include uppercase, lowercase, number, and special character.'
        ]
    ];
}


        // if (!$this->validate($rules)) {
        //     return redirect()->back()->withInput()->with('validation', $this->validator);
        // }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }

           


            $data = [
                'title' => $this->request->getPost('Title'),
                'first_name' => $this->request->getPost('first_name'),
                'middle_name' => $this->request->getPost('middle_name'),
                'last_name' => $this->request->getPost('last_name'),
                'dob' => $this->request->getPost('Date_of_Birth'),
                'income_tax_number' => $this->request->getPost('Income_Tax_Number'),

                // Permanent Address
                'permanent_address1' => $this->request->getPost('Permanent_Address1'),
                'permanent_address2' => $this->request->getPost('Permanent_Address2'),
                'permanent_village' => $this->request->getPost('Permanent_Village'),
                'permanent_country' => $this->request->getPost('Permanent_cuntry'),
                'permanent_state' => $this->request->getPost('Permanent_State'),
                'permanent_city' => $this->request->getPost('Permanent_City'),
                'permanent_pincode' => $this->request->getPost('Permanent_PIN_Code'),

                // Communication Address
                'communication_address1' => $this->request->getPost('Communication_Address1'),
                'communication_address2' => $this->request->getPost('Communication_Address2'),
                'communication_village' => $this->request->getPost('Communication_Village'),
                'communication_country' => $this->request->getPost('Communication_cuntry'),
                'communication_state' => $this->request->getPost('Communication_State'),
                'communication_city' => $this->request->getPost('Communication_City'),
                'communication_pincode' => $this->request->getPost('Communication_PIN_Code'),

                // Contact Info
                'contact_mobile' => $this->request->getPost('Contact_Number_mobile'),
                'contact_fixedline' => $this->request->getPost('Contact_Number_Fixedline'),

                // Credentials
                'email' => $this->request->getPost('Email_id'),
               
            ];
            $password = $this->request->getPost('password');
            if (!empty($password)) {
                $data['password'] = password_hash($password, PASSWORD_DEFAULT);
            }
            $model = new Farmer_module();
            $model->update($id,$data);
         
            
            
        return redirect()->to('admin/farmer?entity_status=1')->with('success', 'Updated successful!');

}

}
