<?php

namespace App\Controllers;

use App\Models\Loginmodel;
use CodeIgniter\Database\Exceptions\DataException;

class Fpo extends BaseController
{



    public function auditors_lists()
    {


    $audit_type     = $this->request->getGet('audit_type');
$auditCategory  = $this->request->getGet('category');
$auditor_name   = $this->request->getGet('auditor_name');

$entityId = session()->get('entity_id');

$db = \Config\Database::connect();

$commonWhere = "i.associated_by = 'fpo' AND i.status = 1 AND i.entity_id = $entityId";

if (!empty($auditCategory) && $auditCategory != "All") {
    $commonWhere .= " AND i.audit_category = " . $db->escape($auditCategory);
}

// Different select for each audit type
$selectColumnsInternal = "
    i.department,
    i.entity_id,
    i.audit_category,
    i.record_date,
    i.auditors,
    YEAR(i.record_date) AS year,
    d.department_name
";

$selectColumnsCertified = "
    NULL AS department,
    i.entity_id,
    i.audit_category,
    i.record_date,
    i.auditors,
    YEAR(i.record_date) AS year,
    NULL AS department_name
";

if ($audit_type === 'internal_audit') {
    $sql = "
        SELECT $selectColumnsInternal, 'internal audit' AS audit_type
        FROM internal_audit i
        LEFT JOIN department d ON d.id = i.department
        WHERE $commonWhere
    ";
} elseif ($audit_type === 'certification_body_audit') {
    $sql = "
        SELECT $selectColumnsCertified, 'certification body audit' AS audit_type
        FROM certified_audit i
        WHERE $commonWhere
    ";
} else {
    $sql = "
        SELECT $selectColumnsInternal, 'internal audit' AS audit_type
        FROM internal_audit i
        LEFT JOIN department d ON d.id = i.department
        WHERE $commonWhere

        UNION ALL

        SELECT $selectColumnsCertified, 'certification body audit' AS audit_type
        FROM certified_audit i
        WHERE $commonWhere
    ";
}

$query = $db->query($sql);
$results = $query->getResultArray();

$finalResults = [];

foreach ($results as $row) {
    $auditorLinks = [];
    $matchFound = false;

    if (!empty($row['auditors'])) {
        $auditors = json_decode($row['auditors'], true);

        if (is_array($auditors)) {
            foreach ($auditors as $auditor) {
                if (!empty($auditor['name'])) {
                    $auditorName = htmlspecialchars($auditor['name']);

                    // Match search
                    if (!empty($auditor_name) && stripos($auditor['name'], $auditor_name) !== false) {
                        $matchFound = true;
                    }

                    // Build full image URL
                    $imageUrl = !empty($auditor['file'])
                        ? base_url($auditor['file'])
                        : null;

                    if ($imageUrl) {
                        $auditorLinks[] = "<a href=\"$imageUrl\" target=\"_blank\">$auditorName</a>";
                    } else {
                        $auditorLinks[] = $auditorName;
                    }
                }
            }
        }
    }

    $row['auditor_names_flat'] = implode(', ', $auditorLinks);

    if (!empty($auditor_name) && strtolower($auditor_name) !== 'all') {
        if ($matchFound) {
            $finalResults[] = $row;
        }
    } else {
        $finalResults[] = $row;
    }
}

$finalResults = array_values($finalResults);

return $this->response->setJSON([
    'status' => 'success',
    'data'   => $finalResults,
    'total_results' => count($finalResults),
]);

    }


    public function audit_type_get()
    {


        $audit_type     = $this->request->getGet('audit_type');
        $auditCategory     = $this->request->getGet('category');
        $department   = $this->request->getGet('department');
        $year         = $this->request->getGet('year');

        $entityId     = session()->get('entity_id');

        $db = \Config\Database::connect();

        $commonWhere = "i.associated_by = 'fpo' AND i.status = 1 AND i.entity_id = $entityId";

        if (!empty($auditCategory) && $auditCategory != "All") {
            $commonWhere .= " AND i.audit_category = " . $db->escape($auditCategory);
        }

        if (!empty($department)) {
            $commonWhere .= " AND i.department = " . $db->escape($department);
        }

        if (!empty($year)) {
            $commonWhere .= " AND YEAR(i.record_date) = " . $db->escape($year);
        }




        $selectColumnsInternal = "
    i.department, 
    i.entity_id,
    i.audit_category,
    i.record_date,
    YEAR(i.record_date) AS year,
    d.department_name
";

        $selectColumnsCertified = "
    NULL AS department, 
    i.entity_id,
    i.audit_category,
    i.record_date,
    YEAR(i.record_date) AS year,
    NULL AS department_name
"; // <-- Use NULL because there's no join

        if ($audit_type === 'internal_audit') {
            $query = "
        SELECT $selectColumnsInternal, 'internal audit' AS audit_type
        FROM internal_audit i
        LEFT JOIN department d ON d.id = i.department
        WHERE $commonWhere
    ";
        } elseif ($audit_type === 'certification_body_audit') {
            $query = "
        SELECT $selectColumnsCertified, 'Certification audit' AS audit_type
        FROM certified_audit i
        WHERE $commonWhere
    ";
        } else {
            $query = "
        SELECT $selectColumnsInternal, 'internal audit' AS audit_type
        FROM internal_audit i
        LEFT JOIN department d ON d.id = i.department
        WHERE $commonWhere

        UNION ALL

        SELECT $selectColumnsCertified, 'Certification audit' AS audit_type
        FROM certified_audit i
        WHERE $commonWhere
    ";
        }


        // Execute the query
        $results = $db->query($query)->getResult();

        // Return JSON response
        return $this->response->setJSON([
            'status' => true,
            'data'   => $results,
            'total_result'   => count($results)
        ]);
    }




    public function verify_otp()
    {

        return view('Fpo/verify_otp');
    }

    public function verify_otp_and_update_profile()
    {


        $inputOtp = $this->request->getPost('otp');

        $inputOtp = (int)$inputOtp;

        // echo gettype(session()->get('otp_code'));



        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {
                // session()->remove('otp_code');

                $tableName = session()->get('table');;
                $insertId = session()->get('entity_id');

                $data_to_update = session()->get('updated_data');

                $loginModel = new Loginmodel();
                $session = session();
                $id = $session->get('entity_id'); // or session('id');
                // var_dump($data_to_update);

                if (session()->get('is_file_uploaded') === true && session()->has('file_path')) {

                    $tempPath = FCPATH . session()->get('file_path'); // full path from session


                    $destinationDir = FCPATH . "uploads/entity_profile/{$insertId}/logo/";
                    $fileName = basename($tempPath);

                    $newFilePath = $destinationDir . $fileName;

                    if (rename($tempPath, $newFilePath)) {
                        // ✅ Move successful, you can update DB or continue process
                        // Optionally unset session






                        $organization = $loginModel->find($id);

                        $oldFilePath = FCPATH . $organization['company_logo'];
                        if (is_file($oldFilePath)) {
                            unlink($oldFilePath);
                        }

                        // Update new file path in DB (relative path)
                        $relativePath = "uploads/entity_profile/{$id}/logo/" . $fileName;
                        $loginModel->update($id, ['company_logo' => $relativePath]);
                        // var_dump($newFilePath);
                        // session()->remove('is_file_uploaded');
                        // session()->remove('file_path');
                    } else {
                        // ❌ Failed to move
                        log_message('error', 'Failed to move uploaded file to organization folder.');
                    }
                }
                session()->remove('otp_code');
                if ($loginModel->update($id, $data_to_update)) {




                    $db = \Config\Database::connect();

                    // Define the data to update
                    $data = [
                        'name_of_the_user' => $data_to_update['establishment_name'],

                    ];

                    // Specify the condition for which the record should be updated
                    $builder = $db->table('register_log');

                    // Perform the update
                    $builder->set($data)
                        ->where('user_id', $id)  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->where('user_table', 'entity_profiles')  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->update();




                    return redirect()->to('Fpo/org_Profile')->with('success', 'Fpo data updated successfully!');
                } else {
                    return redirect()->back()->with('error', 'Failed to update data');
                }



                // return redirect()->to('entity_login')->with('success', 'Account created successfully.');
            } else {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }
        } else {
            return redirect()->back()->with('error', 'OTP expired.');
        }
    }













    public function org_profile_edit()
    {

        $rules = [
            'comp_name' => [
                'label' => 'Establishment Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],

            'legal_identity' => [
                'label' => 'Legal Identity',
                'rules' => 'permit_empty|in_list[Private Limited,Public Company,Partnership,Limited Liability Company]',
                'errors' => [
                    'required' => 'Please select the legal identity.',
                    'in_list' => 'Legal identity must be one of: Private Limited, Public Company, Partnership, or Limited Liability Company.',
                ]
            ],

            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'permit_empty|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Registration_number' => [
                'label' => 'Registration Number',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'gst_registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'income_tax_pan_no' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                ]
            ],
            'income_tax_tan_no' => [
                'label' => ' Income TAN Number',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income TAN Number must be alphanumeric.',
                    'max_length' => 'Income TAN Number must not exceed 15 characters.',
                ]
            ],

            'adress_1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'address_2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'country' => [
                'label' => 'Country',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'state' => [
                'label' => 'State',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'city' => [
                'label' => 'City',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Pincode' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'contact_number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],

            'contact_number_fixed_line' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'email' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|is_unique_email_per_type_org_profile[entity_profiles.email]',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email ID is already registered. Please use another one.',
                    'is_unique_email_per_type_org_profile' => 'This email ID is already registered for the selected user type.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'permit_empty|min_length[8]',
                'errors' => [
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ],


            'comp_logo' => [
                'label' => 'Company Logo',
                'rules' => 'permit_empty|is_image[comp_logo]'
                    . '|mime_in[comp_logo,image/jpeg,image/png,image/jpg]'
                    . '|ext_in[comp_logo,jpg,jpeg,png]'
                    . '|max_size[comp_logo,5120]',
                'errors' => [
                    'is_image' => 'The file must be a valid image.',
                    'mime_in' => 'Only JPEG and PNG images are allowed.',
                    'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
                    'max_size' => 'The image size must not exceed 5MB.',
                ]
            ]

        ];

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
            // var_dump($this->validator->listErrors());
        }
        session()->set('is_file_uploaded', false);

        $data = [
            'establishment_name' => $this->request->getPost('comp_name'),
            'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
            'registration_number' => $this->request->getPost('Registration_number'),
            'gstin_or_vat_id' => $this->request->getPost('gst_registration'),
            // 'company_logo' => $logoName,
            'employer_income_tax_number' => $this->request->getPost('income_tax_pan_no'),
            // 'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
            'address_line1' => $this->request->getPost('adress_1'),
            'address_line2' => $this->request->getPost('address_2'),
            'village' => $this->request->getPost('village'),
            'country' => $this->request->getPost('country'),
            'state' => $this->request->getPost('state'),
            'city' => $this->request->getPost('city'),
            'pin_code' => $this->request->getPost('Pincode'),
            'contact_mobile' => $this->request->getPost('contact_number_mobile'),
            'contact_fixedline' => $this->request->getPost('contact_number_fixed_line'),
            'email' => $this->request->getPost('email'),
            'Legal_identity' => $this->request->getPost('legal_identity'),
            'updated_by' => session()->get('logined_user_id'),
            'Income_Tax_TAN_No' => $this->request->getPost('income_tax_tan_no')



        ];

        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }


        // var_dump($data);

        // die();

        $logo = $this->request->getFile('comp_logo');


        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            // Re-validate file type for double safety (optional)
            $ext = $logo->getClientExtension();
            if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
                session()->set('validation_errors', "Invalid file type uploaded.");
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds




                return redirect()->back()->withInput();
            }

            $logoName = $logo->getRandomName();
            $logoDir = "uploads/temp/logo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file to destination
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            session()->set('is_file_uploaded', true);
            session()->set('file_path', $relativePath);
        }


        $session = session();
        $entityId = $session->get('entity_id');



        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;

        if (!empty($docNames) && is_array($docNames)) {

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }
            foreach ($docNames as $i => $docName) {
                $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

                if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                    // Delete old file
                    if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                        unlink(FCPATH . $existingFiles[$i]);
                    }

                    $file = $files['doc_file'][$i];
                    $newName = $file->getRandomName();
                    $file->move($uploadPath, $newName); // Move to new path
                    $newFilePath = $uploadFolder . $newName; // Save relative path
                }

                $documents[] = [
                    'name' => $docName,
                    'date' => $docDates[$i],
                    'file' => $newFilePath
                ];
            }




            $db = \Config\Database::connect();

            // Define the data to update
            $data1 = [
                'documents' => json_encode($documents),
            ];

            // Specify the condition for which the record should be updated
            $builder = $db->table('entity_profiles');

            // Perform the update
            $builder->set($data1)
                ->where('id', $entityId)  // Use the appropriate condition (e.g., primary key or other unique column)
                ->update();
        }


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);

        // 1. Generate 6-digit OTP
        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($organization['email']);
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $organization['establishment_name'] . '!</h3>
        <p>Your One-Time Password (OTP) for updating profile is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {

            var_dump($data);
            session()->set('otp_code', $otp);

            session()->set('updated_data', $data);
            session()->set('reciver_email', $organization['email']);
            session()->set('user_name', $organization['establishment_name']);
            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

            return redirect()->to('Fpo/verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }

    public function org_Profile()
    {

        $session = session();


        $id = $session->get('entity_id');
        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        // var_dump($organization);
        return view('Fpo/org_profile_page', ['organization' => $organization]);
    }



    public function toggleAutoId()
    {

        $newValue = $this->request->getPost('value');
        $entityId = session()->get('entity_id');

        // Example update
        $db = \Config\Database::connect();
        $db->table('entity_profiles')
            ->where('id', $entityId)
            ->update(['audo_id_gendrator' => $newValue]);

        return $this->response->setJSON(['status' => 'success', 'newValue' => $newValue]);
    }





    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        return view('Fpo/index', ['organization' => $organization]);
    }


    public function getCropsByFarmer()
    {
        $farm_land = $this->request->getPost('farm_land');

        $db = \Config\Database::connect();
        $builder = $db->table('farm_crop_details');
        $crops = $builder->select('crop_id, crop_name')
            ->where('farm_id', $farm_land)
            ->get()
            ->getResultArray();

        return $this->response->setJSON($crops);
    }


    public function cropInventory()
    {
        $db = \Config\Database::connect();
        $builder = $db->table('farm_crop_details c');

        // Load filters from GET (sent by DataTable AJAX)
        $farmerId     = $this->request->getGet('id'); // farmer_id from frontend
        $year         = $this->request->getGet('year');
        $cropVariety  = $this->request->getGet('variety');
        $entityId     = session()->get('entity_id');

        // Joins
        $builder->join('farmers f', 'f.id = c.farmer_id');
        $builder->join('crop_master cm', 'cm.id = c.crop_id');

        // Select required data
        $builder->select("
            c.farmer_id,
            CONCAT(f.title, ' ', f.first_name, ' ', f.middle_name, ' ', f.last_name) AS farmer_name,
            cm.crop_variety,
            IFNULL(SUM(c.production_estimate_qty), 0) AS total_estimate,
            IFNULL(SUM(c.harvest_qty), 0) AS total_harvest,
            IFNULL(SUM(c.wastage_qty), 0) AS total_wastage,
            IFNULL(SUM(c.crop_sales_qty), 0) AS total_sold,
            IFNULL(SUM(c.inventory_qty), 0) AS total_inventory,
            c.year
        ");

        // Apply filters
        if (!empty($farmerId)) {
            $builder->where('c.farmer_id', $farmerId);
        }

        if (!empty($year)) {
            $builder->where('c.year', $year);
        }

        if (!empty($cropVariety)) {
            $builder->like('cm.id', $cropVariety);
        }

        if (!empty($entityId)) {
            $builder->where('c.entity_id', $entityId);
        }

        // Group by farmer/crop/year
        $builder->groupBy(['c.farmer_id', 'c.crop_id', 'c.year']);

        // Execute main query
        $results = $builder->get()->getResult();

        // ✅ Build summary from filtered results
        $summary = [
            'total_farmers'     => count(array_unique(array_column($results, 'farmer_id'))),
            'total_estimate'    => array_sum(array_column($results, 'total_estimate')),
            'total_harvest'     => array_sum(array_column($results, 'total_harvest')),
            'total_wastage'     => array_sum(array_column($results, 'total_wastage')),
            'total_sold'        => array_sum(array_column($results, 'total_sold')),
            'total_inventory'   => array_sum(array_column($results, 'total_inventory')),
        ];

        return $this->response->setJSON([
            'data'    => $results,
            'summary' => $summary
        ]);
    }



    public function internalFarmInspection()
    {
        $db = \Config\Database::connect();
        $builder = $db->table('internal_farm_inspection i');

        // Filters
        $farmerId    = $this->request->getGet('farmer_id');
        $year        = $this->request->getGet('year');
        $cropVariety = $this->request->getGet('crop_variety');
        $entityId    = session()->get('entity_id');

        // Joins
        $builder->join('farmers f', 'f.id = i.farmer_id');
        $builder->join('crop_master cm', 'cm.id = i.crop_id');

        // Select status totals
        $builder->select("
        i.farmer_id,
        CONCAT(f.title, ' ', f.first_name, ' ', f.middle_name, ' ', f.last_name) AS farmer_name,
        cm.crop_variety,
        i.year,
        SUM(CASE WHEN i.status = 0 THEN 1 ELSE 0 END) AS total_yts,
        SUM(CASE WHEN i.status = 1 THEN 1 ELSE 0 END) AS total_completed,
        SUM(CASE WHEN i.status = 2 THEN 1 ELSE 0 END) AS total_pending,
        SUM(CASE WHEN i.status = 3 THEN 1 ELSE 0 END) AS total_hold
    ");

        // Apply filters
        if (!empty($farmerId)) {
            $builder->where('i.farmer_id', $farmerId);
        }

        if (!empty($year)) {
            $builder->where('i.year', $year);
        }

        if (!empty($cropVariety)) {
            $builder->like('cm.crop_variety', $cropVariety);
        }

        if (!empty($entityId)) {
            $builder->where('i.entity_id', $entityId);
        }

        $builder->groupBy(['i.farmer_id', 'i.crop_id', 'i.year']);
        $results = $builder->get()->getResult();

        // Summary aggregation
        $summary = [
            'total_farmers'   => count(array_unique(array_column($results, 'farmer_id'))),
            'total_yts'       => array_sum(array_column($results, 'total_yts')),
            'total_pending'   => array_sum(array_column($results, 'total_pending')),
            'total_completed' => array_sum(array_column($results, 'total_completed')),
            'total_hold'      => array_sum(array_column($results, 'total_hold')),
        ];

        return $this->response->setJSON([
            'data'    => $results,
            'summary' => $summary
        ]);
    }



    public function internalAuditDashboard()
    {
        $db = \Config\Database::connect();
        $builder = $db->table('internal_audit i');

        // Get filters
        $category     = $this->request->getGet('category');
        $department   = $this->request->getGet('department');
        $year         = $this->request->getGet('year');
        $ontimeStatus = $this->request->getGet('ontime_status');
        $entityId     = session()->get('entity_id');

        // Join with department table
        $builder->join('department d', 'd.id = i.department', 'left');

        // Select fields with computed ontime_status
        $builder->select([
            'i.id',
            'i.audit_id',
            'i.audit_category',
            'i.record_date',
            'i.audit_for',
            'i.department',
            'd.department_name',
            'i.year',
            'i.due_date'
        ]);
        $builder->select("(CASE WHEN i.record_date <= i.due_date THEN 1 ELSE 0 END) AS ontime_status", false);
        $builder->where('i.status', 1);


        // Apply filters
        if (!empty($category)) {
            $builder->where('i.audit_category', $category);
        }

        if (!empty($department)) {
            $builder->where('i.department', $department);
        }

        if (!empty($year)) {
            $builder->where('i.year', $year);
        }

        if (!empty($entityId)) {
            $builder->where('i.entity_id', $entityId);
        }

        // Apply HAVING for computed ontime_status
        if ($ontimeStatus !== null && $ontimeStatus !== '') {
            $builder->having('ontime_status', (int) $ontimeStatus);
        }

        // Execute query
        $results = $builder->get()->getResult();

        // Calculate summary
        $totalOntime = 0;
        $totalDelay = 0;

        foreach ($results as $row) {
            if (isset($row->ontime_status) && $row->ontime_status == 1) {
                $totalOntime++;
            } else {
                $totalDelay++;
            }
        }

        $summary = [
            'total_audits' => count($results),
            'total_ontime' => $totalOntime,
            'total_delay'  => $totalDelay,
        ];

        // Return JSON response
        return $this->response->setJSON([
            'status'  => true,
            'data'    => $results,
            'summary' => $summary,
        ]);
    }
}
